package tred;

import java.awt.*; 
import java.io.*;

/** implementation to Tree */
public class Tree extends NodePanel {
  private boolean levelOrder = false;
  
  /** 
   * This constructor invokes the super constructor and only initializes
   * the x and y fields for this object
   */
  Tree(GraphPanel panel, String label, String items) {
    
      super(panel, label, items, 0);
    System.out.println("sdfs");
    // y = position * itemsize;
    //x = 0;
    graphPanel.nextPosition += 2 * (int)Math.round(log2(len)) - 1;
  }

  /** @return base 2 log (Java Math supports only natural log) */
  private double log2(int i) {
    return Math.log(i)/Math.log(2);
  }

  /** 
   * move disabled with trees 
   * note that there was some problems if the tree was movable:
   * refer exercise .24 and .25, which didn't export correctly
   * if the tree was moved (Cannot get inputStream)
   */
  public final void move(int x, int y) {
    System.out.println("aaa");
  }
  
  public Rectangle getBounds() {
    x = 0;
    return super.getBounds();
  }
  
  /** 
   * This method is invoked to set the order of output. The default is
   * tree order. 
   * @param order is a string which determines the output order.
   * Possible values: LEVEL
   * @see getState
   */
  /*public void setOrder(String order) {
    super.setOrder(order);
    if (order.equals("LEVEL") || order.equals("level"))
      levelOrder = true;
    else if (order.equals("TREE") || order.equals("tree"))
      levelOrder = false;
  }*/

  /** 
   * This method is invoked in order to get the state of tree for export.
   * @param str is the substitute string for empty slot.
   * @return the current state (string of items in the slots) of this panel. 
   * @see animImpl.export, setOrder
   */
  protected String getState(String str) {
    String s = "";
    Item item;

    if (str == null)
      str = "-";
    for (int i=0; i<nslots; i++) {
      if ((item = slots[i].getItem()) != null) {
	if (!item.disabled()) {
	  if (levelOrder) {
	    s += item.lbl;
	  }
	  else { // default is tree order
	    s += item.lbl + ": ";
	    if ((2*i+2<nslots)) { 
	      s += (item = slots[2*i+1].getItem()) != null ? item.lbl : str;
	      s += " ";
	      s += (item = slots[2*i+2].getItem()) != null ? item.lbl : str;
	    }
	    else
	      s += "- -";
	    s += "\n";
	  }
	}
      } else if (levelOrder) { s += str; }
    }
    return s;
  }

  /** 
   * This method draws the name of the tree to top of the area.
   * After that all the slots are drawed as tree-like style by
   * invoking the paint method for slots and then drawing the connecting
   * lines between parent slot and target slot.
   */
  public boolean paint(Graphics g) {
    System.out.println("paintti");
    /* FontMetrics fm = g.getFontMetrics(); */
    int label_w = fontMetrics.stringWidth(lbl+" ") + itemsize;
    int label_h = fontMetrics.getHeight();
    // empty space left to both sides (2 * itemsize)
    int panelWidth = graphPanel.getSize().width - 2*itemsize;

    // center the label and leave empty space (itemsize) to the left  
    g.drawString(lbl, panelWidth/2 - label_w/2 + itemsize, y + label_h);
    // root slot is set to the center of the area
    // possible bug: label-width should not use here?
    slots[0].paint(g, panelWidth/2 - label_w/2 + itemsize, y + itemsize);
    for (int i=1; i<len; i++) {
      // #number of parent slot
      int parent = (i-1)/2;
      int dcenter = itemsize/2;
      // squeeze the tree horizontally
      int df = 
	/* (int)Math.round(panelWidth/Math.pow(2, Math.floor(log2(i+1)) + 1)); */
	(int) (panelWidth / Math.pow(2, Math.floor(log2(i+1)) + 1));
      // children slots are set to the area relative to the parent slot
      slots[i].paint(g, 
		     slots[parent].x + (((i % 2) == 1) ? -df : df), 
		     slots[parent].y + 2*itemsize);
      // centers (x,y) of p(arent) and t(arget)
      int cxp = slots[parent].x + dcenter;
      int cyp = slots[parent].y + dcenter;
      int cxt = slots[i].x + dcenter;
      int cyt = slots[i].y + dcenter;
      // length inside the slot (dx, dy)
      int xl = (cxp-cxt);
      int yl = (cyp-cyt);
      int dx = (int)Math.round(dcenter * xl / Math.sqrt(xl*xl + yl*yl));
      int dy = (int)Math.round(dcenter * yl / Math.sqrt(xl*xl + yl*yl));
      // draw the connecting lines only to the border of the slot
      g.drawLine(cxp - dx, cyp - dy, cxt + dx, cyt + dy);
    }
    width = panelWidth;
    height = (int)Math.round(2 * itemsize * log2(len) + itemsize);
    return true;
  }
  
}
