package tred;

import java.util.*;
import java.awt.*; 
import java.io.*;

/** implementation to TextField */
public class TextFieldPanel extends EditorPanel {
  TextField textField;
  Dimension d = new Dimension();

  /** 
   * This is the default constructor for TextFieldPanel. 
   * @param graphPanel the panel whics this panel belong.
   * @param label the name of the panel.
   * @param items initial items of the panel.
   * @param space the number of columns in the textField. Default = 20.
   */
  TextFieldPanel(GraphPanel graphPanel, String label, String items, int space){
    super(graphPanel, label, "", space);
    if (space == 0)
      this.space = 20;
    this.items = items;
    textField = new TextField(items, this.space);
    graphPanel.add(textField);
    d.width = this.space * itemsize;
    d.height = 30;
    addPanel(this);
  }

  public TextField textField() {
    return textField;
  }

  public final void setFont(Font font) {
    if (textField != null)
      textField.setFont(font);
  }

  public void reset() {
    graphPanel.remove(textField);
    textField = new TextField(items, space <= 0 ? 20 : space);
    graphPanel.add(textField);
  }

  public String getState(String str) {
    return textField.getText();
  }

  public boolean paint(Graphics g) {
    boolean ready = super.paint(g);
    Rectangle rect = textField.bounds();
    textField.reshape(x+fontMetrics.stringWidth(lbl+" "),y,d.width,d.height);
    textField.validate();
    return ready;
  }
}


