package tred;

import java.awt.*; 
import java.io.*;

/** implementation to TextArea */
public class TextAreaPanel extends EditorPanel {
  TextArea textArea;
  Dimension d = new Dimension();

  /** 
   * This is the default constructor for TextAreaPanel. 
   * @param graphPanel the panel whics this panel belong.
   * @param label the name of the panel.
   * @param items initial items of the panel.
   * @param space the number of columns in the textArea. Default = 20.
   */
  TextAreaPanel(GraphPanel graphPanel, String label, String items, int space){
    super(graphPanel, label, "", space);
    if (space == 0)
      this.space = 10;
    this.items = items;
    textArea = new TextArea(items, this.space, 20);
    graphPanel.add(textArea);
    d.width = 20 * itemsize;
    d.height = 16 * this.space;
    graphPanel.nextPosition += this.space;
    addPanel(this);
    /* graphPanel.allowSetFont(textArea); */
  }

  /* @return reference to the textArea of this object. */
  public TextArea textArea() {
    return textArea;
  }

  public void reset() {
    graphPanel.remove(textArea);
    textArea = new TextArea(items, space <= 0 ? 10 : space, 20);
    graphPanel.add(textArea);
  }

  public final void setFont(Font font) {
    if (textArea != null)
      textArea.setFont(font);
  }

  public String getState(String str) {
    return textArea.getText();
  }

  public boolean paint(Graphics g) {
    boolean ready = super.paint(g);
    textArea.reshape(x+fontMetrics.stringWidth(lbl+" "),y,d.width,d.height);
    textArea.validate();
    return ready;
  }
}


