package tred;

import java.awt.*; 
import java.io.*;

/** implementation to Stream */
public class StreamPanel extends EditorPanel {
  
  /** 
   * This is the default constructor for StreamPanel. 
   * @param graphPanel the panel whics this panel belong.
   * @param label the name of the panel.
   * @param items initial items of the panel.
   */
  StreamPanel(GraphPanel panel, String label, String items, int space) {
    super(panel, label, items, space);
    for (int i=0; i<len; i++) {
      StreamSlot streamSlot = new StreamSlot(this, i);
      slots[nslots++] = streamSlot;
      if (!(items.substring(i,i+1).equals(" "))) {
	StreamItem streamItem = new StreamItem(items.substring(i,i+1));
	streamItem.move(streamSlot,0,0);
	graphPanel.insertObject(streamItem); 
      }
      graphPanel.addObject(streamSlot);
    }
  }

  StreamPanel(GraphPanel panel, String label, String items, Dimension size) {
    this(panel, label, items, size.width);
    panel.nextPosition += size.height;
  }

  /** 
   * This constructor is same as the default constructor except that the
   * items created by this are hashItems. The parameter hash is unused and
   * only differs this constructor from the default constructor.
   */
  StreamPanel(GraphPanel panel, String label, String items, int space, int hash) {
    super(panel, label, items, space);
    panel.nextPosition++;
    for (int i=0; i<len; i++) {
      StreamSlot streamSlot = new StreamSlot(this, i);
      slots[nslots++] = streamSlot;
      if (!(items.substring(i,i+1).equals(" "))) {
	StreamItem hashStreamItem = new HashStreamItem(items.substring(i,i+1));
	hashStreamItem.move(streamSlot,0,0);
	graphPanel.insertObject(hashStreamItem);
      }
      graphPanel.addObject(streamSlot);
    }
    addPanel(this);
  }


  /**
   * This method is invoked when this panel is draw into the screen. 
   */
  public boolean paint(Graphics g) {
    invoked("stream paint " + x + " " + y);
    super.paint(g);
    if (touched) {
      int label_w = fontMetrics.stringWidth(lbl+" ") + itemsize;
      // int label_h = fm.getHeight();
      width = label_w;
      for (int i=0; i<len; i++)
	width += getSpace() + slots[i].paint(g, x + label_w + i*(itemsize+getSpace()), y);
      touched = false;
    }
    return true;
  }
}


