package tred;

import java.awt.*; 
import java.io.*;

/** 
 * Implementation to Items of stream. StreamItems are items which have a
 * label (usually just one letter) which is displayed inside a bounding box.
 */
public class StreamItem extends Item {

  /** 
   * This is the constructor for StreamItem. It simply does nothing
   * but invokes the super constructor.
   * @see Item
   */
  StreamItem(String lbl) {
    super(lbl);
  }


  /** 
   * This method is invoked when this item is draw into the screen. 
   * First the super.paint() is invoked. After that, the StreamItem is
   * displayed as a label (just on letter) inside a bounding box.
   * @return value of super.paint().
   */
  public boolean paint(Graphics g) {
    /* System.out.println("paint " + this); */
    boolean ready = super.paint(g);
    /* FontMetrics fm = g.getFontMetrics(); */
    int w = fontMetrics.stringWidth(lbl);
    int h = fontMetrics.getHeight();
    g.drawRect(x, y, width, height);
    // with small fonts the adjustment is needed with x (+1) and y (-2)
    g.drawString(lbl, x+1 + (width - w)/2, y-2 + (height + h)/2);
    return ready;
  }
}


