package tred;

import java.awt.*; 
import java.io.*;

/** implementation to StackPanel */
public class StackPanel extends NodePanel {
  
  /** 
   * This constructor invokes the super constructor.
   */
  StackPanel(String label, String items, int space) {
    super(label, items, space);
  }

  /** 
   * This method draws the name of the StackPanel to top of the area.
   * After that all the slots are drawed as StackPanel-like style by
   * invoking the paint method for slots and then drawing the connecting
   * lines between parent slot and target slot.
   */
  public void paint(Graphics g) {
    FontMetrics fm = g.getFontMetrics();
    int label_w = fm.stringWidth(lbl+" ") + itemsize;
    int label_h = fm.getHeight();
    // empty space left to both sides (2 * itemsize)
    int panelWidth = graphPanel.getSize().width - 2*itemsize;


    width = panelWidth;
  }
}
