package tred;

import java.awt.*; 
import java.io.*;
import java.util.Enumeration;

/** implementation to Stack. */
public class Stack extends NodePanel {
  private static final int STACKHEIGHT = 8;
  private static int fromx, fromy, tox, toy;
  protected Button pop;

  /** 
   * This is the constructor for Stack-objects. Super constructor is
   * invoked and all the items are set to be ListArray. Also a new
   * button called "pop" is created to this panel.
   */
  Stack(GraphPanel panel, String label, String items, int space) {
    super(panel, label, " ", space);
    setListArray(items);
    panel.nextPosition += 7;
    panel.add(pop = new Button("Pop"));
    this.disable();
  }

  public final void setFont(Font font) {
    if (pop != null)
      pop.setFont(font);
  }

  /** 
   * This method is invoked when the pop-button is pushed. A new slot
   * (with stack pile) is created.
   */
  public void pop() {
    // record pop start
    moveObject(this, null, this);
    shadowed();
    NodeSlot nodeSlot = new NodeSlot(this, nslots);
    nodeSlot.list = new ListObject();
    graphPanel.insertObject(nodeSlot);
    Slot prevslot = slots[nslots-1];
    prevslot.disable();
    nodeSlot.enable();
    Enumeration enum = prevslot.list.elements();
    Slot slot;
    // drop the first real element
    while (enum.hasMoreElements() && 
	   ((slot = (Slot)enum.nextElement()).item == null));
    // use stack to reverse order of the elements
    java.util.Stack st = new java.util.Stack();
    while (enum.hasMoreElements()) {
      slot = (Slot)enum.nextElement();
      //graphPanel.insertObject(slot);
      if (slot.item != null)
	st.push(slot);
      else
	slot.shadowItem = null;
    }
    while (!st.empty())
      ((Slot)st.pop()).item.move(nodeSlot, x, y);
    slots[nslots++] = nodeSlot;
    len = nslots;
    // record pop end
    moveObject(this, null, this);
    touched = true;
    graphPanel.repaint();
  }

  // This static flag is used to indicate that the whole movement is
  // completed. There is several move operations (many items could be
  // moved) in one stack move operation.
  static boolean called = false;

  /** 
   * This is the special move method for Stack and is invoked by
   * AnimImpl in order to handle all the movements one stack movement
   * needs to do. There could be several move operations (many items could
   * be moved) in one stack move operation. The pop-method marks the
   * beginning and end of the pop operation and when a backward/forward
   * button in pressed we have to make all the move operations between those
   * states as a one move operation. To make this method compatible with
   * all the other move methods, the animImpl class delivers also 
   * parameters which are ignored.
   * @param object move backward if object is null, move forward if not.
   * (this is the way pop-method marks the beginning/end)
   * @param x not needed
   * @param y not needed
   */
  public void move(EditorObject object, int x, int y) {
    // stop the recursion after last move
    if (called) {
      called = false;
      return;
    }
    else
      called = true;

    // forward
    if (object != null) {
      slots[nslots-1].disable();
      Slot lastslot = (Slot)slots[nslots++];
      lastslot.enable();
      lastslot.hide(false);
      len++;
      while (called)
	moveForward();
    }
    // backward
    else { 
      Slot lastslot = (Slot)slots[--nslots];
      slots[nslots-1].enable();
      //lastslot.list = new ListObject();
      lastslot.hide(true);
      lastslot.disable();
      len--;
      while (called)
	moveBackward();
    }
  }

  /** 
   * This method is invoked in order to get the state of Stack for export.
   * @param str is the substitute string for empty slot.
   * @return the current state (string of items in the slots) of this stack. 
   * @see animImpl.export
   */
  protected String getState(String str) {
    String s = "";
    Item item;
    for (int i=0; i<nslots; i++) {
      if ((isListPanel) && (slots[i].list != null)) {
	StringBuffer buf = new StringBuffer();
	Enumeration enum = slots[i].list.elements();
	while (enum.hasMoreElements()) {
	  Slot slot = (Slot)enum.nextElement();
	  if ((item = slot.getItem()) != null) {
	    buf.ensureCapacity(buf.length() + item.lbl.length() + 2);
	    buf.insert(0, item.lbl);
	  }
	  else
	    if (slot.shadowItem != null) {
	      buf.ensureCapacity(buf.length() + 
				 slot.shadowItem.lbl.length() + 2);
	      buf.insert(0, slot.shadowItem.lbl);
	    }
	}
	s += buf.append("\n").toString();
      }
    }
    return s;
  }

  /**
   * This method is invoked when this panel is draw into the screen. 
   */
  public boolean paint(Graphics g) {
    int label_w = fontMetrics.stringWidth(lbl+" ") + itemsize;

    x = itemsize;
    y = position * itemsize;

    super.paint(g);

    for (int i=0; i<len; i++) {
      int xpos = x+i*itemsize + label_w;
      int sHeight = STACKHEIGHT*itemsize;
      g.drawLine(xpos,y+itemsize,xpos,y+itemsize+sHeight);
      g.drawLine(xpos+itemsize,y+itemsize,xpos+itemsize,y+itemsize+sHeight);
      g.drawLine(xpos,y+itemsize+sHeight,xpos+itemsize,y+itemsize+sHeight);
      if (slots[i].list != null) {
	Enumeration enum = slots[i].list.elements();
	int count = 0;
	boolean ignoreShadowed = true;
	Slot slot;
	java.util.Stack st = new java.util.Stack();
	while (enum.hasMoreElements()) {
	  st.push(slot = (Slot)enum.nextElement());
	  if (slot.item != null)
	    ignoreShadowed = false;
	}
	while (!st.empty()) {
	  slot = (Slot)st.pop();
	  if (slot.item != null) {
	    slot.x = x + label_w + i*itemsize;
	    slot.y = y + (STACKHEIGHT - count++)*itemsize;
	    ignoreShadowed = true;
	  }
	  else if ((!ignoreShadowed) && (slot.shadowItem != null)) {
	    slot.x = x + label_w + i*itemsize;
	    slot.y = y + (STACKHEIGHT - count++)*itemsize;
	    int h = fontMetrics.getHeight();
	    int w = fontMetrics.stringWidth(slot.shadowItem.lbl);
	    g.drawString(slot.shadowItem.lbl, 
			 slot.x + (itemsize-w)/2, 
			 slot.y + (itemsize+h)/2 - 2);
	  }
	}
      }
    }
    
    // reshape the pop-button
    pop.reshape(x, y+2*itemsize, label_w - itemsize/2, itemsize);
    pop.validate();

    return true;
  }
}
