package tred;

import java.awt.*; 

/** 
 * Implementation to Slots of Nodes. NodeSlot is a container for one NodeItem.
 * @see Slot.
 */
class NodeSlot extends Slot implements Cloneable {

  /** This is the constructor for NodeSlot. This constructor simply do nothing
   * but invokes the super constructor. (The slot's x and y fields are also
   * set to zero.)
   */
  NodeSlot(EditorPanel panel, int id) {
    super(panel, id);
    x = y = 0;
  }

  /** This method is invoked when this slot is draw into the screen. 
   * The outfit of NodeSlot is a label (just one letter) inside a
   * bounding circle.
   * @return allways true.
   */
  public boolean paint(Graphics g) {
    if ((isVisible()) || SLOT_DEBUG) {
      super.paint(g);
      g.drawOval(x, y, width, height);
    }
    return true;
  }
}

