package tred;

import java.awt.*; 
import java.io.*;

/** implementation to Tree */
public class NodePanel extends EditorPanel {
  
  NodePanel(GraphPanel panel, String label, String items, int space) {
    super(panel, label, items, space);
    for (int i=0; i<len; i++) {
      NodeSlot nodeSlot = new NodeSlot(this, i);
      slots[nslots++] = nodeSlot;
      if (!(this.items.substring(i,i+1).equals(" "))) {
	NodeItem nodeItem = new NodeItem(items.substring(i,i+1));
	nodeItem.move(nodeSlot,0,0);
	graphPanel.insertObject(nodeItem);
      }
      graphPanel.addObject(nodeSlot);
    }
  }

  public void append(String itms) {
    items += itms;
    for (int i=len; i<len+itms.length(); i++) {
      NodeSlot nodeSlot = new NodeSlot(this, i);
      slots[nslots++] = nodeSlot;
      if (!(items.substring(i,i+1).equals(" "))) {
	NodeItem nodeItem = new NodeItem(items.substring(i,i+1));
	nodeItem.move(nodeSlot,0,0);
	graphPanel.insertObject(nodeItem);
      }
      graphPanel.addObject(nodeSlot);
    }
    len = items.length();
  }

  /**
   * This method is invoked when this panel is draw into the screen. 
   */
  public boolean paint(Graphics g) {
   System.out.println("tasdfdfs");
    super.paint(g);
    if (touched) {
      int label_w = fontMetrics.stringWidth(lbl+" ") + itemsize;
      // int label_h = fm.getHeight();
      width = label_w;
      for (int i=0; i<len; i++)
	width += getSpace() + slots[i].paint(g, x + label_w + i*(itemsize+getSpace()), y);
      touched = false;
    }
    return true;
  }
}







