package tred;

import java.awt.*; 
import java.io.*;

/** implementation to Tree */
public class NodeListPanel extends NodePanel {
  private static int fromx, fromy, tox, toy;
  
  NodeListPanel(GraphPanel panel, String label, String items, int space) {
    super(panel, label, items, space);
    panel.nextPosition += 3;
  }

  /**
   * This method is invoked when this panel is draw into the screen. 
   */
  public boolean paint(Graphics g) {
    FontMetrics fm = g.getFontMetrics();
    int label_w = fm.stringWidth(lbl+" ") + itemsize;

    x = itemsize;
    y = position * itemsize;
    for (int i=0; i<len; i++) {
      if ((i % 2) == 0) { 
	fromx = x + label_w + (i/2)*(itemsize + getSpace());
	fromy = y + itemsize;
	if (touched) {
	  width = label_w;
	  width += slots[i].paint(g, fromx, y);
	}
      }
      else {
	tox = x + label_w + ((i-1)/2)*(itemsize + getSpace());
	toy = y + 2*itemsize;
	if (touched) {
	  width = label_w;
	  width += slots[i].paint(g, tox, toy);
	}
	g.drawLine(fromx + itemsize/2, fromy, tox + itemsize/2, toy);
      }
    }
    touch(false);
    g.drawString(lbl, x, y + itemsize/2 + fm.getAscent()/2);
    return true;
  }
}


