package tred;

import java.awt.*; 
import java.io.*;
import java.util.*;

/** implementation to Matrix. */
public class MatrixPanel extends Element {
  private static int fromx, fromy, tox, toy;
  protected Button pop;

  /** 
   * This is the constructor for Matrix-objects. Super constructor is
   * invoked and all the items are set to be ListArray. Also a new
   * button called "pop" is created to this panel.
   */
  MatrixPanel(GraphPanel panel, String label, String items, int space) {
    super(panel, label, space);
    
    /* if (items != null)
      panel.nextPosition += items.length(); */
    height = itemsize * items.length();

    int len = items.length();
    for (int i = 0; i < len; i++) 
      elements.add(new StreamPanel(panel, 
				  " ",
				  items.substring(i, i+1) + 
				  empty_string(len),
				  space));
    this.disable();
  }

  /** returns i empty elements */
  private String empty_string(int i) {
    String str = "________";
    while (str.length() < i)
      str = str + str;
    return str.substring(0,i);
  }

  /** 
   * This is the special move method for Matrix and is invoked by
   * AnimImpl in order to handle all the movements one Matrix movement
   * needs to do. There could be several move operations (many items could
   * be moved) in one Matrix move operation. The pop-method marks the
   * beginning and end of the pop operation and when a backward/forward
   * button in pressed we have to make all the move operations between those
   * states as a one move operation. To make this method compatible with
   * all the other move methods, the animImpl class delivers also 
   * parameters which are ignored.
   * @param object move backward if object is null, move forward if not.
   * (this is the way pop-method marks the beginning/end)
   * @param x not needed
   * @param y not needed
   */
  public void move(EditorObject object, int x, int y) {
  }

  /** 
   * This method is invoked in order to get the state of Matrix for export.
   * @param str is the substitute string for empty slot.
   * @return the current state (string of items in the slots) of this Matrix. 
   * @see animImpl.export
   */
  protected String getState(String str) {
    return str;
  }

  public void move(int newx, int newy) {
    super.move(newx, newy);
    
    int count = 0;
    Enumeration elem = elements.elements();
    while (elem.hasMoreElements()) {
      EditorObject obj = (EditorObject)elem.nextElement();
      obj.move(x, y + itemsize*count++);
    }
  }

  /**
   * This method is invoked when this panel is draw into the screen. 
   */
  public boolean paint(Graphics g) {
    invoked("Matrix paint " + x + " " + y);
    if (lbl != null)
      g.drawString(lbl, x, y + itemsize/2 + fontMetrics.getAscent()/2);
    super.paint(g);

      
    return true;
  }
}
