package tred;

import java.util.*;

/** This is a ListObject class that will store a list of objects. */
public class ListObject {
  private Vector list = new Vector();
  private int id = -1;
  private static int nextId = 0;
 
  /** 
   * This is the constructor for ListObject. A new empty Vector is allocated
   * for the elements this ListObject contains. 
   */
  public ListObject() {
    id = nextId++;
  }

  public Object firstElement() {
    if (list.isEmpty())
      return null;
    else
      return list.firstElement();
  }

  public Object lastElement() {
    if (list.isEmpty())
      return null;
    else
      return list.lastElement();
  }

  /** 
   * Deletes the element object from the vector. If the object is not an
   * element, remove reports an error to the standard err.
   */
  public void remove(Object object) {
    if (!list.removeElement(object))
      System.err.println("Error in class ListObject: element not found.");
  }

  /**
   * This method inserts object as an element at the first position. Elements
   * in the vector are shifted over to make room.
   */
  public void add(Object object) {
    list.insertElementAt(object, 0);
  }

  /**
   * This method inserts object as an element at the position after object
   * after. Elements in the vector are shifted over to make room. If
   * object after is not in the vector a new element is inserted at
   * the first position.
   */
  public void insert(Object object, Object after) {
    int i;
    /* System.out.println("ListObject: insert"); */
    if (after == null) {
      /* System.out.println("+ListObject: append"); */
      this.append(object);
    }
    else {
      /* System.out.println("+ListObject: insert after or before"); */
      if (after instanceof Item) { // insert after item
	/* System.out.println("++ListObject: insert after " + after); */
	list.insertElementAt(object, 
	     (i = list.indexOf(((Item)after).getSlot())) >= 0 ? ++i : 0);
	/* System.out.println("That was location " + i); */
      }
      else if (after instanceof Slot) { // insert after slot
	/* System.out.println("++ListObject: insert before " + after); */
	list.insertElementAt(object, 
	     (i = list.indexOf((Slot)after)) >= 0 ? ++i : 0);
	/* System.out.println("That was location " + i); */
      }
      else 
	System.out.println("Warning: Class ListObject: insert failed."); 
    }
  }

  /**
   * This method inserts object as an element at the position before object
   * befObj. Elements in the vector are shifted over to make room. If
   * object befObj is not in the vector a new element is inserted at
   * the first position.
   */
  public void insertBefore(Object object, Object befObj) {
    int i;
    if (befObj == null)
      list.insertElementAt(object, 0);
    else {
      Slot slot = null;
      if (befObj instanceof Item) // insert before item
	slot = ((Item)befObj).getSlot();
      else if (befObj instanceof Slot) // insert before slot
	slot = (Slot)befObj;
      else 
	System.out.println("Warning: Class ListObject: insert failed."); 
      list.insertElementAt(object, (i = list.indexOf(slot)) >= 0 ? i : 0);
    }
  }

  /**
   * This method appends the new object to the list.
   */
  public void append(Object object) {
    list.addElement(object);
  }
  
  public int indexOf(Object obj) {
    /* System.out.println(obj.toString());
    System.out.println(list.firstElement().toString()); */
    return list.indexOf(obj);
  }

  /**
   * return an Enumeration for the current list of elements.
   */
  public Enumeration elements() {
    return list.elements();
  }

  /**
   * @return the number of elements currently in the vector. Note that this
   * is not the same as the Vector's capacity. 
   */
  public int size() {
    return list.size();
  }

  public String toString() {
    String str = "->";
    Enumeration enum = elements();
    while (enum.hasMoreElements()) {
      Object obj = enum.nextElement();
      if (obj instanceof Slot) {
	Item item = ((Slot)obj).getItem();
	if (item != null)
	  str += item.lbl;
      }
    }
    return str;
  }

}


