package tred;

import java.awt.*; 
import java.io.*;

/** abstract class Item to items */
public abstract class Item extends EditorObject implements Cloneable {
  private Slot slot;
  private Slot origSlot;
  // drawed-coordinates to place where object was previously painted
  private int drawed_x, drawed_y;
  private boolean hidden, infinite, isClone = false;

  /** This is the generic constructor for all items. */
  Item(String lbl) {
    this.lbl = lbl;
    hidden = false;
    infinite = false;
  }
    
  public void setInfinite() {
    infinite = true;
  }

  public boolean isInfinite() {
    return infinite;
  }

  /** 
   * @return the slot this item is attached to. 
   * @see Slot
   */
  protected Slot getSlot() { return slot; }

  /** 
   * This method changes the objects x and y coordinates to new location.
   */
  public void move(int x, int y) {
    this.x = x + dx;
    this.y = y + dx;
  }

  public boolean delete(int x, int y) {
    hide(true);
    moveObject(this, this, null);
    return true;
  }

  public void move(Trash trash, int x, int y) {
    invoked("move trash");
    hide(true);
    if ((x != 0) && (y != 0))
      moveObject(this, this, trash); 
  }

  /** 
   * This method changes the objects slot reference to new location. If
   * there was any previous location where this object was attached to 
   * the item reference of the old slot is set empty by invoking 
   * putItem(null) for the old slot. 
   * If reference to origSlot is null it is set to point to the new slot. 
   */
  public void move(EditorObject object, int x, int y) { 
    /* invoked("move to " + object); */
    
    if ((x != 0) && (y != 0) && (isInfinite())) {
      invoked("infinite object");
      try {
	Item newItem = (Item)clone();
	newItem.infinite = false;
	newItem.isClone = true;
	newItem.slot = getTrash().getSlot(0,0);
	newItem.origSlot = null;
	getGraphPanel().insertObject(newItem);
	moveObject(newItem, null, newItem);
	newItem.move(object, x, y);
	return;
      }
      catch (CloneNotSupportedException e) {
	Warning("move: CloneNotSupportedException");
      }
    }

    if (this.equals(object)) { // animator call: create
      hide(false);
      return;
    }
    else if (object == null) { // animator call: delete
      hide(true);
      return;
    }
    if (object instanceof EditorPanel)
      object = ((EditorPanel)object).getSlot(x,y);

    if (object instanceof Slot) {
      Slot slot = (Slot)object;
      if (slot == getSlot()) // reject the move into the same slot than before
	return;
      /* invoked("putItem to slot " + slot); */
      if ((slot = slot.putItem(this)) != null) {
	// record movement
	if ((x != 0) && (y != 0))
	  moveObject(this, this.slot, slot);
	if (this.slot != null)
	  this.slot.putItem(null);
	if (origSlot == null)
	  origSlot = slot;      
	this.slot = slot;
      }
    }
    else if (object instanceof Item) {
      Slot slot;
      if ((slot = 
	   ((Item)object).slot.insertItem(this, (Item)object)) != null) {
	// record movement
	if ((x != 0) && (y != 0))
	  moveObject(this, this.slot, slot);
	if (this.slot != null)
	  this.slot.putItem(null);
	if (origSlot == null)
	  origSlot = slot;      
	this.slot = slot;
      }
    } 
  }
  

  /** 
   * Generic paint method for Items. The items movement after the release 
   * (MouseUp) is handled here.
   * @return true if the place this object is moving to is reached; false
   * if the movement is not completed. 
   */
  public boolean paint(Graphics g) {
    boolean ready = true;

    width = itemsize-2;
    height = itemsize-2;

    if (!fixed) { // this object is not currently picked up
      // the next palce to draw (paint) the object is in the middle of the
      // current place and place to move to
      int sx = getSlot().x+1;
      int sy = getSlot().y+1;
      if (animated) {
	x = (sx+drawed_x)/2;
	y = (sy+drawed_y)/2;
      }
      else {
	x = sx;
	y = sy;
      }
      // if the object is near enough the place to move to (x-coord)
      if (Math.abs(x-sx) <= 2) {
	drawed_x = sx;
	x = drawed_x;
      }
      else {
	drawed_x = x;
	ready = false;
      }
      // (y-coord)
      if (Math.abs(y-sy) <= 2) {
	drawed_y = sy;
	y = drawed_y;
      }
      else {
	drawed_y = y;
	ready = false;
      }    
    }
    else {
      drawed_x = x;
      drawed_y = y;
    }
    return ready;
  }

  public String toString() {
    return lbl;
  }

}
