package tred;

import java.awt.*; 

/** implementation to Slots of heads of trees */
class HeadSlot extends StreamSlot implements Cloneable {
  private Slot root;
  
  HeadSlot(EditorPanel panel, int id) {
    super(panel, id);
  }

  /* This method is invoked when a new root node is created for a tree.
   * @return allways null because the movement of the item must be rejected! 
   */
  protected Slot putItem(Item item) {
    ((BPlus)editorPanel).createNewRoot(item);
    return null;
  }

  public void setRoot(Slot slot) {
    root = slot;
  }

  public void move(EditorObject obj, int x, int y) {
    if (!((x == y) && (x == 0)))
      moveObject(this, getRoot(), (Slot)obj);
    setRoot((Slot)obj);
  }

  public Slot getRoot() {
    return root;
  }
}

