package tred;

import java.awt.*; 
import java.io.*;

/** 
 * Implementation to Items of HashStream. HashStreamItems are similar to
 * the StreamItems but the hashvalue of the label is displayed just below
 * the rounding box of the item.
 */
public class HashStreamItem extends StreamItem {

  /** 
   * This is the constructor for HashStreamItem. It simply does nothing
   * but invokes the super constructor.
   * @see StreamItem
   */
  public HashStreamItem(String label) {
    super(label);
  }

  public Rectangle getBounds() {
    return new Rectangle(x-1, y-1, width+2, 2*height + 2);
  }

  /** 
   * This method is invoked when this item is draw into the screen. 
   * The behaviour is same as in the StreamItem:paint() method except that
   * the hashItem also has a hashvalue displayed just below the bounding box. 
   * @return value of super.paint().
   */
  public boolean paint(Graphics g) {
    boolean ready = super.paint(g);
    FontMetrics fm = g.getFontMetrics();
    //int w = fm.stringWidth(lbl);
    //int h = fm.getHeight();
    String hashstr;
    if (lbl.charAt(0) >= "a".charAt(0))
      hashstr = String.valueOf(lbl.charAt(0) - "a".charAt(0) + 1);
    else
      hashstr = String.valueOf(lbl.charAt(0) - "A".charAt(0) + 1);
    //g.drawRect(x, y, width, height);
    //g.drawString(lbl, x + (width - w)/2, y + (height + h)/2);
    g.drawString(hashstr, 
		 x+1 + (width - fm.stringWidth(hashstr))/2, 
		 y + (height)/2 + itemsize);
    return ready;
  }
}



