package tred;

import java.awt.*; 
import java.io.*;
import java.util.*;

class State {
  Edge edge;
  int counter;

  State(Edge edge, int counter) {
    this.edge = edge;
    this.counter = counter;
  }

  public int counter() {
    /* System.out.println("My counter shows " + counter); */
    return counter;
  }

  public String toString() {
    return "State " + counter;
  }
}

/** Implementation to Graph. */
public class Graph extends NodePanel {
  Vector edges;
  int edgeCount, counter = 0;

  //-------- constructors 

  /** 
   * This is the default constructor for Graph. 
   * This constructor invokes the super constructor with no parameter items.
   * This is in order to do not let the super constructor to create items
   * for every single mark in the items string because the structure of string
   * items is not same as with the other panels. So, this constructor parses
   * the string items by itself and creates the neccessary slot and edge 
   * objects. 
   */
  public Graph(GraphPanel panel, String label, String items, int space) {
    // this constructor handles items by itself
    super(panel, label, "", space);
    len = 0;

    // slots & nodes
    for (StringTokenizer t = new StringTokenizer(items, ";"); 
	 t.hasMoreTokens() ; ) {
      String s = t.nextToken();
      NodeSlot nodeSlot = new NodeSlot(this, len++);
      slots[nslots++] = nodeSlot;
      
      if (s.length() > 0) {
	NodeItem nodeItem = new NodeItem(s.substring(0,1));
	nodeItem.move(nodeSlot,0,0);
	graphPanel.insertObject(nodeItem);
      }
      graphPanel.addObject(nodeSlot);
    }

    // edges between slots
    edges = new Vector();
    edgeCount = 0;
    for (StringTokenizer t = new StringTokenizer(items, ";"); 
	 t.hasMoreTokens() ; ) {
      String s = t.nextToken();
      Slot fslot = findSlot(s.substring(0, 1));
      for (int i=1; i<s.length(); i++) {
	Edge edge = new Edge(edgeCount++, 
			     fslot, findSlot(s.substring(i, i+1)));
	graphPanel.addObject(edge);
	edges.addElement(new State(edge, 0));
      }
    }

    y = (position + 1) * itemsize;
    graphPanel.nextPosition += 13;
    x = itemsize;
  }

  //-------- private methods

  private Slot findSlot(String str) {
    for (int i=0; i<nslots; i++)
      if (str.equals(slots[i].getItem().nameOf()))
	return slots[i];
    return null;
  }
    
  /** @return base 2 log (Java Math supports only natural log) */
  private double log2(int i) {
    return Math.log(i)/Math.log(2);
  }

  // -------- public methods

  /** 
   * This method is invoked by class Edge to keep track of visit order.
   * @param id is the id-number of this edge 
   * (initialized by constructor Graph).
   * @param edge is the edge which cghanged it's state.
   * @param traveled is true if the edge is set, false if the edge is unset.
   */
  protected void newState(int id, Edge edge, boolean traveled) {
    edges.setElementAt(new State(edge, traveled ? ++counter : 0), id); 
  }

  /** 
   * This method is invoked in order to get the state of this panel for
   * export.
   * @param str is the substitute string for empty slot.
   * @return the current state (string of items in the slots) of this panel. 
   * @see animImpl.export
   */
  protected String getState(String str) {
    State state;
    String s = "";
    Vector tmp = new Vector(counter + 1);

    tmp.setSize(counter + 1);
    for (int i=0; i<edgeCount; i++)
      tmp.setElementAt(edges.elementAt(i), 
		       ((State)edges.elementAt(i)).counter());
    for (int i=1; i<=counter; i++)
      if ((state = (State)tmp.elementAt(i)) != null)
	s += state.edge.fslot.getItem().lbl + 
	  state.edge.tslot.getItem().lbl + " ";
    return s;
  }

  /** 
   * This method is invoked when this graph is drawed on the screen.
   * This method draws the name of the Graph to top of the area.
   * After that all the slots are drawed as Graph-like style by
   * invoking the paint method for slots and then drawing all the 
   * edges needed.
   * @return allways true.
   */
  public boolean paint(Graphics g) {
    // the fixed positions of nodes should look like this
    // A     C
    //    B
    //   D E
    //  F G H
    //   I J
    //    L
    // K     M

    FontMetrics fm = g.getFontMetrics();
    int label_w = fm.stringWidth(lbl+" ") + itemsize;
    int label_h = fm.getHeight();
    // empty space left to both sides (2 * itemsize)
    int panelWidth = graphPanel.getSize().width - 2*itemsize;

    // center the label and leave empty space (itemsize) to the left  
    g.drawString(lbl, 
		 x+6*(itemsize+getSpace())/2 - label_w/2+itemsize, 
		 y+label_h);
    // Nodes are put to fixed places
    int nx = 0, ny = 0;
    for (int i=0; i<len; i++) {
      switch (i) {
      case 0:
      case 10:
	nx = 0;
	ny = 1;
	break;
      case 5:
	nx = 1;
	break;
      case 3:
      case 8:
	nx = 2;
	ny = 3;
	break;
      case 1:
      case 6:
      case 11:
	nx = 3;
	ny = 2;
	break;
      case 4:
      case 9:
	nx = 4;
	ny = 3;
	break;
      case 7:
	nx = 5;
	ny = 4;
	break;
      case 2:
      case 12:
	nx = 6;
	ny = 1;
	break;
      }
      switch (i) {
      case 5:
      case 6:
	ny = 4;
	break;
      case 8:
      case 9:
	ny = 5;
	break;
      case 11:
	ny = 6;
	break;
      case 10:
      case 12:
	ny = 7;
	break;
      }
      nx = nx * (itemsize + getSpace()) + x;
      ny = ny * itemsize + y;
      slots[i].paint(g, nx, ny);
    }

    width = panelWidth;
    height = (int)(2 * itemsize * (Math.rint(log2(len)) + 1));
    return true;
  }
  
}
