package tred;

import java.util.*;
import java.awt.*; 
import java.io.*;
import java.net.*;

class ExportObject {
  String dstr;
  String addStr;
  EditorObject before, after;
  
  ExportObject(String dstr, String addStr, EditorObject e, EditorObject a) {
    this.dstr = dstr;
    this.addStr = addStr;
    this.before = e;
    this.after = a;
  }

  public String toString() {
    return addStr + " before " + before + " after " + after;
  }
}

/** abstract root class EditorObject for all objects. */
public abstract class EditorObject implements Cloneable, Animated {
  /** debug information is printed while debug flag is on */
  public boolean DEBUG = false;
  public boolean WARNINGS = true;

  /** This flag indicates that this object is currently picked up by mouse. */
  public boolean fixed;
  public int dx, dy;
  public boolean getBounds = true;

  //-------- Protected Fields

  /** 
   * This is the static itemsize value. Size of all objects is proportional
   * to this value. 
   */
  protected static int itemsize = 20;
  protected static Trash trash = null;
  /** static fontMetrics */
  protected static FontMetrics fontMetrics;
  /** Every editorObject has a upper left corner (x,y). */
  protected int x, y;
  /** Every editorObject has size (width x height). */
  protected int width = itemsize, height = itemsize;
  /** Every editorObject has a label. */
  protected String lbl = "unknown";
  /** This field contains the GraphPanel where this object belongs. */
  protected GraphPanel graphPanel;

  //-------- Private Fields

  /** If object is disabled it cannot be moved on the screen. */
  private boolean disabled = false;
  /** Attribute hidden determines if this object is visible or not */
  private boolean hidden = false;
  /** This field indicates wheter this object is exportable. */
  private boolean isOutputObject = false;
  /** 
   * This field indicates wheter this object should recalculate 
   * it's position.
   */
  protected boolean touched = true;
  /** String to mark null items when object is exported. */
  protected String dstr = null;
  /** String to add to the beginning of the answer when object is exported. */
  protected String addStr = null;
  /** Table of Strs to indicate which state (before some obj) is exported. */
  protected ListObject outputStateList;

  //-------- Static Fields

  /** This field contains the next objects position on the screen. */
  // public static int nextPosition;
  /** Here is the reference to implementation of the interface Animated. */
  protected static AnimatedImpl animImpl;
  protected static boolean animated = false;
  // This field is used in method nameOf to name objects which labels are null.
  private static int noNameId = 0;

  //-------- Abstract methods
  
  /** Every editorObject should implement it's own paint method. */
  abstract boolean paint(Graphics g);

  //-------- Public static methods

  /**
   * This method is invoked in order to set the fontMetrics for
   * all objects.
   */
  public static final void setFontMetrics(FontMetrics fm) {
    fontMetrics = fm;
  }
  public static final void setTrash(Trash t) {
    trash = t;
  }
  public final Trash getTrash() {
    if (trash == null)
      trash = new Trash(graphPanel, "__INTERNAL_TRASH__");
    return trash;
  }


  //-------- Public methods forwarded to animImpl object

  /** 
   * This method is forwarded to animImpl object and sets touched field 
   * for every object. 
   */
  public final static void touchAll() {
    if (animImpl != null)
      animImpl.touchAll();
  }
  /** This method initializes the itemsize field. */
  public final static void setItemSize(int size) {
    itemsize = size;
    touchAll();
  }
  public final static int getItemSize() {
    return itemsize;
  }
  
  /** 
   * This method is forwarded to animImpl object. 
   * @see AnimatedImpl 
   */
  public final static void resetBuffers() { 
    if (animImpl != null)
      animImpl.reset(); 
  }
  /** 
   * This method is forwarded to animImpl object. 
   * @see AnimatedImpl 
   */
  static boolean combined = false;
  static boolean startMarked = false;
  public final static void moveObject(EditorObject obj, 
				   EditorObject fromObj, 
				   EditorObject toObj) {
    if (combined) {
      animImpl.moveObject(null, null, null);
      startMarked = true;
      combined = false;
    }
    animImpl.moveObject(obj, fromObj, toObj);
  }
  public final static void markMovement() {
    if (!combined) {
      if (startMarked) {
	animImpl.moveObject(null, null, null);
	startMarked = false;
      } 
      else
	combined = true;
    } 
    else
      combined = false;
  }

  /** 
   * This method is forwarded to animImpl object. 
   * @see AnimatedImpl 
   */
  public final static void moveBackward() { 
    animImpl.moveBackward();
  }
  /** 
   * This method is forwarded to animImpl object. 
   * @see AnimatedImpl 
   */
  public final static void moveForward() { 
    animImpl.moveForward();
  }
  /** 
   * This method is forwarded to animImpl object. 
   * @see AnimatedImpl 
   */
  public final static void moveBegin() { 
    animImpl.moveBegin();
  }
  /** 
   * This method is forwarded to animImpl object. 
   * @see AnimatedImpl 
   */
  public final static void moveEnd() { 
    animImpl.moveEnd();
  }
  /** 
   * This method is forwarded to animImpl object. 
   * @see AnimatedImpl 
   */
  public final void export(MyPrintStream printStream) {
    if (isOutputObject)
      animImpl.export(this, printStream);
  }

  //-------- Public methods

  /** 
   * For speeding up the update procedure one might override this
   * method in order to update only the given area of the object.
   * The generic method just invokes the paint(Graphics g) method.
   * @param g - Graphics
   * @param rect - Rectangle which is updated
   */
  public boolean paint(Graphics g, Rectangle rect) {
    return paint(g);
  }

  /** 
   * This method should be overridden in order to invoke setFont
   * for every subComponent 
   */
  public void setFont(Font font) {}

  public Rectangle getBounds() {
    return new Rectangle(x-1, y-1 , width+2, height+2);
  }

  public boolean contains(int px, int py) {
    return ((x <= px) && (px <= x + width) && 
	    (y <= py) && (py <= y + height)); 
  }

  /*
  public boolean intersects(EditorObject pick, Rectangle pickRec, boolean t) {
    if (pick == this)
      return false;
    return (contains(pickRec.x, pickRec.y) || 
	    contains(pickRec.x + pickRec.width, pickRec.y) ||
	    contains(pickRec.x, pickRec.y + pickRec.height) ||
	    contains(pickRec.x + pickRec.width, pickRec.y + pickRec.height) ||
	    (t && pick.intersects(this, this.getBounds(), false)));
  }
  */

  /*
  public boolean fullfills(int x, int y, int width, int height) {
    if ((x < this.x) && (this.x < x + width) &&
	(((this.y < y) && (y < this.y + this.height)) ||
	 ((this.y < y + height) && (y + height < this.y + this.height))) ||
	((y < this.y) && (this.y < y + height) &&
	 (((this.x < x) && (x < this.x + this.width)) ||
	  ((this.x < x + width) && (x + width < this.x + this.width)))))
      return true;
    if ((x < this.x) && (this.x < x + width) && 
	(y < this.y) && (this.y < y + height))
      return true;
    return false;
  }
  */

  /** @return GraphPanel graphPanel */
  public final GraphPanel getGraphPanel() {
    return graphPanel;
  }
  public final void setGraphPanel(GraphPanel gp) {
    graphPanel = gp;
  }

  /** This method is invoked to get the size of this object. Subclasses 
   * which do not have generic size (width * height) should override this 
   * method.
   * @return the current size of this object.
   */
  public final Dimension size() {
    return new Dimension(width, height);
  }
  /** Non movable panels which have movable elements should override
   * this method to return the element which should be moved when picked.
   */
  public EditorObject element(int x, int y) {
    return this;
  }

  /** 
   * These methods (move()) are implemented to be overridden. 
   * Every editorObject should implement it's own move methods. These generic
   * methods simply do nothing.
   */
  /* public void move(Trash trash, int x, int y) { 
    move((EditorObject)trash, x, y);
  }
  public void move(Item item, int x, int y) {
    move((EditorObject)item, x, y);
  } */
  public void move(EditorObject to, int x, int y) {}
  public void animatorMove(EditorObject to) {
    move(to, 0, 0);
  }

  /**
    * This methid is implemented to be overridden.
    * This method is invoked when a user sends a split event to an object.
    * This generic split method simply do nothing 
    */
  public boolean split(int x, int y) { 
    invoked("Cannot split.");
    return false;
  }

  /**
    * This methid is implemented to be overridden.
    * This method is invoked when a user sends a delete event to an object.
    * This generic delete method simply do nothing 
    */
  public boolean delete(int x, int y) { 
    invoked("Cannot delete."); 
    return false;
  }

  /** 
   * This method is implemented to be overridden. 
   * Every editorObject should implement it's own click method. This generic
   * method simply do nothing.
   */
  public void click() { }

  /* 
   * Attribute order is set with this method. This method is implemented
   * to be overridden with subclasses.
   */
  protected void setOrder(String order) {}

  /** 
   * This method is implemented to be subclassed. 
   * Every editorObject should implement it's own move method. This generic
   * method simply do nothing.
   */
  public void move(int x, int y) {}

  /** 
   * This method sets the object to be exportable. 
   * @see AnimatedImpl 
   */
  public final void setOutput(String dstr, String addStr, 
			      EditorObject before, EditorObject after) {
    if (!isOutputObject) {
      isOutputObject = true;
      outputStateList = new ListObject();
    }
    outputStateList.add(new ExportObject(dstr, addStr, before, after));
  }

  /** This method disables the object. */
  public final void disable() {
    disabled = true;
  }

  /** This method enables the object. */
  public final void enable() {
    disabled = false;
  }

  /** 
   * @return true if object is disabled.
   */
  public final boolean disabled() {
    return disabled;
  }

  /** 
   * This method sets the hidden flag which determines if this object
   * is visible or not.
   * @param flag; true = hidden, false = visible.
   */
  public final void hide(boolean flag) {
    hidden = flag;
  }

  /** @return true if this slot is visible; false if this slot is hidden. */
  public final boolean isVisible() {
    return !hidden;
  }
  
  /** Sets or unsets the touched field. */
  public final void touch(boolean value) {
    touched = value;
  }

  /** Informs this object to recalculate it's position. */
  public final void touch() {
    touch(true);
  }

  /** @return True if this object has been touched. False otherwise. */
  public final boolean touched() {
    return touched;
  }
  
  /**
   * This is the general method for inside. Special classes should override
   * this method if upper left corner is not (x,y) and/or object doesn't
   * have width and height fields properly initialized.
   * @return true if point (x,y) is inside this component. 
   */
  public boolean inside(int x, int y) {
    return ((x > this.x) && (y > this.y) && 
	    (x < this.x + this.width) && 
	    (y < this.y + this.height));
  }
    
  /** Unsupported method. Use toString() */
  public final String nameOf() {
    return lbl == null ? "noName" + noNameId++ : lbl;
  }

  /** @return String getClass().toString(). */
  public String toString() {
    return "Class:" + getClass().toString() + " Value:" + lbl;
  }
  
  /** All exportable classes should override this method. */
  String getState(String s) { return null; }

  /** @return String to mark null items when object is exported. */
  final String getSeparator() {
    return dstr;
  }

  /** */
  public void invoked(String str) {
    if (DEBUG)
      System.err.println(this + " INVOKED: " + str);
  }

  public void Warning(String str) {
    if (WARNINGS)
      System.err.println("Warning: " + getClass() + " in method " + str);
  }
}
