package tred;

import java.awt.*;

/** implementation to TextArea */
public class EditorButton extends EditorPanel {
  Button button;
  Dimension d = new Dimension();
  int counter = 0;

  /** 
   * This is the default constructor for EditorButton
   * @param graphPanel the panel whics this panel belong.
   * @param label the name of the panel.
   * @param items initial items of the panel.
   * @param space the number of columns in the textArea. Default = 20.
   */
  EditorButton(GraphPanel graphPanel, String label, String items, int space){
    super(graphPanel, label, "", space);
    graphPanel.add(button = new Button(this.toString()));
    addPanel(this);
  }

  public void reset() {
  }

  public final void setFont(Font font) {
    if (button != null)
      button.setFont(font);
  }

  public void move(EditorObject object, int x, int y) {
    // forward
    if (object != null) {
      counter++;
    }
    // backward
    else {
      counter--;
    }
    button.setLabel(this.toString());
  }

  public void push() {
    moveObject(this, null, this);
    counter++;
    button.setLabel(this.toString());
  }

  public String getState(String str) {
    return null;
  }

  public boolean paint(Graphics g) {
    if (touched()) {
      x = itemsize;
      y = position * itemsize;
      d.width = fontMetrics.stringWidth(this.toString()) + itemsize;
      d.height = fontMetrics.getHeight() + itemsize;
      button.setFont(fontMetrics.getFont());
      button.reshape(x+itemsize,y,d.width,d.height);
      button.validate();
      touched = false;
    }
    return true;
  }
  
  public String toString() {
    return lbl + " " + String.valueOf(counter);
  }
}


