package tred;

import java.awt.*; 
import java.io.*;
import java.util.*;

/** implementation to BPlus */
public class BPlus extends Tree {
  private BSlot head = null;

  /** 
   * This constructor invokes the super constructor and ...
   * 
   */
  BPlus(GraphPanel panel, String label, String items) {
    super(panel, label, null);
    position = graphPanel.nextPosition;
    graphPanel.nextPosition += 0;
    addPanel(this);
    setOrientation(true);    
    isListPanel = true;
    x = 0;
    y = position * itemsize;
  }

  /** 
    * Head of the tree is not the same as root slot of the tree.
    * A tree has a head slot which is treated as a "pointer to the root slot"
    * of the given tree.
    * @return BSlot head - head pointer (slot) of the tree 
    */
  public BSlot getHead() {
    return head;
  }

  /** This methos is invoked when a new root slot is created for this tree and
   * are set to newHead.
   * Note: this method do not take care of the old root and it's children!
   * The calling method should take care of setting the old root as a
   * child of new root or what else is correct.
   * @param newHead - the new root slot of this tree
   */
  public void setHead(BSlot newHead) {
    /* invoked("setHead " + newHead); */
    head = newHead;
  }

  public boolean delete(int x, int y) {
    BSlot dSlot = (BSlot)getSlot(x, y);
    if (dSlot != null)
      return dSlot.delete(x, y);
    /* else
      System.out.println("no such item " + x + "," + y); */
    return false;
  }

  public boolean split(int x, int y) {
    BSlot dSlot = (BSlot)getSlot(x, y);
    if (dSlot != null)
      return dSlot.split(x, y);
    /* else
      System.out.println("no such item " + x + "," + y); */
    return false;
  }

  public EditorObject element(int x, int y) {
    if (head == null) {
      move(new BSlot(this), -1, -1);
      setLocation();
      return head;
    }
    return getElement(x,y);
  }

  public void move(EditorObject object, int x, int y) {
    /* invoked("move head " + object); */
    if ((x != 0) && (y != 0)) {
      if ((x == -1) && (y == -1)) { // new head set (BSlot calls)
	moveObject(this, head, object);
	if (object != this)
	  setHead((BSlot)object);
	else
	  setHead(null);
      }
      else {
	BSlot slot = (BSlot)getSlot(x,y);
	if (slot != null)
	  slot.move(object,x,y);
      }
    }
    else { 
      if (object == this)
	object = null;
      if ((object instanceof BSlot) || // new head set (Animator calls)
	  (object == null)) { 
	setHead((BSlot)object);
	if (object != null)
	  object.hide(false);
      }
    }
  }

  /** Shorthand notation for move(this, -1, -1) */
  public void move() {
    move(this, -1, -1);
  }

  /** 
   * This method determines which slot of this panel is located in (x,y).
   * @return the slot in coordinates (x,y). If there is no slot in the (x,y)
   * return null.
   */
  public Slot getSlot(int x, int y) {
    return head.hasSlot(x, y);
  }
  public EditorObject getElement(int x, int y) {
    return head.hasElement(x, y);
  }


  public boolean intersects(EditorObject p, int x, int y,
			    int width, int height) {
    return true;
  }

  /** 
   * This method draws the name of the tree to top of the area.
   * After that all the slots are drawed as tree-like style by
   * invoking the paint method for slots and then drawing the connecting
   * lines between parent slot and target slot.
   */
  public boolean paint(Graphics g) {
    int label_w = fontMetrics.stringWidth(lbl+" ") + itemsize;
    int label_h = fontMetrics.getHeight();
    width = graphPanel.getSize().width - 2*itemsize;
    height = graphPanel.getSize().height;
    g.drawString(lbl, width/2 - label_w/2 + itemsize, y + label_h);
    if (head != null)
      head.paint(g);
    return true;
  }
  public boolean paint(Graphics g, Rectangle rect) {
    int label_w = fontMetrics.stringWidth(lbl+" ") + itemsize;
    int label_h = fontMetrics.getHeight();
    width = graphPanel.getSize().width - 2*itemsize;
    height = graphPanel.getSize().height;
    g.drawString(lbl, width/2 - label_w/2 + itemsize, y + label_h);
    if (head != null)
      head.paint(g, rect);
    return true;
  }

  public void setLocation() {
    if (head != null)
      head.setLocation(width / 2, y + itemsize, width);
  }
  
}
