package tred;

import java.util.*;
import java.awt.*; 
import java.io.*;
import java.net.*;

/** Animated implementation to replay Item moves. */
public class AnimatedImpl implements Animated {
  private int nbuf, curr;
  private Hashtable editorPanels = new Hashtable();
  private Vector movedObjects = new Vector(/*2*/);
  private GraphPanel graphPanel;

  AnimatedImpl(GraphPanel graphPanel) {
    this.graphPanel = graphPanel;
  }

  private void make_buttons_consistent() {
    if (isBegin()) {
      graphPanel.backward.disable();
      graphPanel.begin.disable();
    }
    else {
      graphPanel.backward.enable();
      graphPanel.begin.enable();
    }
    if (isEnd()) {
      graphPanel.forward.disable();
      graphPanel.end.disable();
    }
    else {
      graphPanel.forward.enable();
      graphPanel.end.enable();
    }
  }

  private boolean isBegin() { return (curr == 0);  }

  private boolean isEnd() { return (curr == nbuf); }
  
  // the logic to remove unneccessary moves
  // after this the buffer (itemList & Slot) should be consistent
  private void make_buffer_consistent() {
    String currstate = thisState();
    // compare to previous states
    moveBegin();
    while ((!isEnd()) && (!currstate.equals(thisState())))
      moveForward();
    nbuf = curr;
  }

  public void reset() {
    moveBegin();
    nbuf = curr = 0;
  }

  /**
   * This method keeps record of movements on the screen. It invokes the
   * method move of object obj and determines if the movement was legal. If 
   * the move request was accepted and there was object toObj (!=null) the
   * movement was recorded so that it could be replayed. If there is no object
   * toObj the movement is not recorded but the object might have changed it's
   * location. 
   */
  public void moveObject(EditorObject obj,
			 EditorObject fromObj,
			 EditorObject toObj) {

    /* System.out.println("Anim: <" + obj + 
		       ", " + fromObj + 
		       ", " + toObj + ">");
		       */

    if ((obj == null) && (fromObj == null) && (toObj == null)) {
      nbuf = curr++;
      if (movedObjects.size() <= nbuf) {
	movedObjects.addElement(new MovedObject(null, null, null));
	nbuf++;
      }
      else
	movedObjects.setElementAt(new MovedObject(null, null, null),
				  nbuf++);
    }
    else
      if (toObj != null) { 
	nbuf = curr++;
	if (movedObjects.size() <= nbuf) {
	  movedObjects.addElement(new MovedObject(obj, fromObj, toObj));
	  nbuf++;
	}
	else
	  movedObjects.setElementAt(new MovedObject(obj,fromObj,toObj), 
				    nbuf++);
	//haven't desided yet how the logic should work
	//make_buffer_consistent();
	make_buttons_consistent();
      } 
  }

  public void moveBackward() {
    MovedObject movedObject = (MovedObject)movedObjects.elementAt(--curr);
    if (movedObject.isMarker()) {
      while (!(movedObject = 
	      (MovedObject)movedObjects.elementAt(--curr)).isMarker())
	movedObject.obj.animatorMove(movedObject.from);
    }
    else
      movedObject.obj.animatorMove(movedObject.from);
    make_buttons_consistent();
  }

  public void moveForward() {
    MovedObject movedObject = (MovedObject)movedObjects.elementAt(curr++);
    if (movedObject.isMarker()) {
      while (!(movedObject = 
	      (MovedObject)movedObjects.elementAt(curr++)).isMarker())
	movedObject.obj.animatorMove(movedObject.to);
    }
    else
      movedObject.obj.animatorMove(movedObject.to);
    make_buttons_consistent();
  }

  public void moveEnd() {
    while (curr != nbuf)
      moveForward();
  }

  public void moveBegin() {
    while (curr != 0)
      moveBackward();
  }

  public void touchAll() {
    Enumeration e = editorPanels.elements();
    while (e.hasMoreElements())
      ((EditorPanel)e.nextElement()).touch();
  }

  // These methods should be implemented in the interface "exportable"

  /** This method is invoked when an object panel is exported. Method
   * searches the panel's before list and determines which states are
   * exported or exports all states if there is no special states
   * defined.
   * @param panel is the EditorPanel to be exported.
   * @param MyPrintStream is the stream where output is printed.
   */
  public void export(EditorObject panel, MyPrintStream printStream) {
    MovedObject movedObject = null;
    boolean flag = false;
    boolean do_while = false;

    moveBegin();
    
    // special case begin == end
    if (isEnd())
      do_while = true;
    while (!isEnd() || do_while) {
      if (!do_while) {
	movedObject = (MovedObject)movedObjects.elementAt(curr);
	// skip marker
	if (movedObject.isMarker())
	  movedObject = (MovedObject)movedObjects.elementAt(curr + 1);
	moveForward();
      } else do_while = false;
      // export all the middle states of the aswer
      Enumeration enum = panel.outputStateList.elements();
      while (enum.hasMoreElements()) {
	ExportObject e = (ExportObject)enum.nextElement();
	// end state marked
	if ((e.before == panel) && (isEnd())) {
	  if (e.addStr != null)
	    printStream.println(e.addStr);
	  printStream.println(panel.getState(e.dstr));
	}
	// all states exported
	else if ((e.before == null) && (e.after == null)) {
	  if ((!flag) && (e.addStr != null))
	    printStream.println(e.addStr);
	  flag = true;
	  printStream.println(panel.getState(e.dstr));
	}
	// some other state marked as before
	else if ((movedObject != null) &&
		 (((movedObject.to instanceof Slot) &&
		   (((Slot)movedObject.to).editorPanel == e.before)) ||
		  ((movedObject.to instanceof EditorButton) &&
		   (movedObject.to == e.before))) &&
		 (e.before != panel)) {
	  moveBackward();
	  if (e.addStr != null)
	    printStream.println(e.addStr);
	  printStream.println(panel.getState(e.dstr));
	  moveForward();
	}
	// some other state marked as after
	else if ((movedObject != null) &&
		 (movedObject.from instanceof Slot) &&
		 (((Slot)movedObject.to).editorPanel == e.after) &&
		 (e.after != panel)) {
	  if (e.addStr != null)
	    printStream.println(e.addStr);
	  printStream.println(panel.getState(e.dstr));
	}
      }
    }
  }

  public void addPanel(EditorObject panel) {
    editorPanels.put(panel.nameOf(), panel);
  }

  private String thisState() {
    String state = "";
    Enumeration e = editorPanels.elements();
    while (e.hasMoreElements())
      state += ((EditorPanel)e.nextElement()).getState("");
    return state;
  }
}
