
/*

TODO:

  0. make it a flag to force integer prior to one of the ops that
        needs it (i.e. <<,!,etc.) by inserting an RINT into the EQ

  1. make Store and PreStore use linked lists of arrays of 64 members

  2. various optimization stuff

  3. There's some kind of bug if you turn off the OPTIMIZE flag

*/

/*
 *
 *
 *** THE CRBEQ OPTIMIZING EQUATION COMPILER ****
 *
 *
 *  12-8-95 : no known bugs
 *

**********
  NOTES :
**********

EQ is in reverse polish :

i.e. :

9
SIN
4
+

means

sin(9) + 4

-------

key to usage :

unless otherwise stated, rules are intuitive.

'~' means "logical xor"

programming operators (|,&,>>,<<) work, but must be used on integers
  same for factorial ( ! )
** <> todo: make it a flag to force integer prior to one of these
  ops, by inserting an RINT into the EQ

@N means "get from UserVar #N"

UserVars must be allocated by the external program.

'>' means '>>' and '<' means '<<'

LINT    64 / *   lower integer * /
GINT    65 / * greater integer * /
RINT    66 / *   round integer * /

---

this program rocks!

---

ORDER OF OPS:

0. factorial
1. functions (trig,log,etc.,random order)
2. programming operators (shift,and,or,xor)
3. exponentials
4. mult & div
5. add & sub

 *
 *
 */

#ifdef _MSC_VER
#pragma warning(disable : 4244) // ulong -> uword
#endif

#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <math.h>
#include <stdio.h>

#include <crblib/inc.h>
#include <crblib/memutil.h>
#include <crblib/strutil.h>

#include <crblib/equtil.h>
#include <crblib/crbconv.h>
#ifndef unix
#include <crblib/floatutil.h>
#endif

/*definitions*/

#define STRSIZE          1024
#define MAXDEBUGMESS     1024
#define WRKSIZE          (1<<15)
#define MAXNUMPRESTORES  1024
#define MAXNUMSTORES     1024

#define NUMPREPARSETOKENS 1024
#define NUMORDTERMS       1024

#ifndef PI
#define PI ((double)3.14159265358979323846)
#endif

#ifdef ABS
#undef ABS
#endif

#ifndef mabs
#define mabs(x) ( (x) < 0 ? - (x) : (x) )
#endif

const static ubyte STOREubyte = '';
  /*temp ubyte in parsing: must not be used in any other way*/

/*flags*/
#define DEBUG    (1<<0)
#define OPTIMIZE (1<<1)

/*operators*/
#define DONE    0     /*returns a  (must always be 0!!!!)*/

#define ADD     1     /*a=a+b*/
#define SUB     2     /*a=a-b*/
#define MULT    3     /*a=a*b*/
#define DIV     4     /*a=a/b*/
#define POW     5     /*a=a^b*/

#define AtoB      10  /*b=a*/
#define BtoA      11  /*a=b*/
#define swapAB    12  /*a=b,b=a   (only generated by optimizer)*/

#define PRESTORED 20  /*b=pre-store*/
#define FMSTORE   21  /*b=(run-time-store)*/
#define TOSTORE   22  /*(run-time-store)=a*/
#define FMUSERVAR 23  /*b=UserVar (not used by the library, used by TMM)*/

#define ISSTORE(x) ( x >= 20 && x <= 23 ) /* tells is an command is a store-type*/

#define HtoB      29  /*b=x*/
#define XtoB      30  /*b=x*/
#define YtoB      31  /*b=y*/
#define ZtoB      32  /*b=z*/
#define TtoB      33  /*b=t*/
#define RtoB      34  /*b=r(esult)*/
#define AtoX      35  /*x=a    (not used by the library, used by TMM) */
#define AtoY      36  /*y=a     */
#define AtoZ      37  /*z=a*/
#define AtoT      38  /*t=a*/
#define AtoR      39  /*r=a*/

#define LOG     50    /*a=func(a)  */
#define LN      51    /*^^^^^^^^^ same for all functions*/
#define L2    	52    
#define COS     53
#define SIN     54
#define TAN     55
#define ACOS    56
#define ASIN    57
#define ATAN    58
#define SINH    59
#define COSH    60
#define TANH    61
#define ASINH    62
#define ACOSH    63
#define ATANH    64
#define ABS     65
#define FACT_B  66 /* special : factorial operates on register B */
#define LINT    67 /*   lower integer */
#define GINT    68 /* greater integer */
#define RINT    69 /*   round integer */
#define SQRT	70

#define PROG_OR         80 /* programming operators A = A op B */
#define PROG_AND        81 /* example : A = A & B */
#define PROG_XOR        82
#define PROG_LEFTSHIFT  83
#define PROG_RIGHTSHIFT 84

#define BLANK   255   /*optimizer temp code*/

struct EqData
  {
  double Result;
  double X,Y,Z,T,H;
  int ParseError;
  ubyte *ErrorMess;
  ubyte **DebugMess;

  double *UserVar; int NumUserVars;
  
  ubyte *EQ;          int EQSize;
  double *PreStored;  int PreStoredSize;
  double *Store;      int StoreSize;
  ubyte *StrEq;       int StrEqSize;

  ubyte *WrkBase;
  ubyte *WrkPtr;
  ubyte *RepPtr;
  int DebugMessNext;
  int Flags;
  int CurPreStoreNum;
  int CurStoreNum;  
  int CPos;
  int SLen;

  ubyte **Tokens;
  int TokNum;
  ubyte *TokWork;
  int TokWorkCnt;
  ubyte **OrdTerms;
  ubyte *OrdPri;
  ubyte *OrdWork;
  };

/*protos:*/
/*for the user:*/
double ValCRBEQ(struct EqData *d);
struct EqData * MakeCRBEQ(ubyte *StrEQ,int inFlags);
void FreeCRBEQ(struct EqData *d);
int CopyCRBEQ(struct EqData *din,struct EqData **dout);
void HelpCRBEQ(void);

/*internal:*/
void PreParseDifferentials(char **strptr,int *strlptr);
short SimplifyEQ  (struct EqData *D);
void MakeTerm     (struct EqData *D);
double ValNumeric (struct EqData *D);
void ReplaceMade  (struct EqData *D);
void ShowCRBEQ    (struct EqData *D);
void OptimizeCRBEQ(struct EqData *D);
void AddDebugMess (struct EqData *D,ubyte *S);

void PreParse     (struct EqData *D);
void Eq2Tok       (struct EqData *D,ubyte *S);
void Tok2Eq       (struct EqData *D,ubyte *S);
void ReOrdTok     (struct EqData *D,ubyte *S);

double Factorial(double N);

double ValStrEq(char *streq)
{
struct EqData *eq;
double v;

	eq = MakeCRBEQ(streq,0);
	if ( ! eq ) return HUGE_VAL;
	if ( eq->ParseError ) {
		FreeCRBEQ(eq);
		return HUGE_VAL;
	}
	v = ValCRBEQ(eq);
	FreeCRBEQ(eq);
	return v;
}

void PreParse(struct EqData *D)
{
register int i;
ubyte * Ptr;

if (D->Flags & DEBUG) {
  AddDebugMess(D,"PreParsing...");
  }

	/*{* <> these need to be replaced by a 
		strrepstrNotQuoted() so as to not destroy string-parameters *}*/

/* pass 0 : easy replaces
	cut out all the commas and backslashes
	replace '{' by '(' */

	strrep(D->StrEq,',',' ');
	strrep(D->StrEq,'{','(');
	strrep(D->StrEq,'}',')');
	strrep(D->StrEq,'\\',' ');

/* pass 1 : replace (-N) by (0-N) */

  Ptr = D->StrEq;

  if ( *Ptr == '-' ) {
    StrBump(Ptr,(long)0,(long)(strlen(Ptr)+1));

    *Ptr++ = '0' ;
    *Ptr++ = '-' ;
    }

  while(*Ptr) {
    while ( *Ptr && *Ptr != '(' )
      Ptr++;

    if ( *Ptr == '(' )
      {
      Ptr++;
  
      if ( *Ptr == '-' )
        {
        StrBump(Ptr,(long)0,(long)(strlen(Ptr)+1));
      
        *Ptr++ = '0' ;
        *Ptr++ = '-' ;
        }
      }
	}

/* pass 2 : replace '>>' by '>' */

  Ptr = D->StrEq;

  while(*Ptr) {
    if ( *Ptr == '<' && Ptr[1] == '<' )
      {
      Ptr[1] = ' ';
      Ptr += 2;
      }
    else if ( *Ptr == '>' && Ptr[1] == '>' )
      {
      Ptr[1] = ' ';
      Ptr += 2;
      }
    else
      {
      Ptr++;
      }
	}

/** replace "frac(x)(y) by (x)/(y)" **/

  Ptr = D->StrEq;
  while(*Ptr) {
	if ( strncmp(Ptr,"FRAC",4) == 0 ) {
		ubyte * tp;
		memmove(Ptr,Ptr+4,strlen(Ptr+4)+1);
		tp = CorrespondP(Ptr);
/*(*/	if ( *tp != ')' ) {
			D->ParseError=1;
			strcpy(D->ErrorMess,"Expected pair of paren'ed items after 'frac'");
			goto DonePreParse;
		}
		tp++;
		memmove(tp+1,tp,strlen(tp)+1);
		*tp = '/';
	} else Ptr++;
  }

/***/

D->TokWork=NULL;
D->Tokens=NULL;
D->OrdPri=NULL;
D->OrdWork=NULL;
D->OrdTerms=NULL;

if ( (D->TokWork=AllocMem(1024,MEMF_ANY)) == NULL)
  {
  D->ParseError=1;
  strcpy(D->ErrorMess,"Couldn't malloc tokwork!");
  goto DonePreParse;
  }
if ( (D->Tokens=AllocMem(NUMPREPARSETOKENS*sizeof(ubyte *),MEMF_ANY|MEMF_CLEAR)) == NULL)
  {
  D->ParseError=1;
  strcpy(D->ErrorMess,"Couldn't malloc tokwork!");
  goto DonePreParse;
  }
for (i=0;i<NUMPREPARSETOKENS;i++)
  {
  if ( (D->Tokens[i]=AllocMem(STRSIZE,MEMF_ANY)) == NULL)
    {
    D->ParseError=1;
    strcpy(D->ErrorMess,"Couldn't malloc tokens!");
    goto DonePreParse;
    }
  }
if ( (D->OrdPri = AllocMem(NUMORDTERMS,MEMF_ANY)) == NULL)
  {
  D->ParseError=1;
  strcpy(D->ErrorMess,"Couldn't malloc OrdPri!");
  goto DonePreParse;
  }
if ( (D->OrdWork =AllocMem(1024,MEMF_ANY)) == NULL)
  {
  D->ParseError=1;
  strcpy(D->ErrorMess,"Couldn't malloc ordwork!");
  goto DonePreParse;
  }
if ( (D->OrdTerms=AllocMem(NUMORDTERMS*sizeof(ubyte *),MEMF_ANY|MEMF_CLEAR)) == NULL)
  {
  D->ParseError=1;
  strcpy(D->ErrorMess,"Couldn't malloc ordterms!");
  goto DonePreParse;
  }
for (i=0;i<NUMORDTERMS;i++)
  {
  if ( (D->OrdTerms[i]=AllocMem(STRSIZE,MEMF_ANY)) == NULL)
    {
    D->ParseError=1;
    strcpy(D->ErrorMess,"Couldn't malloc the terms!");
    goto DonePreParse;
    }
  }

strcpy(D->Tokens[0],D->StrEq);
D->TokNum=1;
Eq2Tok(D,D->Tokens[0]);

for (i=0;i<D->TokNum;i++) 
  ReOrdTok(D,D->Tokens[i]);

/** read out the toks, cutting spaces **/

D->TokWorkCnt=0;
Tok2Eq(D,D->Tokens[0]);
memcpy(D->StrEq,D->TokWork,D->TokWorkCnt);
D->StrEq[D->TokWorkCnt] = 0;

StrCutSpaceNotQuoted(D->StrEq);

/*** <> add routine to remove unnecessary parenthesis */

DonePreParse:

if (D->TokWork) FreeMem(D->TokWork,1024);
if (D->Tokens)
  {
  for (i=0;i<NUMPREPARSETOKENS&&D->Tokens[i];i++) 
    FreeMem(D->Tokens[i],STRSIZE);
  FreeMem(D->Tokens,NUMPREPARSETOKENS*sizeof(ubyte *));
  }
if (D->OrdPri) FreeMem(D->OrdPri,NUMORDTERMS);
if (D->OrdWork) FreeMem(D->OrdWork,1024);
if (D->OrdTerms)
  {
  for (i=0;i<NUMORDTERMS&&D->OrdTerms[i];i++)
    FreeMem(D->OrdTerms[i],STRSIZE);
  FreeMem(D->OrdTerms,NUMORDTERMS*sizeof(ubyte *));
  }

if (D->Flags & DEBUG)
  {
  AddDebugMess(D,"Done PreParsing.");
  }

}

void Eq2Tok (struct EqData *D,ubyte *eq)
{
ubyte numbuf[3];
ubyte *StartP,*EndP;
int plen,eqlen;
int startpc,endpc;

eqlen=strlen(eq);
while (StartP=strchr(eq,'('))
  {
  EndP=CorrespondP(StartP);
  plen=EndP-StartP+1;
  strncpy(D->Tokens[D->TokNum],StartP+1,plen-2);
  D->Tokens[D->TokNum][plen-2]=0;
  startpc=StartP-eq;
  endpc=EndP-eq;
  StrBump(eq,(long)startpc,(long)eqlen); eqlen++; endpc++;
  eq[eqlen]=0;
  sprintf(numbuf,"%d",D->TokNum);
  eq[startpc]=STOREubyte; startpc++;
  eq[startpc]=numbuf[0]; startpc++;
  if (numbuf[1]) { eq[startpc]=numbuf[1]; startpc++; }
  while (startpc<endpc) 
    { eq[startpc]=' '; startpc++; }
  eq[endpc]=' ';
  D->TokNum++;
  Eq2Tok(D,D->Tokens[D->TokNum - 1]);
  }
}

void Tok2Eq (struct EqData *D,ubyte *add)
{
ubyte numbuf[3];
int i;

while(*add)
  {
  if (*add == STOREubyte)
    {
    add++;
    numbuf[0]= *add; add++;
    if (isdigit(*add)) { numbuf[1]= *add; add++; numbuf[2]=0; }
    else numbuf[1]=0;
    i=atoi(numbuf);
    D->TokWork[D->TokWorkCnt]='('; D->TokWorkCnt++;
    Tok2Eq(D,D->Tokens[i]);
    D->TokWork[D->TokWorkCnt]=')'; D->TokWorkCnt++;
    }
  else
    {
    D->TokWork[D->TokWorkCnt]= *add; add++; D->TokWorkCnt++;
    }
  }
}

void ReOrdTok (struct EqData *D,ubyte *in)
{
ubyte *t;
int i,j,k,wc,Breaker,TN;

wc=0;

TN=0; t=in;
while(*t)
  {
  i=0;
  while(*t && *t!='+') { D->OrdTerms[TN][i]= *t; t++; i++; }
  if (*t == '+') t++;
  D->OrdTerms[TN][i]=0;
  TN++;
  }
for(i=0;i<TN;i++)
  {
  if (strchr(D->OrdTerms[i],STOREubyte)) D->OrdPri[i]=0;
  else if (strchr(D->OrdTerms[i],'^')||
           strchr(D->OrdTerms[i],'S')||
           strchr(D->OrdTerms[i],'A')||
           strchr(D->OrdTerms[i],'O')) D->OrdPri[i]=1;
  else if (strchr(D->OrdTerms[i],'*')||
           strchr(D->OrdTerms[i],'/')) D->OrdPri[i]=2;
  else D->OrdPri[i]=3; 
  }
for(k=0;k<4;k++)
  {
  for(i=0;i<TN;i++)
    {
    if (D->OrdPri[i]==k)
      {
      for (j=0;D->OrdTerms[i][j];j++) { D->OrdWork[wc]=D->OrdTerms[i][j]; wc++; }
      D->OrdWork[wc]='+'; wc++;
      }
    }
  }
wc--; D->OrdWork[wc]=0;
strcpy(in,D->OrdWork);

wc=0;
t=in;
do
  { 
  TN=0;
  while(*t && *t !='+' && *t != '-')
    {
    i=0;
    while(*t && *t!='*' && *t!='+' && *t!='-') 
      { D->OrdTerms[TN][i]= *t; t++; i++; }
    if (*t == '*') t++;
    D->OrdTerms[TN][i]=0;
    TN++;
    }
  Breaker= *t;
  if (*t=='+' || *t=='-') t++;
  for(i=0 ; i<TN ; i++)
    {
    if (strchr(D->OrdTerms[i],STOREubyte)) D->OrdPri[i]=0;
    else if (strchr(D->OrdTerms[i],'^')||
             strchr(D->OrdTerms[i],'S')||
             strchr(D->OrdTerms[i],'A')||
             strchr(D->OrdTerms[i],'O')) D->OrdPri[i]=1;
    else D->OrdPri[i]=2;
    }
  for(k=0 ; k<3 ; k++)
    {
    for(i=0;i<TN;i++)
      {
      if (D->OrdPri[i]==k)
        {
        for (j=0;D->OrdTerms[i][j];j++) 
          { 
          D->OrdWork[wc]=D->OrdTerms[i][j]; wc++; 
          }
        D->OrdWork[wc]='*'; wc++;
        }
      }
    }
  wc--; 
  D->OrdWork[wc]=Breaker; 
  wc++;
  } while(Breaker);

strcpy(in,D->OrdWork);
}

double ValCRBEQ(struct EqData *d)
{
register double a;
register double b;
register int c;
register ubyte *EQ;
double *EQPreStored;
double *Store;
int inta,intb;
ulong ula,ulb;

EQ = d->EQ;
EQPreStored = d->PreStored;
Store = d->Store;
a = b =  0.0;

while(1)
  {
  c= (int) *EQ++;
  switch ( c )
    {
    case ADD:
      a=a+b;
      break;
    case SUB:
      a=a-b;
      break;
    case MULT:
      a=a*b;
      break;  
    case DIV:
      a=a/b;
      break;  
    case POW:
      a=pow(a,b);
      break;

    case AtoB:
      b=a;
      break;
    case BtoA:
      a=b;
      break;
    case swapAB:
      {
      double t;
      t=a;
      a=b;
      b=t;
      }
      break;
    case PRESTORED:
      c= *EQ++;
      b=EQPreStored[c];
      break;
    case FMSTORE:
      c= *EQ++;
      b=Store[c];
      break;
    case TOSTORE:
      c= *EQ++;
      Store[c]=a;
      break;
    case FMUSERVAR:
      c= *EQ++;
      if ( c > d->NumUserVars || d->UserVar == NULL )
        {
        strcpy(d->ErrorMess,"Invalid UserVar request");
        d->ParseError = 1;
        return(0);
        }
      b=d->UserVar[c];
      break;

    case HtoB:
      b=d->H;
      break;
    case XtoB:
      b=d->X;
      break;
    case YtoB:
      b=d->Y;
      break;
    case ZtoB:
      b=d->Z;
      break;
    case TtoB:
      b=d->T;
      break;
    case RtoB:
      b=d->Result;
      break;
    case AtoX:
      d->X=a;
      break;
    case AtoY:
      d->Y=a;
      break;
    case AtoZ:
      d->Z=a;
      break;
    case AtoT:
      d->T=a;
      break;
    case AtoR:
      d->Result=a;
      break;

    case ABS:
      a=fabs(a);
      break;
    case LOG:
      a=log10(a);
      break;
    case LN:
      a=log(a);
      break;
    case L2:
      a=log2(a);
      break;
    case SIN:
      a=sin(a);
      break;
    case COS:
      a=cos(a);
      break;
    case TAN:
      a=tan(a);
      break;
    case ASIN:
      a=asin(a);
      break;
    case ACOS:
      a=acos(a);
      break;
    case ATAN:
      a=atan(a);
      break;

#ifdef __WATCOMC__  /* if you're on a PC, use watcom */
    case ASINH:
      a=asinh(a);
      break;
    case ACOSH:
      a=acosh(a);
      break;
    case ATANH:
      a=atanh(a);
      break;
#endif

    case SINH:
      a=sinh(a);
      break;
    case COSH:
      a=cosh(a);
      break;
    case TANH:
      a=tanh(a);
      break;

    case LINT:
      if ( a > 0 )
        {
        ula = (ulong)a;
        a = (double)ula;
        }
      else
        {
        inta = (int)a;
        a = (double)inta;
        }
      break;
    case GINT:
      if ( a > 0 )
        {
        ula = (ulong)a;
        a = (double)ula;
        if ( a > (double)ula ) a = (double)(ula+1);
        }
      else
        {
        inta = (int)a;
        a = (double)inta;
        if ( a > (double)inta ) a = (double)(inta+1);
        }
      break;
    case RINT:
      a += 0.5;
      if ( a > 0 )
        {
        ula = (ulong)a;
        a = (double)ula;
        }
      else
        {
        inta = (int)a;
        a = (double)inta;
        }
      break;

    case SQRT:
      a= sqrt(a);
      break;

    case FACT_B:
      b = Factorial(b);
      break;

    case PROG_OR        :
      if ( a < 0 || b < 0 )
        {
        inta = a; intb = b;
        a = inta | intb;
        }
      else
        {
        ula = a; ulb = b;
        a = ula | ulb;
        }
      break;
    case PROG_AND       :
      if ( a < 0 || b < 0 )
        {
        inta = a; intb = b;
        a = inta & intb;
        }
      else
        {
        ula = a; ulb = b;
        a = ula & ulb;
        }
      break;
    case PROG_XOR       :
      if ( a < 0 || b < 0 )
        {
        inta = a; intb = b;
        a = inta ^ intb;
        }
      else
        {
        ula = a; ulb = b;
        a = ula ^ ulb;
        }
      break;
    case PROG_LEFTSHIFT :
      if ( a < 0 || b < 0 )
        {
        inta = a; intb = b;
        a = inta << intb;
        }
      else
        {
        ula = a; ulb = b;
        a = ula << ulb;
        }
      break;
    case PROG_RIGHTSHIFT:
      if ( a < 0 || b < 0 )
        {
        inta = a; intb = b;
        a = inta >> intb;
        }
      else
        {
        ula = a; ulb = b;
        a = ula >> ulb;
        }
      break;

    case DONE:
      d->Result=a;
      return(a);
      break;

    default:
      break; 
    }
  }
}

void ShowCRBEQ(struct EqData *d)
{
register ubyte *EQ;
register int c;
ubyte *Out;
ubyte *OutT;

if ( (Out=AllocMem(STRSIZE,MEMF_ANY)) == NULL) return;

EQ = d->EQ;

while(1)
  {
  c= *EQ;
  EQ++;
  switch ( c )
    {
    case ADD:
      AddDebugMess(d,"ADD:  a=a+b");
      break;
    case SUB:
      AddDebugMess(d,"SUB:  a=a-b");
      break;
    case MULT:
      AddDebugMess(d,"MULT: a=a*b");
      break;  
    case DIV:
      AddDebugMess(d,"DIV:  a=a/b");
      break;  
    case POW:
      AddDebugMess(d,"POW:  a=a^b");
      break;
    case AtoB:
      AddDebugMess(d,"AtoB: b=a");
      break;
    case BtoA:
      AddDebugMess(d,"BtoA: a=b");
      break;
    case swapAB:
      AddDebugMess(d,"swapAB: a=b,b=a");
      break;
    case PRESTORED:
      c= *EQ++; 
      strcpy(Out,"PRESTORED: b = [");
      OutT=Out+strlen(Out);
      sprintf(Out,"%d",c);
      strcat(Out,"] = ");
      OutT=Out+strlen(Out);
      gcvt(d->PreStored[c],10,OutT);
      AddDebugMess(d,Out);
      break;
    case FMSTORE:
      c= *EQ++;
      strcpy(Out,"FMSTORE: b = [");
      OutT=Out+strlen(Out);
      sprintf(OutT,"%d",c);
      strcat(Out,"]");
      AddDebugMess(d,Out);
      break;
    case TOSTORE:
      c= *EQ++;
      strcpy(Out,"TOSTORE: [");
      OutT=Out+strlen(Out);
      sprintf(OutT,"%d",c);
      strcat(Out,"] = a");
      AddDebugMess(d,Out);
      break;
     case FMUSERVAR:
      c= *EQ++;
      strcpy(Out,"FMUSERVAR: b = [");
      OutT=Out+strlen(Out);
      sprintf(OutT,"%d",c);
      strcat(Out,"]");
      AddDebugMess(d,Out);
      break;


    case HtoB:
      AddDebugMess(d,"HtoB: b=SMALL_VAL");
      break;
    case XtoB:
      AddDebugMess(d,"XtoB: b=X");
      break;
    case YtoB:
      AddDebugMess(d,"YtoB: b=Y");
      break;     
    case ZtoB:
      AddDebugMess(d,"ZtoB: b=Z");
      break;
    case TtoB:
      AddDebugMess(d,"TtoB: b=T");
      break;
    case RtoB:
      AddDebugMess(d,"RtoB: b=Result");
      break;
    case AtoX:
      AddDebugMess(d,"AtoX: X=a");
      break;
    case AtoY:
      AddDebugMess(d,"AtoY: Y=a");
      break;
    case AtoZ:
      AddDebugMess(d,"AtoZ: Z=a");
      break;
    case AtoT:
      AddDebugMess(d,"AtoT: T=a");
      break;
    case AtoR:
      AddDebugMess(d,"AtoR: Result=a");
      break;

    case ABS:
      AddDebugMess(d,"ABS:  a=abs(a)");
      break;
    case LOG:
      AddDebugMess(d,"LOG:  a=log10(a)");
      break;
    case LN:
      AddDebugMess(d,"LN:   a=ln(a)");
      break;
    case L2:
      AddDebugMess(d,"L2:   a=log2(a)");
      break;
    case SIN:
      AddDebugMess(d,"SIN:  a=sin(a)");
      break;
    case COS:
      AddDebugMess(d,"COS:  a=cos(a)");
      break;
    case TAN:
      AddDebugMess(d,"TAN:  a=tan(a)");
      break;
    case ASIN:
      AddDebugMess(d,"ASIN: a=asin(a)");
      break;
    case ACOS:
      AddDebugMess(d,"ACOS: a=acos(a)");
      break;
    case ATAN:
      AddDebugMess(d,"ATAN: a=atan(a)");
      break;

    case ASINH:
      AddDebugMess(d,"ASINH: a=asinh(a)");
      break;
    case ACOSH:
      AddDebugMess(d,"ACOSH: a=acosh(a)");
      break;
    case ATANH:
      AddDebugMess(d,"ATANH: a=atanh(a)");
      break;

    case SINH:
      AddDebugMess(d,"SINH: a=sinh(a)");
      break;
    case COSH:
      AddDebugMess(d,"COSH: a=cosh(a)");
      break;
    case TANH:
      AddDebugMess(d,"TANH: a=tanh(a)");
      break;
    case LINT:
      AddDebugMess(d,"LINT: a=floor(a)");
      break;
    case GINT:
      AddDebugMess(d,"GINT: a=ceil(a)");
      break;
    case RINT:
      AddDebugMess(d,"RINT: a=round_integer(a)");
      break;

    case SQRT:
      AddDebugMess(d,"SQRT: a=sqrt(a)");
      break;

    case FACT_B:
      AddDebugMess(d,"FACT: b=factorial(b)");
      break;  

    case PROG_OR        :
      AddDebugMess(d,"PROG_OR: a = a | b");
      break;
    case PROG_AND       :
      AddDebugMess(d,"PROG_AND: a = a & b");
      break;
    case PROG_XOR       :
      AddDebugMess(d,"PROG_XOR: a = a ^ b");
      break;
    case PROG_LEFTSHIFT :
      AddDebugMess(d,"PROG_LEFTSHIFT: a = a << b");
      break;
    case PROG_RIGHTSHIFT:
      AddDebugMess(d,"PROG_RIGHTSHIFT: a = a >> b");
      break;

    case DONE:
      AddDebugMess(d,"DONE: Result=a");
      AddDebugMess(d,"--------");
      FreeMem(Out,STRSIZE);
      return;
      break;
    default:
      break; 
    }
  }
}

void OptimizeCRBEQ(struct EqData *d)
{
register int i,j,c,StoreNum,o;

/*

todo:

   + add a routine after PreParse to remove unnecessary parenthesis


/ *

OPTIMIZE THIS: either by pattern recognition in the Optimize routine,
or by removing unnecessary parenthesis in PreParse

this sequence is generated from : (9)-(3)

PRESTORED: b = [0] = 9
BtoA: a=b
TOSTORE: [0] = a
PRESTORED: b = [1] = 3
BtoA: a=b
TOSTORE: [1] = a
FMSTORE: b = [0]
BtoA: a=b
FMSTORE: b = [1]
SUB:  a=a-b
DONE       

---

eliminate constant evaluations -> prestore
  2*16    -> 32
  2*(x-4) -> 2*x-8

---

* /

*/

/********************/

/*check for storing then getting right out again:*/

/* TOSTORE+FMSTORE+BTOA -> nothing
   TOSTORE+FMSTORE -> AtoB
*/

i=0;
while((c=d->EQ[i++])!=DONE)
  {
  if (c==TOSTORE)
    {
    StoreNum=d->EQ[i++];
    if (d->EQ[i++]==FMSTORE)
      {
      if ( d->EQ[i++]==StoreNum )
        {
        /* TOSTORE/FMSTORE on same StoreNum */

        if (d->EQ[i]==BtoA) o=5;
        else o=4;
        i -= 4;
        for(j=0;j<o;j++)
          {
          d->EQ[i+j]=BLANK;
          }

        if ( o == 4 ) /* no BtoA */
          {
          d->EQ[i] = AtoB;
          }

        i += o;
        }
      }
    }
  else if ( ISSTORE(c) ) i++;
  }

/*check for unnecessarily storing at the end:*/
i=d->CPos-2;
if (d->EQ[i]==TOSTORE) d->EQ[i]=DONE;

/*replace BLANKS*/
i=j=0;
while ((c=d->EQ[i++])!=DONE)
  {
  if (c != BLANK) d->EQ[j++]=c;
  }
d->EQ[j]=DONE;

}

int CopyCRBEQ(struct EqData *din,struct EqData **dout)
{
struct EqData *d;

*dout = NULL;

if ( (d = AllocMem(sizeof(struct EqData),MEMF_ANY)) == NULL)
  return(0);

MemCpy(d,din,sizeof(struct EqData));

d->EQ       = AllocMem(d->EQSize        ,MEMF_ANY);
d->Store    = AllocMem(d->StoreSize     ,MEMF_ANY);
d->PreStored= AllocMem(d->PreStoredSize ,MEMF_ANY);
d->StrEq    = AllocMem(d->StrEqSize     ,MEMF_ANY);

if ( !(d->EQ) || 
     !(d->Store) || 
     !(d->PreStored) && (d->PreStoredSize) || 
     !(d->StrEq) )
  {
  if (d->EQ)        FreeMem(d->EQ,d->EQSize);
  if (d->PreStored) FreeMem(d->PreStored,d->PreStoredSize);
  if (d->Store)     FreeMem(d->Store,d->StoreSize);
  if (d->StrEq)     FreeMem(d->StrEq,d->StrEqSize);
  FreeMem(d,sizeof(struct EqData));
  return(0);
  }

MemCpy(d->EQ,din->EQ,d->EQSize);
MemCpy(d->Store,din->Store,d->StoreSize);
MemCpy(d->PreStored,din->PreStored,d->PreStoredSize);
MemCpy(d->StrEq,din->StrEq,d->StrEqSize);

d->ErrorMess=NULL;
d->DebugMess=NULL;

*dout = d;
return(1);
}

void FreeCRBEQ(struct EqData *d)
{
int i;

if (d->EQ)        FreeMem(d->EQ,d->EQSize);
if (d->PreStored) FreeMem(d->PreStored,d->PreStoredSize);
if (d->Store)     FreeMem(d->Store,d->StoreSize);
if (d->StrEq)     FreeMem(d->StrEq,d->StrEqSize);
if (d->ErrorMess) FreeMem(d->ErrorMess,STRSIZE);
if (d->DebugMess)
  {
  i=0;
  while(d->DebugMess[i])
    {
    FreeMem(d->DebugMess[i],STRSIZE);
    i++;
    }
  FreeMem(d->DebugMess,MAXDEBUGMESS*sizeof(ubyte *));
  }

FreeMem(d,sizeof(struct EqData));
}

void AddDebugMess(struct EqData *D, ubyte *S)
{

if (D->DebugMess[D->DebugMessNext]=AllocMem(STRSIZE,MEMF_ANY))
  {
  strcpy(D->DebugMess[D->DebugMessNext],S);
  D->DebugMessNext++;
  if (D->DebugMessNext == MAXDEBUGMESS)
    {
    D->ParseError=1;
    strcpy(D->ErrorMess,"DebugMess OverFlow!!");
    }
  }

}

struct EqData * MakeCRBEQ (ubyte *inStrEq,int inFlags)
{
register struct EqData *d;
ubyte *MallocWork;
int MallocMax;

switch(inStrEq[0])
  {
  case '?':
  case 'h':
  case 'H':
    HelpCRBEQ();
    return(NULL);
    break;
  default:
    break;
  }

if ( (d=AllocMem(sizeof(struct EqData),MEMF_ANY|MEMF_CLEAR)) == NULL)
  return(NULL);

d->EQSize             = WRKSIZE;
d->PreStoredSize      =MAXNUMPRESTORES*sizeof(double);
d->StoreSize          =MAXNUMSTORES*sizeof(double);
d->StrEqSize          = strlen(inStrEq) * 64 + 1024;
d->Result             =0;
d->X=d->Y=d->Z        =0;
d->H 					= 0.000001;
d->ParseError         =0;
d->ErrorMess          =AllocMem(STRSIZE,MEMF_ANY);
d->DebugMess          =AllocMem(MAXDEBUGMESS*sizeofpointer,MEMF_ANY|MEMF_CLEAR);
d->EQ                 =AllocMem(d->EQSize,MEMF_ANY);
d->PreStored          =AllocMem(d->PreStoredSize,MEMF_ANY);
d->Store              =AllocMem(d->StoreSize,MEMF_ANY);
d->StrEq              =AllocMem(d->StrEqSize,MEMF_ANY);
d->WrkBase            =AllocMem(WRKSIZE,MEMF_ANY);
d->WrkPtr             =d->WrkBase;
d->RepPtr             =NULL;
d->DebugMessNext      =0;
d->Flags              =inFlags;
d->CurPreStoreNum     =0;
d->CurStoreNum        =0;
d->CPos               =0;
d->SLen               =0;

if (!d->DebugMess || !d->WrkBase || !d->EQ || !d->Store || !d->PreStored || !d->ErrorMess || !d->StrEq )
  {
  d->ParseError=1;
  if (d->ErrorMess) strcpy(d->ErrorMess,"Couldn't AllocMem CRBEQ data!");
  goto DoneMake;
  }

strcpy(d->StrEq,inStrEq);
d->EQ[0]=DONE;

if (d->StrEq[0]==0)
  {
  goto DoneMake;
  }

/*
  {
  char tchar;
  ubyte tubyte;

  tchar = 'e'; tubyte = 'e';

  if ( (int)tchar != (int)tubyte )
    {
    d->ParseError=1;
    strcpy(d->ErrorMess,"chars not unsigned.  Recompile.");
    goto DoneMake;
    }

  }
*/

if ( UnmatchedParenthesis(d->StrEq) )
  {
  d->ParseError=1;
  strcpy(d->ErrorMess,"Parenthesese don't match!");
  goto DoneMake;
  }

StrUprNotQuoted(d->StrEq);
StrCutSpaceNotQuoted(d->StrEq);
ConvAll(d->StrEq); /*convert hex and binary to decimal*/

PreParseDifferentials((char **)&(d->StrEq),&(d->StrEqSize));

PreParse(d);

if (d->Flags & DEBUG)
  {
  if ( (MallocWork=AllocMem(STRSIZE,MEMF_ANY)) )
    {
    sprintf(MallocWork,"Made: %s",d->StrEq);
    AddDebugMess(d,MallocWork);
    FreeMem(MallocWork,STRSIZE);
    }
  else
    d->ParseError=1;
  }
if (d->ParseError) 
  {
  goto DoneMake;
  }

d->SLen=strlen(d->StrEq);
memcpy(d->WrkBase,d->StrEq,d->SLen+1);

while(SimplifyEQ(d))
  {
  if (d->CPos > (d->EQSize - 50))
    {
    d->ParseError=1;
    strcpy(d->ErrorMess,"CRBEQ overflow!");
    }
  if (d->ParseError)
    {
    goto DoneMake;
    }
  }

if (!d->ParseError)
  {
  d->EQ[d->CPos]=DONE;

  if (d->Flags & OPTIMIZE)
    {
    if (d->Flags & DEBUG)
      {
      ShowCRBEQ(d); 
      }

    OptimizeCRBEQ(d);
    }

  if (d->Flags & DEBUG)
    {
    ShowCRBEQ(d);
    }
  }

DoneMake:

SmartFree(d->WrkBase,WRKSIZE); d->WrkBase=NULL;

MallocMax=0;
MallocMax=max(MallocMax,d->EQSize);
MallocMax=max(MallocMax,d->PreStoredSize);
MallocMax=max(MallocMax,d->StoreSize);

if ( MallocWork=AllocMem(MallocMax,MEMF_ANY) )
  {
  
  MemCpy(MallocWork,d->EQ,d->EQSize);
  FreeMem(d->EQ,d->EQSize);
  d->EQSize=PaddedSize(d->CPos);
  if ( d->EQSize )
    {
    d->EQ=AllocMem(d->EQSize,MEMF_ANY);
    MemCpy(d->EQ,MallocWork,d->EQSize);
    }
  else
    {
    d->EQ=NULL; 
    } 
  
  MemCpy(MallocWork,d->PreStored,d->PreStoredSize);
  FreeMem(d->PreStored,d->PreStoredSize);
  d->PreStoredSize=PaddedSize(d->CurPreStoreNum*sizeof(double));
  if ( d->PreStoredSize )
    {
    d->PreStored=AllocMem(d->PreStoredSize,MEMF_ANY);
    MemCpy(d->PreStored,MallocWork,d->PreStoredSize);
    }
  else
    {
    d->PreStored=NULL;
    }
  
  MemCpy(MallocWork,d->Store,d->StoreSize);
  FreeMem(d->Store,d->StoreSize);
  d->StoreSize=PaddedSize(d->CurStoreNum*sizeof(double));
  if ( d->StoreSize )
    {
    d->Store=AllocMem(d->StoreSize,MEMF_ANY);
    MemCpy(d->Store,MallocWork,d->StoreSize);
    }
  else
    {
    d->Store = NULL;
    }
  
  FreeMem(MallocWork,MallocMax);

  }
else
  {
  d->ParseError=1;
  }

return(d);
}

void PreParseDifferentials(char **strptr,int *strlptr)
{
char *str;
int strl,newl,lendiff;
char diffvar;
char *insert;
char *endinsert;
char *vb,*vd;
char valbase[256],valdiff[256];

strl = *strlptr;
str = *strptr;
newl = strlen(str);

/*
 * look for dx(ZZZ)
 *
 * set A = "dx(zzz)"
 * set B = "zzz"
 * copy B to C
 * replace "x" in C with "(x+DIFF_STEP)"
 * set A = (C - B)/DIFF_STEP
 *
 */

	while( (insert = strrchr(str,'D')) ) {

		if ( (newl*5+16) > strl ) {
			char *newstr;
			/* running out of space : re-alloc */
			strl = newl*5 + 256;
			if ( !(newstr = malloc(strl)) ) return; //error
			*strptr = newstr;
			*strlptr = strl;
			strcpy(newstr,str);
			str = newstr;
			insert = strrchr(str,'D');
		}

		diffvar = insert[1];

		if ( diffvar != 'X' && diffvar != 'Y' && diffvar != 'Z' && diffvar !='T' )
			return; // error

		if ( insert[2] != '(' ) /* ) */
			return; // error

		if ( (endinsert = CorrespondP(insert+2)) == NULL )
			return; // error

		*endinsert = 0;

		strcpy(valbase,insert+2); /* ( */
		strcat(valbase, ")");

		vb = valbase;
		vd = valdiff;
		while(*vb) {
			if ( vb[0] == diffvar && !isalpha(vb[1]) ) {
				*vd++ = '(';
				*vd++ = diffvar;
				*vd++ = '+';
				*vd++ = 'H';
				*vd++ = ')';
				vb++;
			} else {
				*vd++ = *vb++;
			}
		}
		*vd = 0;

		lendiff = strlen(valdiff)+5; /* 5 = strlen("((+/H))") - strlen("dx"); */

		memmove(insert+lendiff,insert,strlen(insert)+1);
		newl += lendiff;

		*insert++ = '(';
		*insert++ = '(';
		memcpy(insert,valdiff,strlen(valdiff));
			insert += strlen(valdiff);
		*insert++ = '-';
		memcpy(insert,valbase,strlen(valbase));
			insert += strlen(valbase);
		*insert++ = ')';
		*insert++ = '/';
		*insert++ = 'H';
		*insert++ = ')';
	}

}

short SimplifyEQ (struct EqData *d)
{
register int i;
register ubyte *lt,*fp,*t;

/*find first deepest parenthesis*/
fp=d->WrkPtr=d->WrkBase;
while ((d->WrkPtr-d->WrkBase)<d->SLen && (*d->WrkPtr!=')' || *(d->WrkPtr-1)==STOREubyte))
  {
  if (*d->WrkPtr=='(' && *(d->WrkPtr-1)!=STOREubyte) fp=d->WrkPtr;
  d->WrkPtr++;
  }

/*do functions (sin/cos/ln,etc..)*/
d->WrkPtr=fp;
while ((d->WrkPtr-d->WrkBase)<d->SLen && (*d->WrkPtr!=')' || *(d->WrkPtr-1)==STOREubyte)) {
  if (isupper(*d->WrkPtr)) {
    i=0;
    d->RepPtr=d->WrkPtr;

         if (strncmp(d->WrkPtr,"ABS" ,3)==0) { i=ABS;  d->WrkPtr+=3; }
    else if (strncmp(d->WrkPtr,"LOG" ,3)==0) { i=LOG;  d->WrkPtr+=3; }
    else if (strncmp(d->WrkPtr,"LN"  ,2)==0) { i=LN;   d->WrkPtr+=2; }
    else if (strncmp(d->WrkPtr,"L2"  ,2)==0) { i=L2;   d->WrkPtr+=2; }
    else if (strncmp(d->WrkPtr,"SQRT",4)==0) { i=SQRT; d->WrkPtr+=4; }
    else if (strncmp(d->WrkPtr,"SINH",4)==0) { i=SINH; d->WrkPtr+=4; }
    else if (strncmp(d->WrkPtr,"COSH",4)==0) { i=COSH; d->WrkPtr+=4; }
    else if (strncmp(d->WrkPtr,"TANH",4)==0) { i=TANH; d->WrkPtr+=4; }
    else if (strncmp(d->WrkPtr,"ASINH",5)==0) { i=ASINH; d->WrkPtr+=5; }
    else if (strncmp(d->WrkPtr,"ACOSH",5)==0) { i=ACOSH; d->WrkPtr+=5; }
    else if (strncmp(d->WrkPtr,"ATANH",5)==0) { i=ATANH; d->WrkPtr+=5; }
    else if (strncmp(d->WrkPtr,"SIN" ,3)==0) { i=SIN;  d->WrkPtr+=3; }
    else if (strncmp(d->WrkPtr,"COS" ,3)==0) { i=COS;  d->WrkPtr+=3; }
    else if (strncmp(d->WrkPtr,"TAN" ,3)==0) { i=TAN;  d->WrkPtr+=3; }
    else if (strncmp(d->WrkPtr,"ASIN",4)==0) { i=ASIN; d->WrkPtr+=4; }
    else if (strncmp(d->WrkPtr,"ACOS",4)==0) { i=ACOS; d->WrkPtr+=4; }
    else if (strncmp(d->WrkPtr,"ATAN",4)==0) { i=ATAN; d->WrkPtr+=4; }
    else if (strncmp(d->WrkPtr,"LINT",4)==0) { i=LINT; d->WrkPtr+=4; }
    else if (strncmp(d->WrkPtr,"GINT",4)==0) { i=GINT; d->WrkPtr+=4; }
    else if (strncmp(d->WrkPtr,"RINT",4)==0) { i=RINT; d->WrkPtr+=4; }
    else d->WrkPtr++;

    if (i) {
      MakeTerm(d);
      if (d->ParseError) return(0);
      d->EQ[d->CPos]=BtoA;       d->CPos++;
      d->EQ[d->CPos]=i;          d->CPos++;
      d->EQ[d->CPos]=TOSTORE;    d->CPos++;
      d->EQ[d->CPos]=d->CurStoreNum;d->CPos++;

      ReplaceMade(d);
      return(1);
      }
  } else {
    d->WrkPtr++;
	}
  }

/*do programming operators*/
d->WrkPtr=fp; lt=0;
while ((d->WrkPtr-d->WrkBase)<d->SLen&&*d->WrkPtr!=')')
  {
  if ( *d->WrkPtr == STOREubyte ) d->WrkPtr += 2;
  else
    {
    i = *d->WrkPtr;
    if ( i == '|' || i == '&' || i == '~' || i == '<' || i == '>' )
      {
      lt = d->WrkPtr;
      }
    d->WrkPtr++;
    }
  }

if (lt)
  {
  int j;

  /*back up to first term*/
  d->WrkPtr=lt;
  while(d->WrkPtr>=d->WrkBase&&((*d->WrkPtr!='+'&&*d->WrkPtr!='-'&&*d->WrkPtr!='^'&&*d->WrkPtr!='('&&*d->WrkPtr!='*'&&*d->WrkPtr!='/')||*(d->WrkPtr-1)==STOREubyte) )
    {
    d->WrkPtr--;
    }

  if (d->WrkPtr!=lt) d->WrkPtr++;
  /*do operations*/
  d->RepPtr=d->WrkPtr;
  MakeTerm(d);
  if (d->ParseError) return(0);
  i = *d->WrkPtr;
  d->EQ[d->CPos++]=BtoA;

       if ( i == '<' ) j = PROG_LEFTSHIFT;
  else if ( i == '>' ) j = PROG_RIGHTSHIFT;
  else if ( i == '&' ) j = PROG_AND;
  else if ( i == '|' ) j = PROG_OR;        
  else if ( i == '~' ) j = PROG_XOR;
  else
    {
    sprintf(d->ErrorMess,"Expected programming operator ,found: %c",*d->WrkPtr);
    d->ParseError=1;
    return(0);
    }
  d->WrkPtr++;
  MakeTerm(d);
  if (d->ParseError) return(0);
  d->EQ[d->CPos++]=j;
  d->EQ[d->CPos++]=TOSTORE;
  d->EQ[d->CPos++]=d->CurStoreNum;
  ReplaceMade(d);
  return(1);
  }

/*do exponentials*/
d->WrkPtr=fp; lt=0;
while ((d->WrkPtr-d->WrkBase)<d->SLen&&*d->WrkPtr!=')')
  {
  if (*d->WrkPtr=='^' && *(d->WrkPtr-1)!=STOREubyte) lt=d->WrkPtr;
  d->WrkPtr++;
  }

if (lt)
  {
  /*back up to first term*/
  d->WrkPtr=lt;
  while(d->WrkPtr>=d->WrkBase&&((*d->WrkPtr!='+'&&*d->WrkPtr!='-'&&*d->WrkPtr!='*'&&*d->WrkPtr!='/'&&*d->WrkPtr!='(')||*(d->WrkPtr-1)==STOREubyte) )
    {
    d->WrkPtr--;
    }
  if (d->WrkPtr!=lt) d->WrkPtr++;
  /*do operations*/
  d->RepPtr=d->WrkPtr;
  MakeTerm(d);
  if (d->ParseError) return(0);
  d->EQ[d->CPos]=BtoA; d->CPos++;
  if (*d->WrkPtr!='^')
    {
    sprintf(d->ErrorMess,"Expected exponential '^',found: %c!",*d->WrkPtr);
    d->ParseError=1;
    return(0);
    }
  while((*d->WrkPtr=='^')&&(d->WrkPtr-d->WrkBase)<d->SLen)
    {
    d->WrkPtr++;
    MakeTerm(d);
    if (d->ParseError) return(0);
    d->EQ[d->CPos]=POW; d->CPos++;
    }
  d->EQ[d->CPos]=TOSTORE; d->CPos++;
  d->EQ[d->CPos]=d->CurStoreNum; d->CPos++; 
    
  ReplaceMade(d);
  return(1);
  }

/*do multiplications & divisions*/
d->WrkPtr=fp; lt=0;
while ((d->WrkPtr-d->WrkBase)<d->SLen&&*d->WrkPtr!=')')
  {
  if ((*d->WrkPtr=='*'||*d->WrkPtr=='/') && *(d->WrkPtr-1)!=STOREubyte) lt=d->WrkPtr;
  d->WrkPtr++;
  }

if (lt)
  {
  /*back up to first term*/
  d->WrkPtr=lt;
  while(d->WrkPtr>=d->WrkBase&&((*d->WrkPtr!='+'&&*d->WrkPtr!='-'&&*d->WrkPtr!='^'&&*d->WrkPtr!='(')||*(d->WrkPtr-1)==STOREubyte) )
    {
    d->WrkPtr--;
    }

  if (d->WrkPtr!=lt) d->WrkPtr++;
  /*do operations*/
  d->RepPtr=d->WrkPtr;
  MakeTerm(d);
  if (d->ParseError) return(0);
  d->EQ[d->CPos]=BtoA; d->CPos++;
  if (*d->WrkPtr!='*' && *d->WrkPtr!='/')
    {
    sprintf(d->ErrorMess,"Expected multiplication or division ,found: %c",*d->WrkPtr);
    d->ParseError=1;
    return(0);
    }
  while((*d->WrkPtr=='*'||*d->WrkPtr=='/')&&(d->WrkPtr-d->WrkBase)<d->SLen)
    {
    if (*d->WrkPtr=='*') i=MULT; else i=DIV;
    d->WrkPtr++;
    MakeTerm(d);
    if (d->ParseError) return(0);
    d->EQ[d->CPos]=i; d->CPos++;
    }
  d->EQ[d->CPos]=TOSTORE; d->CPos++;
  d->EQ[d->CPos]=d->CurStoreNum; d->CPos++; 
    
  ReplaceMade(d);
  return(1);
  }

 /*do addition and subtraction*/

i=d->SLen + (int)d->WrkBase;
lt=NULL;
t=fp;
while (t<(ubyte *)i && !lt && *t!=')')
  {
  if (*t == STOREubyte) t+=2;
  else if (*t=='+'|| *t=='-') lt=t;
  else t++;
  }

if (lt)
  {
 
  if (*fp=='(') d->RepPtr=d->WrkPtr=(fp+1);
  else d->RepPtr=d->WrkPtr=fp;

  MakeTerm(d);
  if (d->ParseError) return(0);
  d->EQ[d->CPos]=BtoA; d->CPos++;
  if (*d->WrkPtr!='+' && *d->WrkPtr!='-')
    {
    sprintf(d->ErrorMess,"Expected addition or subtration ,found: %c",*d->WrkPtr);
    d->ParseError=1;
    return(0);
    }
  while((*d->WrkPtr=='+'||*d->WrkPtr=='-')&&(d->WrkPtr-d->WrkBase)<d->SLen)
    {
    if (*d->WrkPtr=='+') i=ADD; else i=SUB;
    d->WrkPtr++;
    MakeTerm(d);
    if (d->ParseError) return(0);
    d->EQ[d->CPos]=i; d->CPos++;
    }
  d->EQ[d->CPos]=TOSTORE; d->CPos++;
  d->EQ[d->CPos]=d->CurStoreNum; d->CPos++; 
   
  ReplaceMade(d);
  return(1);
  }

/*else: nothing but a number in it*/

/* handle to the case of (n)! */

d->WrkPtr=fp;
while(*d->WrkPtr==' ') d->WrkPtr++;
if (*d->WrkPtr==STOREubyte)
  {
  d->WrkPtr+=2; /* pass store num */
  while(*d->WrkPtr==' ') d->WrkPtr++;
  if (*d->WrkPtr == '!')
    {
    d->RepPtr=fp;
    d->WrkPtr=fp;
    MakeTerm(d);
    if (d->ParseError) return(0);
    d->EQ[d->CPos]=BtoA;        d->CPos++;
    d->EQ[d->CPos]=TOSTORE;     d->CPos++;
    d->EQ[d->CPos]=d->CurStoreNum; d->CPos++;
    ReplaceMade(d);
    return(1);
    }
  if (*d->WrkPtr == 0)
    return(0);
  }

/* else, eval that num*/

d->WrkPtr=fp;
if (*d->WrkPtr=='(') d->WrkPtr++;
d->RepPtr=d->WrkPtr;
MakeTerm(d);
if (d->ParseError) return(0);
d->EQ[d->CPos]=BtoA;        d->CPos++;
d->EQ[d->CPos]=TOSTORE;     d->CPos++;
d->EQ[d->CPos]=d->CurStoreNum; d->CPos++;

ReplaceMade(d);
return(1);
}

/* replaces the current term with a Store id

  uses all space between RepPtr and WrkPtr

  cuts unnecessary parens on either side

 */

void ReplaceMade (struct EqData *d)
{
register ubyte *t;

if (d->RepPtr==NULL)
  {
  strcpy(d->ErrorMess,"Error: RepPtr is NULL in ReplaceMade!");
  d->ParseError=1;
  return;
  }

for(t=d->RepPtr;t<d->WrkPtr;t++) *t=' ';
if ((d->WrkPtr - d->RepPtr)<2) 
  {
  StrBump(d->WrkBase,(long)(d->RepPtr - d->WrkBase),(long)d->SLen); 
  d->SLen++;
  d->WrkPtr++;
  d->WrkBase[d->SLen]=0;
  }
*d->RepPtr=(ubyte)STOREubyte;
*(d->RepPtr+1)=d->CurStoreNum;
if (d->RepPtr != d->WrkBase)
  {
  while(*d->WrkPtr==' ') d->WrkPtr++;
  if ( *(d->RepPtr-1)=='(' && (*d->WrkPtr)==')' )
    {
    *(d->RepPtr-1)=' ';
    *d->WrkPtr=' ';
    }
  }

d->CurStoreNum++;
if (d->CurStoreNum==MAXNUMSTORES) 
  {
  sprintf(d->ErrorMess,"STORE OVERFLOW: more than %d runtime stores!\n",MAXNUMSTORES); 
  d->ParseError=1;
  }

d->RepPtr=NULL;
}

/* pulls a numeric out of the WrkData and drops it in EQ

  leaves the numeric in register B

 */

void MakeTerm(struct EqData *d)
{

while   (*d->WrkPtr==' ') d->WrkPtr++;

     if (*d->WrkPtr=='X') { d->EQ[d->CPos++]=XtoB; d->WrkPtr++; }
else if (*d->WrkPtr=='Y') { d->EQ[d->CPos++]=YtoB; d->WrkPtr++; }
else if (*d->WrkPtr=='Z') { d->EQ[d->CPos++]=ZtoB; d->WrkPtr++; }
else if (*d->WrkPtr=='T') { d->EQ[d->CPos++]=TtoB; d->WrkPtr++; }
else if (*d->WrkPtr=='H') { d->EQ[d->CPos++]=HtoB; d->WrkPtr++; }
else if (*d->WrkPtr=='@')
  {
  int c;
  d->EQ[d->CPos++]=FMUSERVAR; d->WrkPtr++;
  c = (int) ValNumeric(d);
  if ( c < 0 || d->ParseError ) { d->ParseError = 1; return; }
  d->EQ[d->CPos++] = c;
  }
else if (*d->WrkPtr==STOREubyte)
  {
  d->EQ[d->CPos++]=FMSTORE;     d->WrkPtr++;
  d->EQ[d->CPos++]= *d->WrkPtr++;
  }
else if (*d->WrkPtr== 0x27) /* ' */
  {
  ulong Out=0;
  ubyte * WrkPtrBase;

  WrkPtrBase = d->WrkPtr++;
  while( *d->WrkPtr != 0x27 )
    {
    Out <<= 8;
    Out += *d->WrkPtr++;
    }
  d->WrkPtr++;

  if ( (d->WrkPtr - WrkPtrBase) > 6 )
    {
    sprintf(d->ErrorMess,"Too many members in string: found: %s",WrkPtrBase);
    d->ParseError=1;
    return;
    }

  d->PreStored[d->CurPreStoreNum] = Out;
  d->EQ[d->CPos]=PRESTORED; d->CPos++;
  d->EQ[d->CPos]=d->CurPreStoreNum; d->CPos++;
  d->CurPreStoreNum++;
  if (d->CurPreStoreNum==MAXNUMPRESTORES) 
    {
    sprintf(d->ErrorMess,"PreStore overflow: more than %d static numbers!",MAXNUMPRESTORES);
    d->ParseError=1;  
    return;
    }
  }
else if (*d->WrkPtr== '"')
  {
  ulong Out=0,Shift=0;
  ubyte * WrkPtrBase;
  WrkPtrBase = d->WrkPtr++;
  while( *d->WrkPtr != '"' )
    {
    if ( Shift < 32 )
      {
      Out += (*d->WrkPtr << Shift );
      Shift += 8;
      }
    d->WrkPtr++;
    }
  d->WrkPtr++;

  if ( (d->WrkPtr - WrkPtrBase) > 6 )
    {
    sprintf(d->ErrorMess,"Too many members in string: found: %s",WrkPtrBase);
    d->ParseError=1;
    return;
    }

  d->PreStored[d->CurPreStoreNum] = Out;
  d->EQ[d->CPos]=PRESTORED; d->CPos++;
  d->EQ[d->CPos]=d->CurPreStoreNum; d->CPos++;
  d->CurPreStoreNum++;
  if (d->CurPreStoreNum==MAXNUMPRESTORES) 
    {
    sprintf(d->ErrorMess,"PreStore overflow: more than %d static numbers!",MAXNUMPRESTORES);
    d->ParseError=1;  
    return;
    }
  }
else if (*d->WrkPtr== '`')
  {
  ulong Out=0;
  ubyte * WrkPtrBase;

  WrkPtrBase = d->WrkPtr++;
  while( *d->WrkPtr != '`' ) d->WrkPtr++;
  d->WrkPtr++;

  switch( (d->WrkPtr - WrkPtrBase - 2) )
    {
    case 4:
      Out = *((ulong *)(WrkPtrBase+1));
      break;
    case 3:
      {
      ubyte Save = *(WrkPtrBase+4); *(WrkPtrBase+4) = 0;
      Out = *((ulong *)(WrkPtrBase+1));
      *(WrkPtrBase+4) = Save;
      }
      break;
    case 2:
      Out = *((uword *)(WrkPtrBase+1));
      break;
    case 1:
      Out = *(WrkPtrBase+1);
      break;
    default:
      sprintf(d->ErrorMess,"expected token, got: %s",WrkPtrBase);
      d->ParseError=1;
      return;
    }

  d->PreStored[d->CurPreStoreNum] = Out;
  d->EQ[d->CPos]=PRESTORED; d->CPos++;
  d->EQ[d->CPos]=d->CurPreStoreNum; d->CPos++;
  d->CurPreStoreNum++;
  if (d->CurPreStoreNum==MAXNUMPRESTORES) 
    {
    sprintf(d->ErrorMess,"PreStore overflow: more than %d static numbers!",MAXNUMPRESTORES);
    d->ParseError=1;  
    return;
    }
  }
else
  {
  double t;
  int PosNeg=1;

  if (*d->WrkPtr=='-') { PosNeg= -1; d->WrkPtr++; }
  if (isdigit(*d->WrkPtr)||*d->WrkPtr=='.') 
    { 
    t=ValNumeric(d); 
    if (d->ParseError) return;
    }
  else if (*d->WrkPtr=='E') { t=2.718281828; d->WrkPtr++; }
  else if (*d->WrkPtr=='P'&&*(d->WrkPtr+1)=='I') { t=PI; d->WrkPtr+=2; }
  else
    {
    sprintf(d->ErrorMess,"Expected term! found: %c",*d->WrkPtr);
    d->ParseError=1;
    return;
    }
  t *= (double)PosNeg;
  d->PreStored[d->CurPreStoreNum] = t;
  d->EQ[d->CPos]=PRESTORED; d->CPos++;
  d->EQ[d->CPos]=d->CurPreStoreNum; d->CPos++;
  d->CurPreStoreNum++;
  if (d->CurPreStoreNum==MAXNUMPRESTORES) 
    {
    sprintf(d->ErrorMess,"PreStore overflow: more than %d static numbers!",MAXNUMPRESTORES);
    d->ParseError=1;  
    return;
    }
  }

while (*d->WrkPtr==' ') d->WrkPtr++;

if ( *d->WrkPtr == '!' )
  {
  /* factorial */
  d->WrkPtr++;

  d->EQ[d->CPos++]= FACT_B;
  }

while (*d->WrkPtr==' ') d->WrkPtr++;

}

double ValNumeric(struct EqData *d)
{
ubyte numbuf[41];
int i;

i=0;
while( (isdigit(*d->WrkPtr)||(*d->WrkPtr)=='.')&&i<40 )
  {
  numbuf[i]= *d->WrkPtr; 
  d->WrkPtr++; i++;
  }
numbuf[i]=0;

if (i==40)
  {
  strcpy(d->ErrorMess,"Overflow in ValNumeric: number is longer than 40 ubyteacters!");
  d->ParseError=1;
  return(0);
  }

return((double)atof(numbuf));
}

double Factorial(double N)
{
long intN;

intN = (long) N;

if ( (mabs(N - intN)) < 0.00001 && intN > 0 ) /* close enough to an integer */
  {
  long Out;

  Out = 1;

  while(intN > 1)
    {
    Out *= intN;
    intN--;
    }
  
  return((double)Out);
  }

/* else N is not an integer or intN is negative */

return(1);
}

/** **/

void HelpCRBEQ(void)
{

/** spit some help out to stdout **/

puts(" The CRBEQ Optimizing Equation Compiler v2.0 ");
puts("  copyright (c) 1996 by ubyteles Bloom");
puts(" ");
puts("---------------------------------------------");
puts("GENERAL NOTES:");
puts(" ");
puts(" equations support all mathematical and programming operators");
puts(" order of operations is slightly different than that in C, in");
puts(" that programming operators (<<,&,|) are done first, not last");
puts(" so 1<<1+1 = 3 , not 4 as it would in C");
puts(" ");
puts("---------------------------------------------");
puts("COMMANDS SUPPORTED:");
puts(" ");
puts(" +,-,*,/,^                  : add,sub/neg,mult,div,pow");
puts(" (<< or <) and (>> or >)    : shifts (integers only) ");
puts(" &,|,~                      : and,or,xor (integers only) ");
puts(" !                          : factorial (integers only) ");
puts(" dx,dy,dz,dt                : derivate by parameter, e.g. dx(x) = 1");
puts(" log,ln,l2                  : log base-10,base-e, and base-2 ");
puts(" abs,lint,gint,rint         : abs.val,lowerint,greaterint,roundint");
puts(" cos,sin,tan,acos,asin,atan : trig functions");
puts(" sinh,cosh,tanh             : hyperbolic trig functions");
puts(" pi,e                       : constants");
puts(" x,y,z,t                    : variables, value set by caller");
puts(" @N                         : extra variable #N");
puts(" 'XXXX'                     : value of string, left-byte high (Good)");
printf(" %cXXXX%c                     : value of string, right-byte high (Intel)\n",34,34);
puts(" `XXXX`                     : value of string, machine-default loaded");
puts("                        string are at most 4 ubyteacters");
puts("---------------------------------------------");
puts(" > press a key for more < ");
puts("---------------------------------------------");
getchar();
puts("SYNTAX:");
puts(" ");
puts(" overuse of parenthesis gaurantees proper parsing, but slows");
puts("  down operation (i.e. 3 is faster than (3) )");
puts(" parenthesis are optional in function calls, i.e. ");
puts("  log4 = log(4) , but log2+2 = (log2)+2 not= log4 = log(2+2)");
puts(" whitespace is ignored , i.e. log 4 = log4");
puts("---------------------------------------------");
puts("ORDER OF OPERATIONS:");
puts(" ");
puts("  numbers");
puts("  factorial");
puts("  functions (trig,log,etc.,random order)");
puts("  programming operators (shift,and,or,xor) ");
puts("  exponentials (pow)");
puts("  mult & div");
puts("  add & sub");
puts(" ");
puts("example:");
puts(" rint cos2!<<2*3+1 = ((rint(cos(2!))<<2)*3)+1 ");
puts("---------------------------------------------");
puts(" > press a key for more < ");
puts("---------------------------------------------");
getchar();
puts("HIGH-LEVEL COMMANDS: (not supported in v2)");
puts(" ");
puts("The following operands at the beginning of the string act as");
puts(" high level operands which effect the rest of the processing.");
puts("Each must be prefixed and postfixed by a colon,:");
puts(" ");
puts("?,h,H          show this help (doesn't require colons) ");
puts(" ");
puts(":S,a,b:        Sum equation with variable X as the index, running");
puts("                from X = a to X = b");
puts("               e.g. ':S,1,3: X' = 6");
puts(" ");
puts(":I,a,b:        return the integral of the following equation, from");
puts("                X = a to X = b");
puts(" ");
puts("---------------------------------------------");
puts("FUTURE IMPROVEMENTS:");
puts(" ");
puts("1. High Level Commands will be functions, so that you could ");
puts("    do (I,0,Y,D(F(X))) = F(Y)");
puts("   This requires recursive nesting of CRBEQ returns");
puts(" ");
puts("2. Make a flag to force parameters of &,<<,|,etc. to be integers");
puts("   Make ! support full the Gamma Function domain");
puts(" ");
puts("3. Remove unnecessary parentheses to avoid the slowdown caused by");
puts("    overloading");
puts("---------------------------------------------");
puts(" > press a key to end < ");
puts("---------------------------------------------");
getchar();

}
