/*
 *  Type-ARQuE - the experimental SPARQL to SQL translator.
 *  Copyright (C) 2010  Sami Kiminki / Aalto University
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

namespace TypeRQ {

   class TransactionImpl
   {
   protected:
      int refCount;

   public:
      TransactionImpl();
      virtual ~TransactionImpl();

      virtual bool isActive() const = 0;
      virtual void commit() = 0;
      virtual void rollback() = 0;

      int addToRefCount(int a);
   };

   class Transaction
   {
   private:
      Transaction &operator =(const Transaction &);
      Transaction();

      TransactionImpl *const txImpl;

      void modifyRefCount(int a);

   public:
      Transaction(const Transaction &);
      Transaction(TransactionImpl *);

      virtual ~Transaction();

      virtual void commit();
      virtual void rollback() ;
   };

   class TxManager
   {
   public:
      TxManager();
      virtual ~TxManager();

      virtual Transaction newTransaction() = 0;
   };

}
