/*
 *  Type-ARQuE - the experimental SPARQL to SQL translator.
 *  Copyright (C) 2010  Sami Kiminki / Aalto University
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "AQLException.h"
#include "TxManager.h"

namespace TypeRQ {

   TransactionImpl::TransactionImpl() : refCount(0) {}
   TransactionImpl::~TransactionImpl() {}
   int TransactionImpl::addToRefCount(int a)
   {
      refCount+=a;
      return refCount;
   }

   Transaction::Transaction() : txImpl()
   {
      throw AQLException("Transaction::Transaction should never be invoked!");
   }
   Transaction::Transaction(const Transaction &o) : txImpl(o.txImpl)
   {
      txImpl->addToRefCount(1);
   }
   Transaction::Transaction(TransactionImpl *_impl) : txImpl(_impl)
   {
      txImpl->addToRefCount(1);
   }

   Transaction::~Transaction()
   {
      if (txImpl->addToRefCount(-1)==0) delete txImpl;
   }

   void Transaction::commit()
   {
      txImpl->commit();
   }

   void Transaction::rollback()
   {
      txImpl->rollback();
   }

   TxManager::TxManager() {}
   TxManager::~TxManager() {}
}
