/*
 *  Type-ARQuE - the experimental SPARQL to SQL translator.
 *  Copyright (C) 2010  Sami Kiminki / Aalto University
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include <sstream>
#include <string>

#include <stdarg.h>

namespace TypeRQ {

   class SeparatedStringBuilder
   {
   private:
      std::string const separator;
      std::stringstream ss;
      bool zeroParts;

   public:
      SeparatedStringBuilder(const char *separator);

      SeparatedStringBuilder &operator << (const char *);
      SeparatedStringBuilder &operator << (const std::string &);

      void newPart();
      bool empty() const;

      std::string getString() const;
   };

   std::string formatToString(const char *fmt ...);
   std::string formatToString(const char *fmt, va_list ap);
}
