/*
 *  Type-ARQuE - the experimental SPARQL to SQL translator.
 *  Copyright (C) 2010  Sami Kiminki / Aalto University
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>
#include <stdio.h>

#include "StringUtils.h"

namespace TypeRQ {

   SeparatedStringBuilder::SeparatedStringBuilder(const char *_separator) : separator(_separator),
                                                                            zeroParts(true) {}

   SeparatedStringBuilder &SeparatedStringBuilder::operator << (const char *text)
   {
      ss << text;
      return *this;
   }

   SeparatedStringBuilder &SeparatedStringBuilder::operator << (const std::string &text)
   {
      ss << text;
      return *this; 
  }

   void SeparatedStringBuilder::newPart()
   {
      if (zeroParts)
         zeroParts=false;
      else
         ss << separator;
   }

   bool SeparatedStringBuilder::empty() const
   {
      return zeroParts;
   }

   std::string SeparatedStringBuilder::getString() const
   {
      return ss.str();
   }


   std::string formatToString(const char *fmt ...)
   {
      std::string str;

      va_list ap;
      va_start(ap, fmt);

      str=formatToString(fmt, ap);

      va_end(ap);      

      return str;
   }

   std::string formatToString(const char *fmt, va_list ap)
   {
      std::string str;
      char *s=0;

      int nobytes=vasprintf(&s, fmt, ap);
      if (nobytes>=0)
      {
         str=s;
         free(s);
      }
      else {
         // some major badness occurred
         str="formatToString: FORMAT ERROR!";
      } 

      return str;
   }

}
