/*
 *  Type-ARQuE - the experimental SPARQL to SQL translator.
 *  Copyright (C) 2010  Sami Kiminki / Aalto University
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include <list>
#include <ostream>

#include "AQLDebug.h"

namespace TypeRQ {

   struct JoinTerm
   {
      std::string table;
      std::string alias;
   };

   struct InnerJoinExpression;

   struct JoinExpression : AQLDebugBase
   {
      std::list<JoinTerm> joinTerms;
      std::list<InnerJoinExpression *> nestedJoins;

      virtual ~JoinExpression();
   };

   struct InnerJoinExpression : JoinExpression
   {
      bool isLeftOuter;
      std::string joinCondition;
   };

   void printJoinExpression(std::ostream &, const JoinExpression &);
}
