/*
 *  Type-ARQuE - the experimental SPARQL to SQL translator.
 *  Copyright (C) 2010  Sami Kiminki / Aalto University
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include <string>
#include <sstream>
#include <stdint.h>

#include "AQLDebug.h"

namespace TypeRQ {

   class SQLInsertBuilder : protected AQLDebugBase
   {
   private:
      SQLInsertBuilder(const SQLInsertBuilder &);
      SQLInsertBuilder &operator = (const SQLInsertBuilder &);

   protected:
      bool zeroColumns;
      std::stringstream columns;
      std::stringstream values;
      std::string table;

      std::string lastStm;

      void addSeparatorIfNeeded();

   public:
      SQLInsertBuilder(const std::string &_table);

      const std::string &buildInsertStatement();

      void addColumn(const std::string &col, const std::string &val);
      void addColumn(const std::string &col, int64_t val);

   };
}
