/*
 *  Type-ARQuE - the experimental SPARQL to SQL translator.
 *  Copyright (C) 2010  Sami Kiminki / Aalto University
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "SQLInsertBuilder.h"


namespace TypeRQ {

   SQLInsertBuilder::SQLInsertBuilder(const std::string &_table) : zeroColumns(true), table(_table) {}

   void SQLInsertBuilder::addSeparatorIfNeeded()
   {
      if (!zeroColumns)
      {
         columns << ", ";
         values << ", ";
      }
      else {
         zeroColumns=false;
      }
   }

   const std::string &SQLInsertBuilder::buildInsertStatement()
   {
      std::stringstream stm;
      stm.clear();
      if (!zeroColumns)
      {
         stm << "INSERT INTO " << table << " (";
         stm << columns.str() << ") VALUES (";
         stm << values.str() << ")";
         lastStm.assign(stm.str());
      }
      else {
         lastStm.clear();
      }
      return lastStm;
   }

   void SQLInsertBuilder::addColumn(const std::string &col, const std::string &val)
   {
      addSeparatorIfNeeded();
      columns << col;
      values << val;
   }
   void SQLInsertBuilder::addColumn(const std::string &col, int64_t val)
   {
      addSeparatorIfNeeded();
      columns << col;
      values << val;
   }
}
