/*
 *  Type-ARQuE - the experimental SPARQL to SQL translator.
 *  Copyright (C) 2010  Sami Kiminki / Aalto University
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

// a little sanity check
#if HAS_MYSQL != 1
#error MySQL support is disabled from build. This file should not be included!
#endif

#include <string>

#include "SQLBackend.h"

namespace TypeRQInternal
{
   struct MySQLContext;
}

namespace TypeRQ {

   class SQLFunctionMap;

   class SQLBackendMySQL : public SQLBackend
   {
   public:
      SQLBackendMySQL();
      virtual ~SQLBackendMySQL();

      virtual const std::string &getName();

      virtual SQLFunctionMap &getFunctionMap();

      virtual void connect(const std::string &connectionString);
      virtual void disconnect();

      virtual void executeStatement(const std::string &statement);
      virtual SQLResultIterator executeQuery(const std::string &query);

      virtual std::string escapeString(const std::string &stringLiteral);

      virtual Transaction newTransaction();

      virtual const SQLBackendCapabilities &getCapabilities();

      virtual std::string getSQLNameForType(AQLTypeSet::ExprType exprType, size_t sizeLimit);

   protected:
      SQLFunctionMap *const functionMap;
      TypeRQInternal::MySQLContext *const mysqlContext;

      void requireConnection();
   };

}
