/*
 *  Type-ARQuE - the experimental SPARQL to SQL translator.
 *  Copyright (C) 2010  Sami Kiminki / Aalto University
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include <list>
#include <map>
#include <vector>
#include <string>

#include "AQLDebug.h"
#include "AQLModel.h"
#include "TxManager.h"

namespace TypeRQ {

   class SQLFunctionMap;

   class SQLResultIteratorImpl : protected AQLDebugBase
   {
   protected:
      int refCount;

   public:
      SQLResultIteratorImpl();
      virtual ~SQLResultIteratorImpl();
      virtual void addRef();
      virtual int removeRef(); // returns refcount

      virtual int getColCount() = 0;

      virtual bool nextRow() = 0;

      virtual const std::string &getString(int col) = 0;
      virtual int64_t getInt(int col) = 0;
      virtual double getDouble(int col) = 0;
      virtual bool isNull(int col) = 0;
   };

   class SQLResultIterator : protected AQLDebugBase
   {
   private:
      SQLResultIterator &operator =(SQLResultIterator &); // disable copy operation

   protected:
      SQLResultIteratorImpl *impl;

   public:
      SQLResultIterator(SQLResultIteratorImpl *impl);
      SQLResultIterator(const SQLResultIterator &);

      virtual ~SQLResultIterator();

      virtual int getColCount();

      virtual bool nextRow();

      virtual const std::string &getString(int col);
      virtual int64_t getInt(int col);
      virtual double getDouble(int col);
      virtual bool isNull(int col);
   };

   struct SQLBackendCapabilities
   {
      std::string createTableSuffix; // text that will be added after CREATE TABLE statement, but before ';'
   };



   class SQLBackend : public TxManager
   {
   public:
      SQLBackend();
      virtual ~SQLBackend();

      virtual const std::string &getName() = 0;

      virtual SQLFunctionMap &getFunctionMap() = 0;

      virtual void connect(const std::string &connectionString) = 0;
      virtual void disconnect() = 0;
      virtual void executeStatement(const std::string &statement) = 0;
      virtual SQLResultIterator executeQuery(const std::string &query) = 0;

      virtual std::string escapeString(const std::string &stringLiteral) = 0;

      virtual const SQLBackendCapabilities &getCapabilities() = 0;

      // returns corresponding SQL type for AQL type. Used in generating sql create statements
      virtual std::string getSQLNameForType(AQLTypeSet::ExprType exprType, size_t sizeLimit);
   };



}
