/*
 *  Type-ARQuE - the experimental SPARQL to SQL translator.
 *  Copyright (C) 2010  Sami Kiminki / Aalto University
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <iostream>
#include <sstream>

#include "AQLException.h"
#include "SQLBackend.h"
#include "AQLSupport.h"

namespace {
   using namespace TypeRQ;

}

namespace TypeRQ {


   SQLResultIteratorImpl::SQLResultIteratorImpl() : refCount(0) {}

   SQLResultIteratorImpl::~SQLResultIteratorImpl() {}

   void SQLResultIteratorImpl::addRef()
   {
      ++refCount;
   }

   int SQLResultIteratorImpl::removeRef()
   {
      --refCount;
      return refCount;
   }

   SQLResultIterator::SQLResultIterator(SQLResultIteratorImpl *_impl) : impl(_impl)
   {
      impl->addRef();
   }

   SQLResultIterator::SQLResultIterator(const SQLResultIterator &i) : impl(i.impl)
   {
      impl->addRef();
   }

   SQLResultIterator::~SQLResultIterator()
   {
      int refCount=impl->removeRef();
      if (refCount==0) delete impl;
   }

   int SQLResultIterator::getColCount()
   {
      return impl->getColCount();
   }

   bool SQLResultIterator::nextRow()
   {
      return impl->nextRow();
   }

   const std::string &SQLResultIterator::getString(int col)
   {
      return impl->getString(col);
   }
   int64_t SQLResultIterator::getInt(int col)
   {
      return impl->getInt(col);
   }
   double SQLResultIterator::getDouble(int col)
   {
      return impl->getDouble(col);
   }
   bool SQLResultIterator::isNull(int col)
   {
      return impl->isNull(col);
   }


   SQLBackend::SQLBackend() {}
   SQLBackend::~SQLBackend() {}

   std::string SQLBackend::getSQLNameForType(AQLTypeSet::ExprType exprType, size_t sizeLimit)
   {
      std::stringstream ss;
      switch (exprType)
      {
         case AQLTypeSet::ANY:
         case AQLTypeSet::IRI:
         case AQLTypeSet::STRING:
            if (sizeLimit>0 && sizeLimit < 256)
            {
               ss << "VARCHAR(" << sizeLimit << ")";
            }
            else {
               ss << "TEXT";
            }
            break;

         case AQLTypeSet::BOOLEAN:
            ss << "BOOLEAN";
            break;

         case AQLTypeSet::INTEGER:
            ss << "INTEGER";
            break;

         case AQLTypeSet::DATETIME:
            ss << "TIMESTAMP";
            break;

         case AQLTypeSet::DOUBLE:
            ss << "DOUBLE PRECISION";
            break;

         default:
            throw AQLException("Unsupported data type: %s", getNameForExprType(exprType));
      }
      return ss.str();
   }
}
