/*
 *  Type-ARQuE - the experimental SPARQL to SQL translator.
 *  Copyright (C) 2010  Sami Kiminki / Aalto University
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include <istream>
#include <ostream>

namespace TypeRQInternal
{
   struct SPARQLParserImpl;
}

namespace TypeRQ
{

   struct SQLFunctionMap;

   class SPARQLParser
   {
   public:
      enum VariableBindingMode {
         VBM_BOTTOM_UP=0, // this is the current mode
         VBM_LEFT_TO_RIGHT, // historical mode
      };

   protected:
      TypeRQInternal::SPARQLParserImpl *parserImpl;

   public:
      SPARQLParser();
      virtual ~SPARQLParser();

      /**
       * Parse query and return corresponding SPARQLQuery object.
       *
       * @param is The input stream containing the query.
       * @return Pointer to SPARQLQuery object
       */
      void parseQuery(std::istream &is, SQLFunctionMap &functionMap, VariableBindingMode variableBindingMode);

      void printIntermediateQuery(std::ostream &os);

      AQLQuery *translateToAQL();
   };


}
