/*
 *  Type-ARQuE - the experimental SPARQL to SQL translator.
 *  Copyright (C) 2010  Sami Kiminki / Aalto University
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include <string>

#include <stdio.h>


namespace TypeRQInternal {
   struct N3TripleReaderContext;
}

namespace TypeRQ
{
   struct AQLLiteralExpr;

   class N3TripleHandler
   {
   public:
      virtual ~N3TripleHandler();

      // throw AQLException to abort parsing
      virtual void handleTriple(const AQLLiteralExpr &s, const AQLLiteralExpr &p, const AQLLiteralExpr &o) = 0;
   };


   class N3TripleReader
   {
   public:
      N3TripleReader();
      virtual ~N3TripleReader();

      void openFile(const std::string &filename);
      void openConsoleIn();
      void close();

      void readTriples(N3TripleHandler &handler);

   protected:
      std::string filename;
      FILE *in;
      bool invokeClose;
      TypeRQInternal::N3TripleReaderContext *context;

      void openParserContext();
      void closeParserContext();
   };



}
