/*
 *  Type-ARQuE - the experimental SPARQL to SQL translator.
 *  Copyright (C) 2010  Sami Kiminki / Aalto University
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include <list>
#include <ostream>

#include <stdint.h>

namespace TypeRQ {

   class ListPrettyPrinter
   {
   public:
      ListPrettyPrinter(std::ostream &);
      ~ListPrettyPrinter();

      void openLevel(const char *);
      void newTerm();
      void closeLevel();
      void printIndent();

      ListPrettyPrinter &operator << (const std::string &s);
      ListPrettyPrinter &operator << (char s);
      ListPrettyPrinter &operator << (const char *s);
      ListPrettyPrinter &operator << (int);
      ListPrettyPrinter &operator << (int64_t);
      ListPrettyPrinter &operator << (double);


   protected:
      std::ostream &os;
      bool requireSpaceBeforeTerm;
      std::list<int> levelIndents;
      int currentIndent;
      int cursorPos;

      void updateIndent();
   };


}
