/*
 *  Type-ARQuE - the experimental SPARQL to SQL translator.
 *  Copyright (C) 2010  Sami Kiminki / Aalto University
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string>
#include <sstream>

#include "FormatUtils.h"

namespace {

   std::string readPart(std::istream &is, char terminator)
   {
      std::string ret;
      bool isEscape=false;

      while (is)
      {
         char c;
         c=is.get();

         if (is)
         {
            if (!isEscape)
            {
               if (c==terminator) return ret;

               if (c!='\\')
                  ret.push_back(c);
               else
                  isEscape=true;
            }
            else {
               ret.push_back(c);
               isEscape=false;
            }
         }
      }
      return ret;
   }


}

namespace TypeRQ {

   std::string intToHexString(unsigned i, int minimumWidth)
   {
      static const char hexChars[16]={
         '0', '1', '2', '3', '4', '5', '6', '7',
         '8', '9', 'A', 'B', 'C', 'D', 'E', 'F',
      };
      std::string buf;
      do {
         buf+=hexChars[i & 0xF];
         i>>=4;
         --minimumWidth;
      } while (i || minimumWidth>0);
      return std::string(buf.rbegin(), buf.rend());
   }

   void parseConnectionString(const std::string &connectionString,
                              std::map<std::string, std::string> &connectionParameters)
   {
      std::istringstream iss(connectionString);
      while (iss)
      {
         const std::string &key=readPart(iss, '=');
         const std::string &value=readPart(iss, ',');
         connectionParameters[key]=value;
      }
   }
}
