/*
 *  Type-ARQuE - the experimental SPARQL to SQL translator.
 *  Copyright (C) 2010  Sami Kiminki / Aalto University
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include "AQLSupport.h"
#include "FlexibleSQLLayoutDebug.h"
#include "Messages.h"

#ifndef NDEBUG
namespace {
   using namespace TypeRQInternal;


}
#endif // ifndef NDEBUG

namespace TypeRQInternal {

   void dumpFlexibleLayoutDescriptor(const FlexibleLayoutDescriptor &fld)
   {
#ifndef DEBUG
      print(OL_QUIET, "Flexible layout descriptor dump={\n");
      print(OL_QUIET, "  triple table = %s\n", fld.tripleTable.c_str());
      for (int i=0; i<AQLPropertyExpr::PROPERTY_SIZE; ++i)
      {
         const AQLPropertyExpr::Property p=static_cast<AQLPropertyExpr::Property>(i);
         const FlexiblePropertyLayout &fpl=fld.propertyLayouts[i];
         print(OL_QUIET, "  %s = {\n", getNameForAQLTripleProperty(p));

         for (int j=0; j<AQLTypeSet::EXPRTYPE_SIZE; ++j)
         {
            const AQLTypeSet::ExprType exprType=static_cast<AQLTypeSet::ExprType>(j);
            const FlexibleExprTypeLayout &fetl=fpl.exprTypeLayouts[j];
            print(OL_QUIET, "    %s = {\n", getNameForExprType(exprType));

            for (FlexibleExprTypeLayout::list_type::const_iterator k=fetl.sqlColRefs.begin();
                 k!=fetl.sqlColRefs.end(); ++k)
            {
               const FlexibleSqlColumnReference &fscr=*k;
               print(OL_QUIET, "      ");
               switch (fscr.referenceType)
               {
                  case FlexibleSqlColumnReference::INLINE:
                     print(OL_QUIET, "INLINE valueColumn=%s", fscr.valueColumn.c_str());
                     break;

                  case FlexibleSqlColumnReference::INDEX:
                     print(OL_QUIET, "INDEX tripleTableColumn=%s valuetable=%s indexColumn=%s valueColumn=%s",
                           fpl.tripleTableColumn.c_str(),
                           fscr.table.c_str(), fscr.indexColumn.c_str(), fscr.valueColumn.c_str());
                     break;
               }
               if (fscr.valueColumnSize>0)
               {
                  print(OL_QUIET, " valueColumnSize=%zu", fscr.valueColumnSize);
               }
               print(OL_QUIET, " valueColumnType=%s", getNameForExprType(fscr.valueColumnType));
               print(OL_QUIET, "\n");
            }

            print(OL_QUIET, "    }\n");
         }

         print(OL_QUIET, "  }\n");
      }
      print(OL_QUIET, "}\n\n");
#endif // ifndef NDEBUG
   }

   void dumpValueUpdatePlan(const ValueUpdatePlan &plan, AQLPropertyExpr::Property property,
                            AQLTypeSet::ExprType literalType)
   {
#ifndef DEBUG
      print(OL_QUIET, "Value update plan for referenced literal %s:%s = {\n",
            getNameForAQLTripleProperty(property), getNameForExprType(literalType));

      for (ValueUpdatePlan::outer_list_type::const_iterator i=plan.tableUpdates.begin();
           i!=plan.tableUpdates.end(); ++i)
      {
         const ValueUpdatePlan::inner_list_type &innerList=*i;

         print(OL_QUIET, "  Update chain={\n");

         for (ValueUpdatePlan::inner_list_type::const_iterator j=innerList.begin();
              j!=innerList.end(); ++j)
         {
            const TableUpdate &tabU=*j;
            print(OL_QUIET,
                  "    table=%s, indexColumn='%s', valueColumn=%s, columnType=%s, valueColumnSize=%zu\n",
                  tabU.table.c_str(), tabU.indexColumn.c_str(), tabU.valueColumn.c_str(),
                  getNameForExprType(tabU.columnType), tabU.valueColumnSize);
         }

         print(OL_QUIET, "  }\n");
      }

      print(OL_QUIET, "}\n");
#endif // ifndef NDEBUG
   }
}
