/*
 *  Type-ARQuE - the experimental SPARQL to SQL translator.
 *  Copyright (C) 2010  Sami Kiminki / Aalto University
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include <ostream>


namespace TypeRQInternal {
   struct ExpressionWriterContext;
}

namespace TypeRQ {

   class ExpressionWriter
   {
   protected:
      TypeRQInternal::ExpressionWriterContext &ctx;
      std::ostream &os;

   public:
      ExpressionWriter(std::ostream &);
      virtual ~ExpressionWriter();

      void startUnOp(const char *op, int precedence, bool isLeftAssociative);
      void startBinOp(const char *op, int precedence, bool isLeftAssociative, bool isCommutative);
      void startFunction(const std::string &fn);
      void endOp();

      void nextTerm();

      template <class T> ExpressionWriter &operator << (const T &t)
      {
         os << t;
         return *this;
      }

   };

   class SQLExpressionWriter : public ExpressionWriter
   {
   public:
      SQLExpressionWriter(std::ostream &);

      void startDot(); // .
      void startUnaryMinus(); // -
      void startExp(); // ^
      void startMult(); // *
      void startDiv(); // /
      void startMod(); // %
      void startPlus(); // a + b
      void startMinus(); // a - b
      void startUnaryIs(const char *op); // IS NULL, IS NOT NULL, ...

      // misc
      void startConcat(); // a || b

      // end of misc
      void startIn(); // a IN b
      void startBetween(); // a BETWEEN b
      void startLike(const char *op); // a LIKE b, a ILIKE b, a SIMILAR b, ...
      void startComparison(const char *op); // <, <=, >, >=, <> but not =
      void startEq(); // =
      void startNot(); // NOT a
      void startAnd(); // a AND b
      void startOr(); // a OR b
   };
}
