/*
 *  Type-ARQuE - the experimental SPARQL to SQL translator.
 *  Copyright (C) 2010  Sami Kiminki / Aalto University
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include <string>

#include "AQLModel.h"

namespace TypeRQ {

   struct AQLQuery;
   struct SQLQuery;
   struct SQLLayout;
   struct SQLFunctionMap;

   class AQLToSQLTranslator
   {
   protected:
      SQLFunctionMap &functionMap;

   public:
      AQLToSQLTranslator(SQLFunctionMap &);
      virtual ~AQLToSQLTranslator();

      std::string translateToSql(AQLQuery &aql, SQLLayout &);

      // Translates expr to sql. Note: please use translateToSql unless you know
      // how to prepare the expression before translations. This is mostly meant
      // for SQLLayout engines.
      std::string translateExprToSql(AQLExpr &, SQLLayout &);
      std::string aqlLiteralExprToSQL(const AQLLiteralExpr &, SQLLayout &);

      static const char *getFunctionNameForTypecast(AQLTypeSet::ExprType toType);

   };

}
