/*
 *  Type-ARQuE - the experimental SPARQL to SQL translator.
 *  Copyright (C) 2010  Sami Kiminki / Aalto University
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include <istream>
#include <ostream>

#include "AQLDebug.h"
#include "SPARQLParser.h"

namespace TypeRQ
{
   struct AQLQuery;
   struct SPARQLParser;
   struct SQLLayout;
   struct SQLBackend;
   struct SQLResultIterator;

   class QueryExecutor : protected AQLDebugBase
   {
   private:
      int currentStage;
      const int finalStage;

      std::istream *is;
      bool deleteIsAfterUse;

      void releaseIs();
   protected:

      virtual void processStage(int stage) = 0;

      QueryExecutor(int finalStage);

      virtual void releaseResources() = 0;

      std::istream &getIs();

   public:
      virtual ~QueryExecutor();

      void newQuery(std::istream *, bool deleteIsAfterUse);

      int getCurrentStage() const;
      int getFinalStage() const;
      void advanceToStage(int stage);

      virtual const char *getStageName(int stage) const = 0;
      virtual void printCurrentStageResult(std::ostream &) = 0;
   };

   class AQLQueryExecutor : public QueryExecutor
   {
   protected:
      SQLLayout &sqlLayout;
      SQLBackend &sqlBackend;

      AQLQuery *aqlQuery;
      std::string sqlQuery;
      SQLResultIterator *sqlResultIterator;

      virtual void processStage(int stage);
      virtual void releaseResources();
   public:
      AQLQueryExecutor(SQLLayout &, SQLBackend &);
      virtual ~AQLQueryExecutor();
      virtual void printCurrentStageResult(std::ostream &);
      virtual const char *getStageName(int stage) const;
   };

   class SPARQLQueryExecutor : public QueryExecutor
   {
   protected:
      SQLLayout &sqlLayout;
      SQLBackend &sqlBackend;
      const SPARQLParser::VariableBindingMode variableBindingMode;

      SPARQLParser *sparqlParser;
      AQLQuery *aqlQuery;
      std::string sqlQuery;
      SQLResultIterator *sqlResultIterator;

      virtual void processStage(int stage);
      virtual void releaseResources();
   public:
      SPARQLQueryExecutor(SQLLayout &, SQLBackend &, SPARQLParser::VariableBindingMode variableBindingMode);
      virtual ~SPARQLQueryExecutor();
      virtual void printCurrentStageResult(std::ostream &);
      virtual const char *getStageName(int stage) const;
   };

}
