/*
 *  Type-ARQuE - the experimental SPARQL to SQL translator.
 *  Copyright (C) 2010  Sami Kiminki / Aalto University
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include <ostream>
#include <string>

#include <stdarg.h>

namespace TypeRQ {

   class AQLException {
   public:
      AQLException();
      AQLException(const std::string &reason);
      AQLException(const char *fmt ...);

      const char *getReason() const;

      virtual const char *getType() const;

   protected:
      std::string reason;

      void setFormattedReason(const char *fmt, va_list ap);
   };

}

std::ostream & operator << (std::ostream &, const TypeRQ::AQLException &);
