/*
 *  Type-ARQuE - the experimental SPARQL to SQL translator.
 *  Copyright (C) 2010  Sami Kiminki / Aalto University
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>

#include "AQLException.h"

namespace {

}

namespace TypeRQ {

   AQLException::AQLException() {}

   AQLException::AQLException(const char *format ...) {
     va_list ap;
     va_start(ap, format);
     setFormattedReason(format, ap);
     va_end(ap);
  }

   AQLException::AQLException(const std::string &_reason) : reason(_reason) {}

   void AQLException::setFormattedReason(const char *fmt, va_list ap) {
      char *s=0;
      int nobytes=vasprintf(&s, fmt, ap);
      if (nobytes>=0)
      {
         reason=s;
         free(s);
      }
      else {
         // some major badness occurred
         reason="AQLException::setFormattedReason: FORMAT FAILURE!";
      }
   }

   const char *AQLException::getReason() const {
      return reason.c_str();
   }

   const char *AQLException::getType() const {
      return "AQLException";
   }
}

std::ostream & operator << (std::ostream &out, const TypeRQ::AQLException &ex) {
   out << ex.getType() << ": " << ex.getReason();
   return out;
}
