/*
 *  Type-ARQuE - the experimental SPARQL to SQL translator.
 *  Copyright (C) 2010  Sami Kiminki / Aalto University
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef NDEBUG

#include <cstdlib>
#include <cstdio>
#include <set>
#include <typeinfo>

#include "AQLDebug.h"

namespace {

   using namespace TypeRQ;

   std::set<AQLDebugBase *> liveObjects;

   bool moduleInitialized=false;


   void assertNoLiveObjects()
   {
      if (!liveObjects.empty())
      {
         fprintf(stderr, "Warning! The following objects were not destroyed before exit:\n");
         for (std::set<AQLDebugBase *>::const_iterator i=liveObjects.begin(); i!=liveObjects.end(); ++i) {
            const AQLDebugBase *object=*i;
            const std::type_info &info = typeid(*object);
            fprintf(stderr, "- %s@%p\n", info.name(), object);
         }
         fprintf(stderr, "Totaling %zd objects. Consider using delete.\n", liveObjects.size());
      }
   }

}

namespace TypeRQ
{

   AQLDebugBase::AQLDebugBase()
   {
      if (!moduleInitialized)
      {
         moduleInitialized=true;
         atexit(assertNoLiveObjects);
      }

      initializedMagic=-13579;

      if (!liveObjects.insert(this).second)
      {
         const std::type_info &info = typeid(*this);
         fprintf(stderr, "%s@%p: Same memory used twice for different live objects.\n", info.name(), this);
         abort();
      }
   }

   AQLDebugBase::~AQLDebugBase()
   {
      if (initializedMagic!=-13579)
      {
         const std::type_info &info = typeid(*this);
         fprintf(stderr, "%s@%p: Not initialized (try adding copy-constructor to this class) or memory corruption.\n", info.name(), this);
         abort();
      }

      if (!liveObjects.erase(this))
      {
         const std::type_info &info = typeid(*this);
         fprintf(stderr, "%s@%p: Object was not found from live object set.\n", info.name(), this);
         abort();
      }
   }


}

#endif
