#ifndef VALUATION_H
#define VALUATION_H

#include "element.h"
#include <string>
#include <vector>
#include <list>
#include <set>
#include <utility>
#include <nautinv.h>
#include <map>

class Valuation
{
	int typeCount;
	int relvarCount;
	int avarCount;
	//std::map<TypeVariable, int> type2int;
	//std::map<RelationVariable, int> relv2int;
	//std::map<AtomVariable, int> atomv2int;
	std::vector<int> typeSizes;
	std::vector<std::pair<int, int> > relType;
	std::vector<std::pair<int, int> > relTypeCumSizes;
	std::vector<int> avarType;
	std::vector<int> avarVal;
	std::vector<int> colourCount;
	std::vector<std::vector<int> > colours;
	int greatestNonemptyRelvar;
	int greatestNonemptyRow;
	int greatestNonemptyCol;
	//std::map<std::set<AtomVariable>, std::set<int> >* colour2atom;
	graph *valg;
	graph *cang;
	int n;
	int m;
/*
	std::map<AtomVariable,Atom> avmap;
	int typeToInt(const TypeVariable&) const;
	int relvarToInt(const RelationVariable&) const;
*/
	Valuation(const Valuation&, int, int);
	void initialiseGraphs();
public:
	Valuation();
	Valuation(const std::vector<int>&, const std::vector<std::pair<int,int> >&);
	Valuation(const Valuation&);
	Valuation& operator=(const Valuation&);
	~Valuation();
	/*std::set<TypeVariable> getTypeVariables() const;
	std::set<RelationVariable> getRelationVariables() const;
	std::set<AtomVariable> getAtomVariables() const;
	*/
	std::list<Valuation*> children() const;
	std::list<Valuation*> addAtomVariable(const TypeVariable&) const;
	Valuation* addRelationVariable(const TypeVariable&, const TypeVariable&) const;
	std::list<Valuation*> addTypeVariable(int) const;
	AtomSet* getValue(const TypeVariable&) const;
	AtomSet* getValue(const std::set<TypeVariable>&) const;
	AtomTupleSet* getValue(const RelationVariable&) const;
	Atom getValue(const AtomVariable&) const;
	bool isMember(int, int, int) const;
	bool areEqual(int, int) const;
	void computeCanonicalGraph();
	int getTypeVariableCount() const;
	int getRelationVariableCount() const;
	int getAtomVariableCount() const;
	bool operator<(const Valuation&) const;
	bool operator==(const Valuation&) const;
	bool almostEquals(const Valuation&) const;
//	std::string toString(const std::set<TypeVariable>&, const std::set<RelationVariable>&, const std::set<AtomVariable>&) const;
};

#endif
