#include "valuation.h"
#include <iostream>
#include <sstream>
#include <assert.h>
#include <algorithm>

Valuation::Valuation() : typeCount(0), relvarCount(0), avarCount(0), typeSizes(std::vector<int>()), relType(std::vector<std::pair<int,int> >()), relTypeCumSizes(std::vector<std::pair<int, int> >(1, std::pair<int,int>(0,0))), avarType(std::vector<int>()), avarVal(std::vector<int>()), colourCount(std::vector<int>()), colours(std::vector<std::vector<int> >()), greatestNonemptyRelvar(-1), greatestNonemptyRow(0), greatestNonemptyCol(0), valg(0), cang(0), n(0), m(0)
{
	valg = new graph[0];
	cang = new graph[0];
}

Valuation::Valuation(const std::vector<int>& ts, const std::vector<std::pair<int, int> >& rvs) : typeCount(ts.size()), relvarCount(rvs.size()), avarCount(0), typeSizes(ts), relType(rvs), relTypeCumSizes(std::vector<std::pair<int, int> >(rvs.size()+1, std::pair<int,int>(0,0))), avarType(std::vector<int>()), avarVal(std::vector<int>()), colourCount(std::vector<int>(ts.size(), 1)), colours(std::vector<std::vector<int> >(ts.size())), greatestNonemptyRelvar(-1), greatestNonemptyRow(0), greatestNonemptyCol(0), valg(0), cang(0), n(0), m(0)
{
	int i;
	for(int i = 0; i < typeCount; i++)
	{
		colours[i].assign(typeSizes[i], 1);
	}
	for(int i = 0; i < relvarCount; i++)
	{
		if(relType[i].first < 0 || relType[i].second < 0 || relType[i].first >= typeCount || relType[i].second >= typeCount)
		{
			std::cout << "Every type in domain must be listed as a type variable!" << std::endl;
			exit(1);
		}

		relTypeCumSizes[i + 1].first = relTypeCumSizes[i].second + typeSizes[relType[i].first];
		if(relType[i].first != relType[i].second)
		{
			relTypeCumSizes[i + 1].second = relTypeCumSizes[i + 1].first + typeSizes[relType[i].second];
		}
		else
		{
			relTypeCumSizes[i + 1].second = relTypeCumSizes[i + 1].first;
		}
	}
/*	colour2atom = new std::map<std::set<AtomVariable>, std::set<int> >[typeCount];
	for(i = 0; i < typeCount; ++i)
	{
		std::set<int> atoms;
		for(int j = 0; j < typeSizes[i]; ++j)
		{
			atoms.insert(j);
		}
		(colour2atom[i])[std::set<AtomVariable>()] = atoms;
	}
*/
	n = relTypeCumSizes[relvarCount].second;
	m = ((n - 1) / WORDSIZE) + 1;
	valg = new graph[n*m];
	cang = new graph[n*m];
	for(i = 0; i < n; ++i)
	{
		EMPTYSET(GRAPHROW(valg, i, m), m);
	}
	initialiseGraphs();
}

void Valuation::initialiseGraphs()
{
	for(int i = 0; i < relvarCount; ++i)
	{
		for(int j = i + 1; j < relvarCount; ++j)
		{
			if(relType[i].first == relType[j].first)
			{
				for(int k = 0; k < typeSizes[relType[i].first]; ++k)
				{
					ADDELEMENT(GRAPHROW(valg, relTypeCumSizes[i].first + k, m), relTypeCumSizes[j].first + k);
					ADDELEMENT(GRAPHROW(valg, relTypeCumSizes[j].first + k, m), relTypeCumSizes[i].first + k);
				}
			}
			if(relType[i].first == relType[j].second)
			{
				for(int k = 0; k < typeSizes[relType[i].first]; ++k)
				{
					ADDELEMENT(GRAPHROW(valg, relTypeCumSizes[i].first + k, m), relTypeCumSizes[j].second + k);
					ADDELEMENT(GRAPHROW(valg, relTypeCumSizes[j].second + k, m), relTypeCumSizes[i].first + k);
				}
			}
			if(relType[i].second == relType[j].first)
			{
				for(int k = 0; k < typeSizes[relType[i].second]; ++k)
				{
					ADDELEMENT(GRAPHROW(valg, relTypeCumSizes[i].second + k, m), relTypeCumSizes[j].first + k);
					ADDELEMENT(GRAPHROW(valg, relTypeCumSizes[j].first + k, m), relTypeCumSizes[i].second + k);
				}
			}
			if(relType[i].second == relType[j].second)
			{
				for(int k = 0; k < typeSizes[relType[i].second]; ++k)
				{
					ADDELEMENT(GRAPHROW(valg, relTypeCumSizes[i].second + k, m), relTypeCumSizes[j].second + k);
					ADDELEMENT(GRAPHROW(valg, relTypeCumSizes[j].second + k, m), relTypeCumSizes[i].second + k);
				}
			}
		}
	}
	for(int i = 0; i < n*m; ++i)
	{
		cang[i] = valg[i];
	}
}

/*
int Valuation::type2int(const TypeVariable& tv) const
{
	int pos = typeCount - 1;
	for(std::set<TypeVariable>::const_reverse_iterator cit = types.rbegin(); cit != types.rend(); ++cit)
	{
		if(*cit == tv) break;
		--pos;
	}
	return pos;
}

int Valuation::relv2int(const RelationVariable& rv) const
{
	int pos = relvarCount - 1;
	for(std::set<RelationVariable>::const_reverse_iterator cit = relvars.rbegin(); cit != relvars.rend(); ++cit)
	{
		if(*cit == rv) break;
		--pos;
	}
	return pos;
}
*/

Valuation::~Valuation()
{
/*
	delete[] typeSizes;
	delete[] relType1;
	delete[] relType2;
	delete[] relType1CumSizes;
	delete[] relType2CumSizes;
	delete[] colourCount;
	delete[] colours;
//	delete[] colour2atom;
*/
	delete[] valg;
	delete[] cang;
}

Valuation::Valuation(const Valuation& val) : typeCount(val.typeCount), relvarCount(val.relvarCount), avarCount(val.avarCount), typeSizes(val.typeSizes), relType(val.relType), relTypeCumSizes(val.relTypeCumSizes), avarType(val.avarType), avarVal(val.avarVal), colourCount(val.colourCount), colours(val.colours), greatestNonemptyRelvar(val.greatestNonemptyRelvar), greatestNonemptyRow(val.greatestNonemptyRow), greatestNonemptyCol(val.greatestNonemptyCol), valg(0), cang(0), n(val.n), m(val.m)
{
/*
	typeSizes = new int[typeCount];
	colourCount = new int[typeCount];
	colours = new std::vector<int>[typeCount];
	for(int i = 0; i != typeCount; ++i)
	{
		typeSizes[i] = val.typeSizes[i];
		colourCount[i] = val.colourCount[i];
		colours[i].assign(val.colours[i].begin(), val.colours[i].end());
	}
	relType1 = new int[relvarCount];
	relType2 = new int[relvarCount];
	relType1CumSizes = new int[relvarCount + 1];
	relType2CumSizes = new int[relvarCount + 1];
	for(int i = 0; i < relvarCount; ++i)
	{
		relType1[i] = val.relType1[i];
		relType2[i] = val.relType2[i];
		relType1CumSizes[i] = val.relType1CumSizes[i];
		relType2CumSizes[i] = val.relType2CumSizes[i];
	}
	relType1CumSizes[relvarCount] = val.relType1CumSizes[relvarCount];
	relType2CumSizes[relvarCount] = val.relType2CumSizes[relvarCount];
/*
	colour2atom = new std::map<std::set<AtomVariable>, std::set<int> >[typeCount];
	for(int i = 0; i != typeCount; ++i)
	{
		for(std::map<std::set<AtomVariable>, std::set<int> >::const_reverse_iterator cit = val.colour2atom[i].rbegin(); cit != val.colour2atom[i].rend(); ++cit)
		{
			(colour2atom[i])[cit->first] = cit->second;
		}
	}
*/
	valg = new graph[n*m];
	cang = new graph[n*m];
	for(int i = 0; i < n*m; ++i)
	{
		valg[i] = val.valg[i];
		cang[i] = val.cang[i];
	}
}

Valuation::Valuation(const Valuation& val, int type1, int type2) : typeCount(val.typeCount), relvarCount(val.relvarCount + 1), avarCount(val.avarCount), typeSizes(val.typeSizes), relType(val.relType), relTypeCumSizes(val.relTypeCumSizes), avarType(val.avarType), avarVal(val.avarVal), colourCount(val.colourCount), colours(val.colours), greatestNonemptyRelvar(val.greatestNonemptyRelvar), greatestNonemptyRow(val.greatestNonemptyRow), greatestNonemptyCol(val.greatestNonemptyCol), valg(0), cang(0), n(0), m(0)
{
	if(type1 < 0 || type1 >= typeCount || type2 < 0 || type2 >= typeCount)
	{
			std::cout << "The domain types of the relation variable must be listed as types variable!" << std::endl;
			exit(1);
	}
	relType.push_back(std::pair<int, int>(type1, type2));
	int cumSize1 = relTypeCumSizes[relvarCount-1].second + typeSizes[type1];
	int cumSize2 = cumSize1;
	if(type1 != type2) cumSize2 += typeSizes[type2];
	relTypeCumSizes.push_back(std::pair<int, int>(cumSize1, cumSize2));
	n = cumSize2;
	m = ((n - 1) / WORDSIZE) + 1;
	valg = new graph[n*m];
	cang = new graph[n*m];
	for(int i = 0; i < n; ++i)
	{
		EMPTYSET(GRAPHROW(valg, i, m), m);
	}
	for(int i = 0; i < val.n; ++i)
	{
		for(int j = 0; j < val.m; ++j)
		{
			valg[m*i+j] = val.valg[(val.m)*i+j];
		}
	}
	initialiseGraphs();
}

Valuation&::Valuation::operator=(const Valuation& val)
{
	Valuation tempval(val);
	std::swap(typeCount, tempval.typeCount);
	std::swap(relvarCount, tempval.relvarCount);
	std::swap(avarCount, tempval.avarCount);
	std::swap(typeSizes, tempval.typeSizes);
	std::swap(relType, tempval.relType);
	std::swap(relTypeCumSizes, tempval.relTypeCumSizes);
	std::swap(avarType, tempval.avarType);
	std::swap(avarVal, tempval.avarVal);
	std::swap(colourCount, tempval.colourCount);
	std::swap(colours, tempval.colours);
	std::swap(greatestNonemptyRelvar, tempval.greatestNonemptyRelvar);
	std::swap(greatestNonemptyRow, tempval.greatestNonemptyRow);
	std::swap(greatestNonemptyCol, tempval.greatestNonemptyCol);
//	std::swap(colour2atom, tempval.colour2atom);
	std::swap(valg, tempval.valg);
	std::swap(cang, tempval.cang);
	std::swap(n, tempval.n);
	std::swap(m, tempval.m);
	return *this;
}

/*
std::set<TypeVariable> Valuation::getTypeVariables() const
{
	std::set<TypeVariable> types;
	for(std::map<TypeVariable, int>::const_reverse_iterator crit = type2int.rbegin(); crit != type2int.rend(); ++crit)
	{
		types.insert(crit->first);
	}
	return types;
}

std::set<RelationVariable> Valuation::getRelationVariables() const
{
	std::set<RelationVariable> relvars;
	for(std::map<RelationVariable, int>::const_reverse_iterator crit = relv2int.rbegin(); crit != relv2int.rend(); ++crit)
	{
		relvars.insert(crit->first);
	}
	return relvars;
}

std::set<AtomVariable> Valuation::getAtomVariables() const
{
	std::set<AtomVariable> atomvars;
	for(std::map<AtomVariable, int>::const_reverse_iterator crit = atomv2int.rbegin(); crit != atomv2int.rend(); ++crit)
	{
		atomvars.insert(crit->first);
	}
	return atomvars;
}
*/

AtomSet* Valuation::getValue(const TypeVariable& tv) const
{
	assert(tv.second == TYPEVAR);
	
	AtomSet* atoms = new AtomSet();
	if(tv.id >= 0 && tv.id < typeCount)
	{
		for(int i = typeSizes[tv.id]-1; i >= 0; i--)
		{
			atoms->insert(Atom(i,tv));
		}
	}
	return atoms;
}

AtomSet* Valuation::getValue(const std::set<TypeVariable>& types) const
{
	AtomSet* atoms = new AtomSet();

	for(std::set<TypeVariable>::const_iterator ctit = types.begin(); ctit != types.end(); ctit++)
	{
		if(ctit->second == TYPEVAR)
		{
			if(ctit->id >= 0 && ctit->id < typeCount)
			{
				for(int i = typeSizes[ctit->id]-1; i >= 0; i--)
				{
					atoms->insert(Atom(i,*ctit));
				}
			}		
		}
	}
	return atoms;
}

Atom Valuation::getValue(const AtomVariable& av) const
{
	assert(av.id >= 0 && av.id < avarCount);
	return Atom(avarVal[av.id],av.second);
}

bool Valuation::isMember(int rv, int av1, int av2) const
{
	if(rv >= 0 && rv < relvarCount && av1 >= 0 && av1 < avarCount && av2 >= 0 && av2 < avarCount)
	{
		return ISELEMENT(GRAPHROW(valg, relTypeCumSizes[rv].first + avarVal[av1], m), relTypeCumSizes[rv].second + avarVal[av2]);
	}
	else
	{
		return false;
	}
}

bool Valuation::areEqual(int av1, int av2) const
{
	if(av1 >= 0 && av1 < avarCount && av2 >= 0 && av2 < avarCount)
	{
		return avarType[av1] == avarType[av2] && avarVal[av1] == avarVal[av2];
	}
	else
	{
		return false;
	}
}

AtomTupleSet* Valuation::getValue(const RelationVariable& rv) const
{
	AtomTupleSet* ats = new AtomTupleSet();
	if(rv.id >= 0 && rv.id < relvarCount && rv.second.id >= 0 && rv.second.id < typeCount && rv.third.id >= 0 && rv.third.id < typeCount)
	{
//		std::ostringstream oss1, oss2;
		for(int i = 0; i < typeSizes[relType[rv.id].first]; ++i)
		{
			for(int j = 0; j < typeSizes[relType[rv.id].second]; ++j)
			{
				if(ISELEMENT(GRAPHROW(valg, relTypeCumSizes[rv.id].first + i, m), relTypeCumSizes[rv.id].second + j))
				{
					AtomTuple at;
					at.push_back(Atom(i,rv.second));
					at.push_back(Atom(j,rv.third));
					ats->insert(at);
/*
					oss1.str("");
					oss1 << rv.domain.first << '_' << (i + 1);
					oss2.str("");
					oss2 << rv.domain.second << '_' << (j + 1);
					relation.insert(AtomPair(TypeVariable(oss1.str()), TypeVariable(oss2.str())));
*/
				}
			}
		}
	}
	return ats;
}

std::list<Valuation*> Valuation::children() const
{
	std::list<Valuation*> vals;
	if(greatestNonemptyRelvar >= 0)
	{
		for(int k = greatestNonemptyCol + 1; k < typeSizes[relType[greatestNonemptyRelvar].second]; ++k)
		{
			Valuation* val = new Valuation(*this);
			ADDELEMENT(GRAPHROW(val->valg, relTypeCumSizes[greatestNonemptyRelvar].first + greatestNonemptyRow, m), relTypeCumSizes[greatestNonemptyRelvar].second + k);
			val->greatestNonemptyCol = k;
			for(int i = 0; i < n*m; ++i) val->cang[i] = val->valg[i];
			vals.push_back(val);				
		}
		for(int j = greatestNonemptyRow + 1; j < typeSizes[relType[greatestNonemptyRelvar].first]; ++j)
		{
			for(int k = 0; k < typeSizes[relType[greatestNonemptyRelvar].second]; ++k)
			{
				Valuation* val = new Valuation(*this);
				ADDELEMENT(GRAPHROW(val->valg, relTypeCumSizes[greatestNonemptyRelvar].first + j, m), relTypeCumSizes[greatestNonemptyRelvar].second + k);
				val->greatestNonemptyRow = j;
				val->greatestNonemptyCol = k;
				for(int i = 0; i < n*m; ++i) val->cang[i] = val->valg[i];
				vals.push_back(val);				
			}
		}
	}
	for(int i = greatestNonemptyRelvar + 1; i < relvarCount; ++i)
	{
		for(int j = 0; j < typeSizes[relType[i].first]; ++j)
		{
			for(int k = 0; k < typeSizes[relType[i].second]; ++k)
			{
				Valuation* val = new Valuation(*this);
				ADDELEMENT(GRAPHROW(val->valg, relTypeCumSizes[i].first + j, m), relTypeCumSizes[i].second + k);
				val->greatestNonemptyRelvar = i;
				val->greatestNonemptyRow = j;
				val->greatestNonemptyCol = k;
				for(int i = 0; i < n*m; ++i) val->cang[i] = val->valg[i];
				vals.push_back(val);				
			}
		}
	}
	return vals;
}

std::list<Valuation*> Valuation::addAtomVariable(const TypeVariable& type) const
{
	assert(type.second == FINTYPE || (type.id >= 0 && type.id < typeCount));
	
	std::list<Valuation*> vals;

/*	if(type < 0 || type >= typeCount)
	{
			std::cout << "The type of the atom variable must be listed as a type variable!" << std::endl;
			exit(1);
	}
*/
	
	if(type.second == TYPEVAR)
	{
		for(int a = 0; a < typeSizes[type.id]; a++)
		{
			Valuation* val = new Valuation(*this);
			val->avarCount++;
			val->avarType.push_back(type.id);
			val->avarVal.push_back(a);
			if(val->colours[type.id][a] == 1)
			{
				val->colours[type.id][a] = val->colourCount[type.id] + 1;
				if(val->colourCount[type.id] < val->typeSizes[type.id]) val->colourCount[type.id]++;
			}
			vals.push_back(val);
		}
	}
	else
	{
		for(int a = 0; a < type.id; a++)
		{
			Valuation* val = new Valuation(*this);
			val->avarCount++;
			val->avarType.push_back(-1);
			val->avarVal.push_back(a);
			vals.push_back(val);
		}
	}
	
	return vals;
}

std::list<Valuation*> Valuation::addTypeVariable(int cutoff) const
{
	std::list<Valuation*> vals;
	for(int size = 1; size <= cutoff; size++)
	{
		Valuation* val = new Valuation(*this);
		val->typeCount++;
		val->typeSizes.push_back(size);
		val->colourCount.push_back(1);
		val->colours.push_back(std::vector<int>(size,1));
		vals.push_back(val);
	}
	return vals;
}

/*
Valuation* Valuation::addTypeVariable(int size) const
{
	Valuation* val = new Valuation(*this);
	val->typeCount++;
	val->typeSizes.push_back(size);
	val->colourCount.push_back(1);
	val->colours.push_back(std::vector<int>(size,1));
	return val;
}
*/

Valuation* Valuation::addRelationVariable(const TypeVariable& type1, const TypeVariable& type2) const
{
	assert(type1.id >= 0 && type1.id < typeCount && type2.id >= 0 && type2.id < typeCount);
	
	Valuation* val = new Valuation(*this, type1.id, type2.id);
	val->greatestNonemptyRelvar = val->relvarCount - 1;
	val->greatestNonemptyCol = val->typeSizes[type2.id];
	val->greatestNonemptyRow = -1;
	return val;
}

bool Valuation::operator<(const Valuation& val) const
{
	if(typeCount < val.typeCount) return true;
	if(val.typeCount < typeCount) return false;

	if(avarCount < val.avarCount) return true;
	if(val.avarCount < avarCount) return false;

	if(relvarCount < val.relvarCount) return true;
	if(val.relvarCount < relvarCount) return false;

	for(int i = 0; i != typeCount; ++i)
	{
		if(typeSizes[i] < val.typeSizes[i]) return true;
		if(val.typeSizes[i] < typeSizes[i]) return false;
	}
	
	for(int i = 0; i != avarCount; i++)
	{
		if(avarType[i] < val.avarType[i]) return true;
		if(avarType[i] > val.avarType[i]) return false;
	}
	
	for(int i = 0; i != avarCount; ++i)
	{
		if(avarType[i] != -1)
		{
			if(colours[avarType[i]][avarVal[i]] < val.colours[val.avarType[i]][val.avarVal[i]]) return true;
			if(colours[avarType[i]][avarVal[i]] > val.colours[val.avarType[i]][val.avarVal[i]]) return false;
		}
	}
	
	for(int i = 0; i != relvarCount; i++)
	{
		if(relType[i] < val.relType[i]) return true;
		if(relType[i] > val.relType[i]) return false;
	}
	
	for(int i = 0; i < n*m; ++i)
	{
		if(cang[i] < val.cang[i]) return true;
		if(cang[i] > val.cang[i]) return false;
	}

	return false;
}

bool Valuation::operator==(const Valuation& val) const
{
	if(typeCount != val.typeCount) return false;

	if(avarCount != val.avarCount) return false;

	if(val.relvarCount != relvarCount) return false;

	for(int i = 0; i != typeCount; ++i)
	{
		if(val.typeSizes[i] != typeSizes[i]) return false;
	}
	

	for(int i = 0; i != avarCount; i++)
	{
		if(avarType[i] != val.avarType[i]) return false;
	}
	
	for(int i = 0; i != avarCount; ++i)
	{
		// if the type of the variable is not bounded
		if(avarType[i] != -1)
		{
			if(colours[avarType[i]][avarVal[i]] != val.colours[val.avarType[i]][val.avarVal[i]]) return false;
		}
	}

	for(int i = 0; i != relvarCount; i++)
	{
		if(relType[i] != val.relType[i]) return false;
	}
	
	for(int i = 0; i < n*m; ++i)
	{
		if(valg[i] != val.valg[i]) return false;
	}

	return true;
}

bool Valuation::almostEquals(const Valuation& val) const
{
	if(typeCount != val.typeCount) return false;

	if(val.relvarCount != relvarCount) return false;

	for(int i = 0; i != typeCount; ++i)
	{
		if(val.typeSizes[i] != typeSizes[i]) return false;
	}
	
	for(int i = 0; i != avarCount; i++)
	{
		if(avarType[i] != val.avarType[i]) return false;
	}
	
	for(int i = 0; i != avarCount; ++i)
	{
		// if the type of the variable is not bounded
		if(avarType[i] != -1)
		{
			if(std::find(val.colours[val.avarType[i]].begin(), val.colours[val.avarType[i]].end(), colours[avarType[i]][avarVal[i]]) == val.colours[val.avarType[i]].end()) return false;
			if(std::find(colours[avarType[i]].begin(), colours[avarType[i]].end(), val.colours[val.avarType[i]][val.avarVal[i]]) == colours[avarType[i]].end()) return false;
		}
	}

	for(int i = 0; i != relvarCount; i++)
	{
		if(relType[i] != val.relType[i]) return false;
	}
	
	for(int i = 0; i < n*m; ++i)
	{
		if(valg[i] != val.valg[i]) return false;
	}

	return true;
}

void Valuation::computeCanonicalGraph()
{	
	int* lab = new int[n];
	int* ptn = new int[n];
	int* orb = new int[n];
	set* ws = new set[100*m];
	statsblk stats;
	static DEFAULTOPTIONS_DIGRAPH(opt);
	opt.getcanon = TRUE;
	//opt.digraph = TRUE;
	opt.defaultptn = FALSE;

	//std::cout << "About to compute a canonical graph" << std::endl;
	
	int atom = 0;
	for(int i = 0; i < relvarCount; ++i)
	{
		int atom = colourCount[relType[i].first] - 1;
		for(int j = 0; j < typeSizes[relType[i].first]; ++j)
		{
			if(colours[relType[i].first][j] > 1)
			{
				lab[relTypeCumSizes[i].first + colours[relType[i].first][j] - 2] = relTypeCumSizes[i].first + j;
				ptn[relTypeCumSizes[i].first + colours[relType[i].first][j] - 2] = 0;
			}
			else
			{
				lab[relTypeCumSizes[i].first + atom] = relTypeCumSizes[i].first + j;
				ptn[relTypeCumSizes[i].first + atom] = 1;
				atom++;
			}
		}
		ptn[relTypeCumSizes[i].first + typeSizes[relType[i].first] - 1] = 0;
		if(relType[i].first != relType[i].second)
		{
			atom = colourCount[relType[i].second] - 1;
			for(int j = 0; j < typeSizes[relType[i].second]; ++j)
			{
				if(colours[relType[i].second][j] > 1)
				{
					lab[relTypeCumSizes[i].second + colours[relType[i].second][j] - 2] = relTypeCumSizes[i].second + j;
					ptn[relTypeCumSizes[i].second + colours[relType[i].second][j] - 2] = 0;
				}
				else
				{
					lab[relTypeCumSizes[i].second + atom] = relTypeCumSizes[i].second + j;
					ptn[relTypeCumSizes[i].second + atom] = 1;
					atom++;
				}
			}
			ptn[relTypeCumSizes[i].second + typeSizes[relType[i].second] - 1] = 0;
		}
/*
		for(std::map<std::set<AtomVariable>, std::set<int> >::const_iterator cit = colour2atom[relType1[i]].begin(); cit !=  colour2atom[relType1[i]].end(); ++cit)
		{
			for(std::set<int>::const_iterator cit2 = cit->second.begin(); cit2 != cit->second.end(); ++cit2)
			{
				lab[atom] = relType1CumSizes[i] + *cit2;
				ptn[atom] = 1;
				++atom;
			}
			ptn[atom-1] = 0;
		}
		if(relType1[i] != relType2[i])
		{
			for(std::map<std::set<AtomVariable>, std::set<int> >::const_iterator cit = colour2atom[relType2[i]].begin(); cit !=  colour2atom[relType2[i]].end(); ++cit)
			{
				for(std::set<int>::const_iterator cit2 = cit->second.begin(); cit2 != cit->second.end(); ++cit2)
				{
					lab[atom] = relType2CumSizes[i] + *cit2;
					ptn[atom] = 1;
					++atom;
				}
				ptn[atom-1] = 0;
			}
		}
*/
	}
/*
	for(int i = 0; i < n; ++i)
	{
		lab[i] = i;
		ptn[i] = 1;
	}
	for(int i = 1; i <= relvarCount; ++i)
	{
		ptn[relType1CumSizes[i] - 1] = 0;
		ptn[relType2CumSizes[i] - 1] = 0;
	}
*/
	//std::cout << "valg: " << valg << " lab: " << lab << " ptn: " << ptn << " orb: " << orb << " ws: " << ws << " m: " << m << " n: " << n << " cang: " << cang << std::endl;
	//std::cout << "lab[0]: " << lab[0] << " ptn[0]: " << ptn[0] << std::endl;
	
//	std::cout << "Computing a anonical graph." << std::endl;

	nauty_check(WORDSIZE, m, n,NAUTYVERSIONID);
	nauty(valg, lab, ptn, NULL, orb, &opt, &stats, ws, 100*m, m, n, cang);
//	Nauty::getInstance().canonicalGraph(valg, m, n, lab, ptn, cang);

	//std::cout << "Canonical graph computed." << std::endl;

	delete[] lab;
	delete[] ptn;
	delete[] orb;
	delete[] ws;
}

int Valuation::getTypeVariableCount() const
{
	return typeCount;
}

int Valuation::getRelationVariableCount() const
{
	return relvarCount;
}

int Valuation::getAtomVariableCount() const
{
	return avarCount;
}


/*
int Nauty::maxn = 16;
Nauty Nauty::instance = Nauty();

Nauty::Nauty()
{
	maxm = ((maxn - 1) / WORDSIZE) + 1;
	nauty_check(WORDSIZE,maxm,maxn,NAUTYVERSIONID);
	g = new graph[maxn*maxm];
	cg = new graph[maxn*maxm];
	g2 = new graph[maxn*maxm];
	cg2 = new graph[maxn*maxm];
	lab = new int[maxn];
	ptn = new int[maxn];
	orb = new int[maxn];
	ws = new set[100*maxm];
}

Nauty::~Nauty()
{
	delete[] g;
	delete[] cg;
	delete[] lab;
	delete[] ptn;
	delete[] orb;
	delete[] ws;
	nauty_freedyn();
}

Nauty& Nauty::getInstance()
{
	return instance;
}

void Nauty::canonicalGraph(const graph* valg, int m, int n, const int* l, const int* p, graph* cang)
{
	DEFAULTOPTIONS_GRAPH(opt);
	opt.getcanon = TRUE;
	opt.digraph = TRUE;
	opt.defaultptn = FALSE;
	statsblk stats;

	if(m > maxm || n > maxn)
	{
		std::cout << "Valuation too large!" << std::endl;
		exit(1);
	}
	for(int i = 0; i < n*m; ++i)
	{
		g[i] = valg[i];
	}
	for(int i = 0; i < n; ++i)
	{
		ptn[i] = p[i];
		lab[i] = l[i];
	}
	
	nauty (g, lab, ptn, NULL, orb, &opt, &stats, ws, 100*maxm, m, n, cg);

	for(int i = 0; i < n*m; ++i)
	{
		cang[i] = cg[i];
	}
}
*/

/*
std::string Valuation::toString(const std::set<TypeVariable>& typevars, const std::set<RelationVariable>& relvars, const std::set<AtomVariable>& atomvars) const
{
	std::string str;
	int i = 0;
	for(std::set<TypeVariable>::const_iterator cit = typevars.begin(); cit != typevars.end(); ++cit)
	{
		str.append(*cit);
		str.push_back('-');
		str.push_back('>');
		str.append(setToString<Atom>(getValue(i)));
		str.push_back('\n');
	}
	i = 0;
	for(std::set<RelationVariable>::const_iterator cit = relvars.begin(); cit != relvars.end(); ++cit)
	{
		str.append(*cit);
		str.push_back('-');
		str.push_back('>');
		str.append(setToString<AtomPair>(getValue(i)));
		str.push_back('\n');
	}
	i = 0;
	for(std::set<AtomVariable>::const_iterator cit = atomvars.begin(); cit != atomvars.end(); ++cit)
	{
		str.append(*cit);
		str.push_back('-');
		str.push_back('>');
		str.append(getValue(i));
		str.push_back('\n');
	}
	return str;
}
*/
