#ifndef REDUCE_H
#define REDUCE_H

#include <set>
#include <list>
#include "template.h"
#include "element.h"
#include "valuation.h"
#include "valuationformula.h"
#include "ltsschema.h"
#include "context.h"

#define CUTOFFMAX 255
#define MAX_SYS_COMP_SIZE 2500000
#define MAX_SPEC_COMP_SIZE 200000

enum VerType {NOVERIFY, TRACEREF, COMPAT, ALTSIM};

quartet<std::map<TypeVariable,int>*, std::map<TypeVariable,bool>*, bool, bool> determineCutoffs(const Context&, ValuationFormula*&, LTSSchema*&, LTSSchema*&, VerType);
quartet<std::set<Valuation*,PointerCompare<Valuation> >*, int, int, int> computeValuations(const Context&, ValuationFormula*&, LTSSchema*&, LTSSchema*&, const std::map<TypeVariable,int>&);
void updateStoredCount(int&, int, int&);
void printProgress(double&, double, int&, int&, int&);
std::set<Valuation*,PointerCompare<Valuation> >* computeValuations(std::set<TypeVariable, VariableCompare<TypeVariable> >, std::set<RelationVariable, VariableCompare<RelationVariable> >, std::set<AtomVariable, VariableCompare<AtomVariable> >, const std::map<TypeVariable,int>&, ValuationFormula*, ValuationFormula*, std::list<ValuationFormula*>&, std::list<ValuationFormula*>&, double&, double, int&, int&, int&, int&, std::set<Valuation*,PointerCompare<Valuation> >*, bool);
int search(Valuation*, std::list<Valuation*>*, const ValuationFormula*);
std::list<ValuationFormula*> cloneConjuncts(const std::list<ValuationFormula*>&);
void deleteConjuncts(std::list<ValuationFormula*>&);

#endif