#ifndef FDR2OUTPUT4COMP_H
#define FDR2OUTPUT4COMP_H

#include <string>
#include <iostream>
#include "template.h"
#include "element.h"
#include "valuation.h"
#include "ltsschema.h"
#include "context.h"

class CompatibilityOutput
{
private:
	static bool generateInstance(const Context&, const InstanceOfLTSSchema*, int, const std::string&, bool, bool);
	static void printString(const std::string&);
	static std::ostream& toFDRFormattedStream(const Context&, std::ostream&, const InstanceOfLTSSchema*, const std::string&, bool = false, int = 1);
	static std::ostream& toFDRFormattedStream(const Context&, std::ostream&, const UnitLTS&, const std::string&, bool, int);
	static std::ostream& toFDRFormattedStream(const Context&, std::ostream&, const ElementaryInstanceOfLTSSchema&, const std::string&, bool, int);
	static std::ostream& toFDRFormattedStream(const Context&, std::ostream&, const ParallelInstanceOfLTSSchema&, const std::string&, bool, int);
//	static std::ostream& toFDRFormattedStream(const Context&, std::ostream&, const NamedInstanceOfLTSSchema&, const std::string&, bool, int);
	static std::ostream& toFDRFormattedStream(const Context&, std::ostream&, const ActionSet&);
public:
	static int generateInstances(const Context&, const LTSSchema*, const ValuationFormula*, const std::set<Valuation*,PointerCompare<Valuation> >*, const std::string&, const std::map<TypeVariable,bool>&, bool, bool);
};

#endif 
