/** \file
 *  This C source file was generated by $ANTLR version !Unknown version!
 *
 *     -  From the grammar source file : cps/CPS.g
 *     -                            On : 2013-10-12 23:13:39
 *     -                for the parser : CPSParserParser *
 * Editing it, at least manually, is not wise. 
 *
 * C language generator and runtime by Jim Idle, jimi|hereisanat|idle|dotgoeshere|ws.
 *
 *
*/
// [The "BSD licence"]
// Copyright (c) 2005-2009 Jim Idle, Temporal Wave LLC
// http://www.temporal-wave.com
// http://www.linkedin.com/in/jimidle
//
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. The name of the author may not be used to endorse or promote products
//    derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


/* =============================================================================
 * This is what the grammar programmer asked us to put at the top of every file.
 */

#include <string>
#include <iostream>
#include <set>
#include <limits>
#include <iomanip>
#include <sstream>
#include "element.h"
#include "elementschema.h"
#include "valuationformula.h"
#include "CPSLexer.h"
#include "context.h"
#include "timer.h"
#include "reduce.h"
#include "fdr2output4trref.h"
#include "fdr2output4altsim.h"
#include "fdr2output4comp.h"

/* End of Header action.
 * =============================================================================
 */
/* -----------------------------------------
 * Include the ANTLR3 generated header file.
 */
#include    "CPSParser.h"
/* ----------------------------------------- */





/* MACROS that hide the C interface implementations from the
 * generated code, which makes it a little more understandable to the human eye.
 * I am very much against using C pre-processor macros for function calls and bits
 * of code as you cannot see what is happening when single stepping in debuggers
 * and so on. The exception (in my book at least) is for generated code, where you are
 * not maintaining it, but may wish to read and understand it. If you single step it, you know that input()
 * hides some indirect calls, but is always referring to the input stream. This is
 * probably more readable than ctx->input->istream->input(snarfle0->blarg) and allows me to rejig
 * the runtime interfaces without changing the generated code too often, without
 * confusing the reader of the generated output, who may not wish to know the gory
 * details of the interface inheritance.
 */
 
#define		CTX	ctx

/* Aids in accessing scopes for grammar programmers
 */
#undef	SCOPE_TYPE
#undef	SCOPE_STACK
#undef	SCOPE_TOP
#define	SCOPE_TYPE(scope)   pCPSParser_##scope##_SCOPE
#define SCOPE_STACK(scope)  pCPSParser_##scope##Stack
#define	SCOPE_TOP(scope)    ctx->pCPSParser_##scope##Top
#define	SCOPE_SIZE(scope)		ctx->pCPSParser_##scope##Stack_limit
#define SCOPE_INSTANCE(scope, i)	(ctx->SCOPE_STACK(scope)->get(ctx->SCOPE_STACK(scope),i))

/* Macros for accessing things in the parser
 */
 
#undef	    PARSER		    
#undef	    RECOGNIZER		    
#undef	    HAVEPARSEDRULE
#undef		MEMOIZE
#undef	    INPUT
#undef	    STRSTREAM
#undef	    HASEXCEPTION
#undef	    EXCEPTION
#undef	    MATCHT
#undef	    MATCHANYT
#undef	    FOLLOWSTACK
#undef	    FOLLOWPUSH
#undef	    FOLLOWPOP
#undef	    PRECOVER
#undef	    PREPORTERROR
#undef	    LA
#undef	    LT
#undef	    CONSTRUCTEX
#undef	    CONSUME
#undef	    MARK
#undef	    REWIND
#undef	    REWINDLAST
#undef	    PERRORRECOVERY
#undef	    HASFAILED
#undef	    FAILEDFLAG
#undef	    RECOVERFROMMISMATCHEDSET
#undef	    RECOVERFROMMISMATCHEDELEMENT
#undef		INDEX
#undef      ADAPTOR
#undef		SEEK
#undef	    RULEMEMO		    
#undef		DBG

#define	    PARSER							ctx->pParser  
#define	    RECOGNIZER						PARSER->rec
#define		PSRSTATE						RECOGNIZER->state
#define	    HAVEPARSEDRULE(r)				RECOGNIZER->alreadyParsedRule(RECOGNIZER, r)
#define		MEMOIZE(ri,si)					RECOGNIZER->memoize(RECOGNIZER, ri, si)
#define	    INPUT							PARSER->tstream
#define	    STRSTREAM						INPUT
#define		ISTREAM							INPUT->istream
#define		INDEX()							ISTREAM->index(INPUT->istream)
#define	    HASEXCEPTION()					(PSRSTATE->error == ANTLR3_TRUE)
#define	    EXCEPTION						PSRSTATE->exception
#define	    MATCHT(t, fs)					RECOGNIZER->match(RECOGNIZER, t, fs)
#define	    MATCHANYT()						RECOGNIZER->matchAny(RECOGNIZER)
#define	    FOLLOWSTACK					    PSRSTATE->following
#define	    FOLLOWPUSH(x)					FOLLOWSTACK->push(FOLLOWSTACK, ((void *)(&(x))), NULL)
#define	    FOLLOWPOP()						FOLLOWSTACK->pop(FOLLOWSTACK)
#define	    PRECOVER()						RECOGNIZER->recover(RECOGNIZER)
#define	    PREPORTERROR()					RECOGNIZER->reportError(RECOGNIZER)
#define	    LA(n)							INPUT->istream->_LA(ISTREAM, n)
#define	    LT(n)							INPUT->_LT(INPUT, n)
#define	    CONSTRUCTEX()					RECOGNIZER->exConstruct(RECOGNIZER)
#define	    CONSUME()						ISTREAM->consume(ISTREAM)
#define	    MARK()							ISTREAM->mark(ISTREAM)
#define	    REWIND(m)						ISTREAM->rewind(ISTREAM, m)
#define	    REWINDLAST()					ISTREAM->rewindLast(ISTREAM)
#define		SEEK(n)							ISTREAM->seek(ISTREAM, n)
#define	    PERRORRECOVERY					PSRSTATE->errorRecovery
#define	    FAILEDFLAG						PSRSTATE->failed
#define	    HASFAILED()						(FAILEDFLAG == ANTLR3_TRUE)
#define	    BACKTRACKING					PSRSTATE->backtracking
#define	    RECOVERFROMMISMATCHEDSET(s)		RECOGNIZER->recoverFromMismatchedSet(RECOGNIZER, s)
#define	    RECOVERFROMMISMATCHEDELEMENT(e)	RECOGNIZER->recoverFromMismatchedElement(RECOGNIZER, s)
#define     ADAPTOR                         ctx->adaptor
#define		RULEMEMO						PSRSTATE->ruleMemo
#define		DBG								RECOGNIZER->debugger

#define		TOKTEXT(tok, txt)				tok, (pANTLR3_UINT8)txt

/* The 4 tokens defined below may well clash with your own #defines or token types. If so
 * then for the present you must use different names for your defines as these are hard coded
 * in the code generator. It would be better not to use such names internally, and maybe
 * we can change this in a forthcoming release. I deliberately do not #undef these
 * here as this will at least give you a redefined error somewhere if they clash.
 */
#define	    UP	    ANTLR3_TOKEN_UP
#define	    DOWN    ANTLR3_TOKEN_DOWN
#define	    EOR	    ANTLR3_TOKEN_EOR
#define	    INVALID ANTLR3_TOKEN_INVALID


/* =============================================================================
 * Functions to create and destroy scopes. First come the rule scopes, followed
 * by the global declared scopes.
 */



/* ============================================================================= */

/* =============================================================================
 * Start of recognizer
 */



/** \brief Table of all token names in symbolic order, mainly used for
 *         error reporting.
 */
pANTLR3_UINT8   CPSParserTokenNames[57+4]
     = {
        (pANTLR3_UINT8) "<invalid>",       /* String to print to indicate an invalid token */
        (pANTLR3_UINT8) "<EOR>",
        (pANTLR3_UINT8) "<DOWN>", 
        (pANTLR3_UINT8) "<UP>", 
        (pANTLR3_UINT8) "TRUEVF",
        (pANTLR3_UINT8) "FALSEVF",
        (pANTLR3_UINT8) "ATOMVAR",
        (pANTLR3_UINT8) "VAR",
        (pANTLR3_UINT8) "RELVAR",
        (pANTLR3_UINT8) "RELSYM",
        (pANTLR3_UINT8) "TYPEVAR",
        (pANTLR3_UINT8) "VALF",
        (pANTLR3_UINT8) "VALC",
        (pANTLR3_UINT8) "SSC",
        (pANTLR3_UINT8) "PSET",
        (pANTLR3_UINT8) "LTSC",
        (pANTLR3_UINT8) "PLTS",
        (pANTLR3_UINT8) "VERIFY",
        (pANTLR3_UINT8) "AGAINST",
        (pANTLR3_UINT8) "WHEN",
        (pANTLR3_UINT8) "IMPL",
        (pANTLR3_UINT8) "EQ",
        (pANTLR3_UINT8) "NEG",
        (pANTLR3_UINT8) "AND",
        (pANTLR3_UINT8) "OR",
        (pANTLR3_UINT8) "FORALL",
        (pANTLR3_UINT8) "LTS",
        (pANTLR3_UINT8) "FROM",
        (pANTLR3_UINT8) "PAR",
        (pANTLR3_UINT8) "CUP",
        (pANTLR3_UINT8) "PLUS",
        (pANTLR3_UINT8) "MINUS",
        (pANTLR3_UINT8) "HIDE",
        (pANTLR3_UINT8) "CHOICE",
        (pANTLR3_UINT8) "SET",
        (pANTLR3_UINT8) "RELFUNC",
        (pANTLR3_UINT8) "ISIN",
        (pANTLR3_UINT8) "IN",
        (pANTLR3_UINT8) "CHANNEL",
        (pANTLR3_UINT8) "TAU",
        (pANTLR3_UINT8) "ERREVENT",
        (pANTLR3_UINT8) "ERRSTATE",
        (pANTLR3_UINT8) "POSINT",
        (pANTLR3_UINT8) "SMALLID",
        (pANTLR3_UINT8) "CAPITID",
        (pANTLR3_UINT8) "CAPITNUMID",
        (pANTLR3_UINT8) "COMMENT",
        (pANTLR3_UINT8) "WS",
        (pANTLR3_UINT8) "'['",
        (pANTLR3_UINT8) "']'",
        (pANTLR3_UINT8) "'='",
        (pANTLR3_UINT8) "'{'",
        (pANTLR3_UINT8) "','",
        (pANTLR3_UINT8) "'}'",
        (pANTLR3_UINT8) "':'",
        (pANTLR3_UINT8) "'trace refinement:'",
        (pANTLR3_UINT8) "'alternating simulation:'",
        (pANTLR3_UINT8) "'compatibility:'",
        (pANTLR3_UINT8) "'('",
        (pANTLR3_UINT8) "')'",
        (pANTLR3_UINT8) "'?'"
       };

        

// Forward declare the locally static matching functions we have generated.
//
static CPSParser_cps_return	cps    (pCPSParser ctx);
static CPSParser_ltsschema_return	ltsschema    (pCPSParser ctx);
static CPSParser_parltsc_return	parltsc    (pCPSParser ctx);
static CPSParser_repparltsc_return	repparltsc    (pCPSParser ctx);
static CPSParser_condltsc_return	condltsc    (pCPSParser ctx);
static CPSParser_elemltsc_return	elemltsc    (pCPSParser ctx);
static CPSParser_transetschema_return	transetschema    (pCPSParser ctx);
static CPSParser_transchema_return	transchema    (pCPSParser ctx);
static CPSParser_choicetranschema_return	choicetranschema    (pCPSParser ctx, TransitionSchema* tsin);
static CPSParser_setschema_return	setschema    (pCPSParser ctx);
static CPSParser_repssc_return	repssc    (pCPSParser ctx);
static CPSParser_elemssc_return	elemssc    (pCPSParser ctx);
static CPSParser_condssc_return	condssc    (pCPSParser ctx);
static CPSParser_actionsetsc_return	actionsetsc    (pCPSParser ctx);
static ValuationFormula*	valf    (pCPSParser ctx);
static CPSParser_univf_return	univf    (pCPSParser ctx);
static CPSParser_equivf_return	equivf    (pCPSParser ctx);
static CPSParser_implvf_return	implvf    (pCPSParser ctx);
static CPSParser_disjvf_return	disjvf    (pCPSParser ctx);
static CPSParser_conjvf_return	conjvf    (pCPSParser ctx);
static CPSParser_negvf_return	negvf    (pCPSParser ctx);
static CPSParser_elemvf_return	elemvf    (pCPSParser ctx);
static CPSParser_boundparlist_return	boundparlist    (pCPSParser ctx);
static CPSParser_stateschema_return	stateschema    (pCPSParser ctx);
static CPSParser_fromstateschema_return	fromstateschema    (pCPSParser ctx);
static CPSParser_atomschematuple_return	atomschematuple    (pCPSParser ctx, AtomSchemaTuple* ast);
static CPSParser_actionschema_return	actionschema    (pCPSParser ctx);
static CPSParser_atomschema_return	atomschema    (pCPSParser ctx);
static CPSParser_relschema_return	relschema    (pCPSParser ctx);
static CPSParser_atomrel_return	atomrel    (pCPSParser ctx);
static CPSParser_elematomrel_return	elematomrel    (pCPSParser ctx);
static std::string*	smallstr    (pCPSParser ctx);
static std::string*	capitstr    (pCPSParser ctx);
static std::string*	string    (pCPSParser ctx);
static ANTLR3_BOOLEAN	synpred1_CPS    (pCPSParser ctx);
static ANTLR3_BOOLEAN	synpred2_CPS    (pCPSParser ctx);
static ANTLR3_BOOLEAN	synpred3_CPS    (pCPSParser ctx);
static ANTLR3_BOOLEAN	synpred7_CPS    (pCPSParser ctx);
static ANTLR3_BOOLEAN	synpred8_CPS    (pCPSParser ctx);
static void	CPSParserFree(pCPSParser ctx);
/* For use in tree output where we are accumulating rule labels via label += ruleRef
 * we need a function that knows how to free a return scope when the list is destroyed. 
 * We cannot just use ANTLR3_FREE because in debug tracking mode, this is a macro.
 */
static	void ANTLR3_CDECL freeScope(void * scope)
{
    ANTLR3_FREE(scope);
}

/** \brief Name of the grammar file that generated this code
 */
static const char fileName[] = "cps/CPS.g";

/** \brief Return the name of the grammar file that generated this code.
 */
static const char * getGrammarFileName()
{
	return fileName;
}
/** \brief Create a new CPSParser parser and return a context for it.
 *
 * \param[in] instream Pointer to an input stream interface.
 *
 * \return Pointer to new parser context upon success.
 */
ANTLR3_API pCPSParser
CPSParserNew   (pANTLR3_COMMON_TOKEN_STREAM instream)
{
	// See if we can create a new parser with the standard constructor
	//
	return CPSParserNewSSD(instream, NULL);
}

/** \brief Create a new CPSParser parser and return a context for it.
 *
 * \param[in] instream Pointer to an input stream interface.
 *
 * \return Pointer to new parser context upon success.
 */
ANTLR3_API pCPSParser
CPSParserNewSSD   (pANTLR3_COMMON_TOKEN_STREAM instream, pANTLR3_RECOGNIZER_SHARED_STATE state)
{
    pCPSParser ctx;	    /* Context structure we will build and return   */
    
    ctx	= (pCPSParser) ANTLR3_CALLOC(1, sizeof(CPSParser));
    
    if	(ctx == NULL)
    {
		// Failed to allocate memory for parser context
		//
        return  NULL;
    }
    
    /* -------------------------------------------------------------------
     * Memory for basic structure is allocated, now to fill in
     * the base ANTLR3 structures. We initialize the function pointers
     * for the standard ANTLR3 parser function set, but upon return
     * from here, the programmer may set the pointers to provide custom
     * implementations of each function. 
     *
     * We don't use the macros defined in CPSParser.h here, in order that you can get a sense
     * of what goes where.
     */

    /* Create a base parser/recognizer, using the supplied token stream
     */
    ctx->pParser	    = antlr3ParserNewStream(ANTLR3_SIZE_HINT, instream->tstream, state);
    /* Install the implementation of our CPSParser interface
     */
    ctx->cps	= cps;
    ctx->ltsschema	= ltsschema;
    ctx->parltsc	= parltsc;
    ctx->repparltsc	= repparltsc;
    ctx->condltsc	= condltsc;
    ctx->elemltsc	= elemltsc;
    ctx->transetschema	= transetschema;
    ctx->transchema	= transchema;
    ctx->choicetranschema	= choicetranschema;
    ctx->setschema	= setschema;
    ctx->repssc	= repssc;
    ctx->elemssc	= elemssc;
    ctx->condssc	= condssc;
    ctx->actionsetsc	= actionsetsc;
    ctx->valf	= valf;
    ctx->univf	= univf;
    ctx->equivf	= equivf;
    ctx->implvf	= implvf;
    ctx->disjvf	= disjvf;
    ctx->conjvf	= conjvf;
    ctx->negvf	= negvf;
    ctx->elemvf	= elemvf;
    ctx->boundparlist	= boundparlist;
    ctx->stateschema	= stateschema;
    ctx->fromstateschema	= fromstateschema;
    ctx->atomschematuple	= atomschematuple;
    ctx->actionschema	= actionschema;
    ctx->atomschema	= atomschema;
    ctx->relschema	= relschema;
    ctx->atomrel	= atomrel;
    ctx->elematomrel	= elematomrel;
    ctx->smallstr	= smallstr;
    ctx->capitstr	= capitstr;
    ctx->string	= string;
    ctx->synpred1_CPS	= synpred1_CPS;
    ctx->synpred2_CPS	= synpred2_CPS;
    ctx->synpred3_CPS	= synpred3_CPS;
    ctx->synpred7_CPS	= synpred7_CPS;
    ctx->synpred8_CPS	= synpred8_CPS;
    ctx->free			= CPSParserFree;
    ctx->getGrammarFileName	= getGrammarFileName;
    
    /* Install the scope pushing methods.
     */

        
    

	
    /* Install the token table
     */
    PSRSTATE->tokenNames   = CPSParserTokenNames;
    
    
    /* Return the newly built parser to the caller
     */
    return  ctx;
}

/** Free the parser resources
 */
 static void
 CPSParserFree(pCPSParser ctx)
 {
    /* Free any scope memory
     */
    
        
	// Free this parser
	//
    ctx->pParser->free(ctx->pParser);
    ANTLR3_FREE(ctx);

    /* Everything is released, so we can return
     */
    return;
 }
 
/** Return token names used by this parser
 *
 * The returned pointer is used as an index into the token names table (using the token 
 * number as the index).
 * 
 * \return Pointer to first char * in the table.
 */
static pANTLR3_UINT8    *getTokenNames() 
{
        return CPSParserTokenNames; 
}


    Context context;
    pANTLR3_INPUT_STREAM           input;
    pCPSParser parser;
    std::string filename;
    Timer timer(3);
    int instCount = 0;
    int valCount = 0;
    int canCount = 0;
    int storedMax = 0;
    bool error =false;
    VerType vertype = NOVERIFY;

    void printPosition(pANTLR3_COMMON_TOKEN tok)
    {
        std::cout << "Line " << tok->line << ", Column " << tok->charPosition << ": ";
        error = true;
    }

    int main(int argc, char * argv[])
    {
    	int retval = -1;

    	std::cout << std::endl << "Welcome to Bounds 2.2!" << std::endl;
    	std::cout << "Created by Antti Siirtola 2010-2013 (contact: antti.siirtola@aalto.fi)" << std::endl << std::endl; 

    	if(argc >= 2)
    	{
    		pCPSLexer               lex;
    		pANTLR3_COMMON_TOKEN_STREAM    tokens;

    		input  = antlr3AsciiFileStreamNew          ((pANTLR3_UINT8)argv[1]);
    		if(input != 0)
    		{
    			lex    = CPSLexerNew                (input);
    			tokens = antlr3CommonTokenStreamSourceNew  (ANTLR3_SIZE_HINT, TOKENSOURCE(lex));
    			parser = CPSParserNew               (tokens);

    			filename = std::string(argv[1]);
    			size_t pos = filename.find_last_of('.');
    			if(pos != std::string::npos)
    			{
    				if(filename.find_first_of('/',pos) == std::string::npos) filename.erase(pos);
    			}

    			timer.start();
                            try
                            {
            			parser->cps(parser);
                            }
                            catch(std::bad_alloc& ba)
                            {
                                    std::cout << "Bounds run out of memory." << std::endl;
                                    std::cout << "Try to rerun the tool and provide smaller cut-offs manually." << std::endl << std::endl;
                            }
    			timer.stop();
    			if(error == true || parser-> pParser -> rec -> state -> errorCount != 0) 
                            {
                                std::cout << "Errors encountered!" << std::endl << std::endl;
                            }
                            else if(vertype == NOVERIFY)
                            {
                                std::cout << "No verification targets found." << std::endl << std::endl;
                            }
                            else
                            {
                                std::cout << "A total number of instances generated: " << instCount << std::endl;
                                std::cout << "    (a total number of valuations generated: " << valCount << std::endl;
                                std::cout << "     a total number of canonical forms computed: " << canCount << std::endl;
                                std::cout << "     the maximum number of valuations stored all at once: " << storedMax << ')' << std::endl;
                                std::cout << "Total time taken: " << timer.getTotalTime() << " seconds" << std::endl;
                                std::cout << "    (time taken by input processing: " << timer.getValue(0) << " seconds" << std::endl;
                                std::cout << "     time taken by the computation of valuations: " << timer.getValue(1) << " seconds" << std::endl;
                                std::cout << "     time taken by output processing: " << timer.getValue(2) << " seconds)" << std::endl << std::endl;
                                std::string tool;
                                switch(vertype)
                                {
                                    case TRACEREF:
                                        tool = "boundsTraceRefinementChecker";
                                        break;
                                    case ALTSIM:
                                        tool = "boundsAlternatingSimulationChecker";
                                        break;
                                    case COMPAT:
                                        tool = "boundsCompatibilityChecker";
                                        break;
                                }
                                std::cout << "Run " << tool << " " << filename << " to complete the verification." << std::endl << std::endl;
                            }
                            
    			parser ->free(parser);
    			tokens ->free(tokens);
    			lex    ->free(lex);
    			input  ->close(input);
    			retval = 0;
    		}
    		else
    		{
    			std::cout << "Unable to open file!" << std::endl;
    			retval = -1;
    		}
    	}
    	else
    	{
    		std::cout << "File name missing!" << std::endl;
    		retval = -1;
    	}
    	context.clear();
    	return retval;

    }


    
/* Declare the bitsets
 */

/** Bitset defining follow set for error recovery in rule state: FOLLOW_TYPEVAR_in_cps310  */
static	ANTLR3_BITWORD FOLLOW_TYPEVAR_in_cps310_bits[]	= { ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_TYPEVAR_in_cps310	= { FOLLOW_TYPEVAR_in_cps310_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_48_in_cps311  */
static	ANTLR3_BITWORD FOLLOW_48_in_cps311_bits[]	= { ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_48_in_cps311	= { FOLLOW_48_in_cps311_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_POSINT_in_cps315  */
static	ANTLR3_BITWORD FOLLOW_POSINT_in_cps315_bits[]	= { ANTLR3_UINT64_LIT(0x0002000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_POSINT_in_cps315	= { FOLLOW_POSINT_in_cps315_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_49_in_cps317  */
static	ANTLR3_BITWORD FOLLOW_49_in_cps317_bits[]	= { ANTLR3_UINT64_LIT(0x0000100000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_49_in_cps317	= { FOLLOW_49_in_cps317_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_capitstr_in_cps321  */
static	ANTLR3_BITWORD FOLLOW_capitstr_in_cps321_bits[]	= { ANTLR3_UINT64_LIT(0x038000480001FFC0) };
static  ANTLR3_BITSET_LIST FOLLOW_capitstr_in_cps321	= { FOLLOW_capitstr_in_cps321_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TYPEVAR_in_cps342  */
static	ANTLR3_BITWORD FOLLOW_TYPEVAR_in_cps342_bits[]	= { ANTLR3_UINT64_LIT(0x0000100000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_TYPEVAR_in_cps342	= { FOLLOW_TYPEVAR_in_cps342_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_capitstr_in_cps409  */
static	ANTLR3_BITWORD FOLLOW_capitstr_in_cps409_bits[]	= { ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_capitstr_in_cps409	= { FOLLOW_capitstr_in_cps409_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_50_in_cps412  */
static	ANTLR3_BITWORD FOLLOW_50_in_cps412_bits[]	= { ANTLR3_UINT64_LIT(0x0008000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_50_in_cps412	= { FOLLOW_50_in_cps412_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_51_in_cps414  */
static	ANTLR3_BITWORD FOLLOW_51_in_cps414_bits[]	= { ANTLR3_UINT64_LIT(0x0000080000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_51_in_cps414	= { FOLLOW_51_in_cps414_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_smallstr_in_cps446  */
static	ANTLR3_BITWORD FOLLOW_smallstr_in_cps446_bits[]	= { ANTLR3_UINT64_LIT(0x0030000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_smallstr_in_cps446	= { FOLLOW_smallstr_in_cps446_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_52_in_cps488  */
static	ANTLR3_BITWORD FOLLOW_52_in_cps488_bits[]	= { ANTLR3_UINT64_LIT(0x0000080000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_52_in_cps488	= { FOLLOW_52_in_cps488_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_smallstr_in_cps494  */
static	ANTLR3_BITWORD FOLLOW_smallstr_in_cps494_bits[]	= { ANTLR3_UINT64_LIT(0x0030000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_smallstr_in_cps494	= { FOLLOW_smallstr_in_cps494_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_53_in_cps537  */
static	ANTLR3_BITWORD FOLLOW_53_in_cps537_bits[]	= { ANTLR3_UINT64_LIT(0x038000480001FFC0) };
static  ANTLR3_BITSET_LIST FOLLOW_53_in_cps537	= { FOLLOW_53_in_cps537_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_capitstr_in_cps614  */
static	ANTLR3_BITWORD FOLLOW_capitstr_in_cps614_bits[]	= { ANTLR3_UINT64_LIT(0x038000480001FFC0) };
static  ANTLR3_BITSET_LIST FOLLOW_capitstr_in_cps614	= { FOLLOW_capitstr_in_cps614_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_cps672  */
static	ANTLR3_BITWORD FOLLOW_set_in_cps672_bits[]	= { ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_cps672	= { FOLLOW_set_in_cps672_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_48_in_cps679  */
static	ANTLR3_BITWORD FOLLOW_48_in_cps679_bits[]	= { ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_48_in_cps679	= { FOLLOW_48_in_cps679_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_POSINT_in_cps685  */
static	ANTLR3_BITWORD FOLLOW_POSINT_in_cps685_bits[]	= { ANTLR3_UINT64_LIT(0x0002000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_POSINT_in_cps685	= { FOLLOW_POSINT_in_cps685_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_49_in_cps687  */
static	ANTLR3_BITWORD FOLLOW_49_in_cps687_bits[]	= { ANTLR3_UINT64_LIT(0x0000080000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_49_in_cps687	= { FOLLOW_49_in_cps687_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_smallstr_in_cps691  */
static	ANTLR3_BITWORD FOLLOW_smallstr_in_cps691_bits[]	= { ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_smallstr_in_cps691	= { FOLLOW_smallstr_in_cps691_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_54_in_cps693  */
static	ANTLR3_BITWORD FOLLOW_54_in_cps693_bits[]	= { ANTLR3_UINT64_LIT(0x0000100000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_54_in_cps693	= { FOLLOW_54_in_cps693_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_capitstr_in_cps699  */
static	ANTLR3_BITWORD FOLLOW_capitstr_in_cps699_bits[]	= { ANTLR3_UINT64_LIT(0x038000480001FFC0) };
static  ANTLR3_BITSET_LIST FOLLOW_capitstr_in_cps699	= { FOLLOW_capitstr_in_cps699_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_cps720  */
static	ANTLR3_BITWORD FOLLOW_set_in_cps720_bits[]	= { ANTLR3_UINT64_LIT(0x0000080000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_cps720	= { FOLLOW_set_in_cps720_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_smallstr_in_cps730  */
static	ANTLR3_BITWORD FOLLOW_smallstr_in_cps730_bits[]	= { ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_smallstr_in_cps730	= { FOLLOW_smallstr_in_cps730_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_54_in_cps732  */
static	ANTLR3_BITWORD FOLLOW_54_in_cps732_bits[]	= { ANTLR3_UINT64_LIT(0x0000100000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_54_in_cps732	= { FOLLOW_54_in_cps732_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_capitstr_in_cps738  */
static	ANTLR3_BITWORD FOLLOW_capitstr_in_cps738_bits[]	= { ANTLR3_UINT64_LIT(0x038000480001FFC0) };
static  ANTLR3_BITSET_LIST FOLLOW_capitstr_in_cps738	= { FOLLOW_capitstr_in_cps738_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_cps759  */
static	ANTLR3_BITWORD FOLLOW_set_in_cps759_bits[]	= { ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_cps759	= { FOLLOW_set_in_cps759_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_48_in_cps766  */
static	ANTLR3_BITWORD FOLLOW_48_in_cps766_bits[]	= { ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_48_in_cps766	= { FOLLOW_48_in_cps766_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_POSINT_in_cps771  */
static	ANTLR3_BITWORD FOLLOW_POSINT_in_cps771_bits[]	= { ANTLR3_UINT64_LIT(0x0002000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_POSINT_in_cps771	= { FOLLOW_POSINT_in_cps771_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_49_in_cps773  */
static	ANTLR3_BITWORD FOLLOW_49_in_cps773_bits[]	= { ANTLR3_UINT64_LIT(0x0000380000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_49_in_cps773	= { FOLLOW_49_in_cps773_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_string_in_cps777  */
static	ANTLR3_BITWORD FOLLOW_string_in_cps777_bits[]	= { ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_string_in_cps777	= { FOLLOW_string_in_cps777_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_54_in_cps779  */
static	ANTLR3_BITWORD FOLLOW_54_in_cps779_bits[]	= { ANTLR3_UINT64_LIT(0x0000100000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_54_in_cps779	= { FOLLOW_54_in_cps779_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_capitstr_in_cps785  */
static	ANTLR3_BITWORD FOLLOW_capitstr_in_cps785_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_capitstr_in_cps785	= { FOLLOW_capitstr_in_cps785_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_52_in_cps787  */
static	ANTLR3_BITWORD FOLLOW_52_in_cps787_bits[]	= { ANTLR3_UINT64_LIT(0x0000100000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_52_in_cps787	= { FOLLOW_52_in_cps787_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_capitstr_in_cps793  */
static	ANTLR3_BITWORD FOLLOW_capitstr_in_cps793_bits[]	= { ANTLR3_UINT64_LIT(0x038000480001FFC0) };
static  ANTLR3_BITSET_LIST FOLLOW_capitstr_in_cps793	= { FOLLOW_capitstr_in_cps793_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_cps814  */
static	ANTLR3_BITWORD FOLLOW_set_in_cps814_bits[]	= { ANTLR3_UINT64_LIT(0x0000380000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_cps814	= { FOLLOW_set_in_cps814_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_string_in_cps824  */
static	ANTLR3_BITWORD FOLLOW_string_in_cps824_bits[]	= { ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_string_in_cps824	= { FOLLOW_string_in_cps824_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_54_in_cps826  */
static	ANTLR3_BITWORD FOLLOW_54_in_cps826_bits[]	= { ANTLR3_UINT64_LIT(0x0000100000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_54_in_cps826	= { FOLLOW_54_in_cps826_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_capitstr_in_cps832  */
static	ANTLR3_BITWORD FOLLOW_capitstr_in_cps832_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_capitstr_in_cps832	= { FOLLOW_capitstr_in_cps832_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_52_in_cps834  */
static	ANTLR3_BITWORD FOLLOW_52_in_cps834_bits[]	= { ANTLR3_UINT64_LIT(0x0000100000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_52_in_cps834	= { FOLLOW_52_in_cps834_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_capitstr_in_cps840  */
static	ANTLR3_BITWORD FOLLOW_capitstr_in_cps840_bits[]	= { ANTLR3_UINT64_LIT(0x038000480001FFC0) };
static  ANTLR3_BITSET_LIST FOLLOW_capitstr_in_cps840	= { FOLLOW_capitstr_in_cps840_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_cps861  */
static	ANTLR3_BITWORD FOLLOW_set_in_cps861_bits[]	= { ANTLR3_UINT64_LIT(0x0000380000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_cps861	= { FOLLOW_set_in_cps861_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_string_in_cps871  */
static	ANTLR3_BITWORD FOLLOW_string_in_cps871_bits[]	= { ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_string_in_cps871	= { FOLLOW_string_in_cps871_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_50_in_cps873  */
static	ANTLR3_BITWORD FOLLOW_50_in_cps873_bits[]	= { ANTLR3_UINT64_LIT(0x0400380002400030) };
static  ANTLR3_BITSET_LIST FOLLOW_50_in_cps873	= { FOLLOW_50_in_cps873_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_valf_in_cps879  */
static	ANTLR3_BITWORD FOLLOW_valf_in_cps879_bits[]	= { ANTLR3_UINT64_LIT(0x038000480001FFC0) };
static  ANTLR3_BITSET_LIST FOLLOW_valf_in_cps879	= { FOLLOW_valf_in_cps879_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_cps900  */
static	ANTLR3_BITWORD FOLLOW_set_in_cps900_bits[]	= { ANTLR3_UINT64_LIT(0x0000380000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_cps900	= { FOLLOW_set_in_cps900_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_string_in_cps910  */
static	ANTLR3_BITWORD FOLLOW_string_in_cps910_bits[]	= { ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_string_in_cps910	= { FOLLOW_string_in_cps910_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_50_in_cps912  */
static	ANTLR3_BITWORD FOLLOW_50_in_cps912_bits[]	= { ANTLR3_UINT64_LIT(0x0409380060000000) };
static  ANTLR3_BITSET_LIST FOLLOW_50_in_cps912	= { FOLLOW_50_in_cps912_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_setschema_in_cps918  */
static	ANTLR3_BITWORD FOLLOW_setschema_in_cps918_bits[]	= { ANTLR3_UINT64_LIT(0x038000480001FFC0) };
static  ANTLR3_BITSET_LIST FOLLOW_setschema_in_cps918	= { FOLLOW_setschema_in_cps918_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_cps939  */
static	ANTLR3_BITWORD FOLLOW_set_in_cps939_bits[]	= { ANTLR3_UINT64_LIT(0x0000380000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_cps939	= { FOLLOW_set_in_cps939_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_string_in_cps949  */
static	ANTLR3_BITWORD FOLLOW_string_in_cps949_bits[]	= { ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_string_in_cps949	= { FOLLOW_string_in_cps949_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_50_in_cps951  */
static	ANTLR3_BITWORD FOLLOW_50_in_cps951_bits[]	= { ANTLR3_UINT64_LIT(0x0401380014000000) };
static  ANTLR3_BITSET_LIST FOLLOW_50_in_cps951	= { FOLLOW_50_in_cps951_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ltsschema_in_cps957  */
static	ANTLR3_BITWORD FOLLOW_ltsschema_in_cps957_bits[]	= { ANTLR3_UINT64_LIT(0x038000480001FFC0) };
static  ANTLR3_BITSET_LIST FOLLOW_ltsschema_in_cps957	= { FOLLOW_ltsschema_in_cps957_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RELFUNC_in_cps978  */
static	ANTLR3_BITWORD FOLLOW_RELFUNC_in_cps978_bits[]	= { ANTLR3_UINT64_LIT(0x0000380000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RELFUNC_in_cps978	= { FOLLOW_RELFUNC_in_cps978_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_string_in_cps982  */
static	ANTLR3_BITWORD FOLLOW_string_in_cps982_bits[]	= { ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_string_in_cps982	= { FOLLOW_string_in_cps982_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_50_in_cps984  */
static	ANTLR3_BITWORD FOLLOW_50_in_cps984_bits[]	= { ANTLR3_UINT64_LIT(0x0408380000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_50_in_cps984	= { FOLLOW_50_in_cps984_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_atomrel_in_cps990  */
static	ANTLR3_BITWORD FOLLOW_atomrel_in_cps990_bits[]	= { ANTLR3_UINT64_LIT(0x038000480001FFC0) };
static  ANTLR3_BITSET_LIST FOLLOW_atomrel_in_cps990	= { FOLLOW_atomrel_in_cps990_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CHANNEL_in_cps1015  */
static	ANTLR3_BITWORD FOLLOW_CHANNEL_in_cps1015_bits[]	= { ANTLR3_UINT64_LIT(0x0000080000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_CHANNEL_in_cps1015	= { FOLLOW_CHANNEL_in_cps1015_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_smallstr_in_cps1019  */
static	ANTLR3_BITWORD FOLLOW_smallstr_in_cps1019_bits[]	= { ANTLR3_UINT64_LIT(0x03C000480001FFC0) };
static  ANTLR3_BITSET_LIST FOLLOW_smallstr_in_cps1019	= { FOLLOW_smallstr_in_cps1019_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_54_in_cps1049  */
static	ANTLR3_BITWORD FOLLOW_54_in_cps1049_bits[]	= { ANTLR3_UINT64_LIT(0x0000100000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_54_in_cps1049	= { FOLLOW_54_in_cps1049_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_capitstr_in_cps1067  */
static	ANTLR3_BITWORD FOLLOW_capitstr_in_cps1067_bits[]	= { ANTLR3_UINT64_LIT(0x039000480001FFC0) };
static  ANTLR3_BITSET_LIST FOLLOW_capitstr_in_cps1067	= { FOLLOW_capitstr_in_cps1067_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_52_in_cps1096  */
static	ANTLR3_BITWORD FOLLOW_52_in_cps1096_bits[]	= { ANTLR3_UINT64_LIT(0x0000100000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_52_in_cps1096	= { FOLLOW_52_in_cps1096_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_capitstr_in_cps1102  */
static	ANTLR3_BITWORD FOLLOW_capitstr_in_cps1102_bits[]	= { ANTLR3_UINT64_LIT(0x039000480001FFC0) };
static  ANTLR3_BITSET_LIST FOLLOW_capitstr_in_cps1102	= { FOLLOW_capitstr_in_cps1102_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_55_in_cps1195  */
static	ANTLR3_BITWORD FOLLOW_55_in_cps1195_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_55_in_cps1195	= { FOLLOW_55_in_cps1195_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_VERIFY_in_cps1197  */
static	ANTLR3_BITWORD FOLLOW_VERIFY_in_cps1197_bits[]	= { ANTLR3_UINT64_LIT(0x0401380014000000) };
static  ANTLR3_BITSET_LIST FOLLOW_VERIFY_in_cps1197	= { FOLLOW_VERIFY_in_cps1197_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ltsschema_in_cps1203  */
static	ANTLR3_BITWORD FOLLOW_ltsschema_in_cps1203_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_ltsschema_in_cps1203	= { FOLLOW_ltsschema_in_cps1203_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_AGAINST_in_cps1205  */
static	ANTLR3_BITWORD FOLLOW_AGAINST_in_cps1205_bits[]	= { ANTLR3_UINT64_LIT(0x0401380014000000) };
static  ANTLR3_BITSET_LIST FOLLOW_AGAINST_in_cps1205	= { FOLLOW_AGAINST_in_cps1205_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ltsschema_in_cps1211  */
static	ANTLR3_BITWORD FOLLOW_ltsschema_in_cps1211_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000080002) };
static  ANTLR3_BITSET_LIST FOLLOW_ltsschema_in_cps1211	= { FOLLOW_ltsschema_in_cps1211_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_WHEN_in_cps1218  */
static	ANTLR3_BITWORD FOLLOW_WHEN_in_cps1218_bits[]	= { ANTLR3_UINT64_LIT(0x0400380002400030) };
static  ANTLR3_BITSET_LIST FOLLOW_WHEN_in_cps1218	= { FOLLOW_WHEN_in_cps1218_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_valf_in_cps1224  */
static	ANTLR3_BITWORD FOLLOW_valf_in_cps1224_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_valf_in_cps1224	= { FOLLOW_valf_in_cps1224_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_56_in_cps1252  */
static	ANTLR3_BITWORD FOLLOW_56_in_cps1252_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_56_in_cps1252	= { FOLLOW_56_in_cps1252_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_VERIFY_in_cps1254  */
static	ANTLR3_BITWORD FOLLOW_VERIFY_in_cps1254_bits[]	= { ANTLR3_UINT64_LIT(0x0401380014000000) };
static  ANTLR3_BITSET_LIST FOLLOW_VERIFY_in_cps1254	= { FOLLOW_VERIFY_in_cps1254_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ltsschema_in_cps1260  */
static	ANTLR3_BITWORD FOLLOW_ltsschema_in_cps1260_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_ltsschema_in_cps1260	= { FOLLOW_ltsschema_in_cps1260_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_AGAINST_in_cps1262  */
static	ANTLR3_BITWORD FOLLOW_AGAINST_in_cps1262_bits[]	= { ANTLR3_UINT64_LIT(0x0401380014000000) };
static  ANTLR3_BITSET_LIST FOLLOW_AGAINST_in_cps1262	= { FOLLOW_AGAINST_in_cps1262_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ltsschema_in_cps1268  */
static	ANTLR3_BITWORD FOLLOW_ltsschema_in_cps1268_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000080002) };
static  ANTLR3_BITSET_LIST FOLLOW_ltsschema_in_cps1268	= { FOLLOW_ltsschema_in_cps1268_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_WHEN_in_cps1275  */
static	ANTLR3_BITWORD FOLLOW_WHEN_in_cps1275_bits[]	= { ANTLR3_UINT64_LIT(0x0400380002400030) };
static  ANTLR3_BITSET_LIST FOLLOW_WHEN_in_cps1275	= { FOLLOW_WHEN_in_cps1275_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_valf_in_cps1281  */
static	ANTLR3_BITWORD FOLLOW_valf_in_cps1281_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_valf_in_cps1281	= { FOLLOW_valf_in_cps1281_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_57_in_cps1309  */
static	ANTLR3_BITWORD FOLLOW_57_in_cps1309_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_57_in_cps1309	= { FOLLOW_57_in_cps1309_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_VERIFY_in_cps1311  */
static	ANTLR3_BITWORD FOLLOW_VERIFY_in_cps1311_bits[]	= { ANTLR3_UINT64_LIT(0x0401380014000000) };
static  ANTLR3_BITSET_LIST FOLLOW_VERIFY_in_cps1311	= { FOLLOW_VERIFY_in_cps1311_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ltsschema_in_cps1317  */
static	ANTLR3_BITWORD FOLLOW_ltsschema_in_cps1317_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000080002) };
static  ANTLR3_BITSET_LIST FOLLOW_ltsschema_in_cps1317	= { FOLLOW_ltsschema_in_cps1317_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_WHEN_in_cps1324  */
static	ANTLR3_BITWORD FOLLOW_WHEN_in_cps1324_bits[]	= { ANTLR3_UINT64_LIT(0x0400380002400030) };
static  ANTLR3_BITSET_LIST FOLLOW_WHEN_in_cps1324	= { FOLLOW_WHEN_in_cps1324_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_valf_in_cps1330  */
static	ANTLR3_BITWORD FOLLOW_valf_in_cps1330_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_valf_in_cps1330	= { FOLLOW_valf_in_cps1330_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_parltsc_in_ltsschema1371  */
static	ANTLR3_BITWORD FOLLOW_parltsc_in_ltsschema1371_bits[]	= { ANTLR3_UINT64_LIT(0x0000000100000002) };
static  ANTLR3_BITSET_LIST FOLLOW_parltsc_in_ltsschema1371	= { FOLLOW_parltsc_in_ltsschema1371_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HIDE_in_ltsschema1393  */
static	ANTLR3_BITWORD FOLLOW_HIDE_in_ltsschema1393_bits[]	= { ANTLR3_UINT64_LIT(0x0409380060000000) };
static  ANTLR3_BITSET_LIST FOLLOW_HIDE_in_ltsschema1393	= { FOLLOW_HIDE_in_ltsschema1393_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_setschema_in_ltsschema1399  */
static	ANTLR3_BITWORD FOLLOW_setschema_in_ltsschema1399_bits[]	= { ANTLR3_UINT64_LIT(0x0000000100000002) };
static  ANTLR3_BITSET_LIST FOLLOW_setschema_in_ltsschema1399	= { FOLLOW_setschema_in_ltsschema1399_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_repparltsc_in_parltsc1438  */
static	ANTLR3_BITWORD FOLLOW_repparltsc_in_parltsc1438_bits[]	= { ANTLR3_UINT64_LIT(0x0000000010000002) };
static  ANTLR3_BITSET_LIST FOLLOW_repparltsc_in_parltsc1438	= { FOLLOW_repparltsc_in_parltsc1438_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condltsc_in_parltsc1448  */
static	ANTLR3_BITWORD FOLLOW_condltsc_in_parltsc1448_bits[]	= { ANTLR3_UINT64_LIT(0x0000000010000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condltsc_in_parltsc1448	= { FOLLOW_condltsc_in_parltsc1448_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_elemltsc_in_parltsc1458  */
static	ANTLR3_BITWORD FOLLOW_elemltsc_in_parltsc1458_bits[]	= { ANTLR3_UINT64_LIT(0x0000000010000002) };
static  ANTLR3_BITSET_LIST FOLLOW_elemltsc_in_parltsc1458	= { FOLLOW_elemltsc_in_parltsc1458_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PAR_in_parltsc1467  */
static	ANTLR3_BITWORD FOLLOW_PAR_in_parltsc1467_bits[]	= { ANTLR3_UINT64_LIT(0x0401380014000000) };
static  ANTLR3_BITSET_LIST FOLLOW_PAR_in_parltsc1467	= { FOLLOW_PAR_in_parltsc1467_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_repparltsc_in_parltsc1474  */
static	ANTLR3_BITWORD FOLLOW_repparltsc_in_parltsc1474_bits[]	= { ANTLR3_UINT64_LIT(0x0000000010000002) };
static  ANTLR3_BITSET_LIST FOLLOW_repparltsc_in_parltsc1474	= { FOLLOW_repparltsc_in_parltsc1474_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condltsc_in_parltsc1508  */
static	ANTLR3_BITWORD FOLLOW_condltsc_in_parltsc1508_bits[]	= { ANTLR3_UINT64_LIT(0x0000000010000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condltsc_in_parltsc1508	= { FOLLOW_condltsc_in_parltsc1508_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_elemltsc_in_parltsc1543  */
static	ANTLR3_BITWORD FOLLOW_elemltsc_in_parltsc1543_bits[]	= { ANTLR3_UINT64_LIT(0x0000000010000002) };
static  ANTLR3_BITSET_LIST FOLLOW_elemltsc_in_parltsc1543	= { FOLLOW_elemltsc_in_parltsc1543_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PAR_in_repparltsc1579  */
static	ANTLR3_BITWORD FOLLOW_PAR_in_repparltsc1579_bits[]	= { ANTLR3_UINT64_LIT(0x0000380000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_PAR_in_repparltsc1579	= { FOLLOW_PAR_in_repparltsc1579_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundparlist_in_repparltsc1583  */
static	ANTLR3_BITWORD FOLLOW_boundparlist_in_repparltsc1583_bits[]	= { ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_boundparlist_in_repparltsc1583	= { FOLLOW_boundparlist_in_repparltsc1583_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_54_in_repparltsc1585  */
static	ANTLR3_BITWORD FOLLOW_54_in_repparltsc1585_bits[]	= { ANTLR3_UINT64_LIT(0x0401380014000000) };
static  ANTLR3_BITSET_LIST FOLLOW_54_in_repparltsc1585	= { FOLLOW_54_in_repparltsc1585_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_repparltsc_in_repparltsc1594  */
static	ANTLR3_BITWORD FOLLOW_repparltsc_in_repparltsc1594_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_repparltsc_in_repparltsc1594	= { FOLLOW_repparltsc_in_repparltsc1594_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condltsc_in_repparltsc1604  */
static	ANTLR3_BITWORD FOLLOW_condltsc_in_repparltsc1604_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condltsc_in_repparltsc1604	= { FOLLOW_condltsc_in_repparltsc1604_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_elemltsc_in_repparltsc1614  */
static	ANTLR3_BITWORD FOLLOW_elemltsc_in_repparltsc1614_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_elemltsc_in_repparltsc1614	= { FOLLOW_elemltsc_in_repparltsc1614_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_48_in_condltsc1651  */
static	ANTLR3_BITWORD FOLLOW_48_in_condltsc1651_bits[]	= { ANTLR3_UINT64_LIT(0x0400380002400030) };
static  ANTLR3_BITSET_LIST FOLLOW_48_in_condltsc1651	= { FOLLOW_48_in_condltsc1651_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_valf_in_condltsc1657  */
static	ANTLR3_BITWORD FOLLOW_valf_in_condltsc1657_bits[]	= { ANTLR3_UINT64_LIT(0x0002000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_valf_in_condltsc1657	= { FOLLOW_valf_in_condltsc1657_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_49_in_condltsc1659  */
static	ANTLR3_BITWORD FOLLOW_49_in_condltsc1659_bits[]	= { ANTLR3_UINT64_LIT(0x0401380014000000) };
static  ANTLR3_BITSET_LIST FOLLOW_49_in_condltsc1659	= { FOLLOW_49_in_condltsc1659_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condltsc_in_condltsc1668  */
static	ANTLR3_BITWORD FOLLOW_condltsc_in_condltsc1668_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condltsc_in_condltsc1668	= { FOLLOW_condltsc_in_condltsc1668_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_elemltsc_in_condltsc1678  */
static	ANTLR3_BITWORD FOLLOW_elemltsc_in_condltsc1678_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_elemltsc_in_condltsc1678	= { FOLLOW_elemltsc_in_condltsc1678_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_repparltsc_in_condltsc1688  */
static	ANTLR3_BITWORD FOLLOW_repparltsc_in_condltsc1688_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_repparltsc_in_condltsc1688	= { FOLLOW_repparltsc_in_condltsc1688_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LTS_in_elemltsc1726  */
static	ANTLR3_BITWORD FOLLOW_LTS_in_elemltsc1726_bits[]	= { ANTLR3_UINT64_LIT(0x0000380008000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LTS_in_elemltsc1726	= { FOLLOW_LTS_in_elemltsc1726_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_transetschema_in_elemltsc1760  */
static	ANTLR3_BITWORD FOLLOW_transetschema_in_elemltsc1760_bits[]	= { ANTLR3_UINT64_LIT(0x0000000008000000) };
static  ANTLR3_BITSET_LIST FOLLOW_transetschema_in_elemltsc1760	= { FOLLOW_transetschema_in_elemltsc1760_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FROM_in_elemltsc1762  */
static	ANTLR3_BITWORD FOLLOW_FROM_in_elemltsc1762_bits[]	= { ANTLR3_UINT64_LIT(0x0000380000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FROM_in_elemltsc1762	= { FOLLOW_FROM_in_elemltsc1762_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_stateschema_in_elemltsc1768  */
static	ANTLR3_BITWORD FOLLOW_stateschema_in_elemltsc1768_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_stateschema_in_elemltsc1768	= { FOLLOW_stateschema_in_elemltsc1768_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_string_in_elemltsc1798  */
static	ANTLR3_BITWORD FOLLOW_string_in_elemltsc1798_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_string_in_elemltsc1798	= { FOLLOW_string_in_elemltsc1798_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_58_in_elemltsc1819  */
static	ANTLR3_BITWORD FOLLOW_58_in_elemltsc1819_bits[]	= { ANTLR3_UINT64_LIT(0x0401380014000000) };
static  ANTLR3_BITSET_LIST FOLLOW_58_in_elemltsc1819	= { FOLLOW_58_in_elemltsc1819_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ltsschema_in_elemltsc1825  */
static	ANTLR3_BITWORD FOLLOW_ltsschema_in_elemltsc1825_bits[]	= { ANTLR3_UINT64_LIT(0x0800000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_ltsschema_in_elemltsc1825	= { FOLLOW_ltsschema_in_elemltsc1825_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_59_in_elemltsc1827  */
static	ANTLR3_BITWORD FOLLOW_59_in_elemltsc1827_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_59_in_elemltsc1827	= { FOLLOW_59_in_elemltsc1827_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_transchema_in_transetschema1868  */
static	ANTLR3_BITWORD FOLLOW_transchema_in_transetschema1868_bits[]	= { ANTLR3_UINT64_LIT(0x0000380200000002) };
static  ANTLR3_BITSET_LIST FOLLOW_transchema_in_transetschema1868	= { FOLLOW_transchema_in_transetschema1868_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_choicetranschema_in_transetschema1889  */
static	ANTLR3_BITWORD FOLLOW_choicetranschema_in_transetschema1889_bits[]	= { ANTLR3_UINT64_LIT(0x0000380200000002) };
static  ANTLR3_BITSET_LIST FOLLOW_choicetranschema_in_transetschema1889	= { FOLLOW_choicetranschema_in_transetschema1889_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_fromstateschema_in_transchema1931  */
static	ANTLR3_BITWORD FOLLOW_fromstateschema_in_transchema1931_bits[]	= { ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_fromstateschema_in_transchema1931	= { FOLLOW_fromstateschema_in_transchema1931_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_50_in_transchema1957  */
static	ANTLR3_BITWORD FOLLOW_50_in_transchema1957_bits[]	= { ANTLR3_UINT64_LIT(0x1001088200400000) };
static  ANTLR3_BITSET_LIST FOLLOW_50_in_transchema1957	= { FOLLOW_50_in_transchema1957_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CHOICE_in_transchema1963  */
static	ANTLR3_BITWORD FOLLOW_CHOICE_in_transchema1963_bits[]	= { ANTLR3_UINT64_LIT(0x0000380000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_CHOICE_in_transchema1963	= { FOLLOW_CHOICE_in_transchema1963_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundparlist_in_transchema1969  */
static	ANTLR3_BITWORD FOLLOW_boundparlist_in_transchema1969_bits[]	= { ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_boundparlist_in_transchema1969	= { FOLLOW_boundparlist_in_transchema1969_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_54_in_transchema1971  */
static	ANTLR3_BITWORD FOLLOW_54_in_transchema1971_bits[]	= { ANTLR3_UINT64_LIT(0x1001088200400000) };
static  ANTLR3_BITSET_LIST FOLLOW_54_in_transchema1971	= { FOLLOW_54_in_transchema1971_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_48_in_transchema2004  */
static	ANTLR3_BITWORD FOLLOW_48_in_transchema2004_bits[]	= { ANTLR3_UINT64_LIT(0x0400380002400030) };
static  ANTLR3_BITSET_LIST FOLLOW_48_in_transchema2004	= { FOLLOW_48_in_transchema2004_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_valf_in_transchema2010  */
static	ANTLR3_BITWORD FOLLOW_valf_in_transchema2010_bits[]	= { ANTLR3_UINT64_LIT(0x0002000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_valf_in_transchema2010	= { FOLLOW_valf_in_transchema2010_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_49_in_transchema2012  */
static	ANTLR3_BITWORD FOLLOW_49_in_transchema2012_bits[]	= { ANTLR3_UINT64_LIT(0x1001088200400000) };
static  ANTLR3_BITSET_LIST FOLLOW_49_in_transchema2012	= { FOLLOW_49_in_transchema2012_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_actionschema_in_transchema2051  */
static	ANTLR3_BITWORD FOLLOW_actionschema_in_transchema2051_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_actionschema_in_transchema2051	= { FOLLOW_actionschema_in_transchema2051_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IMPL_in_transchema2083  */
static	ANTLR3_BITWORD FOLLOW_IMPL_in_transchema2083_bits[]	= { ANTLR3_UINT64_LIT(0x0000380000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_IMPL_in_transchema2083	= { FOLLOW_IMPL_in_transchema2083_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_stateschema_in_transchema2089  */
static	ANTLR3_BITWORD FOLLOW_stateschema_in_transchema2089_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_stateschema_in_transchema2089	= { FOLLOW_stateschema_in_transchema2089_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CHOICE_in_choicetranschema2132  */
static	ANTLR3_BITWORD FOLLOW_CHOICE_in_choicetranschema2132_bits[]	= { ANTLR3_UINT64_LIT(0x1001088200400000) };
static  ANTLR3_BITSET_LIST FOLLOW_CHOICE_in_choicetranschema2132	= { FOLLOW_CHOICE_in_choicetranschema2132_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CHOICE_in_choicetranschema2144  */
static	ANTLR3_BITWORD FOLLOW_CHOICE_in_choicetranschema2144_bits[]	= { ANTLR3_UINT64_LIT(0x0000380000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_CHOICE_in_choicetranschema2144	= { FOLLOW_CHOICE_in_choicetranschema2144_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundparlist_in_choicetranschema2150  */
static	ANTLR3_BITWORD FOLLOW_boundparlist_in_choicetranschema2150_bits[]	= { ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_boundparlist_in_choicetranschema2150	= { FOLLOW_boundparlist_in_choicetranschema2150_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_54_in_choicetranschema2152  */
static	ANTLR3_BITWORD FOLLOW_54_in_choicetranschema2152_bits[]	= { ANTLR3_UINT64_LIT(0x1001088200400000) };
static  ANTLR3_BITSET_LIST FOLLOW_54_in_choicetranschema2152	= { FOLLOW_54_in_choicetranschema2152_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_48_in_choicetranschema2184  */
static	ANTLR3_BITWORD FOLLOW_48_in_choicetranschema2184_bits[]	= { ANTLR3_UINT64_LIT(0x0400380002400030) };
static  ANTLR3_BITSET_LIST FOLLOW_48_in_choicetranschema2184	= { FOLLOW_48_in_choicetranschema2184_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_valf_in_choicetranschema2190  */
static	ANTLR3_BITWORD FOLLOW_valf_in_choicetranschema2190_bits[]	= { ANTLR3_UINT64_LIT(0x0002000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_valf_in_choicetranschema2190	= { FOLLOW_valf_in_choicetranschema2190_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_49_in_choicetranschema2192  */
static	ANTLR3_BITWORD FOLLOW_49_in_choicetranschema2192_bits[]	= { ANTLR3_UINT64_LIT(0x1001088200400000) };
static  ANTLR3_BITSET_LIST FOLLOW_49_in_choicetranschema2192	= { FOLLOW_49_in_choicetranschema2192_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_actionschema_in_choicetranschema2234  */
static	ANTLR3_BITWORD FOLLOW_actionschema_in_choicetranschema2234_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_actionschema_in_choicetranschema2234	= { FOLLOW_actionschema_in_choicetranschema2234_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IMPL_in_choicetranschema2266  */
static	ANTLR3_BITWORD FOLLOW_IMPL_in_choicetranschema2266_bits[]	= { ANTLR3_UINT64_LIT(0x0000380000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_IMPL_in_choicetranschema2266	= { FOLLOW_IMPL_in_choicetranschema2266_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_stateschema_in_choicetranschema2272  */
static	ANTLR3_BITWORD FOLLOW_stateschema_in_choicetranschema2272_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_stateschema_in_choicetranschema2272	= { FOLLOW_stateschema_in_choicetranschema2272_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_elemssc_in_setschema2317  */
static	ANTLR3_BITWORD FOLLOW_elemssc_in_setschema2317_bits[]	= { ANTLR3_UINT64_LIT(0x0000000060000002) };
static  ANTLR3_BITSET_LIST FOLLOW_elemssc_in_setschema2317	= { FOLLOW_elemssc_in_setschema2317_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_repssc_in_setschema2327  */
static	ANTLR3_BITWORD FOLLOW_repssc_in_setschema2327_bits[]	= { ANTLR3_UINT64_LIT(0x0000000060000002) };
static  ANTLR3_BITSET_LIST FOLLOW_repssc_in_setschema2327	= { FOLLOW_repssc_in_setschema2327_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condssc_in_setschema2337  */
static	ANTLR3_BITWORD FOLLOW_condssc_in_setschema2337_bits[]	= { ANTLR3_UINT64_LIT(0x0000000060000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condssc_in_setschema2337	= { FOLLOW_condssc_in_setschema2337_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_setschema2346  */
static	ANTLR3_BITWORD FOLLOW_set_in_setschema2346_bits[]	= { ANTLR3_UINT64_LIT(0x0409380060000000) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_setschema2346	= { FOLLOW_set_in_setschema2346_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_elemssc_in_setschema2359  */
static	ANTLR3_BITWORD FOLLOW_elemssc_in_setschema2359_bits[]	= { ANTLR3_UINT64_LIT(0x0000000060000002) };
static  ANTLR3_BITSET_LIST FOLLOW_elemssc_in_setschema2359	= { FOLLOW_elemssc_in_setschema2359_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_repssc_in_setschema2394  */
static	ANTLR3_BITWORD FOLLOW_repssc_in_setschema2394_bits[]	= { ANTLR3_UINT64_LIT(0x0000000060000002) };
static  ANTLR3_BITSET_LIST FOLLOW_repssc_in_setschema2394	= { FOLLOW_repssc_in_setschema2394_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condssc_in_setschema2429  */
static	ANTLR3_BITWORD FOLLOW_condssc_in_setschema2429_bits[]	= { ANTLR3_UINT64_LIT(0x0000000060000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condssc_in_setschema2429	= { FOLLOW_condssc_in_setschema2429_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_repssc2464  */
static	ANTLR3_BITWORD FOLLOW_set_in_repssc2464_bits[]	= { ANTLR3_UINT64_LIT(0x0000380000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_repssc2464	= { FOLLOW_set_in_repssc2464_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundparlist_in_repssc2476  */
static	ANTLR3_BITWORD FOLLOW_boundparlist_in_repssc2476_bits[]	= { ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_boundparlist_in_repssc2476	= { FOLLOW_boundparlist_in_repssc2476_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_54_in_repssc2478  */
static	ANTLR3_BITWORD FOLLOW_54_in_repssc2478_bits[]	= { ANTLR3_UINT64_LIT(0x0409380060000000) };
static  ANTLR3_BITSET_LIST FOLLOW_54_in_repssc2478	= { FOLLOW_54_in_repssc2478_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_elemssc_in_repssc2487  */
static	ANTLR3_BITWORD FOLLOW_elemssc_in_repssc2487_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_elemssc_in_repssc2487	= { FOLLOW_elemssc_in_repssc2487_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_repssc_in_repssc2497  */
static	ANTLR3_BITWORD FOLLOW_repssc_in_repssc2497_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_repssc_in_repssc2497	= { FOLLOW_repssc_in_repssc2497_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condssc_in_repssc2507  */
static	ANTLR3_BITWORD FOLLOW_condssc_in_repssc2507_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condssc_in_repssc2507	= { FOLLOW_condssc_in_repssc2507_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_actionsetsc_in_elemssc2546  */
static	ANTLR3_BITWORD FOLLOW_actionsetsc_in_elemssc2546_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_actionsetsc_in_elemssc2546	= { FOLLOW_actionsetsc_in_elemssc2546_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_string_in_elemssc2571  */
static	ANTLR3_BITWORD FOLLOW_string_in_elemssc2571_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_string_in_elemssc2571	= { FOLLOW_string_in_elemssc2571_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_58_in_elemssc2591  */
static	ANTLR3_BITWORD FOLLOW_58_in_elemssc2591_bits[]	= { ANTLR3_UINT64_LIT(0x0409380060000000) };
static  ANTLR3_BITSET_LIST FOLLOW_58_in_elemssc2591	= { FOLLOW_58_in_elemssc2591_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_setschema_in_elemssc2597  */
static	ANTLR3_BITWORD FOLLOW_setschema_in_elemssc2597_bits[]	= { ANTLR3_UINT64_LIT(0x0800000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_setschema_in_elemssc2597	= { FOLLOW_setschema_in_elemssc2597_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_59_in_elemssc2599  */
static	ANTLR3_BITWORD FOLLOW_59_in_elemssc2599_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_59_in_elemssc2599	= { FOLLOW_59_in_elemssc2599_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_48_in_condssc2629  */
static	ANTLR3_BITWORD FOLLOW_48_in_condssc2629_bits[]	= { ANTLR3_UINT64_LIT(0x0400380002400030) };
static  ANTLR3_BITSET_LIST FOLLOW_48_in_condssc2629	= { FOLLOW_48_in_condssc2629_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_valf_in_condssc2635  */
static	ANTLR3_BITWORD FOLLOW_valf_in_condssc2635_bits[]	= { ANTLR3_UINT64_LIT(0x0002000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_valf_in_condssc2635	= { FOLLOW_valf_in_condssc2635_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_49_in_condssc2637  */
static	ANTLR3_BITWORD FOLLOW_49_in_condssc2637_bits[]	= { ANTLR3_UINT64_LIT(0x0409380060000000) };
static  ANTLR3_BITSET_LIST FOLLOW_49_in_condssc2637	= { FOLLOW_49_in_condssc2637_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condssc_in_condssc2646  */
static	ANTLR3_BITWORD FOLLOW_condssc_in_condssc2646_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condssc_in_condssc2646	= { FOLLOW_condssc_in_condssc2646_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_elemssc_in_condssc2656  */
static	ANTLR3_BITWORD FOLLOW_elemssc_in_condssc2656_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_elemssc_in_condssc2656	= { FOLLOW_elemssc_in_condssc2656_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_repssc_in_condssc2666  */
static	ANTLR3_BITWORD FOLLOW_repssc_in_condssc2666_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_repssc_in_condssc2666	= { FOLLOW_repssc_in_condssc2666_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_51_in_actionsetsc2704  */
static	ANTLR3_BITWORD FOLLOW_51_in_actionsetsc2704_bits[]	= { ANTLR3_UINT64_LIT(0x1021088200400000) };
static  ANTLR3_BITSET_LIST FOLLOW_51_in_actionsetsc2704	= { FOLLOW_51_in_actionsetsc2704_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_actionschema_in_actionsetsc2717  */
static	ANTLR3_BITWORD FOLLOW_actionschema_in_actionsetsc2717_bits[]	= { ANTLR3_UINT64_LIT(0x0030000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_actionschema_in_actionsetsc2717	= { FOLLOW_actionschema_in_actionsetsc2717_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_52_in_actionsetsc2737  */
static	ANTLR3_BITWORD FOLLOW_52_in_actionsetsc2737_bits[]	= { ANTLR3_UINT64_LIT(0x1001088200400000) };
static  ANTLR3_BITSET_LIST FOLLOW_52_in_actionsetsc2737	= { FOLLOW_52_in_actionsetsc2737_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_actionschema_in_actionsetsc2743  */
static	ANTLR3_BITWORD FOLLOW_actionschema_in_actionsetsc2743_bits[]	= { ANTLR3_UINT64_LIT(0x0030000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_actionschema_in_actionsetsc2743	= { FOLLOW_actionschema_in_actionsetsc2743_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_53_in_actionsetsc2768  */
static	ANTLR3_BITWORD FOLLOW_53_in_actionsetsc2768_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_53_in_actionsetsc2768	= { FOLLOW_53_in_actionsetsc2768_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_equivf_in_valf2790  */
static	ANTLR3_BITWORD FOLLOW_equivf_in_valf2790_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_equivf_in_valf2790	= { FOLLOW_equivf_in_valf2790_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_univf_in_valf2805  */
static	ANTLR3_BITWORD FOLLOW_univf_in_valf2805_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_univf_in_valf2805	= { FOLLOW_univf_in_valf2805_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FORALL_in_univf2830  */
static	ANTLR3_BITWORD FOLLOW_FORALL_in_univf2830_bits[]	= { ANTLR3_UINT64_LIT(0x0000380000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FORALL_in_univf2830	= { FOLLOW_FORALL_in_univf2830_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundparlist_in_univf2834  */
static	ANTLR3_BITWORD FOLLOW_boundparlist_in_univf2834_bits[]	= { ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_boundparlist_in_univf2834	= { FOLLOW_boundparlist_in_univf2834_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_54_in_univf2836  */
static	ANTLR3_BITWORD FOLLOW_54_in_univf2836_bits[]	= { ANTLR3_UINT64_LIT(0x0400380002400030) };
static  ANTLR3_BITSET_LIST FOLLOW_54_in_univf2836	= { FOLLOW_54_in_univf2836_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_valf_in_univf2840  */
static	ANTLR3_BITWORD FOLLOW_valf_in_univf2840_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_valf_in_univf2840	= { FOLLOW_valf_in_univf2840_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_implvf_in_equivf2877  */
static	ANTLR3_BITWORD FOLLOW_implvf_in_equivf2877_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000200002) };
static  ANTLR3_BITSET_LIST FOLLOW_implvf_in_equivf2877	= { FOLLOW_implvf_in_equivf2877_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQ_in_equivf2900  */
static	ANTLR3_BITWORD FOLLOW_EQ_in_equivf2900_bits[]	= { ANTLR3_UINT64_LIT(0x0400380000400030) };
static  ANTLR3_BITSET_LIST FOLLOW_EQ_in_equivf2900	= { FOLLOW_EQ_in_equivf2900_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_implvf_in_equivf2904  */
static	ANTLR3_BITWORD FOLLOW_implvf_in_equivf2904_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000200002) };
static  ANTLR3_BITSET_LIST FOLLOW_implvf_in_equivf2904	= { FOLLOW_implvf_in_equivf2904_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_disjvf_in_implvf2947  */
static	ANTLR3_BITWORD FOLLOW_disjvf_in_implvf2947_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000100002) };
static  ANTLR3_BITSET_LIST FOLLOW_disjvf_in_implvf2947	= { FOLLOW_disjvf_in_implvf2947_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IMPL_in_implvf2970  */
static	ANTLR3_BITWORD FOLLOW_IMPL_in_implvf2970_bits[]	= { ANTLR3_UINT64_LIT(0x0400380000400030) };
static  ANTLR3_BITSET_LIST FOLLOW_IMPL_in_implvf2970	= { FOLLOW_IMPL_in_implvf2970_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_disjvf_in_implvf2976  */
static	ANTLR3_BITWORD FOLLOW_disjvf_in_implvf2976_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000100002) };
static  ANTLR3_BITSET_LIST FOLLOW_disjvf_in_implvf2976	= { FOLLOW_disjvf_in_implvf2976_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_conjvf_in_disjvf3019  */
static	ANTLR3_BITWORD FOLLOW_conjvf_in_disjvf3019_bits[]	= { ANTLR3_UINT64_LIT(0x0000000001000002) };
static  ANTLR3_BITSET_LIST FOLLOW_conjvf_in_disjvf3019	= { FOLLOW_conjvf_in_disjvf3019_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_OR_in_disjvf3033  */
static	ANTLR3_BITWORD FOLLOW_OR_in_disjvf3033_bits[]	= { ANTLR3_UINT64_LIT(0x0400380000400030) };
static  ANTLR3_BITSET_LIST FOLLOW_OR_in_disjvf3033	= { FOLLOW_OR_in_disjvf3033_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_conjvf_in_disjvf3039  */
static	ANTLR3_BITWORD FOLLOW_conjvf_in_disjvf3039_bits[]	= { ANTLR3_UINT64_LIT(0x0000000001000002) };
static  ANTLR3_BITSET_LIST FOLLOW_conjvf_in_disjvf3039	= { FOLLOW_conjvf_in_disjvf3039_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_elemvf_in_conjvf3083  */
static	ANTLR3_BITWORD FOLLOW_elemvf_in_conjvf3083_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000800002) };
static  ANTLR3_BITSET_LIST FOLLOW_elemvf_in_conjvf3083	= { FOLLOW_elemvf_in_conjvf3083_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_negvf_in_conjvf3093  */
static	ANTLR3_BITWORD FOLLOW_negvf_in_conjvf3093_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000800002) };
static  ANTLR3_BITSET_LIST FOLLOW_negvf_in_conjvf3093	= { FOLLOW_negvf_in_conjvf3093_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_58_in_conjvf3099  */
static	ANTLR3_BITWORD FOLLOW_58_in_conjvf3099_bits[]	= { ANTLR3_UINT64_LIT(0x0400380002400030) };
static  ANTLR3_BITSET_LIST FOLLOW_58_in_conjvf3099	= { FOLLOW_58_in_conjvf3099_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_valf_in_conjvf3105  */
static	ANTLR3_BITWORD FOLLOW_valf_in_conjvf3105_bits[]	= { ANTLR3_UINT64_LIT(0x0800000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_valf_in_conjvf3105	= { FOLLOW_valf_in_conjvf3105_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_59_in_conjvf3107  */
static	ANTLR3_BITWORD FOLLOW_59_in_conjvf3107_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000800002) };
static  ANTLR3_BITSET_LIST FOLLOW_59_in_conjvf3107	= { FOLLOW_59_in_conjvf3107_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_AND_in_conjvf3116  */
static	ANTLR3_BITWORD FOLLOW_AND_in_conjvf3116_bits[]	= { ANTLR3_UINT64_LIT(0x0400380000400030) };
static  ANTLR3_BITSET_LIST FOLLOW_AND_in_conjvf3116	= { FOLLOW_AND_in_conjvf3116_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_elemvf_in_conjvf3122  */
static	ANTLR3_BITWORD FOLLOW_elemvf_in_conjvf3122_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000800002) };
static  ANTLR3_BITSET_LIST FOLLOW_elemvf_in_conjvf3122	= { FOLLOW_elemvf_in_conjvf3122_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_negvf_in_conjvf3157  */
static	ANTLR3_BITWORD FOLLOW_negvf_in_conjvf3157_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000800002) };
static  ANTLR3_BITSET_LIST FOLLOW_negvf_in_conjvf3157	= { FOLLOW_negvf_in_conjvf3157_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_58_in_conjvf3188  */
static	ANTLR3_BITWORD FOLLOW_58_in_conjvf3188_bits[]	= { ANTLR3_UINT64_LIT(0x0400380002400030) };
static  ANTLR3_BITSET_LIST FOLLOW_58_in_conjvf3188	= { FOLLOW_58_in_conjvf3188_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_valf_in_conjvf3194  */
static	ANTLR3_BITWORD FOLLOW_valf_in_conjvf3194_bits[]	= { ANTLR3_UINT64_LIT(0x0800000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_valf_in_conjvf3194	= { FOLLOW_valf_in_conjvf3194_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_59_in_conjvf3196  */
static	ANTLR3_BITWORD FOLLOW_59_in_conjvf3196_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000800002) };
static  ANTLR3_BITSET_LIST FOLLOW_59_in_conjvf3196	= { FOLLOW_59_in_conjvf3196_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NEG_in_negvf3245  */
static	ANTLR3_BITWORD FOLLOW_NEG_in_negvf3245_bits[]	= { ANTLR3_UINT64_LIT(0x0400380000400030) };
static  ANTLR3_BITSET_LIST FOLLOW_NEG_in_negvf3245	= { FOLLOW_NEG_in_negvf3245_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_negvf_in_negvf3254  */
static	ANTLR3_BITWORD FOLLOW_negvf_in_negvf3254_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_negvf_in_negvf3254	= { FOLLOW_negvf_in_negvf3254_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_elemvf_in_negvf3264  */
static	ANTLR3_BITWORD FOLLOW_elemvf_in_negvf3264_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_elemvf_in_negvf3264	= { FOLLOW_elemvf_in_negvf3264_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_58_in_negvf3270  */
static	ANTLR3_BITWORD FOLLOW_58_in_negvf3270_bits[]	= { ANTLR3_UINT64_LIT(0x0400380002400030) };
static  ANTLR3_BITSET_LIST FOLLOW_58_in_negvf3270	= { FOLLOW_58_in_negvf3270_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_valf_in_negvf3275  */
static	ANTLR3_BITWORD FOLLOW_valf_in_negvf3275_bits[]	= { ANTLR3_UINT64_LIT(0x0800000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_valf_in_negvf3275	= { FOLLOW_valf_in_negvf3275_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_59_in_negvf3277  */
static	ANTLR3_BITWORD FOLLOW_59_in_negvf3277_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_59_in_negvf3277	= { FOLLOW_59_in_negvf3277_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TRUEVF_in_elemvf3320  */
static	ANTLR3_BITWORD FOLLOW_TRUEVF_in_elemvf3320_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_TRUEVF_in_elemvf3320	= { FOLLOW_TRUEVF_in_elemvf3320_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FALSEVF_in_elemvf3339  */
static	ANTLR3_BITWORD FOLLOW_FALSEVF_in_elemvf3339_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FALSEVF_in_elemvf3339	= { FOLLOW_FALSEVF_in_elemvf3339_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_atomschema_in_elemvf3353  */
static	ANTLR3_BITWORD FOLLOW_atomschema_in_elemvf3353_bits[]	= { ANTLR3_UINT64_LIT(0x0004382000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_atomschema_in_elemvf3353	= { FOLLOW_atomschema_in_elemvf3353_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_50_in_elemvf3360  */
static	ANTLR3_BITWORD FOLLOW_50_in_elemvf3360_bits[]	= { ANTLR3_UINT64_LIT(0x0000380000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_50_in_elemvf3360	= { FOLLOW_50_in_elemvf3360_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_atomschema_in_elemvf3364  */
static	ANTLR3_BITWORD FOLLOW_atomschema_in_elemvf3364_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_atomschema_in_elemvf3364	= { FOLLOW_atomschema_in_elemvf3364_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IN_in_elemvf3392  */
static	ANTLR3_BITWORD FOLLOW_IN_in_elemvf3392_bits[]	= { ANTLR3_UINT64_LIT(0x0408380000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_IN_in_elemvf3392	= { FOLLOW_IN_in_elemvf3392_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_atomrel_in_elemvf3396  */
static	ANTLR3_BITWORD FOLLOW_atomrel_in_elemvf3396_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_atomrel_in_elemvf3396	= { FOLLOW_atomrel_in_elemvf3396_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_string_in_elemvf3427  */
static	ANTLR3_BITWORD FOLLOW_string_in_elemvf3427_bits[]	= { ANTLR3_UINT64_LIT(0x0000380000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_string_in_elemvf3427	= { FOLLOW_string_in_elemvf3427_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_atomschema_in_elemvf3431  */
static	ANTLR3_BITWORD FOLLOW_atomschema_in_elemvf3431_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_atomschema_in_elemvf3431	= { FOLLOW_atomschema_in_elemvf3431_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_string_in_elemvf3468  */
static	ANTLR3_BITWORD FOLLOW_string_in_elemvf3468_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_string_in_elemvf3468	= { FOLLOW_string_in_elemvf3468_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_atomschema_in_boundparlist3502  */
static	ANTLR3_BITWORD FOLLOW_atomschema_in_boundparlist3502_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_atomschema_in_boundparlist3502	= { FOLLOW_atomschema_in_boundparlist3502_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_52_in_boundparlist3523  */
static	ANTLR3_BITWORD FOLLOW_52_in_boundparlist3523_bits[]	= { ANTLR3_UINT64_LIT(0x0000380000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_52_in_boundparlist3523	= { FOLLOW_52_in_boundparlist3523_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_atomschema_in_boundparlist3529  */
static	ANTLR3_BITWORD FOLLOW_atomschema_in_boundparlist3529_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_atomschema_in_boundparlist3529	= { FOLLOW_atomschema_in_boundparlist3529_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_string_in_stateschema3568  */
static	ANTLR3_BITWORD FOLLOW_string_in_stateschema3568_bits[]	= { ANTLR3_UINT64_LIT(0x0400000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_string_in_stateschema3568	= { FOLLOW_string_in_stateschema3568_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_58_in_stateschema3605  */
static	ANTLR3_BITWORD FOLLOW_58_in_stateschema3605_bits[]	= { ANTLR3_UINT64_LIT(0x0800380000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_58_in_stateschema3605	= { FOLLOW_58_in_stateschema3605_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_atomschema_in_stateschema3618  */
static	ANTLR3_BITWORD FOLLOW_atomschema_in_stateschema3618_bits[]	= { ANTLR3_UINT64_LIT(0x0810000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_atomschema_in_stateschema3618	= { FOLLOW_atomschema_in_stateschema3618_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_52_in_stateschema3652  */
static	ANTLR3_BITWORD FOLLOW_52_in_stateschema3652_bits[]	= { ANTLR3_UINT64_LIT(0x0000380000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_52_in_stateschema3652	= { FOLLOW_52_in_stateschema3652_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_atomschema_in_stateschema3658  */
static	ANTLR3_BITWORD FOLLOW_atomschema_in_stateschema3658_bits[]	= { ANTLR3_UINT64_LIT(0x0810000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_atomschema_in_stateschema3658	= { FOLLOW_atomschema_in_stateschema3658_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_59_in_stateschema3694  */
static	ANTLR3_BITWORD FOLLOW_59_in_stateschema3694_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_59_in_stateschema3694	= { FOLLOW_59_in_stateschema3694_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_string_in_fromstateschema3719  */
static	ANTLR3_BITWORD FOLLOW_string_in_fromstateschema3719_bits[]	= { ANTLR3_UINT64_LIT(0x0400000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_string_in_fromstateschema3719	= { FOLLOW_string_in_fromstateschema3719_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_58_in_fromstateschema3756  */
static	ANTLR3_BITWORD FOLLOW_58_in_fromstateschema3756_bits[]	= { ANTLR3_UINT64_LIT(0x0800380000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_58_in_fromstateschema3756	= { FOLLOW_58_in_fromstateschema3756_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_atomschema_in_fromstateschema3769  */
static	ANTLR3_BITWORD FOLLOW_atomschema_in_fromstateschema3769_bits[]	= { ANTLR3_UINT64_LIT(0x0810000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_atomschema_in_fromstateschema3769	= { FOLLOW_atomschema_in_fromstateschema3769_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_52_in_fromstateschema3803  */
static	ANTLR3_BITWORD FOLLOW_52_in_fromstateschema3803_bits[]	= { ANTLR3_UINT64_LIT(0x0000380000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_52_in_fromstateschema3803	= { FOLLOW_52_in_fromstateschema3803_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_atomschema_in_fromstateschema3809  */
static	ANTLR3_BITWORD FOLLOW_atomschema_in_fromstateschema3809_bits[]	= { ANTLR3_UINT64_LIT(0x0810000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_atomschema_in_fromstateschema3809	= { FOLLOW_atomschema_in_fromstateschema3809_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_59_in_fromstateschema3845  */
static	ANTLR3_BITWORD FOLLOW_59_in_fromstateschema3845_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_59_in_fromstateschema3845	= { FOLLOW_59_in_fromstateschema3845_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_atomschema_in_atomschematuple3873  */
static	ANTLR3_BITWORD FOLLOW_atomschema_in_atomschematuple3873_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_atomschema_in_atomschematuple3873	= { FOLLOW_atomschema_in_atomschematuple3873_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_58_in_atomschematuple3919  */
static	ANTLR3_BITWORD FOLLOW_58_in_atomschematuple3919_bits[]	= { ANTLR3_UINT64_LIT(0x0800380000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_58_in_atomschematuple3919	= { FOLLOW_58_in_atomschematuple3919_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_atomschema_in_atomschematuple3942  */
static	ANTLR3_BITWORD FOLLOW_atomschema_in_atomschematuple3942_bits[]	= { ANTLR3_UINT64_LIT(0x0810000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_atomschema_in_atomschematuple3942	= { FOLLOW_atomschema_in_atomschematuple3942_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_52_in_atomschematuple3976  */
static	ANTLR3_BITWORD FOLLOW_52_in_atomschematuple3976_bits[]	= { ANTLR3_UINT64_LIT(0x0000380000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_52_in_atomschematuple3976	= { FOLLOW_52_in_atomschematuple3976_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_atomschema_in_atomschematuple3982  */
static	ANTLR3_BITWORD FOLLOW_atomschema_in_atomschematuple3982_bits[]	= { ANTLR3_UINT64_LIT(0x0810000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_atomschema_in_atomschematuple3982	= { FOLLOW_atomschema_in_atomschematuple3982_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_59_in_atomschematuple4038  */
static	ANTLR3_BITWORD FOLLOW_59_in_atomschematuple4038_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_59_in_atomschematuple4038	= { FOLLOW_59_in_atomschematuple4038_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NEG_in_actionschema4060  */
static	ANTLR3_BITWORD FOLLOW_NEG_in_actionschema4060_bits[]	= { ANTLR3_UINT64_LIT(0x0000080000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_NEG_in_actionschema4060	= { FOLLOW_NEG_in_actionschema4060_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_smallstr_in_actionschema4068  */
static	ANTLR3_BITWORD FOLLOW_smallstr_in_actionschema4068_bits[]	= { ANTLR3_UINT64_LIT(0x0400380000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_smallstr_in_actionschema4068	= { FOLLOW_smallstr_in_actionschema4068_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_60_in_actionschema4110  */
static	ANTLR3_BITWORD FOLLOW_60_in_actionschema4110_bits[]	= { ANTLR3_UINT64_LIT(0x0000080000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_60_in_actionschema4110	= { FOLLOW_60_in_actionschema4110_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_smallstr_in_actionschema4116  */
static	ANTLR3_BITWORD FOLLOW_smallstr_in_actionschema4116_bits[]	= { ANTLR3_UINT64_LIT(0x0400380000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_smallstr_in_actionschema4116	= { FOLLOW_smallstr_in_actionschema4116_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_atomschematuple_in_actionschema4172  */
static	ANTLR3_BITWORD FOLLOW_atomschematuple_in_actionschema4172_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_atomschematuple_in_actionschema4172	= { FOLLOW_atomschematuple_in_actionschema4172_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TAU_in_actionschema4191  */
static	ANTLR3_BITWORD FOLLOW_TAU_in_actionschema4191_bits[]	= { ANTLR3_UINT64_LIT(0x0400000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_TAU_in_actionschema4191	= { FOLLOW_TAU_in_actionschema4191_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_58_in_actionschema4194  */
static	ANTLR3_BITWORD FOLLOW_58_in_actionschema4194_bits[]	= { ANTLR3_UINT64_LIT(0x0800000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_58_in_actionschema4194	= { FOLLOW_58_in_actionschema4194_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_59_in_actionschema4195  */
static	ANTLR3_BITWORD FOLLOW_59_in_actionschema4195_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_59_in_actionschema4195	= { FOLLOW_59_in_actionschema4195_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_string_in_atomschema4255  */
static	ANTLR3_BITWORD FOLLOW_string_in_atomschema4255_bits[]	= { ANTLR3_UINT64_LIT(0x0400380000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_string_in_atomschema4255	= { FOLLOW_string_in_atomschema4255_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_atomschematuple_in_atomschema4261  */
static	ANTLR3_BITWORD FOLLOW_atomschematuple_in_atomschema4261_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_atomschematuple_in_atomschema4261	= { FOLLOW_atomschematuple_in_atomschema4261_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_smallstr_in_atomschema4291  */
static	ANTLR3_BITWORD FOLLOW_smallstr_in_atomschema4291_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_smallstr_in_atomschema4291	= { FOLLOW_smallstr_in_atomschema4291_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_51_in_relschema4330  */
static	ANTLR3_BITWORD FOLLOW_51_in_relschema4330_bits[]	= { ANTLR3_UINT64_LIT(0x0400380000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_51_in_relschema4330	= { FOLLOW_51_in_relschema4330_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_atomschematuple_in_relschema4337  */
static	ANTLR3_BITWORD FOLLOW_atomschematuple_in_relschema4337_bits[]	= { ANTLR3_UINT64_LIT(0x0030000001000000) };
static  ANTLR3_BITSET_LIST FOLLOW_atomschematuple_in_relschema4337	= { FOLLOW_atomschematuple_in_relschema4337_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_52_in_relschema4358  */
static	ANTLR3_BITWORD FOLLOW_52_in_relschema4358_bits[]	= { ANTLR3_UINT64_LIT(0x0400380000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_52_in_relschema4358	= { FOLLOW_52_in_relschema4358_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_atomschematuple_in_relschema4364  */
static	ANTLR3_BITWORD FOLLOW_atomschematuple_in_relschema4364_bits[]	= { ANTLR3_UINT64_LIT(0x0030000001000000) };
static  ANTLR3_BITSET_LIST FOLLOW_atomschematuple_in_relschema4364	= { FOLLOW_atomschematuple_in_relschema4364_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_OR_in_relschema4389  */
static	ANTLR3_BITWORD FOLLOW_OR_in_relschema4389_bits[]	= { ANTLR3_UINT64_LIT(0x0400380002400030) };
static  ANTLR3_BITSET_LIST FOLLOW_OR_in_relschema4389	= { FOLLOW_OR_in_relschema4389_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_valf_in_relschema4395  */
static	ANTLR3_BITWORD FOLLOW_valf_in_relschema4395_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_valf_in_relschema4395	= { FOLLOW_valf_in_relschema4395_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_53_in_relschema4409  */
static	ANTLR3_BITWORD FOLLOW_53_in_relschema4409_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_53_in_relschema4409	= { FOLLOW_53_in_relschema4409_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_elematomrel_in_atomrel4443  */
static	ANTLR3_BITWORD FOLLOW_elematomrel_in_atomrel4443_bits[]	= { ANTLR3_UINT64_LIT(0x00000000C0000002) };
static  ANTLR3_BITSET_LIST FOLLOW_elematomrel_in_atomrel4443	= { FOLLOW_elematomrel_in_atomrel4443_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PLUS_in_atomrel4461  */
static	ANTLR3_BITWORD FOLLOW_PLUS_in_atomrel4461_bits[]	= { ANTLR3_UINT64_LIT(0x0408380000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_PLUS_in_atomrel4461	= { FOLLOW_PLUS_in_atomrel4461_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_elematomrel_in_atomrel4467  */
static	ANTLR3_BITWORD FOLLOW_elematomrel_in_atomrel4467_bits[]	= { ANTLR3_UINT64_LIT(0x00000000C0000002) };
static  ANTLR3_BITSET_LIST FOLLOW_elematomrel_in_atomrel4467	= { FOLLOW_elematomrel_in_atomrel4467_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_MINUS_in_atomrel4486  */
static	ANTLR3_BITWORD FOLLOW_MINUS_in_atomrel4486_bits[]	= { ANTLR3_UINT64_LIT(0x0408380000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_MINUS_in_atomrel4486	= { FOLLOW_MINUS_in_atomrel4486_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_elematomrel_in_atomrel4492  */
static	ANTLR3_BITWORD FOLLOW_elematomrel_in_atomrel4492_bits[]	= { ANTLR3_UINT64_LIT(0x00000000C0000002) };
static  ANTLR3_BITSET_LIST FOLLOW_elematomrel_in_atomrel4492	= { FOLLOW_elematomrel_in_atomrel4492_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_relschema_in_elematomrel4530  */
static	ANTLR3_BITWORD FOLLOW_relschema_in_elematomrel4530_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_relschema_in_elematomrel4530	= { FOLLOW_relschema_in_elematomrel4530_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_string_in_elematomrel4553  */
static	ANTLR3_BITWORD FOLLOW_string_in_elematomrel4553_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_string_in_elematomrel4553	= { FOLLOW_string_in_elematomrel4553_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_58_in_elematomrel4572  */
static	ANTLR3_BITWORD FOLLOW_58_in_elematomrel4572_bits[]	= { ANTLR3_UINT64_LIT(0x0408380000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_58_in_elematomrel4572	= { FOLLOW_58_in_elematomrel4572_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_atomrel_in_elematomrel4578  */
static	ANTLR3_BITWORD FOLLOW_atomrel_in_elematomrel4578_bits[]	= { ANTLR3_UINT64_LIT(0x0800000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_atomrel_in_elematomrel4578	= { FOLLOW_atomrel_in_elematomrel4578_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_59_in_elematomrel4580  */
static	ANTLR3_BITWORD FOLLOW_59_in_elematomrel4580_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_59_in_elematomrel4580	= { FOLLOW_59_in_elematomrel4580_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SMALLID_in_smallstr4608  */
static	ANTLR3_BITWORD FOLLOW_SMALLID_in_smallstr4608_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_SMALLID_in_smallstr4608	= { FOLLOW_SMALLID_in_smallstr4608_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CAPITID_in_capitstr4635  */
static	ANTLR3_BITWORD FOLLOW_CAPITID_in_capitstr4635_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_CAPITID_in_capitstr4635	= { FOLLOW_CAPITID_in_capitstr4635_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_string4662  */
static	ANTLR3_BITWORD FOLLOW_set_in_string4662_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_string4662	= { FOLLOW_set_in_string4662_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CAPITID_in_synpred1_CPS372  */
static	ANTLR3_BITWORD FOLLOW_CAPITID_in_synpred1_CPS372_bits[]	= { ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_CAPITID_in_synpred1_CPS372	= { FOLLOW_CAPITID_in_synpred1_CPS372_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_50_in_synpred1_CPS373  */
static	ANTLR3_BITWORD FOLLOW_50_in_synpred1_CPS373_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_50_in_synpred1_CPS373	= { FOLLOW_50_in_synpred1_CPS373_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TRUEVF_in_synpred2_CPS3314  */
static	ANTLR3_BITWORD FOLLOW_TRUEVF_in_synpred2_CPS3314_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_TRUEVF_in_synpred2_CPS3314	= { FOLLOW_TRUEVF_in_synpred2_CPS3314_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FALSEVF_in_synpred3_CPS3333  */
static	ANTLR3_BITWORD FOLLOW_FALSEVF_in_synpred3_CPS3333_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FALSEVF_in_synpred3_CPS3333	= { FOLLOW_FALSEVF_in_synpred3_CPS3333_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_string_in_synpred7_CPS4245  */
static	ANTLR3_BITWORD FOLLOW_string_in_synpred7_CPS4245_bits[]	= { ANTLR3_UINT64_LIT(0x0400000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_string_in_synpred7_CPS4245	= { FOLLOW_string_in_synpred7_CPS4245_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_58_in_synpred7_CPS4246  */
static	ANTLR3_BITWORD FOLLOW_58_in_synpred7_CPS4246_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_58_in_synpred7_CPS4246	= { FOLLOW_58_in_synpred7_CPS4246_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_smallstr_in_synpred8_CPS4283  */
static	ANTLR3_BITWORD FOLLOW_smallstr_in_synpred8_CPS4283_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_smallstr_in_synpred8_CPS4283	= { FOLLOW_smallstr_in_synpred8_CPS4283_bits, 1	};
     

 
 
/* ==============================================
 * Parsing rules
 */
/** 
 * $ANTLR start cps
 * cps/CPS.g:185:1: cps : ( ( TYPEVAR '[' valstr= POSINT ']' name= capitstr ) | ( TYPEVAR ( ( CAPITID '=' )=> ( (name= capitstr ) '=' '{' a= smallstr ( ',' a= smallstr )* '}' ) | (name= capitstr ) ) ) | ( ( ATOMVAR | VAR ) '[' valstr= POSINT ']' name= smallstr ':' type= capitstr ) | ( ( ATOMVAR | VAR ) name= smallstr ':' type= capitstr ) | ( ( RELVAR | RELSYM ) '[' valstr= POSINT ']' name= string ':' type1= capitstr ',' type2= capitstr ) | ( ( RELVAR | RELSYM ) name= string ':' type1= capitstr ',' type2= capitstr ) | ( ( VALF | VALC ) name= string '=' v= valf ) | ( ( SSC | PSET ) name= string '=' ss= setschema ) | ( ( LTSC | PLTS ) name= string '=' l= ltsschema ) | ( RELFUNC name= string '=' r= atomrel ) | ( CHANNEL name= smallstr ) ( ':' type= capitstr ( ',' type= capitstr )* )? )* ( ( 'trace refinement:' VERIFY sys= ltsschema AGAINST spec= ltsschema (when= WHEN v= valf )? ) | ( 'alternating simulation:' VERIFY sys= ltsschema AGAINST spec= ltsschema (when= WHEN v= valf )? ) | ( 'compatibility:' VERIFY sys= ltsschema (when= WHEN v= valf )? ) ) ;
 */
static CPSParser_cps_return
cps(pCPSParser ctx)
{   
    CPSParser_cps_return retval;

    pANTLR3_COMMON_TOKEN    valstr;
    pANTLR3_COMMON_TOKEN    when;
    std::string* name;
    #undef	RETURN_TYPE_name
    #define	RETURN_TYPE_name std::string*

    std::string* a;
    #undef	RETURN_TYPE_a
    #define	RETURN_TYPE_a std::string*

    std::string* type;
    #undef	RETURN_TYPE_type
    #define	RETURN_TYPE_type std::string*

    std::string* type1;
    #undef	RETURN_TYPE_type1
    #define	RETURN_TYPE_type1 std::string*

    std::string* type2;
    #undef	RETURN_TYPE_type2
    #define	RETURN_TYPE_type2 std::string*

    ValuationFormula* v;
    #undef	RETURN_TYPE_v
    #define	RETURN_TYPE_v ValuationFormula*

    CPSParser_setschema_return ss;
    #undef	RETURN_TYPE_ss
    #define	RETURN_TYPE_ss CPSParser_setschema_return

    CPSParser_ltsschema_return l;
    #undef	RETURN_TYPE_l
    #define	RETURN_TYPE_l CPSParser_ltsschema_return

    CPSParser_atomrel_return r;
    #undef	RETURN_TYPE_r
    #define	RETURN_TYPE_r CPSParser_atomrel_return

    CPSParser_ltsschema_return sys;
    #undef	RETURN_TYPE_sys
    #define	RETURN_TYPE_sys CPSParser_ltsschema_return

    CPSParser_ltsschema_return spec;
    #undef	RETURN_TYPE_spec
    #define	RETURN_TYPE_spec CPSParser_ltsschema_return

    /* Initialize rule variables
     */


    valstr       = NULL;
    when       = NULL;
    name = NULL;
    a = NULL;
    type = NULL;
    type1 = NULL;
    type2 = NULL;
    v = NULL;
    retval.start = LT(1); retval.stop = retval.start;

    {
        // cps/CPS.g:185:5: ( ( ( TYPEVAR '[' valstr= POSINT ']' name= capitstr ) | ( TYPEVAR ( ( CAPITID '=' )=> ( (name= capitstr ) '=' '{' a= smallstr ( ',' a= smallstr )* '}' ) | (name= capitstr ) ) ) | ( ( ATOMVAR | VAR ) '[' valstr= POSINT ']' name= smallstr ':' type= capitstr ) | ( ( ATOMVAR | VAR ) name= smallstr ':' type= capitstr ) | ( ( RELVAR | RELSYM ) '[' valstr= POSINT ']' name= string ':' type1= capitstr ',' type2= capitstr ) | ( ( RELVAR | RELSYM ) name= string ':' type1= capitstr ',' type2= capitstr ) | ( ( VALF | VALC ) name= string '=' v= valf ) | ( ( SSC | PSET ) name= string '=' ss= setschema ) | ( ( LTSC | PLTS ) name= string '=' l= ltsschema ) | ( RELFUNC name= string '=' r= atomrel ) | ( CHANNEL name= smallstr ) ( ':' type= capitstr ( ',' type= capitstr )* )? )* ( ( 'trace refinement:' VERIFY sys= ltsschema AGAINST spec= ltsschema (when= WHEN v= valf )? ) | ( 'alternating simulation:' VERIFY sys= ltsschema AGAINST spec= ltsschema (when= WHEN v= valf )? ) | ( 'compatibility:' VERIFY sys= ltsschema (when= WHEN v= valf )? ) ) )
        // cps/CPS.g:186:2: ( ( TYPEVAR '[' valstr= POSINT ']' name= capitstr ) | ( TYPEVAR ( ( CAPITID '=' )=> ( (name= capitstr ) '=' '{' a= smallstr ( ',' a= smallstr )* '}' ) | (name= capitstr ) ) ) | ( ( ATOMVAR | VAR ) '[' valstr= POSINT ']' name= smallstr ':' type= capitstr ) | ( ( ATOMVAR | VAR ) name= smallstr ':' type= capitstr ) | ( ( RELVAR | RELSYM ) '[' valstr= POSINT ']' name= string ':' type1= capitstr ',' type2= capitstr ) | ( ( RELVAR | RELSYM ) name= string ':' type1= capitstr ',' type2= capitstr ) | ( ( VALF | VALC ) name= string '=' v= valf ) | ( ( SSC | PSET ) name= string '=' ss= setschema ) | ( ( LTSC | PLTS ) name= string '=' l= ltsschema ) | ( RELFUNC name= string '=' r= atomrel ) | ( CHANNEL name= smallstr ) ( ':' type= capitstr ( ',' type= capitstr )* )? )* ( ( 'trace refinement:' VERIFY sys= ltsschema AGAINST spec= ltsschema (when= WHEN v= valf )? ) | ( 'alternating simulation:' VERIFY sys= ltsschema AGAINST spec= ltsschema (when= WHEN v= valf )? ) | ( 'compatibility:' VERIFY sys= ltsschema (when= WHEN v= valf )? ) )
        {

            // cps/CPS.g:186:2: ( ( TYPEVAR '[' valstr= POSINT ']' name= capitstr ) | ( TYPEVAR ( ( CAPITID '=' )=> ( (name= capitstr ) '=' '{' a= smallstr ( ',' a= smallstr )* '}' ) | (name= capitstr ) ) ) | ( ( ATOMVAR | VAR ) '[' valstr= POSINT ']' name= smallstr ':' type= capitstr ) | ( ( ATOMVAR | VAR ) name= smallstr ':' type= capitstr ) | ( ( RELVAR | RELSYM ) '[' valstr= POSINT ']' name= string ':' type1= capitstr ',' type2= capitstr ) | ( ( RELVAR | RELSYM ) name= string ':' type1= capitstr ',' type2= capitstr ) | ( ( VALF | VALC ) name= string '=' v= valf ) | ( ( SSC | PSET ) name= string '=' ss= setschema ) | ( ( LTSC | PLTS ) name= string '=' l= ltsschema ) | ( RELFUNC name= string '=' r= atomrel ) | ( CHANNEL name= smallstr ) ( ':' type= capitstr ( ',' type= capitstr )* )? )*

            for (;;)
            {
                int alt5=12;
                switch ( LA(1) ) 
                {
                case TYPEVAR:
                	{
                		switch ( LA(2) ) 
                		{
                		case 48:
                			{
                				alt5=1;
                			}
                		    break;
                		case CAPITID:
                			{
                				alt5=2;
                			}
                		    break;

                		}

                	}
                    break;
                case ATOMVAR:
                case VAR:
                	{
                		switch ( LA(2) ) 
                		{
                		case 48:
                			{
                				alt5=3;
                			}
                		    break;
                		case SMALLID:
                			{
                				alt5=4;
                			}
                		    break;

                		}

                	}
                    break;
                case RELVAR:
                case RELSYM:
                	{
                		switch ( LA(2) ) 
                		{
                		case 48:
                			{
                				alt5=5;
                			}
                		    break;
                		case SMALLID:
                		case CAPITID:
                		case CAPITNUMID:
                			{
                				alt5=6;
                			}
                		    break;

                		}

                	}
                    break;
                case VALF:
                case VALC:
                	{
                		alt5=7;
                	}
                    break;
                case SSC:
                case PSET:
                	{
                		alt5=8;
                	}
                    break;
                case LTSC:
                case PLTS:
                	{
                		alt5=9;
                	}
                    break;
                case RELFUNC:
                	{
                		alt5=10;
                	}
                    break;
                case CHANNEL:
                	{
                		alt5=11;
                	}
                    break;

                }

                switch (alt5) 
                {
            	case 1:
            	    // cps/CPS.g:187:2: ( TYPEVAR '[' valstr= POSINT ']' name= capitstr )
            	    {
            	        // cps/CPS.g:187:2: ( TYPEVAR '[' valstr= POSINT ']' name= capitstr )
            	        // cps/CPS.g:187:3: TYPEVAR '[' valstr= POSINT ']' name= capitstr
            	        {
            	             MATCHT(TYPEVAR, &FOLLOW_TYPEVAR_in_cps310); 
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	             MATCHT(48, &FOLLOW_48_in_cps311); 
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	            valstr = (pANTLR3_COMMON_TOKEN) MATCHT(POSINT, &FOLLOW_POSINT_in_cps315); 
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	             MATCHT(49, &FOLLOW_49_in_cps317); 
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	            FOLLOWPUSH(FOLLOW_capitstr_in_cps321);
            	            name=capitstr(ctx);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }

            	        }

            	        if ( BACKTRACKING==0 ) 
            	        {

            	                            if(name == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "String expected.\n";
            	                            }
            	                            else if (!context.isNotDefined(name))
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Identifier " << *(name) << " is already defined.\n";
            	                            }
            	                            else
            	            		{
            	                                int id = atoi((char*)(((valstr->getText(valstr)))->chars));
            	                                context.insertTypeVariable(name, id);
            	            		
            	                                #ifdef DEBUG
            	                                std::cout << "new type variable: " <<* name << std::endl;
            	                                #endif
            	            		}
            	                            delete name;
            	                        
            	        }

            	    }
            	    break;
            	case 2:
            	    // cps/CPS.g:210:4: ( TYPEVAR ( ( CAPITID '=' )=> ( (name= capitstr ) '=' '{' a= smallstr ( ',' a= smallstr )* '}' ) | (name= capitstr ) ) )
            	    {
            	        // cps/CPS.g:210:4: ( TYPEVAR ( ( CAPITID '=' )=> ( (name= capitstr ) '=' '{' a= smallstr ( ',' a= smallstr )* '}' ) | (name= capitstr ) ) )
            	        // cps/CPS.g:210:5: TYPEVAR ( ( CAPITID '=' )=> ( (name= capitstr ) '=' '{' a= smallstr ( ',' a= smallstr )* '}' ) | (name= capitstr ) )
            	        {
            	             MATCHT(TYPEVAR, &FOLLOW_TYPEVAR_in_cps342); 
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }

            	            // cps/CPS.g:211:13: ( ( CAPITID '=' )=> ( (name= capitstr ) '=' '{' a= smallstr ( ',' a= smallstr )* '}' ) | (name= capitstr ) )
            	            {
            	                int alt2=2;
            	                switch ( LA(1) ) 
            	                {
            	                case CAPITID:
            	                	{

            	                		{
            	                		    int LA2_1 = LA(2);
            	                		    if ( (((LA2_1 >= ATOMVAR) && (LA2_1 <= PLTS)) || LA2_1 == RELFUNC || LA2_1 == CHANNEL || ((LA2_1 >= 55) && (LA2_1 <= 57))) ) 
            	                		    {
            	                		        alt2=2;
            	                		    }
            	                		    else if ( (LA2_1 == 50) && (synpred1_CPS(ctx))) 
            	                		    {
            	                		        alt2=1;
            	                		    }
            	                		    else 
            	                		    {
            	                		        if (BACKTRACKING>0)
            	                		        {
            	                		            FAILEDFLAG = ANTLR3_TRUE;
            	                		            return retval;
            	                		        }
            	                		    
            	                		        CONSTRUCTEX();
            	                		        EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	                		        EXCEPTION->message      = (void *)"";
            	                		        EXCEPTION->decisionNum  = 2;
            	                		        EXCEPTION->state        = 1;


            	                		        goto rulecpsEx;
            	                		    }
            	                		}
            	                	}
            	                    break;

            	                default:
            	                    if (BACKTRACKING>0)
            	                    {
            	                        FAILEDFLAG = ANTLR3_TRUE;
            	                        return retval;
            	                    }
            	                    CONSTRUCTEX();
            	                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	                    EXCEPTION->message      = (void *)"";
            	                    EXCEPTION->decisionNum  = 2;
            	                    EXCEPTION->state        = 0;


            	                    goto rulecpsEx;
            	                }

            	                switch (alt2) 
            	                {
            	            	case 1:
            	            	    // cps/CPS.g:212:13: ( CAPITID '=' )=> ( (name= capitstr ) '=' '{' a= smallstr ( ',' a= smallstr )* '}' )
            	            	    {
            	            	        // cps/CPS.g:213:13: ( (name= capitstr ) '=' '{' a= smallstr ( ',' a= smallstr )* '}' )
            	            	        // cps/CPS.g:214:13: (name= capitstr ) '=' '{' a= smallstr ( ',' a= smallstr )* '}'
            	            	        {
            	            	            // cps/CPS.g:214:13: (name= capitstr )
            	            	            // cps/CPS.g:214:14: name= capitstr
            	            	            {
            	            	                FOLLOWPUSH(FOLLOW_capitstr_in_cps409);
            	            	                name=capitstr(ctx);

            	            	                FOLLOWPOP();
            	            	                if  (HASEXCEPTION())
            	            	                {
            	            	                    goto rulecpsEx;
            	            	                }
            	            	                if (HASFAILED())
            	            	                {
            	            	                    return retval;
            	            	                }

            	            	            }

            	            	             MATCHT(50, &FOLLOW_50_in_cps412); 
            	            	            if  (HASEXCEPTION())
            	            	            {
            	            	                goto rulecpsEx;
            	            	            }
            	            	            if (HASFAILED())
            	            	            {
            	            	                return retval;
            	            	            }
            	            	             MATCHT(51, &FOLLOW_51_in_cps414); 
            	            	            if  (HASEXCEPTION())
            	            	            {
            	            	                goto rulecpsEx;
            	            	            }
            	            	            if (HASFAILED())
            	            	            {
            	            	                return retval;
            	            	            }
            	            	            if ( BACKTRACKING==0 ) 
            	            	            {

            	            	                                if(name == 0)
            	            	                                {
            	            	                                    printPosition(retval.start);
            	            	                                    std::cout << "String expected.\n";
            	            	                                }
            	            	                                else if (!context.isNotDefined(name))
            	            	                                {
            	            	                                    printPosition(retval.start);
            	            	                                    std::cout << "Identifier " << *(name) << " is already defined.\n";
            	            	                                }
            	            	                                else
            	            	                		{
            	            	                                    context.insertFiniteType(name);

            	            	                                    #ifdef DEBUG
            	            	                                    std::cout << "new finite type: " << *name << std::endl;
            	            	                                    #endif
            	            	                                }
            	            	                                delete name;
            	            	                            
            	            	            }
            	            	            FOLLOWPUSH(FOLLOW_smallstr_in_cps446);
            	            	            a=smallstr(ctx);

            	            	            FOLLOWPOP();
            	            	            if  (HASEXCEPTION())
            	            	            {
            	            	                goto rulecpsEx;
            	            	            }
            	            	            if (HASFAILED())
            	            	            {
            	            	                return retval;
            	            	            }
            	            	            if ( BACKTRACKING==0 ) 
            	            	            {

            	            	                                if(!context.isNotDefined(a))
            	            	                                {
            	            	                                    printPosition(retval.start);
            	            	                                    std::cout << "Identifier " << *(a) << " already defined.\n";
            	            	                                }
            	            	                                else
            	            	                                {                    
            	            	                                    context.insertAtom(a);
            	            	                                }
            	            	                                delete a;
            	            	                            
            	            	            }

            	            	            // cps/CPS.g:249:13: ( ',' a= smallstr )*

            	            	            for (;;)
            	            	            {
            	            	                int alt1=2;
            	            	                switch ( LA(1) ) 
            	            	                {
            	            	                case 52:
            	            	                	{
            	            	                		alt1=1;
            	            	                	}
            	            	                    break;

            	            	                }

            	            	                switch (alt1) 
            	            	                {
            	            	            	case 1:
            	            	            	    // cps/CPS.g:250:13: ',' a= smallstr
            	            	            	    {
            	            	            	         MATCHT(52, &FOLLOW_52_in_cps488); 
            	            	            	        if  (HASEXCEPTION())
            	            	            	        {
            	            	            	            goto rulecpsEx;
            	            	            	        }
            	            	            	        if (HASFAILED())
            	            	            	        {
            	            	            	            return retval;
            	            	            	        }
            	            	            	        FOLLOWPUSH(FOLLOW_smallstr_in_cps494);
            	            	            	        a=smallstr(ctx);

            	            	            	        FOLLOWPOP();
            	            	            	        if  (HASEXCEPTION())
            	            	            	        {
            	            	            	            goto rulecpsEx;
            	            	            	        }
            	            	            	        if (HASFAILED())
            	            	            	        {
            	            	            	            return retval;
            	            	            	        }
            	            	            	        if ( BACKTRACKING==0 ) 
            	            	            	        {

            	            	            	                            if(!context.isNotDefined(a))
            	            	            	                            {
            	            	            	                                printPosition(retval.start);
            	            	            	                                std::cout << "Identifier " << *(a) << " already defined.\n";
            	            	            	                            }
            	            	            	                            else 
            	            	            	                            {                    
            	            	            	                                context.insertAtom(a);
            	            	            	                            }
            	            	            	                            delete a;
            	            	            	                        
            	            	            	        }

            	            	            	    }
            	            	            	    break;

            	            	            	default:
            	            	            	    goto loop1;	/* break out of the loop */
            	            	            	    break;
            	            	                }
            	            	            }
            	            	            loop1: ; /* Jump out to here if this rule does not match */

            	            	             MATCHT(53, &FOLLOW_53_in_cps537); 
            	            	            if  (HASEXCEPTION())
            	            	            {
            	            	                goto rulecpsEx;
            	            	            }
            	            	            if (HASFAILED())
            	            	            {
            	            	                return retval;
            	            	            }
            	            	            if ( BACKTRACKING==0 ) 
            	            	            {

            	            	                                    context.finiteTypeInserted();
            	            	                                
            	            	            }

            	            	        }


            	            	    }
            	            	    break;
            	            	case 2:
            	            	    // cps/CPS.g:270:13: (name= capitstr )
            	            	    {
            	            	        // cps/CPS.g:270:13: (name= capitstr )
            	            	        // cps/CPS.g:271:13: name= capitstr
            	            	        {
            	            	            FOLLOWPUSH(FOLLOW_capitstr_in_cps614);
            	            	            name=capitstr(ctx);

            	            	            FOLLOWPOP();
            	            	            if  (HASEXCEPTION())
            	            	            {
            	            	                goto rulecpsEx;
            	            	            }
            	            	            if (HASFAILED())
            	            	            {
            	            	                return retval;
            	            	            }
            	            	            if ( BACKTRACKING==0 ) 
            	            	            {

            	            	                                if(name == 0)
            	            	                                {
            	            	                                    printPosition(retval.start);
            	            	                                    std::cout << "String expected.\n";
            	            	                                }
            	            	                                else if (!context.isNotDefined(name))
            	            	                                {
            	            	                                    printPosition(retval.start);
            	            	                                    std::cout << "Identifier " << *(name) << " is already defined.\n";
            	            	                                }
            	            	                                else
            	            	                                {
            	            	                                    context.insertTypeVariable(name, std::numeric_limits<int>::max());

            	            	                                    #ifdef DEBUG
            	            	                                    std::cout << "new type variable: " << *name << std::endl;
            	            	                                    #endif
            	            	                                }
            	            	                                delete name;
            	            	                            
            	            	            }

            	            	        }


            	            	    }
            	            	    break;

            	                }
            	            }

            	        }


            	    }
            	    break;
            	case 3:
            	    // cps/CPS.g:296:4: ( ( ATOMVAR | VAR ) '[' valstr= POSINT ']' name= smallstr ':' type= capitstr )
            	    {
            	        // cps/CPS.g:296:4: ( ( ATOMVAR | VAR ) '[' valstr= POSINT ']' name= smallstr ':' type= capitstr )
            	        // cps/CPS.g:296:5: ( ATOMVAR | VAR ) '[' valstr= POSINT ']' name= smallstr ':' type= capitstr
            	        {
            	            if ( ((LA(1) >= ATOMVAR) && (LA(1) <= VAR)) )
            	            {
            	                CONSUME();
            	                PERRORRECOVERY=ANTLR3_FALSE;FAILEDFLAG=ANTLR3_FALSE;

            	            }
            	            else 
            	            {
            	                if (BACKTRACKING>0)
            	                {
            	                    FAILEDFLAG = ANTLR3_TRUE;
            	                    return retval;
            	                }
            	                CONSTRUCTEX();
            	                EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            	                EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
            	                EXCEPTION->expectingSet = &FOLLOW_set_in_cps672;
            	                RECOVERFROMMISMATCHEDSET(&FOLLOW_set_in_cps672);    goto rulecpsEx;
            	            }

            	             MATCHT(48, &FOLLOW_48_in_cps679); 
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	            valstr = (pANTLR3_COMMON_TOKEN) MATCHT(POSINT, &FOLLOW_POSINT_in_cps685); 
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	             MATCHT(49, &FOLLOW_49_in_cps687); 
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	            FOLLOWPUSH(FOLLOW_smallstr_in_cps691);
            	            name=smallstr(ctx);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	             MATCHT(54, &FOLLOW_54_in_cps693); 
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	            FOLLOWPUSH(FOLLOW_capitstr_in_cps699);
            	            type=capitstr(ctx);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }

            	        }

            	        if ( BACKTRACKING==0 ) 
            	        {

            	                            if(name == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "String expected.\n";
            	                            }
            	                            else if (type == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Type expected.\n";
            	                            }
            	                            else if (!context.isNotDefined(name))
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Identifier " << *(name) << " is already defined.\n";
            	                            }
            	                            else if (!context.isTypeVariable(type))
            	                            {   
            	                                printPosition(retval.start);
            	                                std::cout << "Identifier " << *(type) << " is not a type.\n";
            	                            }
            	                            else
            	            		{
            	                                int id = atoi((char*)(((valstr->getText(valstr)))->chars));
            	                                context.insertAtomVariable(name, type, id);

            	                                #ifdef DEBUG
            	                                std::cout << "new atom variable: " << *name << " of type " << *type << std::endl;
            	                                #endif
            	            		}
            	            		delete name;
            	            		delete type;
            	                        
            	        }

            	    }
            	    break;
            	case 4:
            	    // cps/CPS.g:330:4: ( ( ATOMVAR | VAR ) name= smallstr ':' type= capitstr )
            	    {
            	        // cps/CPS.g:330:4: ( ( ATOMVAR | VAR ) name= smallstr ':' type= capitstr )
            	        // cps/CPS.g:330:5: ( ATOMVAR | VAR ) name= smallstr ':' type= capitstr
            	        {
            	            if ( ((LA(1) >= ATOMVAR) && (LA(1) <= VAR)) )
            	            {
            	                CONSUME();
            	                PERRORRECOVERY=ANTLR3_FALSE;FAILEDFLAG=ANTLR3_FALSE;

            	            }
            	            else 
            	            {
            	                if (BACKTRACKING>0)
            	                {
            	                    FAILEDFLAG = ANTLR3_TRUE;
            	                    return retval;
            	                }
            	                CONSTRUCTEX();
            	                EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            	                EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
            	                EXCEPTION->expectingSet = &FOLLOW_set_in_cps720;
            	                RECOVERFROMMISMATCHEDSET(&FOLLOW_set_in_cps720);    goto rulecpsEx;
            	            }

            	            FOLLOWPUSH(FOLLOW_smallstr_in_cps730);
            	            name=smallstr(ctx);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	             MATCHT(54, &FOLLOW_54_in_cps732); 
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	            FOLLOWPUSH(FOLLOW_capitstr_in_cps738);
            	            type=capitstr(ctx);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }

            	        }

            	        if ( BACKTRACKING==0 ) 
            	        {

            	                            if(name == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "String expected.\n";
            	                            }
            	                            else if (type == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Type expected.\n";
            	                            }
            	                            else if (!context.isNotDefined(name))
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Identifier " << *(name) << " is already defined.\n";
            	                            }
            	                            else if (!context.isTypeVariable(type) && !context.isFiniteType(type))
            	                            {   
            	                                printPosition(retval.start);
            	                                std::cout << "Identifier " << *(type) << " is not a type.\n";
            	                            }
            	                            else
            	            		{
            	                                context.insertAtomVariable(name, type, std::numeric_limits<int>::max());

            	                                #ifdef DEBUG
            	                                std::cout << "new atom variable: " << *name << " of type " << *type << std::endl;
            	                                #endif
            	                            }

            	            		delete name;
            	            		delete type;
            	                        
            	        }

            	    }
            	    break;
            	case 5:
            	    // cps/CPS.g:364:4: ( ( RELVAR | RELSYM ) '[' valstr= POSINT ']' name= string ':' type1= capitstr ',' type2= capitstr )
            	    {
            	        // cps/CPS.g:364:4: ( ( RELVAR | RELSYM ) '[' valstr= POSINT ']' name= string ':' type1= capitstr ',' type2= capitstr )
            	        // cps/CPS.g:364:5: ( RELVAR | RELSYM ) '[' valstr= POSINT ']' name= string ':' type1= capitstr ',' type2= capitstr
            	        {
            	            if ( ((LA(1) >= RELVAR) && (LA(1) <= RELSYM)) )
            	            {
            	                CONSUME();
            	                PERRORRECOVERY=ANTLR3_FALSE;FAILEDFLAG=ANTLR3_FALSE;

            	            }
            	            else 
            	            {
            	                if (BACKTRACKING>0)
            	                {
            	                    FAILEDFLAG = ANTLR3_TRUE;
            	                    return retval;
            	                }
            	                CONSTRUCTEX();
            	                EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            	                EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
            	                EXCEPTION->expectingSet = &FOLLOW_set_in_cps759;
            	                RECOVERFROMMISMATCHEDSET(&FOLLOW_set_in_cps759);    goto rulecpsEx;
            	            }

            	             MATCHT(48, &FOLLOW_48_in_cps766); 
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	            valstr = (pANTLR3_COMMON_TOKEN) MATCHT(POSINT, &FOLLOW_POSINT_in_cps771); 
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	             MATCHT(49, &FOLLOW_49_in_cps773); 
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	            FOLLOWPUSH(FOLLOW_string_in_cps777);
            	            name=string(ctx);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	             MATCHT(54, &FOLLOW_54_in_cps779); 
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	            FOLLOWPUSH(FOLLOW_capitstr_in_cps785);
            	            type1=capitstr(ctx);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	             MATCHT(52, &FOLLOW_52_in_cps787); 
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	            FOLLOWPUSH(FOLLOW_capitstr_in_cps793);
            	            type2=capitstr(ctx);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }

            	        }

            	        if ( BACKTRACKING==0 ) 
            	        {

            	                            if(name == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "String expected.\n";
            	                            }
            	                            else if (type1 == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Type expected.\n";
            	                            }
            	                            else if (type2 == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Type expected.\n";
            	                            }
            	                            else if (!context.isNotDefined(name))
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Identifier " << *(name) << " is already defined.\n";
            	                            }
            	                            else if (!context.isTypeVariable(type1))
            	                            {   
            	                                printPosition(retval.start);
            	                                std::cout << "Identifier " << *(type1) << " is not a type.\n";
            	                            }
            	                            else if (!context.isTypeVariable(type2))
            	                            {   
            	                                printPosition(retval.start);
            	                                std::cout << "Identifier " << *(type2) << " is not a type.\n";
            	                            }
            	                            else
            	            		{
            	                                int id = atoi((char*)(((valstr->getText(valstr)))->chars));
            	                                context.insertRelationVariable(name, type1, type2, id);

            	                                #ifdef DEBUG
            	                                std::cout << "new relation variable: " << *name << " of type " << *type1 << " x " << *type2 << std::endl;
            	                                #endif
            	                            }
            	            		delete name;
            	            		delete type1;
            	            		delete type2;
            	                        
            	        }

            	    }
            	    break;
            	case 6:
            	    // cps/CPS.g:409:4: ( ( RELVAR | RELSYM ) name= string ':' type1= capitstr ',' type2= capitstr )
            	    {
            	        // cps/CPS.g:409:4: ( ( RELVAR | RELSYM ) name= string ':' type1= capitstr ',' type2= capitstr )
            	        // cps/CPS.g:409:5: ( RELVAR | RELSYM ) name= string ':' type1= capitstr ',' type2= capitstr
            	        {
            	            if ( ((LA(1) >= RELVAR) && (LA(1) <= RELSYM)) )
            	            {
            	                CONSUME();
            	                PERRORRECOVERY=ANTLR3_FALSE;FAILEDFLAG=ANTLR3_FALSE;

            	            }
            	            else 
            	            {
            	                if (BACKTRACKING>0)
            	                {
            	                    FAILEDFLAG = ANTLR3_TRUE;
            	                    return retval;
            	                }
            	                CONSTRUCTEX();
            	                EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            	                EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
            	                EXCEPTION->expectingSet = &FOLLOW_set_in_cps814;
            	                RECOVERFROMMISMATCHEDSET(&FOLLOW_set_in_cps814);    goto rulecpsEx;
            	            }

            	            FOLLOWPUSH(FOLLOW_string_in_cps824);
            	            name=string(ctx);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	             MATCHT(54, &FOLLOW_54_in_cps826); 
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	            FOLLOWPUSH(FOLLOW_capitstr_in_cps832);
            	            type1=capitstr(ctx);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	             MATCHT(52, &FOLLOW_52_in_cps834); 
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	            FOLLOWPUSH(FOLLOW_capitstr_in_cps840);
            	            type2=capitstr(ctx);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }

            	        }

            	        if ( BACKTRACKING==0 ) 
            	        {

            	                            if(name == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "String expected.\n";
            	                            }
            	                            else if (type1 == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Type expected.\n";
            	                            }
            	                            else if (type2 == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Type expected.\n";
            	                            }
            	                            else if (!context.isNotDefined(name))
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Identifier " << *(name) << " is already defined.\n";
            	                            }
            	                            else if (!context.isTypeVariable(type1))
            	                            {   
            	                                printPosition(retval.start);
            	                                std::cout << "Identifier " << *(type1) << " is not a type.\n";
            	                            }
            	                            else if (!context.isTypeVariable(type2))
            	                            {   
            	                                printPosition(retval.start);
            	                                std::cout << "Identifier " << *(type2) << " is not a type.\n";
            	                            }
            	                            else
            	            		{
            	                                context.insertRelationVariable(name, type1, type2, std::numeric_limits<int>::max());

            	                                #ifdef DEBUG
            	                                std::cout << "new relation variable: " << *name << " of type " << *type1 << " x " << *type2 << std::endl;
            	                                #endif
            	                            }
            	            		delete name;
            	            		delete type1;
            	            		delete type2;
            	                        
            	        }

            	    }
            	    break;
            	case 7:
            	    // cps/CPS.g:453:4: ( ( VALF | VALC ) name= string '=' v= valf )
            	    {
            	        // cps/CPS.g:453:4: ( ( VALF | VALC ) name= string '=' v= valf )
            	        // cps/CPS.g:453:5: ( VALF | VALC ) name= string '=' v= valf
            	        {
            	            if ( ((LA(1) >= VALF) && (LA(1) <= VALC)) )
            	            {
            	                CONSUME();
            	                PERRORRECOVERY=ANTLR3_FALSE;FAILEDFLAG=ANTLR3_FALSE;

            	            }
            	            else 
            	            {
            	                if (BACKTRACKING>0)
            	                {
            	                    FAILEDFLAG = ANTLR3_TRUE;
            	                    return retval;
            	                }
            	                CONSTRUCTEX();
            	                EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            	                EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
            	                EXCEPTION->expectingSet = &FOLLOW_set_in_cps861;
            	                RECOVERFROMMISMATCHEDSET(&FOLLOW_set_in_cps861);    goto rulecpsEx;
            	            }

            	            FOLLOWPUSH(FOLLOW_string_in_cps871);
            	            name=string(ctx);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	             MATCHT(50, &FOLLOW_50_in_cps873); 
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	            FOLLOWPUSH(FOLLOW_valf_in_cps879);
            	            v=valf(ctx);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }

            	        }

            	        if ( BACKTRACKING==0 ) 
            	        {

            	                            if(name == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "String expected.\n";
            	                            }
            	                            else if(v == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Valuation constraint expected.\n";
            	                            }
            	                            else if(!context.isNotDefined(name))
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Identifier " << *(name) << " is already defined.\n";
            	                            }
            	                            else
            	            		{
            	                                context.insertValuationFormula(name, v);

            	                                #ifdef DEBUG
            	                                std::cout << "new valuation formula: " << *name << " = " << v->toString(context) << std::endl;
            	                                #endif
            	                            }
            	                		delete name;
            	                        
            	        }

            	    }
            	    break;
            	case 8:
            	    // cps/CPS.g:480:4: ( ( SSC | PSET ) name= string '=' ss= setschema )
            	    {
            	        // cps/CPS.g:480:4: ( ( SSC | PSET ) name= string '=' ss= setschema )
            	        // cps/CPS.g:480:5: ( SSC | PSET ) name= string '=' ss= setschema
            	        {
            	            if ( ((LA(1) >= SSC) && (LA(1) <= PSET)) )
            	            {
            	                CONSUME();
            	                PERRORRECOVERY=ANTLR3_FALSE;FAILEDFLAG=ANTLR3_FALSE;

            	            }
            	            else 
            	            {
            	                if (BACKTRACKING>0)
            	                {
            	                    FAILEDFLAG = ANTLR3_TRUE;
            	                    return retval;
            	                }
            	                CONSTRUCTEX();
            	                EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            	                EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
            	                EXCEPTION->expectingSet = &FOLLOW_set_in_cps900;
            	                RECOVERFROMMISMATCHEDSET(&FOLLOW_set_in_cps900);    goto rulecpsEx;
            	            }

            	            FOLLOWPUSH(FOLLOW_string_in_cps910);
            	            name=string(ctx);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	             MATCHT(50, &FOLLOW_50_in_cps912); 
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	            FOLLOWPUSH(FOLLOW_setschema_in_cps918);
            	            ss=setschema(ctx);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }

            	        }

            	        if ( BACKTRACKING==0 ) 
            	        {

            	                            if(name == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "String expected.\n";
            	                            }
            	                            else if (ss.ssc == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Parametrised set expected.\n";
            	                            }
            	                            else if (!context.isNotDefined(name))
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Identifier " << *(name) << " is already defined.\n";
            	                            }
            	                            else
            	            		{
            	                                context.insertSetSchema(name, ss.ssc);

            	                                #ifdef DEBUG
            	                                std::cout << "new set schema: " << *name << " = " << ss.ssc->toString(context) << std::endl;
            	                                #endif
            	                            }
            	                		delete name;
            	                        
            	        }

            	    }
            	    break;
            	case 9:
            	    // cps/CPS.g:507:4: ( ( LTSC | PLTS ) name= string '=' l= ltsschema )
            	    {
            	        // cps/CPS.g:507:4: ( ( LTSC | PLTS ) name= string '=' l= ltsschema )
            	        // cps/CPS.g:507:5: ( LTSC | PLTS ) name= string '=' l= ltsschema
            	        {
            	            if ( ((LA(1) >= LTSC) && (LA(1) <= PLTS)) )
            	            {
            	                CONSUME();
            	                PERRORRECOVERY=ANTLR3_FALSE;FAILEDFLAG=ANTLR3_FALSE;

            	            }
            	            else 
            	            {
            	                if (BACKTRACKING>0)
            	                {
            	                    FAILEDFLAG = ANTLR3_TRUE;
            	                    return retval;
            	                }
            	                CONSTRUCTEX();
            	                EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            	                EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
            	                EXCEPTION->expectingSet = &FOLLOW_set_in_cps939;
            	                RECOVERFROMMISMATCHEDSET(&FOLLOW_set_in_cps939);    goto rulecpsEx;
            	            }

            	            FOLLOWPUSH(FOLLOW_string_in_cps949);
            	            name=string(ctx);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	             MATCHT(50, &FOLLOW_50_in_cps951); 
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	            FOLLOWPUSH(FOLLOW_ltsschema_in_cps957);
            	            l=ltsschema(ctx);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }

            	        }

            	        if ( BACKTRACKING==0 ) 
            	        {

            	                            if(name == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "String expected.\n";
            	                            }
            	                            else if (l.ltsc == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Parametrised LTS expected.\n";
            	                            }
            	                            else if (!context.isNotDefined(name))
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Identifier " << *(name) << " is already defined.\n";
            	                            }
            	                            else
            	            		{
            	                                context.insertLTSSchema(name, l.ltsc);

            	                                #ifdef DEBUG
            	                                std::cout << "new lts schema: " << *name << " = " << l.ltsc->toString(context) << std::endl;
            	                                #endif
            	                            }
            	                		delete name;
            	                        
            	        }

            	    }
            	    break;
            	case 10:
            	    // cps/CPS.g:534:4: ( RELFUNC name= string '=' r= atomrel )
            	    {
            	        // cps/CPS.g:534:4: ( RELFUNC name= string '=' r= atomrel )
            	        // cps/CPS.g:534:5: RELFUNC name= string '=' r= atomrel
            	        {
            	             MATCHT(RELFUNC, &FOLLOW_RELFUNC_in_cps978); 
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	            FOLLOWPUSH(FOLLOW_string_in_cps982);
            	            name=string(ctx);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	             MATCHT(50, &FOLLOW_50_in_cps984); 
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	            FOLLOWPUSH(FOLLOW_atomrel_in_cps990);
            	            r=atomrel(ctx);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }

            	        }

            	        if ( BACKTRACKING==0 ) 
            	        {

            	                            if(name == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "String expected.\n";
            	                            }
            	                            else if (r.rel == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Relation expected.\n";
            	                            }
            	                            else if (!context.isNotDefined(name))
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Identifier " << *(name) << " is already defined.\n";
            	                            }
            	                            else
            	            		{
            	                                context.insertAtomRelation(name, r.rel);

            	                                #ifdef DEBUG
            	                                std::cout << "new relation/function: " << *name << " = " << r.rel->toString(context) << std::endl;
            	                                #endif
            	                            }
            	                		delete name;
            	                		
            	        }

            	    }
            	    break;
            	case 11:
            	    // cps/CPS.g:561:8: ( CHANNEL name= smallstr ) ( ':' type= capitstr ( ',' type= capitstr )* )?
            	    {
            	        // cps/CPS.g:561:8: ( CHANNEL name= smallstr )
            	        // cps/CPS.g:561:9: CHANNEL name= smallstr
            	        {
            	             MATCHT(CHANNEL, &FOLLOW_CHANNEL_in_cps1015); 
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	            FOLLOWPUSH(FOLLOW_smallstr_in_cps1019);
            	            name=smallstr(ctx);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }

            	        }

            	        if ( BACKTRACKING==0 ) 
            	        {

            	                            if(name == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "String expected.\n";
            	                            }
            	                            else if (!context.isNotDefined(name))
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Identifier " << *(name) << " is already defined.\n";
            	                            }
            	                            else
            	                            {
            	                                context.insertChannel(name);

            	                                #ifdef DEBUG
            	                                std::cout << "new channel: " << *name;
            	                                #endif
            	                		}
            	                		delete name;
            	                        
            	        }

            	        // cps/CPS.g:583:13: ( ':' type= capitstr ( ',' type= capitstr )* )?
            	        {
            	            int alt4=2;
            	            switch ( LA(1) ) 
            	            {
            	                case 54:
            	                	{
            	                		alt4=1;
            	                	}
            	                    break;
            	            }

            	            switch (alt4) 
            	            {
            	        	case 1:
            	        	    // cps/CPS.g:583:14: ':' type= capitstr ( ',' type= capitstr )*
            	        	    {
            	        	         MATCHT(54, &FOLLOW_54_in_cps1049); 
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulecpsEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return retval;
            	        	        }
            	        	        FOLLOWPUSH(FOLLOW_capitstr_in_cps1067);
            	        	        type=capitstr(ctx);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulecpsEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return retval;
            	        	        }
            	        	        if ( BACKTRACKING==0 ) 
            	        	        {

            	        	                            if(type == 0)
            	        	                            {
            	        	                                printPosition(retval.start);
            	        	                                std::cout << "Type expected.\n";
            	        	                            }
            	        	                            else if (!context.isTypeVariable(type) && !context.isFiniteType(type))
            	        	                            {
            	        	                                printPosition(retval.start);
            	        	                                std::cout << "Type expected.\n";
            	        	                            }
            	        	                            else
            	        	                            {
            	        	                                context.appendChannelType(type);

            	        	                                #ifdef DEBUG
            	        	                                std::cout << " of type " << *type;
            	        	                                #endif
            	        	                            }
            	        	            		delete type;
            	        	                        
            	        	        }

            	        	        // cps/CPS.g:606:13: ( ',' type= capitstr )*

            	        	        for (;;)
            	        	        {
            	        	            int alt3=2;
            	        	            switch ( LA(1) ) 
            	        	            {
            	        	            case 52:
            	        	            	{
            	        	            		alt3=1;
            	        	            	}
            	        	                break;

            	        	            }

            	        	            switch (alt3) 
            	        	            {
            	        	        	case 1:
            	        	        	    // cps/CPS.g:606:14: ',' type= capitstr
            	        	        	    {
            	        	        	         MATCHT(52, &FOLLOW_52_in_cps1096); 
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulecpsEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return retval;
            	        	        	        }
            	        	        	        FOLLOWPUSH(FOLLOW_capitstr_in_cps1102);
            	        	        	        type=capitstr(ctx);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulecpsEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return retval;
            	        	        	        }
            	        	        	        if ( BACKTRACKING==0 ) 
            	        	        	        {

            	        	        	                            if(type == 0)
            	        	        	                            {
            	        	        	                                printPosition(retval.start);
            	        	        	                                std::cout << "Type expected.\n";
            	        	        	                            }
            	        	        	                            else if (!context.isTypeVariable(type) && !context.isFiniteType(type))
            	        	        	                            {
            	        	        	                                printPosition(retval.start);
            	        	        	                                std::cout << "Type expected.\n";
            	        	        	                            }
            	        	        	                            else
            	        	        	                            {
            	        	        	                                context.appendChannelType(type);

            	        	        	                                #ifdef DEBUG
            	        	        	                                std::cout << " x " << *type;
            	        	        	                                #endif
            	        	        	                            }
            	        	        	            		delete type;
            	        	        	                        
            	        	        	        }

            	        	        	    }
            	        	        	    break;

            	        	        	default:
            	        	        	    goto loop3;	/* break out of the loop */
            	        	        	    break;
            	        	            }
            	        	        }
            	        	        loop3: ; /* Jump out to here if this rule does not match */


            	        	    }
            	        	    break;

            	            }
            	        }
            	        if ( BACKTRACKING==0 ) 
            	        {

            	                            #ifdef DEBUG
            	                            std::cout << std::endl;
            	                            #endif
            	                        
            	        }

            	    }
            	    break;

            	default:
            	    goto loop5;	/* break out of the loop */
            	    break;
                }
            }
            loop5: ; /* Jump out to here if this rule does not match */


            // cps/CPS.g:636:9: ( ( 'trace refinement:' VERIFY sys= ltsschema AGAINST spec= ltsschema (when= WHEN v= valf )? ) | ( 'alternating simulation:' VERIFY sys= ltsschema AGAINST spec= ltsschema (when= WHEN v= valf )? ) | ( 'compatibility:' VERIFY sys= ltsschema (when= WHEN v= valf )? ) )
            {
                int alt9=3;
                switch ( LA(1) ) 
                {
                case 55:
                	{
                		alt9=1;
                	}
                    break;
                case 56:
                	{
                		alt9=2;
                	}
                    break;
                case 57:
                	{
                		alt9=3;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return retval;
                    }
                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 9;
                    EXCEPTION->state        = 0;


                    goto rulecpsEx;
                }

                switch (alt9) 
                {
            	case 1:
            	    // cps/CPS.g:637:6: ( 'trace refinement:' VERIFY sys= ltsschema AGAINST spec= ltsschema (when= WHEN v= valf )? )
            	    {
            	        // cps/CPS.g:637:6: ( 'trace refinement:' VERIFY sys= ltsschema AGAINST spec= ltsschema (when= WHEN v= valf )? )
            	        // cps/CPS.g:637:7: 'trace refinement:' VERIFY sys= ltsschema AGAINST spec= ltsschema (when= WHEN v= valf )?
            	        {
            	             MATCHT(55, &FOLLOW_55_in_cps1195); 
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	             MATCHT(VERIFY, &FOLLOW_VERIFY_in_cps1197); 
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	            FOLLOWPUSH(FOLLOW_ltsschema_in_cps1203);
            	            sys=ltsschema(ctx);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	             MATCHT(AGAINST, &FOLLOW_AGAINST_in_cps1205); 
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	            FOLLOWPUSH(FOLLOW_ltsschema_in_cps1211);
            	            spec=ltsschema(ctx);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }

            	            // cps/CPS.g:637:75: (when= WHEN v= valf )?
            	            {
            	                int alt6=2;
            	                switch ( LA(1) ) 
            	                {
            	                    case WHEN:
            	                    	{
            	                    		alt6=1;
            	                    	}
            	                        break;
            	                }

            	                switch (alt6) 
            	                {
            	            	case 1:
            	            	    // cps/CPS.g:637:76: when= WHEN v= valf
            	            	    {
            	            	        when = (pANTLR3_COMMON_TOKEN) MATCHT(WHEN, &FOLLOW_WHEN_in_cps1218); 
            	            	        if  (HASEXCEPTION())
            	            	        {
            	            	            goto rulecpsEx;
            	            	        }
            	            	        if (HASFAILED())
            	            	        {
            	            	            return retval;
            	            	        }
            	            	        FOLLOWPUSH(FOLLOW_valf_in_cps1224);
            	            	        v=valf(ctx);

            	            	        FOLLOWPOP();
            	            	        if  (HASEXCEPTION())
            	            	        {
            	            	            goto rulecpsEx;
            	            	        }
            	            	        if (HASFAILED())
            	            	        {
            	            	            return retval;
            	            	        }

            	            	    }
            	            	    break;

            	                }
            	            }

            	        }

            	        if ( BACKTRACKING==0 ) 
            	        {

            	                		if(spec.ltsc == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Parametrised LTS expected.\n";
            	                            }
            	                            else if(sys.ltsc == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Parametrised LTS expected.\n";
            	                            }
            	                            else if(error == true && parser-> pParser -> rec -> state -> errorCount > 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Reduction failed due to previous errors.\n";
            	                            }
            	                            else
            	                            {
            	                                #pragma omp parallel
            	                                #pragma omp single nowait
            	                                {
            	                                std::cout << "Reducing a parameterised trace refinement task to a finitary one." << std::endl;
            	                                std::cout << "(implementation: " << sys.ltsc->toString(context) << ", specification: " << spec.ltsc->toString(context);
            	                                if(when != 0)
            	                                {
            	                                    std::cout << ", valuation constraint: " << v->toString(context);
            	                                }
            	                                std::cout << ')' << std::endl << std::endl;
            	                                timer.switchToTimer(1);
            	                                vertype = TRACEREF;
            	                                ValuationFormula* truevf = new TopValuationFormula();
            	                                quartet<std::map<TypeVariable,int>*, std::map<TypeVariable,bool>*, bool, bool> cutoffs(0,0,false,false);
            	                                quartet<std::set<Valuation*,PointerCompare<Valuation> >*, int, int, int> vals(0,0,0,0);
            	                                if(when != 0)
            	                                {
            	                                    timer.stop();
            	                                    cutoffs = determineCutoffs(context, v, spec.ltsc, sys.ltsc, vertype);
            	                                    timer.start();
            	                                    vals = computeValuations(context, v, spec.ltsc, sys.ltsc, *(cutoffs.first));
            	                                }
            	                                else
            	                                {
            	                                    timer.stop();
            	                                    cutoffs = determineCutoffs(context, truevf, spec.ltsc, sys.ltsc, vertype);
            	                                    timer.start();
            	                                    vals = computeValuations(context, truevf, spec.ltsc, sys.ltsc, *(cutoffs.first));
            	                                }
            	                                valCount += vals.second;
            	                                canCount += vals.third;
            	                                storedMax = std::max(storedMax, vals.fourth);
            	                                timer.switchToTimer(2);
            	                                if(when != 0)
            	                                {
            	                                    instCount += TraceRefinementOutput::generateInstances(context, spec.ltsc, sys.ltsc, v, vals.first, filename, *(cutoffs.second), cutoffs.third, cutoffs.fourth);
            	                                }
            	                                else
            	                                {
            	                                    instCount += TraceRefinementOutput::generateInstances(context, spec.ltsc, sys.ltsc, truevf, vals.first, filename, *(cutoffs.second), cutoffs.third, cutoffs.fourth);
            	                                }
            	                                delete cutoffs.first;
            	                                delete cutoffs.second;
            	                                delete vals.first;
            	                                delete truevf;
            	                                timer.switchToTimer(0);
            	                                }
            	            		}
            	                		delete spec.ltsc;
            	                		delete sys.ltsc;
            	                		if(when != 0) delete v;
            	                        
            	        }

            	    }
            	    break;
            	case 2:
            	    // cps/CPS.g:708:8: ( 'alternating simulation:' VERIFY sys= ltsschema AGAINST spec= ltsschema (when= WHEN v= valf )? )
            	    {
            	        // cps/CPS.g:708:8: ( 'alternating simulation:' VERIFY sys= ltsschema AGAINST spec= ltsschema (when= WHEN v= valf )? )
            	        // cps/CPS.g:708:9: 'alternating simulation:' VERIFY sys= ltsschema AGAINST spec= ltsschema (when= WHEN v= valf )?
            	        {
            	             MATCHT(56, &FOLLOW_56_in_cps1252); 
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	             MATCHT(VERIFY, &FOLLOW_VERIFY_in_cps1254); 
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	            FOLLOWPUSH(FOLLOW_ltsschema_in_cps1260);
            	            sys=ltsschema(ctx);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	             MATCHT(AGAINST, &FOLLOW_AGAINST_in_cps1262); 
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	            FOLLOWPUSH(FOLLOW_ltsschema_in_cps1268);
            	            spec=ltsschema(ctx);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }

            	            // cps/CPS.g:708:83: (when= WHEN v= valf )?
            	            {
            	                int alt7=2;
            	                switch ( LA(1) ) 
            	                {
            	                    case WHEN:
            	                    	{
            	                    		alt7=1;
            	                    	}
            	                        break;
            	                }

            	                switch (alt7) 
            	                {
            	            	case 1:
            	            	    // cps/CPS.g:708:84: when= WHEN v= valf
            	            	    {
            	            	        when = (pANTLR3_COMMON_TOKEN) MATCHT(WHEN, &FOLLOW_WHEN_in_cps1275); 
            	            	        if  (HASEXCEPTION())
            	            	        {
            	            	            goto rulecpsEx;
            	            	        }
            	            	        if (HASFAILED())
            	            	        {
            	            	            return retval;
            	            	        }
            	            	        FOLLOWPUSH(FOLLOW_valf_in_cps1281);
            	            	        v=valf(ctx);

            	            	        FOLLOWPOP();
            	            	        if  (HASEXCEPTION())
            	            	        {
            	            	            goto rulecpsEx;
            	            	        }
            	            	        if (HASFAILED())
            	            	        {
            	            	            return retval;
            	            	        }

            	            	    }
            	            	    break;

            	                }
            	            }

            	        }

            	        if ( BACKTRACKING==0 ) 
            	        {

            	                		if(spec.ltsc == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Parametrised LTS expected.\n";
            	                            }
            	                            else if(sys.ltsc == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Parametrised LTS expected.\n";
            	                            }
            	                		else if(!(spec.ltsc->isHidingFree()))
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Hiding is not allowed in the specification when checking for alternating simulation.\n";
            	                            }
            	                		else if(!(sys.ltsc->isHidingFree()))
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Hiding is not allowed in the implementation when checking for alternating simulation.\n";
            	                            }
            	                            else if(error == true || parser-> pParser -> rec -> state -> errorCount > 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Reduction failed due to previous errors.\n";
            	                            }
            	                            else
            	                            {
            	                                #pragma omp parallel
            	                                #pragma omp single nowait
            	                                {
            	                                std::cout << "Reducing a parameterised alternating simulation checking task to a finitary one." << std::endl;
            	                                std::cout << "(implementation: " << sys.ltsc->toString(context) << ", specification: " << spec.ltsc->toString(context);
            	                                if(when != 0)
            	                                {
            	                                    std::cout << ", valuation constraint: " << v->toString(context);
            	                                }
            	                                std::cout << ')' << std::endl << std::endl;
            	                                timer.switchToTimer(1);
            	                                vertype = ALTSIM;
            	                                ValuationFormula* truevf = new TopValuationFormula();
            	                                quartet<std::map<TypeVariable,int>*, std::map<TypeVariable,bool>*, bool, bool> cutoffs(0,0,false,false);
            	                                quartet<std::set<Valuation*,PointerCompare<Valuation> >*, int, int, int> vals(0,0,0,0);
            	                                if(when != 0)
            	                                {
            	                                    timer.stop();
            	                                    cutoffs = determineCutoffs(context, v, spec.ltsc, sys.ltsc, vertype);
            	                                    timer.start();
            	                                    vals = computeValuations(context, v, spec.ltsc, sys.ltsc, *(cutoffs.first));
            	                                }
            	                                else
            	                                {
            	                                    timer.stop();
            	                                    cutoffs = determineCutoffs(context, truevf, spec.ltsc, sys.ltsc, vertype);
            	                                    timer.start();
            	                                    vals = computeValuations(context, truevf, spec.ltsc, sys.ltsc, *(cutoffs.first));
            	                                }
            	                                valCount += vals.second;
            	                                canCount += vals.third;
            	                                storedMax = std::max(storedMax, vals.fourth);
            	                                timer.switchToTimer(2);
            	                                if(when != 0)
            	                                {
            	                                    instCount += AlternatingSimulationOutput::generateInstances(context, spec.ltsc, sys.ltsc, v, vals.first, filename, *(cutoffs.second), cutoffs.third, cutoffs.fourth);
            	                                }
            	                                else
            	                                {
            	                                    instCount += AlternatingSimulationOutput::generateInstances(context, spec.ltsc, sys.ltsc, truevf, vals.first, filename, *(cutoffs.second), cutoffs.third, cutoffs.fourth);
            	                                }
            	                                delete cutoffs.first;
            	                                delete cutoffs.second;
            	                                delete vals.first;
            	                                delete truevf;
            	                                timer.switchToTimer(0);
            	                                }
            	            		}
            	                		delete spec.ltsc;
            	                		delete sys.ltsc;
            	                		if(when != 0) delete v;
            	                        
            	        }

            	    }
            	    break;
            	case 3:
            	    // cps/CPS.g:789:8: ( 'compatibility:' VERIFY sys= ltsschema (when= WHEN v= valf )? )
            	    {
            	        // cps/CPS.g:789:8: ( 'compatibility:' VERIFY sys= ltsschema (when= WHEN v= valf )? )
            	        // cps/CPS.g:789:9: 'compatibility:' VERIFY sys= ltsschema (when= WHEN v= valf )?
            	        {
            	             MATCHT(57, &FOLLOW_57_in_cps1309); 
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	             MATCHT(VERIFY, &FOLLOW_VERIFY_in_cps1311); 
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	            FOLLOWPUSH(FOLLOW_ltsschema_in_cps1317);
            	            sys=ltsschema(ctx);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulecpsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }

            	            // cps/CPS.g:789:49: (when= WHEN v= valf )?
            	            {
            	                int alt8=2;
            	                switch ( LA(1) ) 
            	                {
            	                    case WHEN:
            	                    	{
            	                    		alt8=1;
            	                    	}
            	                        break;
            	                }

            	                switch (alt8) 
            	                {
            	            	case 1:
            	            	    // cps/CPS.g:789:50: when= WHEN v= valf
            	            	    {
            	            	        when = (pANTLR3_COMMON_TOKEN) MATCHT(WHEN, &FOLLOW_WHEN_in_cps1324); 
            	            	        if  (HASEXCEPTION())
            	            	        {
            	            	            goto rulecpsEx;
            	            	        }
            	            	        if (HASFAILED())
            	            	        {
            	            	            return retval;
            	            	        }
            	            	        FOLLOWPUSH(FOLLOW_valf_in_cps1330);
            	            	        v=valf(ctx);

            	            	        FOLLOWPOP();
            	            	        if  (HASEXCEPTION())
            	            	        {
            	            	            goto rulecpsEx;
            	            	        }
            	            	        if (HASFAILED())
            	            	        {
            	            	            return retval;
            	            	        }

            	            	    }
            	            	    break;

            	                }
            	            }

            	        }

            	        if ( BACKTRACKING==0 ) 
            	        {

            	                            if(sys.ltsc == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Parametrised LTS expected.\n";
            	                            }
            	                		else if(!sys.ltsc->isHidingFree())
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Hiding is not allowed when checking for compatibility.\n";
            	                            }
            	                            else if(error == true || parser-> pParser -> rec -> state -> errorCount > 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Reduction failed due to previous errors.\n";
            	                            }
            	                            else
            	                            {
            	                                LTSSchema* unitltsc = new ElementaryLTSSchema(new TransitionSetSchema(), new StateSchema(0,0));
            	                                #pragma omp parallel
            	                                #pragma omp single nowait
            	                                {
            	                                std::cout << "Reducing a parameterised compatibility checking task to a finitary one." << std::endl;
            	                                std::cout << "(implementation: " << sys.ltsc->toString(context);
            	                                if(when != 0)
            	                                {
            	                                    std::cout << ", valuation constraint: " << v->toString(context);
            	                                }
            	                                std::cout << ')' << std::endl << std::endl;
            	                                timer.switchToTimer(1);
            	                                vertype = COMPAT;
            	                                ValuationFormula* truevf = new TopValuationFormula();
            	                                quartet<std::map<TypeVariable,int>*, std::map<TypeVariable,bool>*, bool, bool> cutoffs(0,0,false,false);
            	                                quartet<std::set<Valuation*,PointerCompare<Valuation> >*, int, int, int> vals(0,0,0,0);
            	                                if(when != 0)
            	                                {
            	                                    timer.stop();
            	                                    cutoffs = determineCutoffs(context, v, unitltsc, sys.ltsc, vertype);
            	                                    timer.start();
            	                                    vals = computeValuations(context, v, unitltsc, sys.ltsc, *(cutoffs.first));
            	                                }
            	                                else
            	                                {
            	                                    timer.stop();
            	                                    cutoffs = determineCutoffs(context, truevf, unitltsc, sys.ltsc, vertype);
            	                                    timer.start();
            	                                    vals = computeValuations(context, truevf, unitltsc, sys.ltsc, *(cutoffs.first));
            	                                }
            	                                valCount += vals.second;
            	                                canCount += vals.third;
            	                                storedMax = std::max(storedMax, vals.fourth);
            	                                timer.switchToTimer(2);
            	                                if(when != 0)
            	                                {
            	                                    instCount += CompatibilityOutput::generateInstances(context, sys.ltsc, v, vals.first, filename, *(cutoffs.second), cutoffs.third, cutoffs.fourth);
            	                                }
            	                                else
            	                                {
            	                                    instCount += CompatibilityOutput::generateInstances(context, sys.ltsc, truevf, vals.first, filename, *(cutoffs.second), cutoffs.third, cutoffs.fourth);
            	                                }
            	                                delete cutoffs.first;
            	                                delete cutoffs.second;
            	                                delete vals.first;
            	                                delete truevf;
            	                                timer.switchToTimer(0);
            	                                }
            	                                delete unitltsc;
            	                            }
            	                		delete sys.ltsc;
            	                		if(when != 0) delete v;
            	                        
            	        }

            	    }
            	    break;

                }
            }

        }

    }
    

    // This is where rules clean up and exit
    //
    goto rulecpsEx; /* Prevent compiler warnings */
    rulecpsEx: ;
    retval.stop = LT(-1);

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }


    return retval;
}
/* $ANTLR end cps */

/** 
 * $ANTLR start ltsschema
 * cps/CPS.g:864:1: ltsschema returns [LTSSchema* ltsc] : (l= parltsc ) ( ( HIDE s= setschema ) )* ;
 */
static CPSParser_ltsschema_return
ltsschema(pCPSParser ctx)
{   
    CPSParser_ltsschema_return retval;

    CPSParser_parltsc_return l;
    #undef	RETURN_TYPE_l
    #define	RETURN_TYPE_l CPSParser_parltsc_return

    CPSParser_setschema_return s;
    #undef	RETURN_TYPE_s
    #define	RETURN_TYPE_s CPSParser_setschema_return

    /* Initialize rule variables
     */


    retval.start = LT(1); retval.stop = retval.start;

    {
        // cps/CPS.g:865:2: ( (l= parltsc ) ( ( HIDE s= setschema ) )* )
        // cps/CPS.g:865:4: (l= parltsc ) ( ( HIDE s= setschema ) )*
        {
            // cps/CPS.g:865:4: (l= parltsc )
            // cps/CPS.g:865:5: l= parltsc
            {
                FOLLOWPUSH(FOLLOW_parltsc_in_ltsschema1371);
                l=parltsc(ctx);

                FOLLOWPOP();
                if  (HASEXCEPTION())
                {
                    goto ruleltsschemaEx;
                }
                if (HASFAILED())
                {
                    return retval;
                }

            }

            if ( BACKTRACKING==0 ) 
            {

                                retval.ltsc= 0;
                                if(l.ltsc == 0)
                                {
                                    printPosition(retval.start);
                                    std::cout << "Parametrised LTS expected.\n";
                                }
                                else
                                {
                                    retval.ltsc= l.ltsc;
                                }
                            
            }

            // cps/CPS.g:878:2: ( ( HIDE s= setschema ) )*

            for (;;)
            {
                int alt10=2;
                switch ( LA(1) ) 
                {
                case HIDE:
                	{
                		alt10=1;
                	}
                    break;

                }

                switch (alt10) 
                {
            	case 1:
            	    // cps/CPS.g:879:2: ( HIDE s= setschema )
            	    {
            	        // cps/CPS.g:879:2: ( HIDE s= setschema )
            	        // cps/CPS.g:879:3: HIDE s= setschema
            	        {
            	             MATCHT(HIDE, &FOLLOW_HIDE_in_ltsschema1393); 
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruleltsschemaEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }
            	            FOLLOWPUSH(FOLLOW_setschema_in_ltsschema1399);
            	            s=setschema(ctx);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruleltsschemaEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return retval;
            	            }

            	        }

            	        if ( BACKTRACKING==0 ) 
            	        {

            	                            if(s.ssc == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Parametrised set expected.\n";
            	                            }
            	                            else if(retval.ltsc != 0)
            	                            {
            	                                retval.ltsc= new HidingLTSSchema(retval.ltsc, s.ssc);
            	                            }
            	                        
            	        }

            	    }
            	    break;

            	default:
            	    goto loop10;	/* break out of the loop */
            	    break;
                }
            }
            loop10: ; /* Jump out to here if this rule does not match */


        }

    }
    

    // This is where rules clean up and exit
    //
    goto ruleltsschemaEx; /* Prevent compiler warnings */
    ruleltsschemaEx: ;
    retval.stop = LT(-1);

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }


    return retval;
}
/* $ANTLR end ltsschema */

/** 
 * $ANTLR start parltsc
 * cps/CPS.g:894:1: parltsc returns [LTSSchema* ltsc] : (l1= repparltsc | l2= condltsc | l3= elemltsc ) ( PAR (l1= repparltsc | l2= condltsc | l3= elemltsc ) )* ;
 */
static CPSParser_parltsc_return
parltsc(pCPSParser ctx)
{   
    CPSParser_parltsc_return retval;

    CPSParser_repparltsc_return l1;
    #undef	RETURN_TYPE_l1
    #define	RETURN_TYPE_l1 CPSParser_repparltsc_return

    CPSParser_condltsc_return l2;
    #undef	RETURN_TYPE_l2
    #define	RETURN_TYPE_l2 CPSParser_condltsc_return

    CPSParser_elemltsc_return l3;
    #undef	RETURN_TYPE_l3
    #define	RETURN_TYPE_l3 CPSParser_elemltsc_return

    /* Initialize rule variables
     */


    retval.start = LT(1); retval.stop = retval.start;

    {
        // cps/CPS.g:895:2: ( (l1= repparltsc | l2= condltsc | l3= elemltsc ) ( PAR (l1= repparltsc | l2= condltsc | l3= elemltsc ) )* )
        // cps/CPS.g:895:4: (l1= repparltsc | l2= condltsc | l3= elemltsc ) ( PAR (l1= repparltsc | l2= condltsc | l3= elemltsc ) )*
        {

            // cps/CPS.g:895:4: (l1= repparltsc | l2= condltsc | l3= elemltsc )
            {
                int alt11=3;
                switch ( LA(1) ) 
                {
                case PAR:
                	{
                		alt11=1;
                	}
                    break;
                case 48:
                	{
                		alt11=2;
                	}
                    break;
                case LTS:
                case SMALLID:
                case CAPITID:
                case CAPITNUMID:
                case 58:
                	{
                		alt11=3;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return retval;
                    }
                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 11;
                    EXCEPTION->state        = 0;


                    goto ruleparltscEx;
                }

                switch (alt11) 
                {
            	case 1:
            	    // cps/CPS.g:895:5: l1= repparltsc
            	    {
            	        if ( BACKTRACKING==0 ) 
            	        {
            	            retval.ltsc= 0;
            	        }
            	        FOLLOWPUSH(FOLLOW_repparltsc_in_parltsc1438);
            	        l1=repparltsc(ctx);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleparltscEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        if ( BACKTRACKING==0 ) 
            	        {
            	            retval.ltsc= l1.ltsc;
            	        }

            	    }
            	    break;
            	case 2:
            	    // cps/CPS.g:895:54: l2= condltsc
            	    {
            	        FOLLOWPUSH(FOLLOW_condltsc_in_parltsc1448);
            	        l2=condltsc(ctx);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleparltscEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        if ( BACKTRACKING==0 ) 
            	        {
            	            retval.ltsc= l2.ltsc;
            	        }

            	    }
            	    break;
            	case 3:
            	    // cps/CPS.g:895:90: l3= elemltsc
            	    {
            	        FOLLOWPUSH(FOLLOW_elemltsc_in_parltsc1458);
            	        l3=elemltsc(ctx);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleparltscEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        if ( BACKTRACKING==0 ) 
            	        {
            	             retval.ltsc= l3.ltsc;
            	        }

            	    }
            	    break;

                }
            }

            // cps/CPS.g:896:2: ( PAR (l1= repparltsc | l2= condltsc | l3= elemltsc ) )*

            for (;;)
            {
                int alt13=2;
                switch ( LA(1) ) 
                {
                case PAR:
                	{
                		alt13=1;
                	}
                    break;

                }

                switch (alt13) 
                {
            	case 1:
            	    // cps/CPS.g:897:2: PAR (l1= repparltsc | l2= condltsc | l3= elemltsc )
            	    {
            	         MATCHT(PAR, &FOLLOW_PAR_in_parltsc1467); 
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleparltscEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }

            	        // cps/CPS.g:897:6: (l1= repparltsc | l2= condltsc | l3= elemltsc )
            	        {
            	            int alt12=3;
            	            switch ( LA(1) ) 
            	            {
            	            case PAR:
            	            	{
            	            		alt12=1;
            	            	}
            	                break;
            	            case 48:
            	            	{
            	            		alt12=2;
            	            	}
            	                break;
            	            case LTS:
            	            case SMALLID:
            	            case CAPITID:
            	            case CAPITNUMID:
            	            case 58:
            	            	{
            	            		alt12=3;
            	            	}
            	                break;

            	            default:
            	                if (BACKTRACKING>0)
            	                {
            	                    FAILEDFLAG = ANTLR3_TRUE;
            	                    return retval;
            	                }
            	                CONSTRUCTEX();
            	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	                EXCEPTION->message      = (void *)"";
            	                EXCEPTION->decisionNum  = 12;
            	                EXCEPTION->state        = 0;


            	                goto ruleparltscEx;
            	            }

            	            switch (alt12) 
            	            {
            	        	case 1:
            	        	    // cps/CPS.g:897:7: l1= repparltsc
            	        	    {
            	        	        FOLLOWPUSH(FOLLOW_repparltsc_in_parltsc1474);
            	        	        l1=repparltsc(ctx);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruleparltscEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return retval;
            	        	        }
            	        	        if ( BACKTRACKING==0 ) 
            	        	        {

            	        	                            if(l1.ltsc == 0)
            	        	                            {
            	        	                                printPosition(retval.start);
            	        	                                std::cout << "Parametrised LTS expected.\n";
            	        	                            }
            	        	                            else if(retval.ltsc != 0)
            	        	                            {
            	        	                                retval.ltsc= new ParallelLTSSchema(retval.ltsc, l1.ltsc);
            	        	            		}
            	        	                        
            	        	        }

            	        	    }
            	        	    break;
            	        	case 2:
            	        	    // cps/CPS.g:909:15: l2= condltsc
            	        	    {
            	        	        FOLLOWPUSH(FOLLOW_condltsc_in_parltsc1508);
            	        	        l2=condltsc(ctx);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruleparltscEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return retval;
            	        	        }
            	        	        if ( BACKTRACKING==0 ) 
            	        	        {

            	        	                            if(l2.ltsc == 0)
            	        	                            {
            	        	                                printPosition(retval.start);
            	        	                                std::cout << "Parametrised LTS expected.\n";
            	        	                            }
            	        	                            else if(retval.ltsc != 0)
            	        	                            {
            	        	                                retval.ltsc= new ParallelLTSSchema(retval.ltsc, l2.ltsc);
            	        	            		}
            	        	                        
            	        	        }

            	        	    }
            	        	    break;
            	        	case 3:
            	        	    // cps/CPS.g:921:15: l3= elemltsc
            	        	    {
            	        	        FOLLOWPUSH(FOLLOW_elemltsc_in_parltsc1543);
            	        	        l3=elemltsc(ctx);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruleparltscEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return retval;
            	        	        }

            	        	    }
            	        	    break;

            	            }
            	        }
            	        if ( BACKTRACKING==0 ) 
            	        {

            	                            if(l3.ltsc == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Parametrised LTS expected.\n";
            	                            }
            	                            else if(retval.ltsc != 0)
            	                            {
            	                                retval.ltsc= new ParallelLTSSchema(retval.ltsc, l3.ltsc);
            	            		}
            	                        
            	        }

            	    }
            	    break;

            	default:
            	    goto loop13;	/* break out of the loop */
            	    break;
                }
            }
            loop13: ; /* Jump out to here if this rule does not match */


        }

    }
    

    // This is where rules clean up and exit
    //
    goto ruleparltscEx; /* Prevent compiler warnings */
    ruleparltscEx: ;
    retval.stop = LT(-1);

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }


    return retval;
}
/* $ANTLR end parltsc */

/** 
 * $ANTLR start repparltsc
 * cps/CPS.g:936:1: repparltsc returns [LTSSchema* ltsc] : ( PAR avl= boundparlist ':' (l1= repparltsc | l2= condltsc | l3= elemltsc ) ) ;
 */
static CPSParser_repparltsc_return
repparltsc(pCPSParser ctx)
{   
    CPSParser_repparltsc_return retval;

    CPSParser_boundparlist_return avl;
    #undef	RETURN_TYPE_avl
    #define	RETURN_TYPE_avl CPSParser_boundparlist_return

    CPSParser_repparltsc_return l1;
    #undef	RETURN_TYPE_l1
    #define	RETURN_TYPE_l1 CPSParser_repparltsc_return

    CPSParser_condltsc_return l2;
    #undef	RETURN_TYPE_l2
    #define	RETURN_TYPE_l2 CPSParser_condltsc_return

    CPSParser_elemltsc_return l3;
    #undef	RETURN_TYPE_l3
    #define	RETURN_TYPE_l3 CPSParser_elemltsc_return

    /* Initialize rule variables
     */


    retval.start = LT(1); retval.stop = retval.start;

    {
        // cps/CPS.g:937:2: ( ( PAR avl= boundparlist ':' (l1= repparltsc | l2= condltsc | l3= elemltsc ) ) )
        // cps/CPS.g:937:4: ( PAR avl= boundparlist ':' (l1= repparltsc | l2= condltsc | l3= elemltsc ) )
        {
            // cps/CPS.g:937:4: ( PAR avl= boundparlist ':' (l1= repparltsc | l2= condltsc | l3= elemltsc ) )
            // cps/CPS.g:937:5: PAR avl= boundparlist ':' (l1= repparltsc | l2= condltsc | l3= elemltsc )
            {
                 MATCHT(PAR, &FOLLOW_PAR_in_repparltsc1579); 
                if  (HASEXCEPTION())
                {
                    goto rulerepparltscEx;
                }
                if (HASFAILED())
                {
                    return retval;
                }
                FOLLOWPUSH(FOLLOW_boundparlist_in_repparltsc1583);
                avl=boundparlist(ctx);

                FOLLOWPOP();
                if  (HASEXCEPTION())
                {
                    goto rulerepparltscEx;
                }
                if (HASFAILED())
                {
                    return retval;
                }
                 MATCHT(54, &FOLLOW_54_in_repparltsc1585); 
                if  (HASEXCEPTION())
                {
                    goto rulerepparltscEx;
                }
                if (HASFAILED())
                {
                    return retval;
                }
                if ( BACKTRACKING==0 ) 
                {
                    retval.ltsc= 0;
                }

                // cps/CPS.g:937:43: (l1= repparltsc | l2= condltsc | l3= elemltsc )
                {
                    int alt14=3;
                    switch ( LA(1) ) 
                    {
                    case PAR:
                    	{
                    		alt14=1;
                    	}
                        break;
                    case 48:
                    	{
                    		alt14=2;
                    	}
                        break;
                    case LTS:
                    case SMALLID:
                    case CAPITID:
                    case CAPITNUMID:
                    case 58:
                    	{
                    		alt14=3;
                    	}
                        break;

                    default:
                        if (BACKTRACKING>0)
                        {
                            FAILEDFLAG = ANTLR3_TRUE;
                            return retval;
                        }
                        CONSTRUCTEX();
                        EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                        EXCEPTION->message      = (void *)"";
                        EXCEPTION->decisionNum  = 14;
                        EXCEPTION->state        = 0;


                        goto rulerepparltscEx;
                    }

                    switch (alt14) 
                    {
                	case 1:
                	    // cps/CPS.g:937:44: l1= repparltsc
                	    {
                	        FOLLOWPUSH(FOLLOW_repparltsc_in_repparltsc1594);
                	        l1=repparltsc(ctx);

                	        FOLLOWPOP();
                	        if  (HASEXCEPTION())
                	        {
                	            goto rulerepparltscEx;
                	        }
                	        if (HASFAILED())
                	        {
                	            return retval;
                	        }
                	        if ( BACKTRACKING==0 ) 
                	        {
                	            retval.ltsc= l1.ltsc;
                	        }

                	    }
                	    break;
                	case 2:
                	    // cps/CPS.g:937:82: l2= condltsc
                	    {
                	        FOLLOWPUSH(FOLLOW_condltsc_in_repparltsc1604);
                	        l2=condltsc(ctx);

                	        FOLLOWPOP();
                	        if  (HASEXCEPTION())
                	        {
                	            goto rulerepparltscEx;
                	        }
                	        if (HASFAILED())
                	        {
                	            return retval;
                	        }
                	        if ( BACKTRACKING==0 ) 
                	        {
                	            retval.ltsc= l2.ltsc;
                	        }

                	    }
                	    break;
                	case 3:
                	    // cps/CPS.g:937:118: l3= elemltsc
                	    {
                	        FOLLOWPUSH(FOLLOW_elemltsc_in_repparltsc1614);
                	        l3=elemltsc(ctx);

                	        FOLLOWPOP();
                	        if  (HASEXCEPTION())
                	        {
                	            goto rulerepparltscEx;
                	        }
                	        if (HASFAILED())
                	        {
                	            return retval;
                	        }
                	        if ( BACKTRACKING==0 ) 
                	        {
                	            retval.ltsc= l3.ltsc;
                	        }

                	    }
                	    break;

                    }
                }

            }

            if ( BACKTRACKING==0 ) 
            {

                                if(retval.ltsc == 0)
                                {
                                    printPosition(retval.start);
                                    std::cout << "Parametrised LTS expected.\n";
                                }
                                else if(avl.bal == 0)
                                {
                                    printPosition(retval.start);
                                    std::cout << "Variable list expected.\n";
                                }
                                else if(!retval.ltsc->hasDisjointInputOutputChannels())
                                {
                                    printPosition(retval.start);
                                    std::cout << "The input and output channels are not disjoint.\n";
                                }
                                else
                                {
                                    for(int i = 0; i < avl.bal->size(); ++i)
                                    {
                                        AtomVariable* av = new AtomVariable(avl.bal->operator[](i)->getAtomVariable());
                                        retval.ltsc= new ReplicatedLTSSchema(av, retval.ltsc);
                                    }
                                }
                		delete avl.bal;
                            
            }

        }

    }
    

    // This is where rules clean up and exit
    //
    goto rulerepparltscEx; /* Prevent compiler warnings */
    rulerepparltscEx: ;
    retval.stop = LT(-1);

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }


    return retval;
}
/* $ANTLR end repparltsc */

/** 
 * $ANTLR start condltsc
 * cps/CPS.g:966:1: condltsc returns [LTSSchema* ltsc] : ( '[' v= valf ']' (l1= condltsc | l2= elemltsc | l3= repparltsc ) ) ;
 */
static CPSParser_condltsc_return
condltsc(pCPSParser ctx)
{   
    CPSParser_condltsc_return retval;

    ValuationFormula* v;
    #undef	RETURN_TYPE_v
    #define	RETURN_TYPE_v ValuationFormula*

    CPSParser_condltsc_return l1;
    #undef	RETURN_TYPE_l1
    #define	RETURN_TYPE_l1 CPSParser_condltsc_return

    CPSParser_elemltsc_return l2;
    #undef	RETURN_TYPE_l2
    #define	RETURN_TYPE_l2 CPSParser_elemltsc_return

    CPSParser_repparltsc_return l3;
    #undef	RETURN_TYPE_l3
    #define	RETURN_TYPE_l3 CPSParser_repparltsc_return

    /* Initialize rule variables
     */


    v = NULL;
    retval.start = LT(1); retval.stop = retval.start;

    {
        // cps/CPS.g:967:2: ( ( '[' v= valf ']' (l1= condltsc | l2= elemltsc | l3= repparltsc ) ) )
        // cps/CPS.g:967:4: ( '[' v= valf ']' (l1= condltsc | l2= elemltsc | l3= repparltsc ) )
        {
            // cps/CPS.g:967:4: ( '[' v= valf ']' (l1= condltsc | l2= elemltsc | l3= repparltsc ) )
            // cps/CPS.g:967:5: '[' v= valf ']' (l1= condltsc | l2= elemltsc | l3= repparltsc )
            {
                 MATCHT(48, &FOLLOW_48_in_condltsc1651); 
                if  (HASEXCEPTION())
                {
                    goto rulecondltscEx;
                }
                if (HASFAILED())
                {
                    return retval;
                }
                FOLLOWPUSH(FOLLOW_valf_in_condltsc1657);
                v=valf(ctx);

                FOLLOWPOP();
                if  (HASEXCEPTION())
                {
                    goto rulecondltscEx;
                }
                if (HASFAILED())
                {
                    return retval;
                }
                 MATCHT(49, &FOLLOW_49_in_condltsc1659); 
                if  (HASEXCEPTION())
                {
                    goto rulecondltscEx;
                }
                if (HASFAILED())
                {
                    return retval;
                }
                if ( BACKTRACKING==0 ) 
                {
                    retval.ltsc= 0;
                }

                // cps/CPS.g:967:35: (l1= condltsc | l2= elemltsc | l3= repparltsc )
                {
                    int alt15=3;
                    switch ( LA(1) ) 
                    {
                    case 48:
                    	{
                    		alt15=1;
                    	}
                        break;
                    case LTS:
                    case SMALLID:
                    case CAPITID:
                    case CAPITNUMID:
                    case 58:
                    	{
                    		alt15=2;
                    	}
                        break;
                    case PAR:
                    	{
                    		alt15=3;
                    	}
                        break;

                    default:
                        if (BACKTRACKING>0)
                        {
                            FAILEDFLAG = ANTLR3_TRUE;
                            return retval;
                        }
                        CONSTRUCTEX();
                        EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                        EXCEPTION->message      = (void *)"";
                        EXCEPTION->decisionNum  = 15;
                        EXCEPTION->state        = 0;


                        goto rulecondltscEx;
                    }

                    switch (alt15) 
                    {
                	case 1:
                	    // cps/CPS.g:967:36: l1= condltsc
                	    {
                	        FOLLOWPUSH(FOLLOW_condltsc_in_condltsc1668);
                	        l1=condltsc(ctx);

                	        FOLLOWPOP();
                	        if  (HASEXCEPTION())
                	        {
                	            goto rulecondltscEx;
                	        }
                	        if (HASFAILED())
                	        {
                	            return retval;
                	        }
                	        if ( BACKTRACKING==0 ) 
                	        {
                	            retval.ltsc= l1.ltsc;
                	        }

                	    }
                	    break;
                	case 2:
                	    // cps/CPS.g:967:72: l2= elemltsc
                	    {
                	        FOLLOWPUSH(FOLLOW_elemltsc_in_condltsc1678);
                	        l2=elemltsc(ctx);

                	        FOLLOWPOP();
                	        if  (HASEXCEPTION())
                	        {
                	            goto rulecondltscEx;
                	        }
                	        if (HASFAILED())
                	        {
                	            return retval;
                	        }
                	        if ( BACKTRACKING==0 ) 
                	        {
                	            retval.ltsc= l2.ltsc;
                	        }

                	    }
                	    break;
                	case 3:
                	    // cps/CPS.g:967:108: l3= repparltsc
                	    {
                	        FOLLOWPUSH(FOLLOW_repparltsc_in_condltsc1688);
                	        l3=repparltsc(ctx);

                	        FOLLOWPOP();
                	        if  (HASEXCEPTION())
                	        {
                	            goto rulecondltscEx;
                	        }
                	        if (HASFAILED())
                	        {
                	            return retval;
                	        }
                	        if ( BACKTRACKING==0 ) 
                	        {
                	            retval.ltsc= l3.ltsc;
                	        }

                	    }
                	    break;

                    }
                }

            }

            if ( BACKTRACKING==0 ) 
            {

                                if(retval.ltsc == 0)
                                {
                                    printPosition(retval.start);
                                    std::cout << "Parametrised LTS expected.\n";
                                }
                                else if(v == 0)
                                {
                                    printPosition(retval.start);
                                    std::cout << "Guard expected.\n";
                                }
                                else if(!(v->isUnquantified()))
                                {
                                    printPosition(retval.start);
                                    std::cout << "Unquantified guard expected.\n";
                                }
                                else
                		{
                                    retval.ltsc= static_cast<LTSSchema*>(new ConditionLTSSchema(retval.ltsc, v));
                		}
                            
            }

        }

    }
    

    // This is where rules clean up and exit
    //
    goto rulecondltscEx; /* Prevent compiler warnings */
    rulecondltscEx: ;
    retval.stop = LT(-1);

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }


    return retval;
}
/* $ANTLR end condltsc */

/** 
 * $ANTLR start elemltsc
 * cps/CPS.g:991:1: elemltsc returns [LTSSchema* ltsc] : ( ( LTS (t= transetschema FROM init= stateschema ) ) | (name= string ) | ( '(' l= ltsschema ')' ) );
 */
static CPSParser_elemltsc_return
elemltsc(pCPSParser ctx)
{   
    CPSParser_elemltsc_return retval;

    CPSParser_transetschema_return t;
    #undef	RETURN_TYPE_t
    #define	RETURN_TYPE_t CPSParser_transetschema_return

    CPSParser_stateschema_return init;
    #undef	RETURN_TYPE_init
    #define	RETURN_TYPE_init CPSParser_stateschema_return

    std::string* name;
    #undef	RETURN_TYPE_name
    #define	RETURN_TYPE_name std::string*

    CPSParser_ltsschema_return l;
    #undef	RETURN_TYPE_l
    #define	RETURN_TYPE_l CPSParser_ltsschema_return

    /* Initialize rule variables
     */


    name = NULL;
    retval.start = LT(1); retval.stop = retval.start;

    {
        {
            //  cps/CPS.g:992:2: ( ( LTS (t= transetschema FROM init= stateschema ) ) | (name= string ) | ( '(' l= ltsschema ')' ) )
            
            ANTLR3_UINT32 alt16;

            alt16=3;

            switch ( LA(1) ) 
            {
            case LTS:
            	{
            		alt16=1;
            	}
                break;
            case SMALLID:
            case CAPITID:
            case CAPITNUMID:
            	{
            		alt16=2;
            	}
                break;
            case 58:
            	{
            		alt16=3;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return retval;
                }
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 16;
                EXCEPTION->state        = 0;


                goto ruleelemltscEx;
            }

            switch (alt16) 
            {
        	case 1:
        	    // cps/CPS.g:992:4: ( LTS (t= transetschema FROM init= stateschema ) )
        	    {
        	        // cps/CPS.g:992:4: ( LTS (t= transetschema FROM init= stateschema ) )
        	        // cps/CPS.g:992:6: LTS (t= transetschema FROM init= stateschema )
        	        {
        	             MATCHT(LTS, &FOLLOW_LTS_in_elemltsc1726); 
        	            if  (HASEXCEPTION())
        	            {
        	                goto ruleelemltscEx;
        	            }
        	            if (HASFAILED())
        	            {
        	                return retval;
        	            }
        	            if ( BACKTRACKING==0 ) 
        	            {

        	                		context.insertNewProcess();
        	                            
        	            }
        	            // cps/CPS.g:996:13: (t= transetschema FROM init= stateschema )
        	            // cps/CPS.g:996:14: t= transetschema FROM init= stateschema
        	            {
        	                FOLLOWPUSH(FOLLOW_transetschema_in_elemltsc1760);
        	                t=transetschema(ctx);

        	                FOLLOWPOP();
        	                if  (HASEXCEPTION())
        	                {
        	                    goto ruleelemltscEx;
        	                }
        	                if (HASFAILED())
        	                {
        	                    return retval;
        	                }
        	                 MATCHT(FROM, &FOLLOW_FROM_in_elemltsc1762); 
        	                if  (HASEXCEPTION())
        	                {
        	                    goto ruleelemltscEx;
        	                }
        	                if (HASFAILED())
        	                {
        	                    return retval;
        	                }
        	                FOLLOWPUSH(FOLLOW_stateschema_in_elemltsc1768);
        	                init=stateschema(ctx);

        	                FOLLOWPOP();
        	                if  (HASEXCEPTION())
        	                {
        	                    goto ruleelemltscEx;
        	                }
        	                if (HASFAILED())
        	                {
        	                    return retval;
        	                }

        	            }

        	            if ( BACKTRACKING==0 ) 
        	            {

        	                                retval.ltsc= 0;
        	                		if(init.stsc == 0)
        	                                {
        	                                    printPosition(retval.start);
        	                                    std::cout << "Parametrised state expected.\n";
        	                                }
        	                                else if (t.tss == 0)
        	                                {
        	                                    printPosition(retval.start);
        	                                    std::cout << "List of parametrised transitions expected.\n";
        	                                }
        	                                else if(!t.tss->hasDisjointInputOutputChannels())
        	                                {
        	                                    printPosition(retval.start);
        	                                    std::cout << "The input and output channels are not disjoint.\n";
        	                                }
        	                                else
        	                		{
        	                                    retval.ltsc= static_cast<LTSSchema*>(new ElementaryLTSSchema(t.tss, init.stsc));
        	                		}
        	                            
        	            }

        	        }


        	    }
        	    break;
        	case 2:
        	    // cps/CPS.g:1020:4: (name= string )
        	    {
        	        // cps/CPS.g:1020:4: (name= string )
        	        // cps/CPS.g:1020:5: name= string
        	        {
        	            FOLLOWPUSH(FOLLOW_string_in_elemltsc1798);
        	            name=string(ctx);

        	            FOLLOWPOP();
        	            if  (HASEXCEPTION())
        	            {
        	                goto ruleelemltscEx;
        	            }
        	            if (HASFAILED())
        	            {
        	                return retval;
        	            }

        	        }

        	        if ( BACKTRACKING==0 ) 
        	        {

        	                            retval.ltsc= 0;
        	                            if(name == 0)
        	                            {
        	                                printPosition(retval.start);
        	                                std::cout << "Parametrised LTS expected.\n";
        	                            }
        	                            else if(!context.isLTSSchema(name))
        	                            {
        	                                printPosition(retval.start);
        	                                std::cout << "Identifier " << *(name) << " is not a parametrised LTS.\n";
        	                            }
        	                            else
        	            		{
        	                                retval.ltsc= static_cast<LTSSchema*>(new NamedLTSSchema(name, context.getLTSSchema(name)->clone()));
        	            		}
        	                            if(retval.ltsc == 0) delete name;
        	                        
        	        }

        	    }
        	    break;
        	case 3:
        	    // cps/CPS.g:1039:4: ( '(' l= ltsschema ')' )
        	    {
        	        // cps/CPS.g:1039:4: ( '(' l= ltsschema ')' )
        	        // cps/CPS.g:1039:5: '(' l= ltsschema ')'
        	        {
        	             MATCHT(58, &FOLLOW_58_in_elemltsc1819); 
        	            if  (HASEXCEPTION())
        	            {
        	                goto ruleelemltscEx;
        	            }
        	            if (HASFAILED())
        	            {
        	                return retval;
        	            }
        	            FOLLOWPUSH(FOLLOW_ltsschema_in_elemltsc1825);
        	            l=ltsschema(ctx);

        	            FOLLOWPOP();
        	            if  (HASEXCEPTION())
        	            {
        	                goto ruleelemltscEx;
        	            }
        	            if (HASFAILED())
        	            {
        	                return retval;
        	            }
        	             MATCHT(59, &FOLLOW_59_in_elemltsc1827); 
        	            if  (HASEXCEPTION())
        	            {
        	                goto ruleelemltscEx;
        	            }
        	            if (HASFAILED())
        	            {
        	                return retval;
        	            }

        	        }

        	        if ( BACKTRACKING==0 ) 
        	        {

        	                        retval.ltsc= l.ltsc;
        	                        
        	        }

        	    }
        	    break;

            }
        }
    }
    

    // This is where rules clean up and exit
    //
    goto ruleelemltscEx; /* Prevent compiler warnings */
    ruleelemltscEx: ;
    retval.stop = LT(-1);

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }


    return retval;
}
/* $ANTLR end elemltsc */

/** 
 * $ANTLR start transetschema
 * cps/CPS.g:1045:1: transetschema returns [TransitionSetSchema* tss] : (t1= transchema (t2= choicetranschema[$t1.ts] )* )* ;
 */
static CPSParser_transetschema_return
transetschema(pCPSParser ctx)
{   
    CPSParser_transetschema_return retval;

    CPSParser_transchema_return t1;
    #undef	RETURN_TYPE_t1
    #define	RETURN_TYPE_t1 CPSParser_transchema_return

    CPSParser_choicetranschema_return t2;
    #undef	RETURN_TYPE_t2
    #define	RETURN_TYPE_t2 CPSParser_choicetranschema_return

    /* Initialize rule variables
     */


    retval.start = LT(1); retval.stop = retval.start;

    {
        // cps/CPS.g:1046:2: ( (t1= transchema (t2= choicetranschema[$t1.ts] )* )* )
        // cps/CPS.g:1047:2: (t1= transchema (t2= choicetranschema[$t1.ts] )* )*
        {
            if ( BACKTRACKING==0 ) 
            {

                	retval.tss= new TransitionSetSchema();
                	
            }

            // cps/CPS.g:1050:2: (t1= transchema (t2= choicetranschema[$t1.ts] )* )*

            for (;;)
            {
                int alt18=2;
                switch ( LA(1) ) 
                {
                case SMALLID:
                case CAPITID:
                case CAPITNUMID:
                	{
                		alt18=1;
                	}
                    break;

                }

                switch (alt18) 
                {
            	case 1:
            	    // cps/CPS.g:1051:2: t1= transchema (t2= choicetranschema[$t1.ts] )*
            	    {
            	        FOLLOWPUSH(FOLLOW_transchema_in_transetschema1868);
            	        t1=transchema(ctx);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletransetschemaEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        if ( BACKTRACKING==0 ) 
            	        {

            	                            if(t1.ts == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Parametrised transition expected.\n";
            	                            }
            	                            else if(!t1.ts->hasVisibleGuard())
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Parametrised transition has an invisible guard.\n";
            	                            }
            	                            else
            	            		{
            	                                retval.tss->insert(t1.ts);
            	            		}
            	                        
            	        }

            	        // cps/CPS.g:1068:2: (t2= choicetranschema[$t1.ts] )*

            	        for (;;)
            	        {
            	            int alt17=2;
            	            switch ( LA(1) ) 
            	            {
            	            case CHOICE:
            	            	{
            	            		alt17=1;
            	            	}
            	                break;

            	            }

            	            switch (alt17) 
            	            {
            	        	case 1:
            	        	    // cps/CPS.g:1068:3: t2= choicetranschema[$t1.ts]
            	        	    {
            	        	        FOLLOWPUSH(FOLLOW_choicetranschema_in_transetschema1889);
            	        	        t2=choicetranschema(ctx, t1.ts);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruletransetschemaEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return retval;
            	        	        }
            	        	        if ( BACKTRACKING==0 ) 
            	        	        {

            	        	                            if(t2.ts == 0)
            	        	                            {
            	        	                                printPosition(retval.start);
            	        	                                std::cout << "Parametrised transition expected.\n";
            	        	                            }
            	        	                            else if(!t2.ts->hasVisibleGuard())
            	        	                            {
            	        	                                printPosition(retval.start);
            	        	                                std::cout << "Parametrised transition has an invisible guard.\n";
            	        	                            }
            	        	                            else
            	        	            		{
            	        	                                retval.tss->insert(t2.ts);
            	        	            		}
            	        	                        
            	        	        }

            	        	    }
            	        	    break;

            	        	default:
            	        	    goto loop17;	/* break out of the loop */
            	        	    break;
            	            }
            	        }
            	        loop17: ; /* Jump out to here if this rule does not match */


            	    }
            	    break;

            	default:
            	    goto loop18;	/* break out of the loop */
            	    break;
                }
            }
            loop18: ; /* Jump out to here if this rule does not match */


        }

    }
    

    // This is where rules clean up and exit
    //
    goto ruletransetschemaEx; /* Prevent compiler warnings */
    ruletransetschemaEx: ;
    retval.stop = LT(-1);

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }


    return retval;
}
/* $ANTLR end transetschema */

/** 
 * $ANTLR start transchema
 * cps/CPS.g:1089:1: transchema returns [TransitionSchema* ts] : s1= fromstateschema '=' ( CHOICE bpl= boundparlist ':' )? ( '[' g= valf ']' )? (a= actionschema ) IMPL s2= stateschema ;
 */
static CPSParser_transchema_return
transchema(pCPSParser ctx)
{   
    CPSParser_transchema_return retval;

    CPSParser_fromstateschema_return s1;
    #undef	RETURN_TYPE_s1
    #define	RETURN_TYPE_s1 CPSParser_fromstateschema_return

    CPSParser_boundparlist_return bpl;
    #undef	RETURN_TYPE_bpl
    #define	RETURN_TYPE_bpl CPSParser_boundparlist_return

    ValuationFormula* g;
    #undef	RETURN_TYPE_g
    #define	RETURN_TYPE_g ValuationFormula*

    CPSParser_actionschema_return a;
    #undef	RETURN_TYPE_a
    #define	RETURN_TYPE_a CPSParser_actionschema_return

    CPSParser_stateschema_return s2;
    #undef	RETURN_TYPE_s2
    #define	RETURN_TYPE_s2 CPSParser_stateschema_return

    /* Initialize rule variables
     */


    g = NULL;
    retval.start = LT(1); retval.stop = retval.start;

    {
        // cps/CPS.g:1090:3: (s1= fromstateschema '=' ( CHOICE bpl= boundparlist ':' )? ( '[' g= valf ']' )? (a= actionschema ) IMPL s2= stateschema )
        // cps/CPS.g:1090:5: s1= fromstateschema '=' ( CHOICE bpl= boundparlist ':' )? ( '[' g= valf ']' )? (a= actionschema ) IMPL s2= stateschema
        {
            FOLLOWPUSH(FOLLOW_fromstateschema_in_transchema1931);
            s1=fromstateschema(ctx);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruletranschemaEx;
            }
            if (HASFAILED())
            {
                return retval;
            }
            if ( BACKTRACKING==0 ) 
            {

                			retval.ts= new TransitionSchema();
                                        if(s1.stsc == 0)
                                        {
                                            printPosition(retval.start);
                                            std::cout << "Parametrised state expected.\n";
                                        }
                                        else
                			{
                                            retval.ts->setFromState(s1.stsc);
                			}
                                    
            }
             MATCHT(50, &FOLLOW_50_in_transchema1957); 
            if  (HASEXCEPTION())
            {
                goto ruletranschemaEx;
            }
            if (HASFAILED())
            {
                return retval;
            }

            // cps/CPS.g:1104:3: ( CHOICE bpl= boundparlist ':' )?
            {
                int alt19=2;
                switch ( LA(1) ) 
                {
                    case CHOICE:
                    	{
                    		alt19=1;
                    	}
                        break;
                }

                switch (alt19) 
                {
            	case 1:
            	    // cps/CPS.g:1104:5: CHOICE bpl= boundparlist ':'
            	    {
            	         MATCHT(CHOICE, &FOLLOW_CHOICE_in_transchema1963); 
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletranschemaEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        FOLLOWPUSH(FOLLOW_boundparlist_in_transchema1969);
            	        bpl=boundparlist(ctx);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletranschemaEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	         MATCHT(54, &FOLLOW_54_in_transchema1971); 
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletranschemaEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        if ( BACKTRACKING==0 ) 
            	        {

            	            			if(bpl.bal == 0)
            	                                    {
            	                                        printPosition(retval.start);
            	                                        std::cout << "Variable list expected.\n";
            	                                    }
            	                                    else
            	                                    {
            	                                        retval.ts->setBoundParameters(bpl.bal);
            	                                    }
            	                                
            	        }

            	    }
            	    break;

                }
            }

            // cps/CPS.g:1117:4: ( '[' g= valf ']' )?
            {
                int alt20=2;
                switch ( LA(1) ) 
                {
                    case 48:
                    	{
                    		alt20=1;
                    	}
                        break;
                }

                switch (alt20) 
                {
            	case 1:
            	    // cps/CPS.g:1117:5: '[' g= valf ']'
            	    {
            	         MATCHT(48, &FOLLOW_48_in_transchema2004); 
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletranschemaEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        FOLLOWPUSH(FOLLOW_valf_in_transchema2010);
            	        g=valf(ctx);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletranschemaEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	         MATCHT(49, &FOLLOW_49_in_transchema2012); 
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletranschemaEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        if ( BACKTRACKING==0 ) 
            	        {

            	            		 	if(g == 0)
            	                                    {
            	                                        printPosition(retval.start);
            	                                        std::cout << "Guard expected.\n";
            	                                    }
            	                                    else if(!g->isUnquantified())
            	                                    {
            	                                        printPosition(retval.start);
            	                                        std::cout << "Unquantified guard expected.\n";
            	                                    }
            	                                    else
            	            		 	{
            	                                        retval.ts->setGuard(g);
            	            		 	}
            	                                
            	        }

            	    }
            	    break;

                }
            }
            // cps/CPS.g:1135:4: (a= actionschema )
            // cps/CPS.g:1135:5: a= actionschema
            {
                FOLLOWPUSH(FOLLOW_actionschema_in_transchema2051);
                a=actionschema(ctx);

                FOLLOWPOP();
                if  (HASEXCEPTION())
                {
                    goto ruletranschemaEx;
                }
                if (HASFAILED())
                {
                    return retval;
                }
                if ( BACKTRACKING==0 ) 
                {

                                            if(a.actsc == 0)
                                            {
                                                printPosition(retval.start);
                                                std::cout << "Parametrised event expected.\n";
                                            }
                                            else if(!context.isCorrectlyTyped(a.actsc))
                                            {
                                                printPosition(retval.start);
                                                std::cout << "The types of the parametrised event and the channel do not match.\n";
                                            }
                                            else
                    		 	{
                                                retval.ts->setActionSchema(a.actsc);
                    		 	}
                                        
                }

            }

             MATCHT(IMPL, &FOLLOW_IMPL_in_transchema2083); 
            if  (HASEXCEPTION())
            {
                goto ruletranschemaEx;
            }
            if (HASFAILED())
            {
                return retval;
            }
            FOLLOWPUSH(FOLLOW_stateschema_in_transchema2089);
            s2=stateschema(ctx);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruletranschemaEx;
            }
            if (HASFAILED())
            {
                return retval;
            }
            if ( BACKTRACKING==0 ) 
            {

                                        if(s2.stsc == 0)
                                        {
                                            printPosition(retval.start);
                                            std::cout << "Parametrised state expected.\n";
                                        }
                                        else
                                        {
                                            retval.ts->setToState(s2.stsc);
                 			}
                                    
            }

        }

    }
    

    // This is where rules clean up and exit
    //
    goto ruletranschemaEx; /* Prevent compiler warnings */
    ruletranschemaEx: ;
    retval.stop = LT(-1);

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }


    return retval;
}
/* $ANTLR end transchema */

/** 
 * $ANTLR start choicetranschema
 * cps/CPS.g:1167:1: choicetranschema[TransitionSchema* tsin] returns [TransitionSchema* ts] : CHOICE ( CHOICE bpl= boundparlist ':' )? ( '[' g= valf ']' )? (a= actionschema ) IMPL s2= stateschema ;
 */
static CPSParser_choicetranschema_return
choicetranschema(pCPSParser ctx, TransitionSchema* tsin)
{   
    CPSParser_choicetranschema_return retval;

    CPSParser_boundparlist_return bpl;
    #undef	RETURN_TYPE_bpl
    #define	RETURN_TYPE_bpl CPSParser_boundparlist_return

    ValuationFormula* g;
    #undef	RETURN_TYPE_g
    #define	RETURN_TYPE_g ValuationFormula*

    CPSParser_actionschema_return a;
    #undef	RETURN_TYPE_a
    #define	RETURN_TYPE_a CPSParser_actionschema_return

    CPSParser_stateschema_return s2;
    #undef	RETURN_TYPE_s2
    #define	RETURN_TYPE_s2 CPSParser_stateschema_return

    /* Initialize rule variables
     */


    g = NULL;
    retval.start = LT(1); retval.stop = retval.start;

    {
        // cps/CPS.g:1169:3: ( CHOICE ( CHOICE bpl= boundparlist ':' )? ( '[' g= valf ']' )? (a= actionschema ) IMPL s2= stateschema )
        // cps/CPS.g:1169:5: CHOICE ( CHOICE bpl= boundparlist ':' )? ( '[' g= valf ']' )? (a= actionschema ) IMPL s2= stateschema
        {
             MATCHT(CHOICE, &FOLLOW_CHOICE_in_choicetranschema2132); 
            if  (HASEXCEPTION())
            {
                goto rulechoicetranschemaEx;
            }
            if (HASFAILED())
            {
                return retval;
            }
            if ( BACKTRACKING==0 ) 
            {

                                            if(tsin == 0)
                                            {
                                                retval.ts= new TransitionSchema(0,0,0,0,0);
                                            }
                                            else
                                            {
                        			retval.ts= new TransitionSchema(new StateSchema(tsin->getFromState()), 0, 0, 0, 0);
                                            }
                			
            }

            // cps/CPS.g:1180:3: ( CHOICE bpl= boundparlist ':' )?
            {
                int alt21=2;
                switch ( LA(1) ) 
                {
                    case CHOICE:
                    	{
                    		alt21=1;
                    	}
                        break;
                }

                switch (alt21) 
                {
            	case 1:
            	    // cps/CPS.g:1180:5: CHOICE bpl= boundparlist ':'
            	    {
            	         MATCHT(CHOICE, &FOLLOW_CHOICE_in_choicetranschema2144); 
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulechoicetranschemaEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        FOLLOWPUSH(FOLLOW_boundparlist_in_choicetranschema2150);
            	        bpl=boundparlist(ctx);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulechoicetranschemaEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	         MATCHT(54, &FOLLOW_54_in_choicetranschema2152); 
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulechoicetranschemaEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        if ( BACKTRACKING==0 ) 
            	        {

            	            			if(bpl.bal == 0)
            	                                    {
            	                                        printPosition(retval.start);
            	                                        std::cout << "Variable list expected.\n";
            	                                    }
            	                                    else
            	                                    {
            	                                        retval.ts->setBoundParameters(bpl.bal);
            	                                    }
            	                                
            	        }

            	    }
            	    break;

                }
            }

            // cps/CPS.g:1193:3: ( '[' g= valf ']' )?
            {
                int alt22=2;
                switch ( LA(1) ) 
                {
                    case 48:
                    	{
                    		alt22=1;
                    	}
                        break;
                }

                switch (alt22) 
                {
            	case 1:
            	    // cps/CPS.g:1193:4: '[' g= valf ']'
            	    {
            	         MATCHT(48, &FOLLOW_48_in_choicetranschema2184); 
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulechoicetranschemaEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        FOLLOWPUSH(FOLLOW_valf_in_choicetranschema2190);
            	        g=valf(ctx);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulechoicetranschemaEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	         MATCHT(49, &FOLLOW_49_in_choicetranschema2192); 
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulechoicetranschemaEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        if ( BACKTRACKING==0 ) 
            	        {

            	            		 	if(g == 0)
            	                                    {
            	                                        printPosition(retval.start);
            	                                        std::cout << "Guard expected.\n";
            	                                    }
            	                                    else if(!g->isUnquantified())
            	                                    {
            	                                        printPosition(retval.start);
            	                                        std::cout << "Unquantified guard expected.\n";
            	                                    }
            	                                    else
            	            		 	{
            	                                        retval.ts->setGuard(g);
            	            		 	}
            	                                
            	        }

            	    }
            	    break;

                }
            }
            // cps/CPS.g:1211:4: (a= actionschema )
            // cps/CPS.g:1212:4: a= actionschema
            {
                FOLLOWPUSH(FOLLOW_actionschema_in_choicetranschema2234);
                a=actionschema(ctx);

                FOLLOWPOP();
                if  (HASEXCEPTION())
                {
                    goto rulechoicetranschemaEx;
                }
                if (HASFAILED())
                {
                    return retval;
                }
                if ( BACKTRACKING==0 ) 
                {

                                            if(a.actsc == 0)
                                            {
                                                printPosition(retval.start);
                                                std::cout << "Parametrised event expected.\n";
                                            }
                                            else if(!context.isCorrectlyTyped(a.actsc))
                                            {
                                                printPosition(retval.start);
                                                std::cout << "The types of the parametrised event and the channel do not match.\n";
                                            }
                                            else
                    		 	{
                                                retval.ts->setActionSchema(a.actsc);
                    		 	}
                                        
                }

            }

             MATCHT(IMPL, &FOLLOW_IMPL_in_choicetranschema2266); 
            if  (HASEXCEPTION())
            {
                goto rulechoicetranschemaEx;
            }
            if (HASFAILED())
            {
                return retval;
            }
            FOLLOWPUSH(FOLLOW_stateschema_in_choicetranschema2272);
            s2=stateschema(ctx);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulechoicetranschemaEx;
            }
            if (HASFAILED())
            {
                return retval;
            }
            if ( BACKTRACKING==0 ) 
            {

                                        if(s2.stsc == 0)
                                        {
                                            printPosition(retval.start);
                                            std::cout << "Parametrised state expected.\n";
                                        }
                                        else
                                        {
                                            retval.ts->setToState(s2.stsc);
                 			}
                                    
            }

        }

    }
    

    // This is where rules clean up and exit
    //
    goto rulechoicetranschemaEx; /* Prevent compiler warnings */
    rulechoicetranschemaEx: ;
    retval.stop = LT(-1);

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }


    return retval;
}
/* $ANTLR end choicetranschema */

/** 
 * $ANTLR start setschema
 * cps/CPS.g:1244:1: setschema returns [SetSchema* ssc] : (s1= elemssc | s2= repssc | s3= condssc ) ( ( CUP | PLUS ) (s1= elemssc | s2= repssc | s3= condssc ) )* ;
 */
static CPSParser_setschema_return
setschema(pCPSParser ctx)
{   
    CPSParser_setschema_return retval;

    CPSParser_elemssc_return s1;
    #undef	RETURN_TYPE_s1
    #define	RETURN_TYPE_s1 CPSParser_elemssc_return

    CPSParser_repssc_return s2;
    #undef	RETURN_TYPE_s2
    #define	RETURN_TYPE_s2 CPSParser_repssc_return

    CPSParser_condssc_return s3;
    #undef	RETURN_TYPE_s3
    #define	RETURN_TYPE_s3 CPSParser_condssc_return

    /* Initialize rule variables
     */


    retval.start = LT(1); retval.stop = retval.start;

    {
        // cps/CPS.g:1245:2: ( (s1= elemssc | s2= repssc | s3= condssc ) ( ( CUP | PLUS ) (s1= elemssc | s2= repssc | s3= condssc ) )* )
        // cps/CPS.g:1245:4: (s1= elemssc | s2= repssc | s3= condssc ) ( ( CUP | PLUS ) (s1= elemssc | s2= repssc | s3= condssc ) )*
        {
            if ( BACKTRACKING==0 ) 
            {
                retval.ssc= 0;
            }

            // cps/CPS.g:1245:16: (s1= elemssc | s2= repssc | s3= condssc )
            {
                int alt23=3;
                switch ( LA(1) ) 
                {
                case SMALLID:
                case CAPITID:
                case CAPITNUMID:
                case 51:
                case 58:
                	{
                		alt23=1;
                	}
                    break;
                case CUP:
                case PLUS:
                	{
                		alt23=2;
                	}
                    break;
                case 48:
                	{
                		alt23=3;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return retval;
                    }
                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 23;
                    EXCEPTION->state        = 0;


                    goto rulesetschemaEx;
                }

                switch (alt23) 
                {
            	case 1:
            	    // cps/CPS.g:1245:17: s1= elemssc
            	    {
            	        FOLLOWPUSH(FOLLOW_elemssc_in_setschema2317);
            	        s1=elemssc(ctx);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulesetschemaEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        if ( BACKTRACKING==0 ) 
            	        {
            	            retval.ssc= s1.ssc;
            	        }

            	    }
            	    break;
            	case 2:
            	    // cps/CPS.g:1245:50: s2= repssc
            	    {
            	        FOLLOWPUSH(FOLLOW_repssc_in_setschema2327);
            	        s2=repssc(ctx);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulesetschemaEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        if ( BACKTRACKING==0 ) 
            	        {
            	            retval.ssc= s2.ssc;
            	        }

            	    }
            	    break;
            	case 3:
            	    // cps/CPS.g:1245:82: s3= condssc
            	    {
            	        FOLLOWPUSH(FOLLOW_condssc_in_setschema2337);
            	        s3=condssc(ctx);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulesetschemaEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        if ( BACKTRACKING==0 ) 
            	        {
            	            retval.ssc= s3.ssc;
            	        }

            	    }
            	    break;

                }
            }

            // cps/CPS.g:1246:2: ( ( CUP | PLUS ) (s1= elemssc | s2= repssc | s3= condssc ) )*

            for (;;)
            {
                int alt25=2;
                switch ( LA(1) ) 
                {
                case CUP:
                case PLUS:
                	{
                		alt25=1;
                	}
                    break;

                }

                switch (alt25) 
                {
            	case 1:
            	    // cps/CPS.g:1247:2: ( CUP | PLUS ) (s1= elemssc | s2= repssc | s3= condssc )
            	    {
            	        if ( ((LA(1) >= CUP) && (LA(1) <= PLUS)) )
            	        {
            	            CONSUME();
            	            PERRORRECOVERY=ANTLR3_FALSE;FAILEDFLAG=ANTLR3_FALSE;

            	        }
            	        else 
            	        {
            	            if (BACKTRACKING>0)
            	            {
            	                FAILEDFLAG = ANTLR3_TRUE;
            	                return retval;
            	            }
            	            CONSTRUCTEX();
            	            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            	            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
            	            EXCEPTION->expectingSet = &FOLLOW_set_in_setschema2346;
            	            RECOVERFROMMISMATCHEDSET(&FOLLOW_set_in_setschema2346);    goto rulesetschemaEx;
            	        }


            	        // cps/CPS.g:1247:15: (s1= elemssc | s2= repssc | s3= condssc )
            	        {
            	            int alt24=3;
            	            switch ( LA(1) ) 
            	            {
            	            case SMALLID:
            	            case CAPITID:
            	            case CAPITNUMID:
            	            case 51:
            	            case 58:
            	            	{
            	            		alt24=1;
            	            	}
            	                break;
            	            case CUP:
            	            case PLUS:
            	            	{
            	            		alt24=2;
            	            	}
            	                break;
            	            case 48:
            	            	{
            	            		alt24=3;
            	            	}
            	                break;

            	            default:
            	                if (BACKTRACKING>0)
            	                {
            	                    FAILEDFLAG = ANTLR3_TRUE;
            	                    return retval;
            	                }
            	                CONSTRUCTEX();
            	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	                EXCEPTION->message      = (void *)"";
            	                EXCEPTION->decisionNum  = 24;
            	                EXCEPTION->state        = 0;


            	                goto rulesetschemaEx;
            	            }

            	            switch (alt24) 
            	            {
            	        	case 1:
            	        	    // cps/CPS.g:1247:16: s1= elemssc
            	        	    {
            	        	        FOLLOWPUSH(FOLLOW_elemssc_in_setschema2359);
            	        	        s1=elemssc(ctx);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulesetschemaEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return retval;
            	        	        }
            	        	        if ( BACKTRACKING==0 ) 
            	        	        {

            	        	                            if(s1.ssc == 0)
            	        	                            {
            	        	                                printPosition(retval.start);
            	        	                                std::cout << "Parametrised set expected.\n";
            	        	                            }
            	        	                            else if(retval.ssc != 0)
            	        	                            {
            	        	                                retval.ssc= new UnionSetSchema(retval.ssc, s1.ssc);
            	        	                            }
            	        	                        
            	        	        }

            	        	    }
            	        	    break;
            	        	case 2:
            	        	    // cps/CPS.g:1259:15: s2= repssc
            	        	    {
            	        	        FOLLOWPUSH(FOLLOW_repssc_in_setschema2394);
            	        	        s2=repssc(ctx);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulesetschemaEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return retval;
            	        	        }
            	        	        if ( BACKTRACKING==0 ) 
            	        	        {

            	        	                            if(s2.ssc == 0)
            	        	                            {
            	        	                                printPosition(retval.start);
            	        	                                std::cout << "Parametrised set expected.\n";
            	        	                            }
            	        	                            else if(retval.ssc != 0)
            	        	                            {
            	        	                                retval.ssc= new UnionSetSchema(retval.ssc, s2.ssc);
            	        	                            }
            	        	                        
            	        	        }

            	        	    }
            	        	    break;
            	        	case 3:
            	        	    // cps/CPS.g:1271:15: s3= condssc
            	        	    {
            	        	        FOLLOWPUSH(FOLLOW_condssc_in_setschema2429);
            	        	        s3=condssc(ctx);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulesetschemaEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return retval;
            	        	        }

            	        	    }
            	        	    break;

            	            }
            	        }
            	        if ( BACKTRACKING==0 ) 
            	        {

            	                            if(s3.ssc == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Parametrised set expected.\n";
            	                            }
            	                            else if(retval.ssc != 0)
            	                            {
            	                                retval.ssc= new UnionSetSchema(retval.ssc, s3.ssc);
            	                            }
            	                        
            	        }

            	    }
            	    break;

            	default:
            	    goto loop25;	/* break out of the loop */
            	    break;
                }
            }
            loop25: ; /* Jump out to here if this rule does not match */


        }

    }
    

    // This is where rules clean up and exit
    //
    goto rulesetschemaEx; /* Prevent compiler warnings */
    rulesetschemaEx: ;
    retval.stop = LT(-1);

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }


    return retval;
}
/* $ANTLR end setschema */

/** 
 * $ANTLR start repssc
 * cps/CPS.g:1286:1: repssc returns [SetSchema* ssc] : ( ( CUP | PLUS ) avl= boundparlist ':' (s1= elemssc | s2= repssc | s3= condssc ) ) ;
 */
static CPSParser_repssc_return
repssc(pCPSParser ctx)
{   
    CPSParser_repssc_return retval;

    CPSParser_boundparlist_return avl;
    #undef	RETURN_TYPE_avl
    #define	RETURN_TYPE_avl CPSParser_boundparlist_return

    CPSParser_elemssc_return s1;
    #undef	RETURN_TYPE_s1
    #define	RETURN_TYPE_s1 CPSParser_elemssc_return

    CPSParser_repssc_return s2;
    #undef	RETURN_TYPE_s2
    #define	RETURN_TYPE_s2 CPSParser_repssc_return

    CPSParser_condssc_return s3;
    #undef	RETURN_TYPE_s3
    #define	RETURN_TYPE_s3 CPSParser_condssc_return

    /* Initialize rule variables
     */


    retval.start = LT(1); retval.stop = retval.start;

    {
        // cps/CPS.g:1287:2: ( ( ( CUP | PLUS ) avl= boundparlist ':' (s1= elemssc | s2= repssc | s3= condssc ) ) )
        // cps/CPS.g:1287:4: ( ( CUP | PLUS ) avl= boundparlist ':' (s1= elemssc | s2= repssc | s3= condssc ) )
        {
            // cps/CPS.g:1287:4: ( ( CUP | PLUS ) avl= boundparlist ':' (s1= elemssc | s2= repssc | s3= condssc ) )
            // cps/CPS.g:1287:5: ( CUP | PLUS ) avl= boundparlist ':' (s1= elemssc | s2= repssc | s3= condssc )
            {
                if ( ((LA(1) >= CUP) && (LA(1) <= PLUS)) )
                {
                    CONSUME();
                    PERRORRECOVERY=ANTLR3_FALSE;FAILEDFLAG=ANTLR3_FALSE;

                }
                else 
                {
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return retval;
                    }
                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                    EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
                    EXCEPTION->expectingSet = &FOLLOW_set_in_repssc2464;
                    RECOVERFROMMISMATCHEDSET(&FOLLOW_set_in_repssc2464);    goto rulerepsscEx;
                }

                FOLLOWPUSH(FOLLOW_boundparlist_in_repssc2476);
                avl=boundparlist(ctx);

                FOLLOWPOP();
                if  (HASEXCEPTION())
                {
                    goto rulerepsscEx;
                }
                if (HASFAILED())
                {
                    return retval;
                }
                 MATCHT(54, &FOLLOW_54_in_repssc2478); 
                if  (HASEXCEPTION())
                {
                    goto rulerepsscEx;
                }
                if (HASFAILED())
                {
                    return retval;
                }
                if ( BACKTRACKING==0 ) 
                {
                    retval.ssc= 0;
                }

                // cps/CPS.g:1287:53: (s1= elemssc | s2= repssc | s3= condssc )
                {
                    int alt26=3;
                    switch ( LA(1) ) 
                    {
                    case SMALLID:
                    case CAPITID:
                    case CAPITNUMID:
                    case 51:
                    case 58:
                    	{
                    		alt26=1;
                    	}
                        break;
                    case CUP:
                    case PLUS:
                    	{
                    		alt26=2;
                    	}
                        break;
                    case 48:
                    	{
                    		alt26=3;
                    	}
                        break;

                    default:
                        if (BACKTRACKING>0)
                        {
                            FAILEDFLAG = ANTLR3_TRUE;
                            return retval;
                        }
                        CONSTRUCTEX();
                        EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                        EXCEPTION->message      = (void *)"";
                        EXCEPTION->decisionNum  = 26;
                        EXCEPTION->state        = 0;


                        goto rulerepsscEx;
                    }

                    switch (alt26) 
                    {
                	case 1:
                	    // cps/CPS.g:1287:54: s1= elemssc
                	    {
                	        FOLLOWPUSH(FOLLOW_elemssc_in_repssc2487);
                	        s1=elemssc(ctx);

                	        FOLLOWPOP();
                	        if  (HASEXCEPTION())
                	        {
                	            goto rulerepsscEx;
                	        }
                	        if (HASFAILED())
                	        {
                	            return retval;
                	        }
                	        if ( BACKTRACKING==0 ) 
                	        {
                	            retval.ssc= s1.ssc;
                	        }

                	    }
                	    break;
                	case 2:
                	    // cps/CPS.g:1287:87: s2= repssc
                	    {
                	        FOLLOWPUSH(FOLLOW_repssc_in_repssc2497);
                	        s2=repssc(ctx);

                	        FOLLOWPOP();
                	        if  (HASEXCEPTION())
                	        {
                	            goto rulerepsscEx;
                	        }
                	        if (HASFAILED())
                	        {
                	            return retval;
                	        }
                	        if ( BACKTRACKING==0 ) 
                	        {
                	            retval.ssc= s2.ssc;
                	        }

                	    }
                	    break;
                	case 3:
                	    // cps/CPS.g:1287:119: s3= condssc
                	    {
                	        FOLLOWPUSH(FOLLOW_condssc_in_repssc2507);
                	        s3=condssc(ctx);

                	        FOLLOWPOP();
                	        if  (HASEXCEPTION())
                	        {
                	            goto rulerepsscEx;
                	        }
                	        if (HASFAILED())
                	        {
                	            return retval;
                	        }
                	        if ( BACKTRACKING==0 ) 
                	        {
                	            retval.ssc= s3.ssc;
                	        }

                	    }
                	    break;

                    }
                }

            }

            if ( BACKTRACKING==0 ) 
            {

                                if(retval.ssc == 0)
                                {
                                    printPosition(retval.start);
                                    std::cout << "Parametrised set expected.\n";
                                }
                                else if(avl.bal == 0)
                                {
                                    printPosition(retval.start);
                                    std::cout << "Variable list expected.\n";
                                }
                                else
                                {
                                    for(int i = 0; i < avl.bal->size(); ++i)
                                    {
                                            const AtomVariable& av = dynamic_cast<const AtomVariableSchema*>(avl.bal->operator[](i))->getAtomVariable();
                                            retval.ssc= new ReplicatedSetSchema(new AtomVariable(av), retval.ssc);
                                    }
                                }
                		delete avl.bal;
                            
            }

        }

    }
    

    // This is where rules clean up and exit
    //
    goto rulerepsscEx; /* Prevent compiler warnings */
    rulerepsscEx: ;
    retval.stop = LT(-1);

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }


    return retval;
}
/* $ANTLR end repssc */

/** 
 * $ANTLR start elemssc
 * cps/CPS.g:1311:1: elemssc returns [SetSchema* ssc] : ( (a= actionsetsc ) | (name= string ) | '(' s= setschema ')' );
 */
static CPSParser_elemssc_return
elemssc(pCPSParser ctx)
{   
    CPSParser_elemssc_return retval;

    CPSParser_actionsetsc_return a;
    #undef	RETURN_TYPE_a
    #define	RETURN_TYPE_a CPSParser_actionsetsc_return

    std::string* name;
    #undef	RETURN_TYPE_name
    #define	RETURN_TYPE_name std::string*

    CPSParser_setschema_return s;
    #undef	RETURN_TYPE_s
    #define	RETURN_TYPE_s CPSParser_setschema_return

    /* Initialize rule variables
     */


    name = NULL;
    retval.start = LT(1); retval.stop = retval.start;

    {
        {
            //  cps/CPS.g:1312:2: ( (a= actionsetsc ) | (name= string ) | '(' s= setschema ')' )
            
            ANTLR3_UINT32 alt27;

            alt27=3;

            switch ( LA(1) ) 
            {
            case 51:
            	{
            		alt27=1;
            	}
                break;
            case SMALLID:
            case CAPITID:
            case CAPITNUMID:
            	{
            		alt27=2;
            	}
                break;
            case 58:
            	{
            		alt27=3;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return retval;
                }
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 27;
                EXCEPTION->state        = 0;


                goto ruleelemsscEx;
            }

            switch (alt27) 
            {
        	case 1:
        	    // cps/CPS.g:1312:4: (a= actionsetsc )
        	    {
        	        // cps/CPS.g:1312:4: (a= actionsetsc )
        	        // cps/CPS.g:1312:5: a= actionsetsc
        	        {
        	            FOLLOWPUSH(FOLLOW_actionsetsc_in_elemssc2546);
        	            a=actionsetsc(ctx);

        	            FOLLOWPOP();
        	            if  (HASEXCEPTION())
        	            {
        	                goto ruleelemsscEx;
        	            }
        	            if (HASFAILED())
        	            {
        	                return retval;
        	            }

        	        }

        	        if ( BACKTRACKING==0 ) 
        	        {

        	                            if(a.asc == 0)
        	                            {
        	                                retval.ssc= 0;
        	                                printPosition(retval.start);
        	                                std::cout << "A set of parametrised events expected.\n";
        	                            }
        	                            else
        	                            {
        	                                retval.ssc= new ElementarySetSchema(a.asc);
        	                            }
        	                        
        	        }

        	    }
        	    break;
        	case 2:
        	    // cps/CPS.g:1325:4: (name= string )
        	    {
        	        // cps/CPS.g:1325:4: (name= string )
        	        // cps/CPS.g:1325:5: name= string
        	        {
        	            FOLLOWPUSH(FOLLOW_string_in_elemssc2571);
        	            name=string(ctx);

        	            FOLLOWPOP();
        	            if  (HASEXCEPTION())
        	            {
        	                goto ruleelemsscEx;
        	            }
        	            if (HASFAILED())
        	            {
        	                return retval;
        	            }

        	        }

        	        if ( BACKTRACKING==0 ) 
        	        {

        	                            if(!context.isSetSchema(name))
        	                            {
        	                                retval.ssc= 0;
        	                                printPosition(retval.start);
        	                                std::cout << "Identifier " << *(name) << " is not a parametrised set.\n";
        	                            }
        	                            else
        	            		{
        	                                retval.ssc= new NamedSetSchema(name, context.getSetSchema(name));
        	            		}
        	                        
        	        }

        	    }
        	    break;
        	case 3:
        	    // cps/CPS.g:1338:4: '(' s= setschema ')'
        	    {
        	         MATCHT(58, &FOLLOW_58_in_elemssc2591); 
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleelemsscEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return retval;
        	        }
        	        FOLLOWPUSH(FOLLOW_setschema_in_elemssc2597);
        	        s=setschema(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleelemsscEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return retval;
        	        }
        	         MATCHT(59, &FOLLOW_59_in_elemssc2599); 
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleelemsscEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return retval;
        	        }
        	        if ( BACKTRACKING==0 ) 
        	        {

        	            		retval.ssc= s.ssc;
        	                        
        	        }

        	    }
        	    break;

            }
        }
    }
    

    // This is where rules clean up and exit
    //
    goto ruleelemsscEx; /* Prevent compiler warnings */
    ruleelemsscEx: ;
    retval.stop = LT(-1);

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }


    return retval;
}
/* $ANTLR end elemssc */

/** 
 * $ANTLR start condssc
 * cps/CPS.g:1344:1: condssc returns [SetSchema* ssc] : '[' v= valf ']' (s1= condssc | s2= elemssc | s3= repssc ) ;
 */
static CPSParser_condssc_return
condssc(pCPSParser ctx)
{   
    CPSParser_condssc_return retval;

    ValuationFormula* v;
    #undef	RETURN_TYPE_v
    #define	RETURN_TYPE_v ValuationFormula*

    CPSParser_condssc_return s1;
    #undef	RETURN_TYPE_s1
    #define	RETURN_TYPE_s1 CPSParser_condssc_return

    CPSParser_elemssc_return s2;
    #undef	RETURN_TYPE_s2
    #define	RETURN_TYPE_s2 CPSParser_elemssc_return

    CPSParser_repssc_return s3;
    #undef	RETURN_TYPE_s3
    #define	RETURN_TYPE_s3 CPSParser_repssc_return

    /* Initialize rule variables
     */


    v = NULL;
    retval.start = LT(1); retval.stop = retval.start;

    {
        // cps/CPS.g:1345:2: ( '[' v= valf ']' (s1= condssc | s2= elemssc | s3= repssc ) )
        // cps/CPS.g:1345:4: '[' v= valf ']' (s1= condssc | s2= elemssc | s3= repssc )
        {
             MATCHT(48, &FOLLOW_48_in_condssc2629); 
            if  (HASEXCEPTION())
            {
                goto rulecondsscEx;
            }
            if (HASFAILED())
            {
                return retval;
            }
            FOLLOWPUSH(FOLLOW_valf_in_condssc2635);
            v=valf(ctx);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulecondsscEx;
            }
            if (HASFAILED())
            {
                return retval;
            }
             MATCHT(49, &FOLLOW_49_in_condssc2637); 
            if  (HASEXCEPTION())
            {
                goto rulecondsscEx;
            }
            if (HASFAILED())
            {
                return retval;
            }
            if ( BACKTRACKING==0 ) 
            {
                retval.ssc= 0;
            }

            // cps/CPS.g:1345:33: (s1= condssc | s2= elemssc | s3= repssc )
            {
                int alt28=3;
                switch ( LA(1) ) 
                {
                case 48:
                	{
                		alt28=1;
                	}
                    break;
                case SMALLID:
                case CAPITID:
                case CAPITNUMID:
                case 51:
                case 58:
                	{
                		alt28=2;
                	}
                    break;
                case CUP:
                case PLUS:
                	{
                		alt28=3;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return retval;
                    }
                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 28;
                    EXCEPTION->state        = 0;


                    goto rulecondsscEx;
                }

                switch (alt28) 
                {
            	case 1:
            	    // cps/CPS.g:1345:34: s1= condssc
            	    {
            	        FOLLOWPUSH(FOLLOW_condssc_in_condssc2646);
            	        s1=condssc(ctx);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulecondsscEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        if ( BACKTRACKING==0 ) 
            	        {
            	            retval.ssc= s1.ssc;
            	        }

            	    }
            	    break;
            	case 2:
            	    // cps/CPS.g:1345:67: s2= elemssc
            	    {
            	        FOLLOWPUSH(FOLLOW_elemssc_in_condssc2656);
            	        s2=elemssc(ctx);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulecondsscEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        if ( BACKTRACKING==0 ) 
            	        {
            	            retval.ssc= s2.ssc;
            	        }

            	    }
            	    break;
            	case 3:
            	    // cps/CPS.g:1345:100: s3= repssc
            	    {
            	        FOLLOWPUSH(FOLLOW_repssc_in_condssc2666);
            	        s3=repssc(ctx);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulecondsscEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        if ( BACKTRACKING==0 ) 
            	        {
            	            retval.ssc= s3.ssc;
            	        }

            	    }
            	    break;

                }
            }
            if ( BACKTRACKING==0 ) 
            {

                                if(retval.ssc == 0)
                                {
                                    printPosition(retval.start);
                                    std::cout << "Parametrised LTS expected.\n";
                                }
                                else if(v == 0)
                                {
                                    printPosition(retval.start);
                                    std::cout << "Guard expected.\n";
                                }
                                else if(!v->isUnquantified())
                                {
                                    printPosition(retval.start);
                                    std::cout << "Unquantified guard expected.\n";           
                                }
                                else
                		{
                                    retval.ssc= new ConditionSetSchema(retval.ssc, v);
                		}
                            
            }

        }

    }
    

    // This is where rules clean up and exit
    //
    goto rulecondsscEx; /* Prevent compiler warnings */
    rulecondsscEx: ;
    retval.stop = LT(-1);

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }


    return retval;
}
/* $ANTLR end condssc */

/** 
 * $ANTLR start actionsetsc
 * cps/CPS.g:1370:1: actionsetsc returns [ActionSetSchema* asc] : '{' (a= actionschema ( ',' a= actionschema )* )? '}' ;
 */
static CPSParser_actionsetsc_return
actionsetsc(pCPSParser ctx)
{   
    CPSParser_actionsetsc_return retval;

    CPSParser_actionschema_return a;
    #undef	RETURN_TYPE_a
    #define	RETURN_TYPE_a CPSParser_actionschema_return

    /* Initialize rule variables
     */


    retval.start = LT(1); retval.stop = retval.start;

    {
        // cps/CPS.g:1371:2: ( '{' (a= actionschema ( ',' a= actionschema )* )? '}' )
        // cps/CPS.g:1372:2: '{' (a= actionschema ( ',' a= actionschema )* )? '}'
        {
             MATCHT(51, &FOLLOW_51_in_actionsetsc2704); 
            if  (HASEXCEPTION())
            {
                goto ruleactionsetscEx;
            }
            if (HASFAILED())
            {
                return retval;
            }
            if ( BACKTRACKING==0 ) 
            {

                	retval.asc= new ActionSetSchema();
                	//std::cout << "Action set created" << std::endl;
                	
            }

            // cps/CPS.g:1377:2: (a= actionschema ( ',' a= actionschema )* )?
            {
                int alt30=2;
                switch ( LA(1) ) 
                {
                    case NEG:
                    case TAU:
                    case SMALLID:
                    case 60:
                    	{
                    		alt30=1;
                    	}
                        break;
                }

                switch (alt30) 
                {
            	case 1:
            	    // cps/CPS.g:1378:2: a= actionschema ( ',' a= actionschema )*
            	    {
            	        FOLLOWPUSH(FOLLOW_actionschema_in_actionsetsc2717);
            	        a=actionschema(ctx);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleactionsetscEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        if ( BACKTRACKING==0 ) 
            	        {

            	            		if(a.actsc == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Parametrised event expected.\n";           
            	                            }
            	                            else if(!context.isCorrectlyTyped(a.actsc))
            	                            {
            	                                std::cout << "The types of the parametrised event and the channel do not match.\n";
            	                            }
            	                            else
            	            		{
            	                                retval.asc->push_back(a.actsc);
            	            		}
            	                        
            	        }

            	        // cps/CPS.g:1394:2: ( ',' a= actionschema )*

            	        for (;;)
            	        {
            	            int alt29=2;
            	            switch ( LA(1) ) 
            	            {
            	            case 52:
            	            	{
            	            		alt29=1;
            	            	}
            	                break;

            	            }

            	            switch (alt29) 
            	            {
            	        	case 1:
            	        	    // cps/CPS.g:1395:2: ',' a= actionschema
            	        	    {
            	        	         MATCHT(52, &FOLLOW_52_in_actionsetsc2737); 
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruleactionsetscEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return retval;
            	        	        }
            	        	        FOLLOWPUSH(FOLLOW_actionschema_in_actionsetsc2743);
            	        	        a=actionschema(ctx);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruleactionsetscEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return retval;
            	        	        }
            	        	        if ( BACKTRACKING==0 ) 
            	        	        {

            	        	            		if(a.actsc == 0)
            	        	                            {
            	        	                                printPosition(retval.start);
            	        	                                std::cout << "Parametrised event expected.\n";           
            	        	                            }
            	        	                            else if(!context.isCorrectlyTyped(a.actsc))
            	        	                            {
            	        	                                std::cout << "The types of the parametrised event and the channel do not match.\n";
            	        	                            }
            	        	                            else
            	        	            		{
            	        	                                retval.asc->push_back(a.actsc);
            	        	            		}
            	        	                        
            	        	        }

            	        	    }
            	        	    break;

            	        	default:
            	        	    goto loop29;	/* break out of the loop */
            	        	    break;
            	            }
            	        }
            	        loop29: ; /* Jump out to here if this rule does not match */


            	    }
            	    break;

                }
            }
             MATCHT(53, &FOLLOW_53_in_actionsetsc2768); 
            if  (HASEXCEPTION())
            {
                goto ruleactionsetscEx;
            }
            if (HASFAILED())
            {
                return retval;
            }

        }

    }
    

    // This is where rules clean up and exit
    //
    goto ruleactionsetscEx; /* Prevent compiler warnings */
    ruleactionsetscEx: ;
    retval.stop = LT(-1);

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }


    return retval;
}
/* $ANTLR end actionsetsc */

/** 
 * $ANTLR start valf
 * cps/CPS.g:1416:1: valf returns [ValuationFormula* vf] : ( (v1= equivf ) | (v2= univf ) );
 */
static ValuationFormula*
valf(pCPSParser ctx)
{   
    ValuationFormula* vf = NULL;

    CPSParser_equivf_return v1;
    #undef	RETURN_TYPE_v1
    #define	RETURN_TYPE_v1 CPSParser_equivf_return

    CPSParser_univf_return v2;
    #undef	RETURN_TYPE_v2
    #define	RETURN_TYPE_v2 CPSParser_univf_return

    /* Initialize rule variables
     */


    {
        {
            //  cps/CPS.g:1417:2: ( (v1= equivf ) | (v2= univf ) )
            
            ANTLR3_UINT32 alt31;

            alt31=2;

            switch ( LA(1) ) 
            {
            case TRUEVF:
            case FALSEVF:
            case NEG:
            case SMALLID:
            case CAPITID:
            case CAPITNUMID:
            case 58:
            	{
            		alt31=1;
            	}
                break;
            case FORALL:
            	{
            		alt31=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return vf;
                }
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 31;
                EXCEPTION->state        = 0;


                goto rulevalfEx;
            }

            switch (alt31) 
            {
        	case 1:
        	    // cps/CPS.g:1417:4: (v1= equivf )
        	    {
        	        // cps/CPS.g:1417:4: (v1= equivf )
        	        // cps/CPS.g:1417:5: v1= equivf
        	        {
        	            FOLLOWPUSH(FOLLOW_equivf_in_valf2790);
        	            v1=equivf(ctx);

        	            FOLLOWPOP();
        	            if  (HASEXCEPTION())
        	            {
        	                goto rulevalfEx;
        	            }
        	            if (HASFAILED())
        	            {
        	                return vf;
        	            }

        	        }

        	        if ( BACKTRACKING==0 ) 
        	        {

        	            		vf= v1.vf;
        	            		
        	        }

        	    }
        	    break;
        	case 2:
        	    // cps/CPS.g:1421:4: (v2= univf )
        	    {
        	        // cps/CPS.g:1421:4: (v2= univf )
        	        // cps/CPS.g:1421:5: v2= univf
        	        {
        	            FOLLOWPUSH(FOLLOW_univf_in_valf2805);
        	            v2=univf(ctx);

        	            FOLLOWPOP();
        	            if  (HASEXCEPTION())
        	            {
        	                goto rulevalfEx;
        	            }
        	            if (HASFAILED())
        	            {
        	                return vf;
        	            }

        	        }

        	        if ( BACKTRACKING==0 ) 
        	        {

        	            		vf= v2.vf;
        	            		
        	        }

        	    }
        	    break;

            }
        }
    }
    

    // This is where rules clean up and exit
    //
    goto rulevalfEx; /* Prevent compiler warnings */
    rulevalfEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }


    return vf;
}
/* $ANTLR end valf */

/** 
 * $ANTLR start univf
 * cps/CPS.g:1427:1: univf returns [ValuationFormula* vf] : FORALL avl= boundparlist ':' v= valf ;
 */
static CPSParser_univf_return
univf(pCPSParser ctx)
{   
    CPSParser_univf_return retval;

    CPSParser_boundparlist_return avl;
    #undef	RETURN_TYPE_avl
    #define	RETURN_TYPE_avl CPSParser_boundparlist_return

    ValuationFormula* v;
    #undef	RETURN_TYPE_v
    #define	RETURN_TYPE_v ValuationFormula*

    /* Initialize rule variables
     */


    v = NULL;
    retval.start = LT(1); retval.stop = retval.start;

    {
        // cps/CPS.g:1428:2: ( FORALL avl= boundparlist ':' v= valf )
        // cps/CPS.g:1428:4: FORALL avl= boundparlist ':' v= valf
        {
             MATCHT(FORALL, &FOLLOW_FORALL_in_univf2830); 
            if  (HASEXCEPTION())
            {
                goto ruleunivfEx;
            }
            if (HASFAILED())
            {
                return retval;
            }
            FOLLOWPUSH(FOLLOW_boundparlist_in_univf2834);
            avl=boundparlist(ctx);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleunivfEx;
            }
            if (HASFAILED())
            {
                return retval;
            }
             MATCHT(54, &FOLLOW_54_in_univf2836); 
            if  (HASEXCEPTION())
            {
                goto ruleunivfEx;
            }
            if (HASFAILED())
            {
                return retval;
            }
            FOLLOWPUSH(FOLLOW_valf_in_univf2840);
            v=valf(ctx);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleunivfEx;
            }
            if (HASFAILED())
            {
                return retval;
            }
            if ( BACKTRACKING==0 ) 
            {

                                retval.vf= 0;
                                if(v == 0)
                                {
                                    printPosition(retval.start);
                                    std::cout << "Valuation constraint expected.\n";
                                }
                                else if(avl.bal == 0)
                                {
                                    printPosition(retval.start);
                                    std::cout << "Variable list expected.\n";
                                }
                                else
                                {
                                    retval.vf= v;
                                    for(int i = 0; i < avl.bal->size(); ++i)
                                    {
                                            const AtomVariable& av = dynamic_cast<const AtomVariableSchema*>(avl.bal->operator[](i))->getAtomVariable();
                                            retval.vf= new UniversalValuationFormula(new AtomVariable(av), retval.vf);
                                    }
                                }
                		delete avl.bal;
                            
            }

        }

    }
    

    // This is where rules clean up and exit
    //
    goto ruleunivfEx; /* Prevent compiler warnings */
    ruleunivfEx: ;
    retval.stop = LT(-1);

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }


    return retval;
}
/* $ANTLR end univf */

/** 
 * $ANTLR start equivf
 * cps/CPS.g:1454:1: equivf returns [ValuationFormula* vf] : (v= implvf ) ( EQ v= implvf )* ;
 */
static CPSParser_equivf_return
equivf(pCPSParser ctx)
{   
    CPSParser_equivf_return retval;

    CPSParser_implvf_return v;
    #undef	RETURN_TYPE_v
    #define	RETURN_TYPE_v CPSParser_implvf_return

    /* Initialize rule variables
     */


    retval.start = LT(1); retval.stop = retval.start;

    {
        // cps/CPS.g:1455:2: ( (v= implvf ) ( EQ v= implvf )* )
        // cps/CPS.g:1456:2: (v= implvf ) ( EQ v= implvf )*
        {
            // cps/CPS.g:1456:2: (v= implvf )
            // cps/CPS.g:1457:2: v= implvf
            {
                FOLLOWPUSH(FOLLOW_implvf_in_equivf2877);
                v=implvf(ctx);

                FOLLOWPOP();
                if  (HASEXCEPTION())
                {
                    goto ruleequivfEx;
                }
                if (HASFAILED())
                {
                    return retval;
                }
                if ( BACKTRACKING==0 ) 
                {

                    		retval.vf= v.vf;
                                
                }

            }


            // cps/CPS.g:1462:2: ( EQ v= implvf )*

            for (;;)
            {
                int alt32=2;
                switch ( LA(1) ) 
                {
                case EQ:
                	{
                		alt32=1;
                	}
                    break;

                }

                switch (alt32) 
                {
            	case 1:
            	    // cps/CPS.g:1463:2: EQ v= implvf
            	    {
            	         MATCHT(EQ, &FOLLOW_EQ_in_equivf2900); 
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleequivfEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        FOLLOWPUSH(FOLLOW_implvf_in_equivf2904);
            	        v=implvf(ctx);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleequivfEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        if ( BACKTRACKING==0 ) 
            	        {

            	                            if(v.vf == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Valuation constraint expected.\n";
            	                            }
            	            		else if(retval.vf != 0)
            	                            {
            	                                ValuationFormula* ivf = 0;
            	                                if(retval.vf != 0 && v.vf != 0)
            	                                {
            	                                        ivf = new NegatedValuationFormula(new ConjunctiveValuationFormula(v.vf->clone(),new NegatedValuationFormula(retval.vf->clone())));
            	                                }
            	                                retval.vf= new ConjunctiveValuationFormula(new NegatedValuationFormula(new ConjunctiveValuationFormula(retval.vf,new NegatedValuationFormula(v.vf))), ivf);
            	                            }
            	                        
            	        }

            	    }
            	    break;

            	default:
            	    goto loop32;	/* break out of the loop */
            	    break;
                }
            }
            loop32: ; /* Jump out to here if this rule does not match */


        }

    }
    

    // This is where rules clean up and exit
    //
    goto ruleequivfEx; /* Prevent compiler warnings */
    ruleequivfEx: ;
    retval.stop = LT(-1);

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }


    return retval;
}
/* $ANTLR end equivf */

/** 
 * $ANTLR start implvf
 * cps/CPS.g:1483:1: implvf returns [ValuationFormula* vf] : (v= disjvf ) ( IMPL v= disjvf )* ;
 */
static CPSParser_implvf_return
implvf(pCPSParser ctx)
{   
    CPSParser_implvf_return retval;

    CPSParser_disjvf_return v;
    #undef	RETURN_TYPE_v
    #define	RETURN_TYPE_v CPSParser_disjvf_return

    /* Initialize rule variables
     */


    retval.start = LT(1); retval.stop = retval.start;

    {
        // cps/CPS.g:1484:2: ( (v= disjvf ) ( IMPL v= disjvf )* )
        // cps/CPS.g:1485:2: (v= disjvf ) ( IMPL v= disjvf )*
        {
            // cps/CPS.g:1485:2: (v= disjvf )
            // cps/CPS.g:1486:2: v= disjvf
            {
                FOLLOWPUSH(FOLLOW_disjvf_in_implvf2947);
                v=disjvf(ctx);

                FOLLOWPOP();
                if  (HASEXCEPTION())
                {
                    goto ruleimplvfEx;
                }
                if (HASFAILED())
                {
                    return retval;
                }
                if ( BACKTRACKING==0 ) 
                {

                    		retval.vf= v.vf;
                                
                }

            }


            // cps/CPS.g:1491:2: ( IMPL v= disjvf )*

            for (;;)
            {
                int alt33=2;
                switch ( LA(1) ) 
                {
                case IMPL:
                	{
                		alt33=1;
                	}
                    break;

                }

                switch (alt33) 
                {
            	case 1:
            	    // cps/CPS.g:1492:2: IMPL v= disjvf
            	    {
            	         MATCHT(IMPL, &FOLLOW_IMPL_in_implvf2970); 
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleimplvfEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        FOLLOWPUSH(FOLLOW_disjvf_in_implvf2976);
            	        v=disjvf(ctx);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleimplvfEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        if ( BACKTRACKING==0 ) 
            	        {

            	                            if(v.vf == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Valuation constraint expected.\n";
            	                            }
            	            		else if(retval.vf != 0)
            	                            {
            	                                retval.vf= new NegatedValuationFormula(new ConjunctiveValuationFormula(retval.vf,new NegatedValuationFormula(v.vf)));
            	            		}
            	                        
            	        }

            	    }
            	    break;

            	default:
            	    goto loop33;	/* break out of the loop */
            	    break;
                }
            }
            loop33: ; /* Jump out to here if this rule does not match */


        }

    }
    

    // This is where rules clean up and exit
    //
    goto ruleimplvfEx; /* Prevent compiler warnings */
    ruleimplvfEx: ;
    retval.stop = LT(-1);

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }


    return retval;
}
/* $ANTLR end implvf */

/** 
 * $ANTLR start disjvf
 * cps/CPS.g:1507:1: disjvf returns [ValuationFormula* vf] : (v= conjvf ) ( OR v= conjvf )* ;
 */
static CPSParser_disjvf_return
disjvf(pCPSParser ctx)
{   
    CPSParser_disjvf_return retval;

    CPSParser_conjvf_return v;
    #undef	RETURN_TYPE_v
    #define	RETURN_TYPE_v CPSParser_conjvf_return

    /* Initialize rule variables
     */


    retval.start = LT(1); retval.stop = retval.start;

    {
        // cps/CPS.g:1508:2: ( (v= conjvf ) ( OR v= conjvf )* )
        // cps/CPS.g:1509:2: (v= conjvf ) ( OR v= conjvf )*
        {
            // cps/CPS.g:1509:2: (v= conjvf )
            // cps/CPS.g:1510:2: v= conjvf
            {
                FOLLOWPUSH(FOLLOW_conjvf_in_disjvf3019);
                v=conjvf(ctx);

                FOLLOWPOP();
                if  (HASEXCEPTION())
                {
                    goto ruledisjvfEx;
                }
                if (HASFAILED())
                {
                    return retval;
                }
                if ( BACKTRACKING==0 ) 
                {

                    		retval.vf= v.vf;
                    		
                }

            }


            // cps/CPS.g:1515:2: ( OR v= conjvf )*

            for (;;)
            {
                int alt34=2;
                switch ( LA(1) ) 
                {
                case OR:
                	{
                		alt34=1;
                	}
                    break;

                }

                switch (alt34) 
                {
            	case 1:
            	    // cps/CPS.g:1516:2: OR v= conjvf
            	    {
            	         MATCHT(OR, &FOLLOW_OR_in_disjvf3033); 
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruledisjvfEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        FOLLOWPUSH(FOLLOW_conjvf_in_disjvf3039);
            	        v=conjvf(ctx);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruledisjvfEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        if ( BACKTRACKING==0 ) 
            	        {

            	                            if(v.vf == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Valuation constraint expected.\n";
            	                            }
            	                            else if(retval.vf != 0)
            	                            {
            	                                retval.vf= new NegatedValuationFormula(new ConjunctiveValuationFormula(new NegatedValuationFormula(retval.vf), new NegatedValuationFormula(v.vf)));
            	            		}
            	                        
            	        }

            	    }
            	    break;

            	default:
            	    goto loop34;	/* break out of the loop */
            	    break;
                }
            }
            loop34: ; /* Jump out to here if this rule does not match */


        }

    }
    

    // This is where rules clean up and exit
    //
    goto ruledisjvfEx; /* Prevent compiler warnings */
    ruledisjvfEx: ;
    retval.stop = LT(-1);

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }


    return retval;
}
/* $ANTLR end disjvf */

/** 
 * $ANTLR start conjvf
 * cps/CPS.g:1531:1: conjvf returns [ValuationFormula* vf] : (v1= elemvf | v2= negvf | '(' v3= valf ')' ) ( AND (v1= elemvf | v2= negvf | '(' v3= valf ')' ) )* ;
 */
static CPSParser_conjvf_return
conjvf(pCPSParser ctx)
{   
    CPSParser_conjvf_return retval;

    CPSParser_elemvf_return v1;
    #undef	RETURN_TYPE_v1
    #define	RETURN_TYPE_v1 CPSParser_elemvf_return

    CPSParser_negvf_return v2;
    #undef	RETURN_TYPE_v2
    #define	RETURN_TYPE_v2 CPSParser_negvf_return

    ValuationFormula* v3;
    #undef	RETURN_TYPE_v3
    #define	RETURN_TYPE_v3 ValuationFormula*

    /* Initialize rule variables
     */


    v3 = NULL;
    retval.start = LT(1); retval.stop = retval.start;

    {
        // cps/CPS.g:1532:2: ( (v1= elemvf | v2= negvf | '(' v3= valf ')' ) ( AND (v1= elemvf | v2= negvf | '(' v3= valf ')' ) )* )
        // cps/CPS.g:1533:2: (v1= elemvf | v2= negvf | '(' v3= valf ')' ) ( AND (v1= elemvf | v2= negvf | '(' v3= valf ')' ) )*
        {

            // cps/CPS.g:1533:2: (v1= elemvf | v2= negvf | '(' v3= valf ')' )
            {
                int alt35=3;
                switch ( LA(1) ) 
                {
                case TRUEVF:
                case FALSEVF:
                case SMALLID:
                case CAPITID:
                case CAPITNUMID:
                	{
                		alt35=1;
                	}
                    break;
                case NEG:
                	{
                		alt35=2;
                	}
                    break;
                case 58:
                	{
                		alt35=3;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return retval;
                    }
                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 35;
                    EXCEPTION->state        = 0;


                    goto ruleconjvfEx;
                }

                switch (alt35) 
                {
            	case 1:
            	    // cps/CPS.g:1533:3: v1= elemvf
            	    {
            	        if ( BACKTRACKING==0 ) 
            	        {
            	            retval.vf= 0;
            	        }
            	        FOLLOWPUSH(FOLLOW_elemvf_in_conjvf3083);
            	        v1=elemvf(ctx);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleconjvfEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        if ( BACKTRACKING==0 ) 
            	        {
            	             retval.vf= v1.vf;
            	        }

            	    }
            	    break;
            	case 2:
            	    // cps/CPS.g:1533:44: v2= negvf
            	    {
            	        FOLLOWPUSH(FOLLOW_negvf_in_conjvf3093);
            	        v2=negvf(ctx);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleconjvfEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        if ( BACKTRACKING==0 ) 
            	        {
            	             retval.vf= v2.vf;
            	        }

            	    }
            	    break;
            	case 3:
            	    // cps/CPS.g:1533:74: '(' v3= valf ')'
            	    {
            	         MATCHT(58, &FOLLOW_58_in_conjvf3099); 
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleconjvfEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        FOLLOWPUSH(FOLLOW_valf_in_conjvf3105);
            	        v3=valf(ctx);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleconjvfEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	         MATCHT(59, &FOLLOW_59_in_conjvf3107); 
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleconjvfEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        if ( BACKTRACKING==0 ) 
            	        {
            	             retval.vf= v3;
            	        }

            	    }
            	    break;

                }
            }

            // cps/CPS.g:1534:2: ( AND (v1= elemvf | v2= negvf | '(' v3= valf ')' ) )*

            for (;;)
            {
                int alt37=2;
                switch ( LA(1) ) 
                {
                case AND:
                	{
                		alt37=1;
                	}
                    break;

                }

                switch (alt37) 
                {
            	case 1:
            	    // cps/CPS.g:1535:2: AND (v1= elemvf | v2= negvf | '(' v3= valf ')' )
            	    {
            	         MATCHT(AND, &FOLLOW_AND_in_conjvf3116); 
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleconjvfEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }

            	        // cps/CPS.g:1535:6: (v1= elemvf | v2= negvf | '(' v3= valf ')' )
            	        {
            	            int alt36=3;
            	            switch ( LA(1) ) 
            	            {
            	            case TRUEVF:
            	            case FALSEVF:
            	            case SMALLID:
            	            case CAPITID:
            	            case CAPITNUMID:
            	            	{
            	            		alt36=1;
            	            	}
            	                break;
            	            case NEG:
            	            	{
            	            		alt36=2;
            	            	}
            	                break;
            	            case 58:
            	            	{
            	            		alt36=3;
            	            	}
            	                break;

            	            default:
            	                if (BACKTRACKING>0)
            	                {
            	                    FAILEDFLAG = ANTLR3_TRUE;
            	                    return retval;
            	                }
            	                CONSTRUCTEX();
            	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	                EXCEPTION->message      = (void *)"";
            	                EXCEPTION->decisionNum  = 36;
            	                EXCEPTION->state        = 0;


            	                goto ruleconjvfEx;
            	            }

            	            switch (alt36) 
            	            {
            	        	case 1:
            	        	    // cps/CPS.g:1535:7: v1= elemvf
            	        	    {
            	        	        FOLLOWPUSH(FOLLOW_elemvf_in_conjvf3122);
            	        	        v1=elemvf(ctx);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruleconjvfEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return retval;
            	        	        }
            	        	        if ( BACKTRACKING==0 ) 
            	        	        {

            	        	                            if(v1.vf == 0)
            	        	                            {
            	        	                                printPosition(retval.start);
            	        	                                std::cout << "Valuation constraint expected.\n";
            	        	                            }
            	        	                            else if(retval.vf != 0)
            	        	                            {
            	        	                                retval.vf= new ConjunctiveValuationFormula(retval.vf,v1.vf);
            	        	                            }
            	        	                        
            	        	        }

            	        	    }
            	        	    break;
            	        	case 2:
            	        	    // cps/CPS.g:1547:15: v2= negvf
            	        	    {
            	        	        FOLLOWPUSH(FOLLOW_negvf_in_conjvf3157);
            	        	        v2=negvf(ctx);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruleconjvfEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return retval;
            	        	        }
            	        	        if ( BACKTRACKING==0 ) 
            	        	        {

            	        	                            if(v2.vf == 0)
            	        	                            {
            	        	                                printPosition(retval.start);
            	        	                                std::cout << "Valuation constraint expected.\n";
            	        	                            }
            	        	                            else if(retval.vf != 0)
            	        	                            {
            	        	                                retval.vf= new ConjunctiveValuationFormula(retval.vf,v2.vf);
            	        	                            }
            	        	                        
            	        	        }

            	        	    }
            	        	    break;
            	        	case 3:
            	        	    // cps/CPS.g:1559:15: '(' v3= valf ')'
            	        	    {
            	        	         MATCHT(58, &FOLLOW_58_in_conjvf3188); 
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruleconjvfEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return retval;
            	        	        }
            	        	        FOLLOWPUSH(FOLLOW_valf_in_conjvf3194);
            	        	        v3=valf(ctx);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruleconjvfEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return retval;
            	        	        }
            	        	         MATCHT(59, &FOLLOW_59_in_conjvf3196); 
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruleconjvfEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return retval;
            	        	        }
            	        	        if ( BACKTRACKING==0 ) 
            	        	        {

            	        	                            if(v3 == 0)
            	        	                            {
            	        	                                printPosition(retval.start);
            	        	                                std::cout << "Valuation constraint expected.\n";
            	        	                            }
            	        	                            else if(retval.vf != 0)
            	        	                            {
            	        	                                retval.vf= new ConjunctiveValuationFormula(retval.vf,v3);
            	        	                            }
            	        	                        
            	        	        }

            	        	    }
            	        	    break;

            	            }
            	        }

            	    }
            	    break;

            	default:
            	    goto loop37;	/* break out of the loop */
            	    break;
                }
            }
            loop37: ; /* Jump out to here if this rule does not match */


        }

    }
    

    // This is where rules clean up and exit
    //
    goto ruleconjvfEx; /* Prevent compiler warnings */
    ruleconjvfEx: ;
    retval.stop = LT(-1);

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }


    return retval;
}
/* $ANTLR end conjvf */

/** 
 * $ANTLR start negvf
 * cps/CPS.g:1575:1: negvf returns [ValuationFormula* vf] : NEG (v1= negvf | v2= elemvf | '(' v3= valf ')' ) ;
 */
static CPSParser_negvf_return
negvf(pCPSParser ctx)
{   
    CPSParser_negvf_return retval;

    CPSParser_negvf_return v1;
    #undef	RETURN_TYPE_v1
    #define	RETURN_TYPE_v1 CPSParser_negvf_return

    CPSParser_elemvf_return v2;
    #undef	RETURN_TYPE_v2
    #define	RETURN_TYPE_v2 CPSParser_elemvf_return

    ValuationFormula* v3;
    #undef	RETURN_TYPE_v3
    #define	RETURN_TYPE_v3 ValuationFormula*

    /* Initialize rule variables
     */


    v3 = NULL;
    retval.start = LT(1); retval.stop = retval.start;

    {
        // cps/CPS.g:1576:2: ( NEG (v1= negvf | v2= elemvf | '(' v3= valf ')' ) )
        // cps/CPS.g:1576:4: NEG (v1= negvf | v2= elemvf | '(' v3= valf ')' )
        {
             MATCHT(NEG, &FOLLOW_NEG_in_negvf3245); 
            if  (HASEXCEPTION())
            {
                goto rulenegvfEx;
            }
            if (HASFAILED())
            {
                return retval;
            }
            if ( BACKTRACKING==0 ) 
            {
                retval.vf= 0;
            }

            // cps/CPS.g:1576:19: (v1= negvf | v2= elemvf | '(' v3= valf ')' )
            {
                int alt38=3;
                switch ( LA(1) ) 
                {
                case NEG:
                	{
                		alt38=1;
                	}
                    break;
                case TRUEVF:
                case FALSEVF:
                case SMALLID:
                case CAPITID:
                case CAPITNUMID:
                	{
                		alt38=2;
                	}
                    break;
                case 58:
                	{
                		alt38=3;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return retval;
                    }
                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 38;
                    EXCEPTION->state        = 0;


                    goto rulenegvfEx;
                }

                switch (alt38) 
                {
            	case 1:
            	    // cps/CPS.g:1576:20: v1= negvf
            	    {
            	        FOLLOWPUSH(FOLLOW_negvf_in_negvf3254);
            	        v1=negvf(ctx);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulenegvfEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        if ( BACKTRACKING==0 ) 
            	        {
            	            retval.vf= v1.vf;
            	        }

            	    }
            	    break;
            	case 2:
            	    // cps/CPS.g:1576:49: v2= elemvf
            	    {
            	        FOLLOWPUSH(FOLLOW_elemvf_in_negvf3264);
            	        v2=elemvf(ctx);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulenegvfEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        if ( BACKTRACKING==0 ) 
            	        {
            	            retval.vf= v2.vf;
            	        }

            	    }
            	    break;
            	case 3:
            	    // cps/CPS.g:1576:79: '(' v3= valf ')'
            	    {
            	         MATCHT(58, &FOLLOW_58_in_negvf3270); 
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulenegvfEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        FOLLOWPUSH(FOLLOW_valf_in_negvf3275);
            	        v3=valf(ctx);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulenegvfEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	         MATCHT(59, &FOLLOW_59_in_negvf3277); 
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulenegvfEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        if ( BACKTRACKING==0 ) 
            	        {
            	            retval.vf= v3;
            	        }

            	    }
            	    break;

                }
            }
            if ( BACKTRACKING==0 ) 
            {

                                if(retval.vf == 0)
                                {
                                    printPosition(retval.start);
                                    std::cout << "Valuation constraint expected.\n";
                                }
                                else if(retval.vf != 0)
                                {
                                    retval.vf= new NegatedValuationFormula(retval.vf);
                                }
                            
            }

        }

    }
    

    // This is where rules clean up and exit
    //
    goto rulenegvfEx; /* Prevent compiler warnings */
    rulenegvfEx: ;
    retval.stop = LT(-1);

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }


    return retval;
}
/* $ANTLR end negvf */

/** 
 * $ANTLR start elemvf
 * cps/CPS.g:1590:1: elemvf returns [ValuationFormula* vf] : ( ( ( TRUEVF )=> ( TRUEVF ) ) | ( ( FALSEVF )=> ( FALSEVF ) ) | (a1= atomschema ( '=' a2= atomschema | IN s= atomrel | rel= string a2= atomschema ) ) | (name= string ) );
 */
static CPSParser_elemvf_return
elemvf(pCPSParser ctx)
{   
    CPSParser_elemvf_return retval;

    CPSParser_atomschema_return a1;
    #undef	RETURN_TYPE_a1
    #define	RETURN_TYPE_a1 CPSParser_atomschema_return

    CPSParser_atomschema_return a2;
    #undef	RETURN_TYPE_a2
    #define	RETURN_TYPE_a2 CPSParser_atomschema_return

    CPSParser_atomrel_return s;
    #undef	RETURN_TYPE_s
    #define	RETURN_TYPE_s CPSParser_atomrel_return

    std::string* rel;
    #undef	RETURN_TYPE_rel
    #define	RETURN_TYPE_rel std::string*

    std::string* name;
    #undef	RETURN_TYPE_name
    #define	RETURN_TYPE_name std::string*

    /* Initialize rule variables
     */


    rel = NULL;
    name = NULL;
    retval.start = LT(1); retval.stop = retval.start;

    {
        {
            //  cps/CPS.g:1591:2: ( ( ( TRUEVF )=> ( TRUEVF ) ) | ( ( FALSEVF )=> ( FALSEVF ) ) | (a1= atomschema ( '=' a2= atomschema | IN s= atomrel | rel= string a2= atomschema ) ) | (name= string ) )
            
            ANTLR3_UINT32 alt40;

            alt40=4;


            {
                int LA40_0 = LA(1);
                if ( (LA40_0 == TRUEVF) && (synpred2_CPS(ctx))) 
                {
                    alt40=1;
                }
                else if ( (LA40_0 == FALSEVF) && (synpred3_CPS(ctx))) 
                {
                    alt40=2;
                }
                else if ( (LA40_0 == SMALLID) ) 
                {
                    switch ( LA(2) ) 
                    {
                    case IN:
                    case SMALLID:
                    case CAPITID:
                    case CAPITNUMID:
                    case 50:
                    case 58:
                    	{
                    		alt40=3;
                    	}
                        break;
                    case EOF:
                    case ATOMVAR:
                    case VAR:
                    case RELVAR:
                    case RELSYM:
                    case TYPEVAR:
                    case VALF:
                    case VALC:
                    case SSC:
                    case PSET:
                    case LTSC:
                    case PLTS:
                    case IMPL:
                    case EQ:
                    case AND:
                    case OR:
                    case RELFUNC:
                    case CHANNEL:
                    case 49:
                    case 53:
                    case 55:
                    case 56:
                    case 57:
                    case 59:
                    	{
                    		alt40=4;
                    	}
                        break;

                    default:
                        if (BACKTRACKING>0)
                        {
                            FAILEDFLAG = ANTLR3_TRUE;
                            return retval;
                        }
                        CONSTRUCTEX();
                        EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                        EXCEPTION->message      = (void *)"";
                        EXCEPTION->decisionNum  = 40;
                        EXCEPTION->state        = 3;


                        goto ruleelemvfEx;
                    }

                }
                else if ( (((LA40_0 >= CAPITID) && (LA40_0 <= CAPITNUMID))) ) 
                {
                    switch ( LA(2) ) 
                    {
                    case SMALLID:
                    case CAPITID:
                    case CAPITNUMID:
                    case 58:
                    	{
                    		alt40=3;
                    	}
                        break;
                    case EOF:
                    case ATOMVAR:
                    case VAR:
                    case RELVAR:
                    case RELSYM:
                    case TYPEVAR:
                    case VALF:
                    case VALC:
                    case SSC:
                    case PSET:
                    case LTSC:
                    case PLTS:
                    case IMPL:
                    case EQ:
                    case AND:
                    case OR:
                    case RELFUNC:
                    case CHANNEL:
                    case 49:
                    case 53:
                    case 55:
                    case 56:
                    case 57:
                    case 59:
                    	{
                    		alt40=4;
                    	}
                        break;

                    default:
                        if (BACKTRACKING>0)
                        {
                            FAILEDFLAG = ANTLR3_TRUE;
                            return retval;
                        }
                        CONSTRUCTEX();
                        EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                        EXCEPTION->message      = (void *)"";
                        EXCEPTION->decisionNum  = 40;
                        EXCEPTION->state        = 4;


                        goto ruleelemvfEx;
                    }

                }
                else 
                {
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return retval;
                    }
                
                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 40;
                    EXCEPTION->state        = 0;


                    goto ruleelemvfEx;
                }
            }
            switch (alt40) 
            {
        	case 1:
        	    // cps/CPS.g:1591:4: ( ( TRUEVF )=> ( TRUEVF ) )
        	    {
        	        // cps/CPS.g:1591:4: ( ( TRUEVF )=> ( TRUEVF ) )
        	        // cps/CPS.g:1591:5: ( TRUEVF )=> ( TRUEVF )
        	        {
        	            // cps/CPS.g:1591:17: ( TRUEVF )
        	            // cps/CPS.g:1591:18: TRUEVF
        	            {
        	                 MATCHT(TRUEVF, &FOLLOW_TRUEVF_in_elemvf3320); 
        	                if  (HASEXCEPTION())
        	                {
        	                    goto ruleelemvfEx;
        	                }
        	                if (HASFAILED())
        	                {
        	                    return retval;
        	                }

        	            }


        	        }

        	        if ( BACKTRACKING==0 ) 
        	        {

        	            		retval.vf= new TopValuationFormula();
        	            		
        	        }

        	    }
        	    break;
        	case 2:
        	    // cps/CPS.g:1595:4: ( ( FALSEVF )=> ( FALSEVF ) )
        	    {
        	        // cps/CPS.g:1595:4: ( ( FALSEVF )=> ( FALSEVF ) )
        	        // cps/CPS.g:1595:5: ( FALSEVF )=> ( FALSEVF )
        	        {
        	            // cps/CPS.g:1595:18: ( FALSEVF )
        	            // cps/CPS.g:1595:19: FALSEVF
        	            {
        	                 MATCHT(FALSEVF, &FOLLOW_FALSEVF_in_elemvf3339); 
        	                if  (HASEXCEPTION())
        	                {
        	                    goto ruleelemvfEx;
        	                }
        	                if (HASFAILED())
        	                {
        	                    return retval;
        	                }

        	            }


        	        }

        	        if ( BACKTRACKING==0 ) 
        	        {

        	            		retval.vf= new NegatedValuationFormula(new TopValuationFormula());
        	            		
        	        }

        	    }
        	    break;
        	case 3:
        	    // cps/CPS.g:1599:4: (a1= atomschema ( '=' a2= atomschema | IN s= atomrel | rel= string a2= atomschema ) )
        	    {
        	        // cps/CPS.g:1599:4: (a1= atomschema ( '=' a2= atomschema | IN s= atomrel | rel= string a2= atomschema ) )
        	        // cps/CPS.g:1599:5: a1= atomschema ( '=' a2= atomschema | IN s= atomrel | rel= string a2= atomschema )
        	        {
        	            FOLLOWPUSH(FOLLOW_atomschema_in_elemvf3353);
        	            a1=atomschema(ctx);

        	            FOLLOWPOP();
        	            if  (HASEXCEPTION())
        	            {
        	                goto ruleelemvfEx;
        	            }
        	            if (HASFAILED())
        	            {
        	                return retval;
        	            }

        	            // cps/CPS.g:1600:3: ( '=' a2= atomschema | IN s= atomrel | rel= string a2= atomschema )
        	            {
        	                int alt39=3;
        	                switch ( LA(1) ) 
        	                {
        	                case 50:
        	                	{
        	                		alt39=1;
        	                	}
        	                    break;
        	                case IN:
        	                	{
        	                		alt39=2;
        	                	}
        	                    break;
        	                case SMALLID:
        	                case CAPITID:
        	                case CAPITNUMID:
        	                	{
        	                		alt39=3;
        	                	}
        	                    break;

        	                default:
        	                    if (BACKTRACKING>0)
        	                    {
        	                        FAILEDFLAG = ANTLR3_TRUE;
        	                        return retval;
        	                    }
        	                    CONSTRUCTEX();
        	                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                    EXCEPTION->message      = (void *)"";
        	                    EXCEPTION->decisionNum  = 39;
        	                    EXCEPTION->state        = 0;


        	                    goto ruleelemvfEx;
        	                }

        	                switch (alt39) 
        	                {
        	            	case 1:
        	            	    // cps/CPS.g:1600:5: '=' a2= atomschema
        	            	    {
        	            	         MATCHT(50, &FOLLOW_50_in_elemvf3360); 
        	            	        if  (HASEXCEPTION())
        	            	        {
        	            	            goto ruleelemvfEx;
        	            	        }
        	            	        if (HASFAILED())
        	            	        {
        	            	            return retval;
        	            	        }
        	            	        FOLLOWPUSH(FOLLOW_atomschema_in_elemvf3364);
        	            	        a2=atomschema(ctx);

        	            	        FOLLOWPOP();
        	            	        if  (HASEXCEPTION())
        	            	        {
        	            	            goto ruleelemvfEx;
        	            	        }
        	            	        if (HASFAILED())
        	            	        {
        	            	            return retval;
        	            	        }
        	            	        if ( BACKTRACKING==0 ) 
        	            	        {

        	            	                                    retval.vf= 0;
        	            	            			if(a1.atsc == 0)
        	            	                                    {
        	            	                                        printPosition(retval.start);
        	            	                                        std::cout << "Constant/variable expected.\n";
        	            	                                    }
        	            	                                    else if(a2.atsc == 0)
        	            	            			{
        	            	                                        printPosition(retval.start);
        	            	                                        std::cout << "Constant/variable expected.\n";
        	            	                                    }
        	            	                                    else
        	            	                                    {
        	            	                                        retval.vf= new EquivalenceValuationFormula(a1.atsc, a2.atsc);
        	            	            			}
        	            	                                    if(retval.vf == 0)
        	            	                                    {
        	            	                                        delete a1.atsc;
        	            	                                        delete a2.atsc;
        	            	                                    }
        	            	                                
        	            	        }

        	            	    }
        	            	    break;
        	            	case 2:
        	            	    // cps/CPS.g:1623:5: IN s= atomrel
        	            	    {
        	            	         MATCHT(IN, &FOLLOW_IN_in_elemvf3392); 
        	            	        if  (HASEXCEPTION())
        	            	        {
        	            	            goto ruleelemvfEx;
        	            	        }
        	            	        if (HASFAILED())
        	            	        {
        	            	            return retval;
        	            	        }
        	            	        FOLLOWPUSH(FOLLOW_atomrel_in_elemvf3396);
        	            	        s=atomrel(ctx);

        	            	        FOLLOWPOP();
        	            	        if  (HASEXCEPTION())
        	            	        {
        	            	            goto ruleelemvfEx;
        	            	        }
        	            	        if (HASFAILED())
        	            	        {
        	            	            return retval;
        	            	        }
        	            	        if ( BACKTRACKING==0 ) 
        	            	        {

        	            	                                    retval.vf= 0;
        	            	            			if(a1.atsc == 0)
        	            	                                    {
        	            	                                        printPosition(retval.start);
        	            	                                        std::cout << "Constant/variable expected.\n";
        	            	                                    }
        	            	                                    else if(s.rel == 0)
        	            	            			{
        	            	                                        printPosition(retval.start);
        	            	                                        std::cout << "Set of constants expected.\n";
        	            	                                    }
        	            	                                    else if(s.rel->getDimension()!=1 || s.rel->getFunctionType() != a1.atsc->getType())
        	            	                                    {
        	            	                                        printPosition(retval.start);
        	            	                                        std::cout << "Types of the set and constant/variable do not match.\n";
        	            	                                    }
        	            	                                    else
        	            	                                    {
        	            	                                        AtomSchemaTuple* atsct = new AtomSchemaTuple();
        	            	                                        atsct->push_back(a1.atsc);
        	            	                                        retval.vf= new InclusionValuationFormula(atsct,s.rel);
        	            	            			}
        	            	                                    if(retval.vf == 0)
        	            	                                    {
        	            	                                        delete a1.atsc;
        	            	                                        delete s.rel;
        	            	            			}
        	            	                                
        	            	        }

        	            	    }
        	            	    break;
        	            	case 3:
        	            	    // cps/CPS.g:1653:5: rel= string a2= atomschema
        	            	    {
        	            	        FOLLOWPUSH(FOLLOW_string_in_elemvf3427);
        	            	        rel=string(ctx);

        	            	        FOLLOWPOP();
        	            	        if  (HASEXCEPTION())
        	            	        {
        	            	            goto ruleelemvfEx;
        	            	        }
        	            	        if (HASFAILED())
        	            	        {
        	            	            return retval;
        	            	        }
        	            	        FOLLOWPUSH(FOLLOW_atomschema_in_elemvf3431);
        	            	        a2=atomschema(ctx);

        	            	        FOLLOWPOP();
        	            	        if  (HASEXCEPTION())
        	            	        {
        	            	            goto ruleelemvfEx;
        	            	        }
        	            	        if (HASFAILED())
        	            	        {
        	            	            return retval;
        	            	        }
        	            	        if ( BACKTRACKING==0 ) 
        	            	        {

        	            	                                    if(context.isAtomRelation(rel))
        	            	                                    {
        	            	                                        retval.vf= 0;
        	            	                                        if(a1.atsc == 0)
        	            	                                        {
        	            	                                            printPosition(retval.start);
        	            	                                            std::cout << "Constant/variable expected.\n";
        	            	                                        }
        	            	                                        else if(a2.atsc == 0)
        	            	                                        {
        	            	                                            printPosition(retval.start);
        	            	                                            std::cout << "Constant/variable expected.\n";
        	            	                                        }
        	            	                                        else
        	            	                                        {
        	            	                                            AtomRelation* ar = context.getAtomRelation(rel);
        	            	                                            AtomSchemaTuple* atsct = new AtomSchemaTuple();
        	            	                                            atsct->push_back(a1.atsc);
        	            	                                            atsct->push_back(a2.atsc);
        	            	                                            if(ar->isEquallyTyped(*atsct))
        	            	                                            {
        	            	                                                retval.vf= new InclusionValuationFormula(atsct, ar);
        	            	                                            }
        	            	                                            else
        	            	                                            {
        	            	                                                printPosition(retval.start);
        	            	                                                std::cout << "Types of the relation and the constants/variables do not match.\n";
        	            	                                                delete atsct;
        	            	                                                delete ar;
        	            	                                            }
        	            	                                        }
        	            	                                        delete rel;
        	            	                                        if(retval.vf == 0)
        	            	                                        {
        	            	                                            delete a1.atsc;
        	            	                                            delete a2.atsc;
        	            	                                        }
        	            	                                    }
        	            	                                    else if(context.isRelationVariable(rel))
        	            	                                    {
        	            	                                        retval.vf= 0;
        	            	                                        AtomVariableSchema* avsc1 = dynamic_cast<AtomVariableSchema*>(a1.atsc);
        	            	                                        AtomVariableSchema* avsc2 = dynamic_cast<AtomVariableSchema*>(a2.atsc);
        	            	                                        if(avsc1 == 0)
        	            	                                        {
        	            	                                            printPosition(retval.start);
        	            	                                            std::cout << "Variable expected.\n";
        	            	                                        }
        	            	                                        else if(avsc2 == 0)
        	            	                                        {
        	            	                                            printPosition(retval.start);
        	            	                                            std::cout << "Variable expected.\n";
        	            	                                        }
        	            	                                        else
        	            	                                        {
        	            	                                            const AtomVariable& av1 = dynamic_cast<const AtomVariable&>(avsc1->getAtomVariable());
        	            	                                            const AtomVariable& av2 = dynamic_cast<const AtomVariable&>(avsc2->getAtomVariable());
        	            	                                            retval.vf= new ElementaryValuationFormula(context.getRelationVariable(rel),new AtomVariable(av1), new AtomVariable(av2));
        	            	                                        }
        	            	                                        delete rel;
        	            	                                        delete a1.atsc;
        	            	                                        delete a2.atsc;
        	            	            			}
        	            	            			else
        	            	            			{
        	            	                                        retval.vf= 0;
        	            	                                        printPosition(retval.start);
        	            	                                        std::cout << "Relation (variable) expected.\n";
        	            	                                        delete rel;
        	            	                                        delete a1.atsc;
        	            	                                        delete a2.atsc;
        	            	            			}
        	            	                                
        	            	        }

        	            	    }
        	            	    break;

        	                }
        	            }

        	        }


        	    }
        	    break;
        	case 4:
        	    // cps/CPS.g:1730:4: (name= string )
        	    {
        	        // cps/CPS.g:1730:4: (name= string )
        	        // cps/CPS.g:1730:5: name= string
        	        {
        	            FOLLOWPUSH(FOLLOW_string_in_elemvf3468);
        	            name=string(ctx);

        	            FOLLOWPOP();
        	            if  (HASEXCEPTION())
        	            {
        	                goto ruleelemvfEx;
        	            }
        	            if (HASFAILED())
        	            {
        	                return retval;
        	            }

        	        }

        	        if ( BACKTRACKING==0 ) 
        	        {

        	                            if(!context.isValuationFormula(name))
        	                            {
        	                                retval.vf= 0;
        	                                printPosition(retval.start);
        	                                std::cout << "Identifier " << *(name) << " is not a valuation constraint.\n";
        	                                delete name;
        	                            }
        	                            else
        	            		{
        	                                retval.vf= new NamedValuationFormula(name, context.getValuationFormula(name));
        	                            }
        	                        
        	        }

        	    }
        	    break;

            }
        }
    }
    

    // This is where rules clean up and exit
    //
    goto ruleelemvfEx; /* Prevent compiler warnings */
    ruleelemvfEx: ;
    retval.stop = LT(-1);

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }


    return retval;
}
/* $ANTLR end elemvf */

/** 
 * $ANTLR start boundparlist
 * cps/CPS.g:1746:1: boundparlist returns [ParameterList* bal] : var= atomschema ( ',' var= atomschema )* ;
 */
static CPSParser_boundparlist_return
boundparlist(pCPSParser ctx)
{   
    CPSParser_boundparlist_return retval;

    CPSParser_atomschema_return var;
    #undef	RETURN_TYPE_var
    #define	RETURN_TYPE_var CPSParser_atomschema_return

    /* Initialize rule variables
     */


    retval.start = LT(1); retval.stop = retval.start;

    {
        // cps/CPS.g:1747:2: (var= atomschema ( ',' var= atomschema )* )
        // cps/CPS.g:1747:4: var= atomschema ( ',' var= atomschema )*
        {
            FOLLOWPUSH(FOLLOW_atomschema_in_boundparlist3502);
            var=atomschema(ctx);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleboundparlistEx;
            }
            if (HASFAILED())
            {
                return retval;
            }
            if ( BACKTRACKING==0 ) 
            {

                		retval.bal= new ParameterList();
                                if(dynamic_cast<AtomVariableSchema*>(var.atsc) == 0)
                                {
                                    printPosition(retval.start);
                                    std::cout << "Variable expected.\n";
                                    delete var.atsc;
                                }
                                else
                		{
                                    retval.bal->push_back(var.atsc);
                		}
                            
            }

            // cps/CPS.g:1761:2: ( ',' var= atomschema )*

            for (;;)
            {
                int alt41=2;
                switch ( LA(1) ) 
                {
                case 52:
                	{
                		alt41=1;
                	}
                    break;

                }

                switch (alt41) 
                {
            	case 1:
            	    // cps/CPS.g:1762:2: ',' var= atomschema
            	    {
            	         MATCHT(52, &FOLLOW_52_in_boundparlist3523); 
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleboundparlistEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        FOLLOWPUSH(FOLLOW_atomschema_in_boundparlist3529);
            	        var=atomschema(ctx);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleboundparlistEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        if ( BACKTRACKING==0 ) 
            	        {

            	                            if(dynamic_cast<AtomVariableSchema*>(var.atsc) == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Variable expected.\n";                   
            	                                delete var.atsc;
            	                            }
            	                            else
            	            		{
            	                                retval.bal->push_back(var.atsc);
            	            		}
            	                        
            	        }

            	    }
            	    break;

            	default:
            	    goto loop41;	/* break out of the loop */
            	    break;
                }
            }
            loop41: ; /* Jump out to here if this rule does not match */


        }

    }
    

    // This is where rules clean up and exit
    //
    goto ruleboundparlistEx; /* Prevent compiler warnings */
    ruleboundparlistEx: ;
    retval.stop = LT(-1);

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }


    return retval;
}
/* $ANTLR end boundparlist */

/** 
 * $ANTLR start stateschema
 * cps/CPS.g:1778:1: stateschema returns [StateSchema* stsc] : c= string ( '(' )=> ( '(' ( (a= atomschema ) ( ',' a= atomschema )* )? ')' )? ;
 */
static CPSParser_stateschema_return
stateschema(pCPSParser ctx)
{   
    CPSParser_stateschema_return retval;

    std::string* c;
    #undef	RETURN_TYPE_c
    #define	RETURN_TYPE_c std::string*

    CPSParser_atomschema_return a;
    #undef	RETURN_TYPE_a
    #define	RETURN_TYPE_a CPSParser_atomschema_return

    /* Initialize rule variables
     */


    c = NULL;
    retval.start = LT(1); retval.stop = retval.start;

    {
        // cps/CPS.g:1779:2: (c= string ( '(' )=> ( '(' ( (a= atomschema ) ( ',' a= atomschema )* )? ')' )? )
        // cps/CPS.g:1779:5: c= string ( '(' )=> ( '(' ( (a= atomschema ) ( ',' a= atomschema )* )? ')' )?
        {
            FOLLOWPUSH(FOLLOW_string_in_stateschema3568);
            c=string(ctx);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulestateschemaEx;
            }
            if (HASFAILED())
            {
                return retval;
            }
            if ( BACKTRACKING==0 ) 
            {

                                        if(!context.isNotDefined(c,false)) 
                                        {
                                            printPosition(retval.start);
                                            std::cout << "Control state expected.\n";                   
                                            retval.stsc= new StateSchema();
                                        }
                                        else
                		 	{
                                            retval.stsc= new StateSchema(context.insertControlState(c));
                		 	}
                		 	delete c;
                                    
            }

            // cps/CPS.g:1794:3: ( '(' ( (a= atomschema ) ( ',' a= atomschema )* )? ')' )?
            {
                int alt44=2;
                switch ( LA(1) ) 
                {
                    case 58:
                    	{
                    		alt44=1;
                    	}
                        break;
                }

                switch (alt44) 
                {
            	case 1:
            	    // cps/CPS.g:1795:3: '(' ( (a= atomschema ) ( ',' a= atomschema )* )? ')'
            	    {
            	         MATCHT(58, &FOLLOW_58_in_stateschema3605); 
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulestateschemaEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }

            	        // cps/CPS.g:1796:3: ( (a= atomschema ) ( ',' a= atomschema )* )?
            	        {
            	            int alt43=2;
            	            switch ( LA(1) ) 
            	            {
            	                case SMALLID:
            	                case CAPITID:
            	                case CAPITNUMID:
            	                	{
            	                		alt43=1;
            	                	}
            	                    break;
            	            }

            	            switch (alt43) 
            	            {
            	        	case 1:
            	        	    // cps/CPS.g:1797:3: (a= atomschema ) ( ',' a= atomschema )*
            	        	    {
            	        	        // cps/CPS.g:1797:3: (a= atomschema )
            	        	        // cps/CPS.g:1797:5: a= atomschema
            	        	        {
            	        	            FOLLOWPUSH(FOLLOW_atomschema_in_stateschema3618);
            	        	            a=atomschema(ctx);

            	        	            FOLLOWPOP();
            	        	            if  (HASEXCEPTION())
            	        	            {
            	        	                goto rulestateschemaEx;
            	        	            }
            	        	            if (HASFAILED())
            	        	            {
            	        	                return retval;
            	        	            }
            	        	            if ( BACKTRACKING==0 ) 
            	        	            {

            	        	                			if(a.atsc == 0)
            	        	                                        {
            	        	                                            printPosition(retval.start);
            	        	                                            std::cout << "Constant/variable/function application expected.\n";                   
            	        	                                        }
            	        	                                        else
            	        	                                        {
            	        	                                            retval.stsc->push_back(a.atsc);
            	        	                                        }
            	        	                                    
            	        	            }

            	        	        }


            	        	        // cps/CPS.g:1810:3: ( ',' a= atomschema )*

            	        	        for (;;)
            	        	        {
            	        	            int alt42=2;
            	        	            switch ( LA(1) ) 
            	        	            {
            	        	            case 52:
            	        	            	{
            	        	            		alt42=1;
            	        	            	}
            	        	                break;

            	        	            }

            	        	            switch (alt42) 
            	        	            {
            	        	        	case 1:
            	        	        	    // cps/CPS.g:1811:3: ',' a= atomschema
            	        	        	    {
            	        	        	         MATCHT(52, &FOLLOW_52_in_stateschema3652); 
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulestateschemaEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return retval;
            	        	        	        }
            	        	        	        FOLLOWPUSH(FOLLOW_atomschema_in_stateschema3658);
            	        	        	        a=atomschema(ctx);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulestateschemaEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return retval;
            	        	        	        }
            	        	        	        if ( BACKTRACKING==0 ) 
            	        	        	        {

            	        	        	            			if(a.atsc == 0)
            	        	        	                                    {
            	        	        	                                        printPosition(retval.start);
            	        	        	                                        std::cout << "Constant/variable/function application expected.\n";                   
            	        	        	                                    }
            	        	        	                                    else
            	        	        	                                    {
            	        	        	                                        retval.stsc->push_back(a.atsc);
            	        	        	                                    }
            	        	        	                                
            	        	        	        }

            	        	        	    }
            	        	        	    break;

            	        	        	default:
            	        	        	    goto loop42;	/* break out of the loop */
            	        	        	    break;
            	        	            }
            	        	        }
            	        	        loop42: ; /* Jump out to here if this rule does not match */


            	        	    }
            	        	    break;

            	            }
            	        }
            	         MATCHT(59, &FOLLOW_59_in_stateschema3694); 
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulestateschemaEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }

            	    }
            	    break;

                }
            }

        }

    }
    

    // This is where rules clean up and exit
    //
    goto rulestateschemaEx; /* Prevent compiler warnings */
    rulestateschemaEx: ;
    retval.stop = LT(-1);

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }


    return retval;
}
/* $ANTLR end stateschema */

/** 
 * $ANTLR start fromstateschema
 * cps/CPS.g:1829:1: fromstateschema returns [StateSchema* stsc] : c= string ( '(' )=> ( '(' ( (a= atomschema ) ( ',' a= atomschema )* )? ')' )? ;
 */
static CPSParser_fromstateschema_return
fromstateschema(pCPSParser ctx)
{   
    CPSParser_fromstateschema_return retval;

    std::string* c;
    #undef	RETURN_TYPE_c
    #define	RETURN_TYPE_c std::string*

    CPSParser_atomschema_return a;
    #undef	RETURN_TYPE_a
    #define	RETURN_TYPE_a CPSParser_atomschema_return

    /* Initialize rule variables
     */


    c = NULL;
    retval.start = LT(1); retval.stop = retval.start;

    {
        // cps/CPS.g:1830:2: (c= string ( '(' )=> ( '(' ( (a= atomschema ) ( ',' a= atomschema )* )? ')' )? )
        // cps/CPS.g:1830:5: c= string ( '(' )=> ( '(' ( (a= atomschema ) ( ',' a= atomschema )* )? ')' )?
        {
            FOLLOWPUSH(FOLLOW_string_in_fromstateschema3719);
            c=string(ctx);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulefromstateschemaEx;
            }
            if (HASFAILED())
            {
                return retval;
            }
            if ( BACKTRACKING==0 ) 
            {

                                        if(!context.isNotDefined(c,false)) 
                                        {
                                            printPosition(retval.start);
                                            std::cout << "Control state expected.\n";                   
                                            retval.stsc= new StateSchema();
                                        }
                                        else
                		 	{
                                            retval.stsc= new StateSchema(context.insertControlState(c));
                		 	}
                		 	delete c;
                                    
            }

            // cps/CPS.g:1845:3: ( '(' ( (a= atomschema ) ( ',' a= atomschema )* )? ')' )?
            {
                int alt47=2;
                switch ( LA(1) ) 
                {
                    case 58:
                    	{
                    		alt47=1;
                    	}
                        break;
                }

                switch (alt47) 
                {
            	case 1:
            	    // cps/CPS.g:1846:3: '(' ( (a= atomschema ) ( ',' a= atomschema )* )? ')'
            	    {
            	         MATCHT(58, &FOLLOW_58_in_fromstateschema3756); 
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulefromstateschemaEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }

            	        // cps/CPS.g:1847:3: ( (a= atomschema ) ( ',' a= atomschema )* )?
            	        {
            	            int alt46=2;
            	            switch ( LA(1) ) 
            	            {
            	                case SMALLID:
            	                case CAPITID:
            	                case CAPITNUMID:
            	                	{
            	                		alt46=1;
            	                	}
            	                    break;
            	            }

            	            switch (alt46) 
            	            {
            	        	case 1:
            	        	    // cps/CPS.g:1848:3: (a= atomschema ) ( ',' a= atomschema )*
            	        	    {
            	        	        // cps/CPS.g:1848:3: (a= atomschema )
            	        	        // cps/CPS.g:1848:5: a= atomschema
            	        	        {
            	        	            FOLLOWPUSH(FOLLOW_atomschema_in_fromstateschema3769);
            	        	            a=atomschema(ctx);

            	        	            FOLLOWPOP();
            	        	            if  (HASEXCEPTION())
            	        	            {
            	        	                goto rulefromstateschemaEx;
            	        	            }
            	        	            if (HASFAILED())
            	        	            {
            	        	                return retval;
            	        	            }
            	        	            if ( BACKTRACKING==0 ) 
            	        	            {

            	        	                			if(dynamic_cast<AtomVariableSchema*>(a.atsc) == 0)
            	        	                                        {
            	        	                                            printPosition(retval.start);
            	        	                                            std::cout << "Variable expected.\n";
            	        	                                            delete a.atsc;
            	        	                                        }
            	        	                                        else
            	        	                                        {
            	        	                                            retval.stsc->push_back(a.atsc);
            	        	                                        }
            	        	                                    
            	        	            }

            	        	        }


            	        	        // cps/CPS.g:1862:3: ( ',' a= atomschema )*

            	        	        for (;;)
            	        	        {
            	        	            int alt45=2;
            	        	            switch ( LA(1) ) 
            	        	            {
            	        	            case 52:
            	        	            	{
            	        	            		alt45=1;
            	        	            	}
            	        	                break;

            	        	            }

            	        	            switch (alt45) 
            	        	            {
            	        	        	case 1:
            	        	        	    // cps/CPS.g:1863:3: ',' a= atomschema
            	        	        	    {
            	        	        	         MATCHT(52, &FOLLOW_52_in_fromstateschema3803); 
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulefromstateschemaEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return retval;
            	        	        	        }
            	        	        	        FOLLOWPUSH(FOLLOW_atomschema_in_fromstateschema3809);
            	        	        	        a=atomschema(ctx);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulefromstateschemaEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return retval;
            	        	        	        }
            	        	        	        if ( BACKTRACKING==0 ) 
            	        	        	        {

            	        	        	            			if(dynamic_cast<AtomVariableSchema*>(a.atsc) == 0)
            	        	        	                                    {
            	        	        	                                        printPosition(retval.start);
            	        	        	                                        std::cout << "Variable expected.\n";
            	        	        	                                        delete a.atsc;
            	        	        	                                    }
            	        	        	                                    else
            	        	        	                                    {
            	        	        	                                        retval.stsc->push_back(a.atsc);
            	        	        	                                    }
            	        	        	                                
            	        	        	        }

            	        	        	    }
            	        	        	    break;

            	        	        	default:
            	        	        	    goto loop45;	/* break out of the loop */
            	        	        	    break;
            	        	            }
            	        	        }
            	        	        loop45: ; /* Jump out to here if this rule does not match */


            	        	    }
            	        	    break;

            	            }
            	        }
            	         MATCHT(59, &FOLLOW_59_in_fromstateschema3845); 
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulefromstateschemaEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }

            	    }
            	    break;

                }
            }

        }

    }
    

    // This is where rules clean up and exit
    //
    goto rulefromstateschemaEx; /* Prevent compiler warnings */
    rulefromstateschemaEx: ;
    retval.stop = LT(-1);

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }


    return retval;
}
/* $ANTLR end fromstateschema */

/** 
 * $ANTLR start atomschematuple
 * cps/CPS.g:1882:1: atomschematuple[AtomSchemaTuple* ast] returns [AtomSchemaTuple* actsc] : (a= atomschema | '(' ( (a= atomschema ) ( ',' a= atomschema )* )? ')' );
 */
static CPSParser_atomschematuple_return
atomschematuple(pCPSParser ctx, AtomSchemaTuple* ast)
{   
    CPSParser_atomschematuple_return retval;

    CPSParser_atomschema_return a;
    #undef	RETURN_TYPE_a
    #define	RETURN_TYPE_a CPSParser_atomschema_return

    /* Initialize rule variables
     */


    retval.start = LT(1); retval.stop = retval.start;

    {
        {
            //  cps/CPS.g:1884:2: (a= atomschema | '(' ( (a= atomschema ) ( ',' a= atomschema )* )? ')' )
            
            ANTLR3_UINT32 alt50;

            alt50=2;

            switch ( LA(1) ) 
            {
            case SMALLID:
            case CAPITID:
            case CAPITNUMID:
            	{
            		alt50=1;
            	}
                break;
            case 58:
            	{
            		alt50=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return retval;
                }
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 50;
                EXCEPTION->state        = 0;


                goto ruleatomschematupleEx;
            }

            switch (alt50) 
            {
        	case 1:
        	    // cps/CPS.g:1884:6: a= atomschema
        	    {
        	        FOLLOWPUSH(FOLLOW_atomschema_in_atomschematuple3873);
        	        a=atomschema(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleatomschematupleEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return retval;
        	        }
        	        if ( BACKTRACKING==0 ) 
        	        {

        	                                if(ast == 0)
        	                                {
        	                                    retval.actsc= new AtomSchemaTuple();
        	                                }
        	                                else
        	                                {
        	                                    retval.actsc= ast;
        	                                }
        	                                if(a.atsc == 0)
        	                                {
        	                                    printPosition(retval.start);
        	                                    std::cout << "Constant/variable expected.\n";
        	                                }
        	                                else
        	                                {
        	                                    retval.actsc->push_back(a.atsc);
        	                                }
        	                            
        	        }

        	    }
        	    break;
        	case 2:
        	    // cps/CPS.g:1905:13: '(' ( (a= atomschema ) ( ',' a= atomschema )* )? ')'
        	    {
        	         MATCHT(58, &FOLLOW_58_in_atomschematuple3919); 
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleatomschematupleEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return retval;
        	        }

        	        // cps/CPS.g:1906:13: ( (a= atomschema ) ( ',' a= atomschema )* )?
        	        {
        	            int alt49=2;
        	            switch ( LA(1) ) 
        	            {
        	                case SMALLID:
        	                case CAPITID:
        	                case CAPITNUMID:
        	                	{
        	                		alt49=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt49) 
        	            {
        	        	case 1:
        	        	    // cps/CPS.g:1907:3: (a= atomschema ) ( ',' a= atomschema )*
        	        	    {
        	        	        // cps/CPS.g:1907:3: (a= atomschema )
        	        	        // cps/CPS.g:1907:5: a= atomschema
        	        	        {
        	        	            FOLLOWPUSH(FOLLOW_atomschema_in_atomschematuple3942);
        	        	            a=atomschema(ctx);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleatomschematupleEx;
        	        	            }
        	        	            if (HASFAILED())
        	        	            {
        	        	                return retval;
        	        	            }
        	        	            if ( BACKTRACKING==0 ) 
        	        	            {

        	        	                                    	if(ast == 0)
        	        	                                    	{
        	        	                                    	    retval.actsc= new AtomSchemaTuple();
        	        	                                    	}
        	        	                                    	else
        	        	                                    	{
        	        	                                    	    retval.actsc= ast;
        	        	                                    	}
        	        	                			if(a.atsc == 0)
        	        	                                        {
        	        	                                            printPosition(retval.start);
        	        	                                            std::cout << "Constant/variable/function application expected.\n";
        	        	                                        }
        	        	                                        else
        	        	                                        {
        	        	                                            retval.actsc->push_back(a.atsc);
        	        	                			}
        	        	                                    
        	        	            }

        	        	        }


        	        	        // cps/CPS.g:1928:3: ( ',' a= atomschema )*

        	        	        for (;;)
        	        	        {
        	        	            int alt48=2;
        	        	            switch ( LA(1) ) 
        	        	            {
        	        	            case 52:
        	        	            	{
        	        	            		alt48=1;
        	        	            	}
        	        	                break;

        	        	            }

        	        	            switch (alt48) 
        	        	            {
        	        	        	case 1:
        	        	        	    // cps/CPS.g:1929:3: ',' a= atomschema
        	        	        	    {
        	        	        	         MATCHT(52, &FOLLOW_52_in_atomschematuple3976); 
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto ruleatomschematupleEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return retval;
        	        	        	        }
        	        	        	        FOLLOWPUSH(FOLLOW_atomschema_in_atomschematuple3982);
        	        	        	        a=atomschema(ctx);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto ruleatomschematupleEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return retval;
        	        	        	        }
        	        	        	        if ( BACKTRACKING==0 ) 
        	        	        	        {

        	        	        	            			if(a.atsc == 0)
        	        	        	                                    {
        	        	        	                                        printPosition(retval.start);
        	        	        	                                        std::cout << "Constant/variable/function application expected.\n";
        	        	        	                                    }
        	        	        	                                    else
        	        	        	                                    {
        	        	        	                                        retval.actsc->push_back(a.atsc);
        	        	        	            			}
        	        	        	                                
        	        	        	        }

        	        	        	    }
        	        	        	    break;

        	        	        	default:
        	        	        	    goto loop48;	/* break out of the loop */
        	        	        	    break;
        	        	            }
        	        	        }
        	        	        loop48: ; /* Jump out to here if this rule does not match */


        	        	    }
        	        	    break;

        	            }
        	        }
        	         MATCHT(59, &FOLLOW_59_in_atomschematuple4038); 
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleatomschematupleEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return retval;
        	        }

        	    }
        	    break;

            }
        }
    }
    

    // This is where rules clean up and exit
    //
    goto ruleatomschematupleEx; /* Prevent compiler warnings */
    ruleatomschematupleEx: ;
    retval.stop = LT(-1);

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }


    return retval;
}
/* $ANTLR end atomschematuple */

/** 
 * $ANTLR start actionschema
 * cps/CPS.g:1946:1: actionschema returns [ActionSchema* actsc] : ( ( ( '!' )? c= smallstr | '?' c= smallstr ) ( '(' )=> atomschematuple[$actsc] | ( TAU ( '(' ')' )? ) );
 */
static CPSParser_actionschema_return
actionschema(pCPSParser ctx)
{   
    CPSParser_actionschema_return retval;

    std::string* c;
    #undef	RETURN_TYPE_c
    #define	RETURN_TYPE_c std::string*

    /* Initialize rule variables
     */


    c = NULL;
    retval.start = LT(1); retval.stop = retval.start;

    {
        {
            //  cps/CPS.g:1947:2: ( ( ( '!' )? c= smallstr | '?' c= smallstr ) ( '(' )=> atomschematuple[$actsc] | ( TAU ( '(' ')' )? ) )
            
            ANTLR3_UINT32 alt54;

            alt54=2;

            switch ( LA(1) ) 
            {
            case NEG:
            case SMALLID:
            case 60:
            	{
            		alt54=1;
            	}
                break;
            case TAU:
            	{
            		alt54=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return retval;
                }
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 54;
                EXCEPTION->state        = 0;


                goto ruleactionschemaEx;
            }

            switch (alt54) 
            {
        	case 1:
        	    // cps/CPS.g:1947:6: ( ( '!' )? c= smallstr | '?' c= smallstr ) ( '(' )=> atomschematuple[$actsc]
        	    {

        	        // cps/CPS.g:1947:6: ( ( '!' )? c= smallstr | '?' c= smallstr )
        	        {
        	            int alt52=2;
        	            switch ( LA(1) ) 
        	            {
        	            case NEG:
        	            case SMALLID:
        	            	{
        	            		alt52=1;
        	            	}
        	                break;
        	            case 60:
        	            	{
        	            		alt52=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return retval;
        	                }
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 52;
        	                EXCEPTION->state        = 0;


        	                goto ruleactionschemaEx;
        	            }

        	            switch (alt52) 
        	            {
        	        	case 1:
        	        	    // cps/CPS.g:1947:10: ( '!' )? c= smallstr
        	        	    {

        	        	        // cps/CPS.g:1947:10: ( '!' )?
        	        	        {
        	        	            int alt51=2;
        	        	            switch ( LA(1) ) 
        	        	            {
        	        	                case NEG:
        	        	                	{
        	        	                		alt51=1;
        	        	                	}
        	        	                    break;
        	        	            }

        	        	            switch (alt51) 
        	        	            {
        	        	        	case 1:
        	        	        	    // cps/CPS.g:1947:11: '!'
        	        	        	    {
        	        	        	         MATCHT(NEG, &FOLLOW_NEG_in_actionschema4060); 
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto ruleactionschemaEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return retval;
        	        	        	        }

        	        	        	    }
        	        	        	    break;

        	        	            }
        	        	        }
        	        	        FOLLOWPUSH(FOLLOW_smallstr_in_actionschema4068);
        	        	        c=smallstr(ctx);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleactionschemaEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return retval;
        	        	        }
        	        	        if ( BACKTRACKING==0 ) 
        	        	        {

        	        	                                    if(!context.isChannel(c))
        	        	                                    {
        	        	                                        printPosition(retval.start);
        	        	                                        std::cout << "Channel expected.\n";
        	        	                                        retval.actsc= new ActionSchema();
        	        	                                    }
        	        	                                    else
        	        	                                    {
        	        	                                        retval.actsc= new ActionSchema(context.getChannel(c));
        	        	                                    }
        	        	                                    delete c;
        	        	                                
        	        	        }

        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // cps/CPS.g:1961:19: '?' c= smallstr
        	        	    {
        	        	         MATCHT(60, &FOLLOW_60_in_actionschema4110); 
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleactionschemaEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return retval;
        	        	        }
        	        	        FOLLOWPUSH(FOLLOW_smallstr_in_actionschema4116);
        	        	        c=smallstr(ctx);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleactionschemaEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return retval;
        	        	        }
        	        	        if ( BACKTRACKING==0 ) 
        	        	        {

        	        	                                    if(!context.isChannel(c))
        	        	                                    {
        	        	                                        printPosition(retval.start);
        	        	                                        std::cout << "Channel expected.\n";
        	        	                                        retval.actsc= new ActionSchema();
        	        	                                    }
        	        	                                    else
        	        	                                    {
        	        	                                        retval.actsc= new ActionSchema(context.getChannel(c), true);
        	        	                                    }
        	        	                                    delete c;
        	        	                                
        	        	        }

        	        	    }
        	        	    break;

        	            }
        	        }
        	        FOLLOWPUSH(FOLLOW_atomschematuple_in_actionschema4172);
        	        atomschematuple(ctx, retval.actsc);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleactionschemaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return retval;
        	        }

        	    }
        	    break;
        	case 2:
        	    // cps/CPS.g:1978:13: ( TAU ( '(' ')' )? )
        	    {
        	        // cps/CPS.g:1978:13: ( TAU ( '(' ')' )? )
        	        // cps/CPS.g:1978:14: TAU ( '(' ')' )?
        	        {
        	             MATCHT(TAU, &FOLLOW_TAU_in_actionschema4191); 
        	            if  (HASEXCEPTION())
        	            {
        	                goto ruleactionschemaEx;
        	            }
        	            if (HASFAILED())
        	            {
        	                return retval;
        	            }

        	            // cps/CPS.g:1978:18: ( '(' ')' )?
        	            {
        	                int alt53=2;
        	                switch ( LA(1) ) 
        	                {
        	                    case 58:
        	                    	{
        	                    		alt53=1;
        	                    	}
        	                        break;
        	                }

        	                switch (alt53) 
        	                {
        	            	case 1:
        	            	    // cps/CPS.g:1978:19: '(' ')'
        	            	    {
        	            	         MATCHT(58, &FOLLOW_58_in_actionschema4194); 
        	            	        if  (HASEXCEPTION())
        	            	        {
        	            	            goto ruleactionschemaEx;
        	            	        }
        	            	        if (HASFAILED())
        	            	        {
        	            	            return retval;
        	            	        }
        	            	         MATCHT(59, &FOLLOW_59_in_actionschema4195); 
        	            	        if  (HASEXCEPTION())
        	            	        {
        	            	            goto ruleactionschemaEx;
        	            	        }
        	            	        if (HASFAILED())
        	            	        {
        	            	            return retval;
        	            	        }

        	            	    }
        	            	    break;

        	                }
        	            }
        	            if ( BACKTRACKING==0 ) 
        	            {

        	                                retval.actsc= new ActionSchema(0);
        	                                
        	            }

        	        }


        	    }
        	    break;

            }
        }
    }
    

    // This is where rules clean up and exit
    //
    goto ruleactionschemaEx; /* Prevent compiler warnings */
    ruleactionschemaEx: ;
    retval.stop = LT(-1);

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }


    return retval;
}
/* $ANTLR end actionschema */

/** 
 * $ANTLR start atomschema
 * cps/CPS.g:1985:1: atomschema returns [AtomSchema* atsc] : ( ( string '(' )=> (name= string a= atomschematuple[0] ) | ( smallstr )=>name= smallstr );
 */
static CPSParser_atomschema_return
atomschema(pCPSParser ctx)
{   
    CPSParser_atomschema_return retval;

    std::string* name;
    #undef	RETURN_TYPE_name
    #define	RETURN_TYPE_name std::string*

    CPSParser_atomschematuple_return a;
    #undef	RETURN_TYPE_a
    #define	RETURN_TYPE_a CPSParser_atomschematuple_return

    /* Initialize rule variables
     */


    name = NULL;
    retval.start = LT(1); retval.stop = retval.start;

    {
        {
            //  cps/CPS.g:1986:2: ( ( string '(' )=> (name= string a= atomschematuple[0] ) | ( smallstr )=>name= smallstr )
            
            ANTLR3_UINT32 alt55;

            alt55=2;


            {
                int LA55_0 = LA(1);
                if ( (LA55_0 == SMALLID) ) 
                {

                    {
                        int LA55_1 = LA(2);
                        if ( (synpred7_CPS(ctx)) ) 
                        {
                            alt55=1;
                        }
                        else if ( (synpred8_CPS(ctx)) ) 
                        {
                            alt55=2;
                        }
                        else 
                        {
                            if (BACKTRACKING>0)
                            {
                                FAILEDFLAG = ANTLR3_TRUE;
                                return retval;
                            }
                        
                            CONSTRUCTEX();
                            EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                            EXCEPTION->message      = (void *)"";
                            EXCEPTION->decisionNum  = 55;
                            EXCEPTION->state        = 1;


                            goto ruleatomschemaEx;
                        }
                    }
                }
                else if ( (((LA55_0 >= CAPITID) && (LA55_0 <= CAPITNUMID))) && (synpred7_CPS(ctx))) 
                {
                    alt55=1;
                }
                else 
                {
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return retval;
                    }
                
                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 55;
                    EXCEPTION->state        = 0;


                    goto ruleatomschemaEx;
                }
            }
            switch (alt55) 
            {
        	case 1:
        	    // cps/CPS.g:1986:4: ( string '(' )=> (name= string a= atomschematuple[0] )
        	    {
        	        // cps/CPS.g:1986:18: (name= string a= atomschematuple[0] )
        	        // cps/CPS.g:1986:19: name= string a= atomschematuple[0]
        	        {
        	            FOLLOWPUSH(FOLLOW_string_in_atomschema4255);
        	            name=string(ctx);

        	            FOLLOWPOP();
        	            if  (HASEXCEPTION())
        	            {
        	                goto ruleatomschemaEx;
        	            }
        	            if (HASFAILED())
        	            {
        	                return retval;
        	            }
        	            FOLLOWPUSH(FOLLOW_atomschematuple_in_atomschema4261);
        	            a=atomschematuple(ctx, 0);

        	            FOLLOWPOP();
        	            if  (HASEXCEPTION())
        	            {
        	                goto ruleatomschemaEx;
        	            }
        	            if (HASFAILED())
        	            {
        	                return retval;
        	            }

        	        }

        	        if ( BACKTRACKING==0 ) 
        	        {

        	                            retval.atsc= 0;
        	                            if(name == 0)
        	                            {
        	                                printPosition(retval.start);
        	                                std::cout << "Function expected.\n";                    
        	                            }
        	                            else if(!context.isAtomRelation(name))
        	                            {
        	                                printPosition(retval.start);
        	                                std::cout << "Identifier " << *(name) << " is not a function.\n";                                  
        	                            }
        	                            else if(a.actsc == 0)
        	                            {
        	                                printPosition(retval.start);
        	                                std::cout << "A tuple of constants expected.\n";                                    
        	                            }
        	                            else
        	            		{
        	                                AtomRelation* f = context.getAtomRelation(name);
        	                                retval.atsc= new FunctionAtomSchema(f, a.actsc);
        	            		}
        	                            if(retval.atsc == 0) delete a.actsc;
        	            		delete name;
        	                        
        	        }

        	    }
        	    break;
        	case 2:
        	    // cps/CPS.g:2012:4: ( smallstr )=>name= smallstr
        	    {
        	        FOLLOWPUSH(FOLLOW_smallstr_in_atomschema4291);
        	        name=smallstr(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleatomschemaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return retval;
        	        }
        	        if ( BACKTRACKING==0 ) 
        	        {

        	                            retval.atsc= 0;
        	            		if(context.isAtom(name))
        	                            {
        	                                retval.atsc= new ElementaryAtomSchema(context.getAtom(name));
        	                            }
        	                            else if(context.isAtomVariable(name))
        	                            {
        	                                retval.atsc= new AtomVariableSchema(context.getAtomVariable(name));
        	                            }
        	                            else
        	                            {
        	                                printPosition(retval.start);
        	                                std::cout << "Constant/variable expected.\n";
        	                            }
        	            		delete name;
        	                        
        	        }

        	    }
        	    break;

            }
        }
    }
    

    // This is where rules clean up and exit
    //
    goto ruleatomschemaEx; /* Prevent compiler warnings */
    ruleatomschemaEx: ;
    retval.stop = LT(-1);

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }


    return retval;
}
/* $ANTLR end atomschema */

/** 
 * $ANTLR start relschema
 * cps/CPS.g:2032:1: relschema returns [RelationSchema* rs] : '{' a= atomschematuple[0] ( ',' a= atomschematuple[0] )* ( '|' g= valf )? '}' ;
 */
static CPSParser_relschema_return
relschema(pCPSParser ctx)
{   
    CPSParser_relschema_return retval;

    CPSParser_atomschematuple_return a;
    #undef	RETURN_TYPE_a
    #define	RETURN_TYPE_a CPSParser_atomschematuple_return

    ValuationFormula* g;
    #undef	RETURN_TYPE_g
    #define	RETURN_TYPE_g ValuationFormula*

    /* Initialize rule variables
     */


    g = NULL;
    retval.start = LT(1); retval.stop = retval.start;

    {
        // cps/CPS.g:2033:9: ( '{' a= atomschematuple[0] ( ',' a= atomschematuple[0] )* ( '|' g= valf )? '}' )
        // cps/CPS.g:2033:11: '{' a= atomschematuple[0] ( ',' a= atomschematuple[0] )* ( '|' g= valf )? '}'
        {
             MATCHT(51, &FOLLOW_51_in_relschema4330); 
            if  (HASEXCEPTION())
            {
                goto rulerelschemaEx;
            }
            if (HASFAILED())
            {
                return retval;
            }
            FOLLOWPUSH(FOLLOW_atomschematuple_in_relschema4337);
            a=atomschematuple(ctx, 0);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulerelschemaEx;
            }
            if (HASFAILED())
            {
                return retval;
            }
            if ( BACKTRACKING==0 ) 
            {

                                retval.rs= 0;
                		if(a.actsc == 0)
                                {
                                    printPosition(retval.start);
                                    std::cout << "A tuple of constants/variables expected.\n";                   
                                }
                                else
                                {
                	            retval.rs= new RelationSchema(a.actsc, context.getTypeSizes(a.actsc));
                                }
                            
            }

            // cps/CPS.g:2048:2: ( ',' a= atomschematuple[0] )*

            for (;;)
            {
                int alt56=2;
                switch ( LA(1) ) 
                {
                case 52:
                	{
                		alt56=1;
                	}
                    break;

                }

                switch (alt56) 
                {
            	case 1:
            	    // cps/CPS.g:2048:3: ',' a= atomschematuple[0]
            	    {
            	         MATCHT(52, &FOLLOW_52_in_relschema4358); 
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulerelschemaEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        FOLLOWPUSH(FOLLOW_atomschematuple_in_relschema4364);
            	        a=atomschematuple(ctx, 0);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulerelschemaEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        if ( BACKTRACKING==0 ) 
            	        {

            	            		if(a.actsc == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "A tuple of constants/variables expected.\n";                   
            	                            }
            	                            else if(retval.rs != 0)
            	                            { 
            	                                if(!retval.rs->isEquallyTyped(*a.actsc))
            	                                {
            	                                    printPosition(retval.start);
            	                                    std::cout << "Types of the relation and the tuple do not match.\n";                   
            	                                }
            	                                else 
            	                                {
            	                                    retval.rs->insert(a.actsc);
            	                                }
            	                            }
            	                        
            	        }

            	    }
            	    break;

            	default:
            	    goto loop56;	/* break out of the loop */
            	    break;
                }
            }
            loop56: ; /* Jump out to here if this rule does not match */


            // cps/CPS.g:2069:2: ( '|' g= valf )?
            {
                int alt57=2;
                switch ( LA(1) ) 
                {
                    case OR:
                    	{
                    		alt57=1;
                    	}
                        break;
                }

                switch (alt57) 
                {
            	case 1:
            	    // cps/CPS.g:2070:2: '|' g= valf
            	    {
            	         MATCHT(OR, &FOLLOW_OR_in_relschema4389); 
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulerelschemaEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        FOLLOWPUSH(FOLLOW_valf_in_relschema4395);
            	        g=valf(ctx);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulerelschemaEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        if ( BACKTRACKING==0 ) 
            	        {

            	            	        if(g == 0)
            	            	        {
            	                                printPosition(retval.start);
            	                                std::cout << "Guard expected.\n";                   
            	            	        }
            	            	        else if(!g->isUnquantified())
            	            	        {
            	                                printPosition(retval.start);
            	                                std::cout << "Unquantified guard expected.\n";                   
            	            	        }
            	            	        else if(retval.rs != 0)
            	            	        {
            	            	            retval.rs->setGuard(g);
            	            	        }
            	            	    
            	        }

            	    }
            	    break;

                }
            }
             MATCHT(53, &FOLLOW_53_in_relschema4409); 
            if  (HASEXCEPTION())
            {
                goto rulerelschemaEx;
            }
            if (HASFAILED())
            {
                return retval;
            }

        }

    }
    

    // This is where rules clean up and exit
    //
    goto rulerelschemaEx; /* Prevent compiler warnings */
    rulerelschemaEx: ;
    retval.stop = LT(-1);

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }


    return retval;
}
/* $ANTLR end relschema */

/** 
 * $ANTLR start atomrel
 * cps/CPS.g:2091:1: atomrel returns [AtomRelation* rel] : rs= elematomrel ( PLUS rs= elematomrel | MINUS rs= elematomrel )* ;
 */
static CPSParser_atomrel_return
atomrel(pCPSParser ctx)
{   
    CPSParser_atomrel_return retval;

    CPSParser_elematomrel_return rs;
    #undef	RETURN_TYPE_rs
    #define	RETURN_TYPE_rs CPSParser_elematomrel_return

    /* Initialize rule variables
     */


    retval.start = LT(1); retval.stop = retval.start;

    {
        // cps/CPS.g:2092:2: (rs= elematomrel ( PLUS rs= elematomrel | MINUS rs= elematomrel )* )
        // cps/CPS.g:2092:4: rs= elematomrel ( PLUS rs= elematomrel | MINUS rs= elematomrel )*
        {
            FOLLOWPUSH(FOLLOW_elematomrel_in_atomrel4443);
            rs=elematomrel(ctx);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleatomrelEx;
            }
            if (HASFAILED())
            {
                return retval;
            }
            if ( BACKTRACKING==0 ) 
            {

                                retval.rel= rs.rel;
                            
            }

            // cps/CPS.g:2096:2: ( PLUS rs= elematomrel | MINUS rs= elematomrel )*

            for (;;)
            {
                int alt58=3;
                switch ( LA(1) ) 
                {
                case PLUS:
                	{
                		alt58=1;
                	}
                    break;
                case MINUS:
                	{
                		alt58=2;
                	}
                    break;

                }

                switch (alt58) 
                {
            	case 1:
            	    // cps/CPS.g:2096:3: PLUS rs= elematomrel
            	    {
            	         MATCHT(PLUS, &FOLLOW_PLUS_in_atomrel4461); 
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleatomrelEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        FOLLOWPUSH(FOLLOW_elematomrel_in_atomrel4467);
            	        rs=elematomrel(ctx);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleatomrelEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        if ( BACKTRACKING==0 ) 
            	        {

            	            		if(rs.rel == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Relation expected.\n";                   
            	                            }
            	                            else if(retval.rel != 0)
            	            		{
            	            		    retval.rel->plus(*(rs.rel));
            	            		}
            	                            delete rs.rel;
            	                        
            	        }

            	    }
            	    break;
            	case 2:
            	    // cps/CPS.g:2109:4: MINUS rs= elematomrel
            	    {
            	         MATCHT(MINUS, &FOLLOW_MINUS_in_atomrel4486); 
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleatomrelEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        FOLLOWPUSH(FOLLOW_elematomrel_in_atomrel4492);
            	        rs=elematomrel(ctx);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleatomrelEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return retval;
            	        }
            	        if ( BACKTRACKING==0 ) 
            	        {

            	            		if(rs.rel == 0)
            	                            {
            	                                printPosition(retval.start);
            	                                std::cout << "Relation expected.\n";                   
            	                            }
            	                            else if(retval.rel != 0)
            	            		{
            	            		    retval.rel->diff(*(rs.rel));
            	            		}
            	                            delete rs.rel;
            	                        
            	        }

            	    }
            	    break;

            	default:
            	    goto loop58;	/* break out of the loop */
            	    break;
                }
            }
            loop58: ; /* Jump out to here if this rule does not match */


        }

    }
    

    // This is where rules clean up and exit
    //
    goto ruleatomrelEx; /* Prevent compiler warnings */
    ruleatomrelEx: ;
    retval.stop = LT(-1);

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }


    return retval;
}
/* $ANTLR end atomrel */

/** 
 * $ANTLR start elematomrel
 * cps/CPS.g:2125:1: elematomrel returns [AtomRelation* rel] : (rs= relschema | name= string | '(' ar= atomrel ')' );
 */
static CPSParser_elematomrel_return
elematomrel(pCPSParser ctx)
{   
    CPSParser_elematomrel_return retval;

    CPSParser_relschema_return rs;
    #undef	RETURN_TYPE_rs
    #define	RETURN_TYPE_rs CPSParser_relschema_return

    std::string* name;
    #undef	RETURN_TYPE_name
    #define	RETURN_TYPE_name std::string*

    CPSParser_atomrel_return ar;
    #undef	RETURN_TYPE_ar
    #define	RETURN_TYPE_ar CPSParser_atomrel_return

    /* Initialize rule variables
     */


    name = NULL;
    retval.start = LT(1); retval.stop = retval.start;

    {
        {
            //  cps/CPS.g:2126:2: (rs= relschema | name= string | '(' ar= atomrel ')' )
            
            ANTLR3_UINT32 alt59;

            alt59=3;

            switch ( LA(1) ) 
            {
            case 51:
            	{
            		alt59=1;
            	}
                break;
            case SMALLID:
            case CAPITID:
            case CAPITNUMID:
            	{
            		alt59=2;
            	}
                break;
            case 58:
            	{
            		alt59=3;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return retval;
                }
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 59;
                EXCEPTION->state        = 0;


                goto ruleelematomrelEx;
            }

            switch (alt59) 
            {
        	case 1:
        	    // cps/CPS.g:2126:4: rs= relschema
        	    {
        	        FOLLOWPUSH(FOLLOW_relschema_in_elematomrel4530);
        	        rs=relschema(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleelematomrelEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return retval;
        	        }
        	        if ( BACKTRACKING==0 ) 
        	        {

        	                        retval.rel= new AtomRelation(rs.rs->instance());
        	                        delete rs.rs;
        	                        
        	        }

        	    }
        	    break;
        	case 2:
        	    // cps/CPS.g:2131:4: name= string
        	    {
        	        FOLLOWPUSH(FOLLOW_string_in_elematomrel4553);
        	        name=string(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleelematomrelEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return retval;
        	        }
        	        if ( BACKTRACKING==0 ) 
        	        {

        	                            if(!context.isAtomRelation(name))
        	                            {
        	                                printPosition(retval.start);
        	                                std::cout << "Relation expected.\n";                   
        	                            }
        	                            else
        	            		{
        	                                retval.rel= context.getAtomRelation(name);
        	                            }
        	            		delete name;
        	                        
        	        }

        	    }
        	    break;
        	case 3:
        	    // cps/CPS.g:2144:4: '(' ar= atomrel ')'
        	    {
        	         MATCHT(58, &FOLLOW_58_in_elematomrel4572); 
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleelematomrelEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return retval;
        	        }
        	        FOLLOWPUSH(FOLLOW_atomrel_in_elematomrel4578);
        	        ar=atomrel(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleelematomrelEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return retval;
        	        }
        	         MATCHT(59, &FOLLOW_59_in_elematomrel4580); 
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleelematomrelEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return retval;
        	        }
        	        if ( BACKTRACKING==0 ) 
        	        {

        	            		retval.rel= ar.rel;
        	            		
        	        }

        	    }
        	    break;

            }
        }
    }
    

    // This is where rules clean up and exit
    //
    goto ruleelematomrelEx; /* Prevent compiler warnings */
    ruleelematomrelEx: ;
    retval.stop = LT(-1);

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }


    return retval;
}
/* $ANTLR end elematomrel */

/** 
 * $ANTLR start smallstr
 * cps/CPS.g:2168:1: smallstr returns [std::string* str] : name= SMALLID ;
 */
static std::string*
smallstr(pCPSParser ctx)
{   
    std::string* str = NULL;

    pANTLR3_COMMON_TOKEN    name;

    /* Initialize rule variables
     */


    name       = NULL;

    {
        // cps/CPS.g:2169:2: (name= SMALLID )
        // cps/CPS.g:2169:4: name= SMALLID
        {
            name = (pANTLR3_COMMON_TOKEN) MATCHT(SMALLID, &FOLLOW_SMALLID_in_smallstr4608); 
            if  (HASEXCEPTION())
            {
                goto rulesmallstrEx;
            }
            if (HASFAILED())
            {
                return str;
            }
            if ( BACKTRACKING==0 ) 
            {

                	str= new std::string((char*)(((name->getText(name)))->chars));
                	
            }

        }

    }
    

    // This is where rules clean up and exit
    //
    goto rulesmallstrEx; /* Prevent compiler warnings */
    rulesmallstrEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }


    return str;
}
/* $ANTLR end smallstr */

/** 
 * $ANTLR start capitstr
 * cps/CPS.g:2175:1: capitstr returns [std::string* str] : name= CAPITID ;
 */
static std::string*
capitstr(pCPSParser ctx)
{   
    std::string* str = NULL;

    pANTLR3_COMMON_TOKEN    name;

    /* Initialize rule variables
     */


    name       = NULL;

    {
        // cps/CPS.g:2176:2: (name= CAPITID )
        // cps/CPS.g:2176:4: name= CAPITID
        {
            name = (pANTLR3_COMMON_TOKEN) MATCHT(CAPITID, &FOLLOW_CAPITID_in_capitstr4635); 
            if  (HASEXCEPTION())
            {
                goto rulecapitstrEx;
            }
            if (HASFAILED())
            {
                return str;
            }
            if ( BACKTRACKING==0 ) 
            {

                	str= new std::string((char*)(((name->getText(name)))->chars));
                	
            }

        }

    }
    

    // This is where rules clean up and exit
    //
    goto rulecapitstrEx; /* Prevent compiler warnings */
    rulecapitstrEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }


    return str;
}
/* $ANTLR end capitstr */

/** 
 * $ANTLR start string
 * cps/CPS.g:2182:1: string returns [std::string* str] : name= ( SMALLID | CAPITID | CAPITNUMID ) ;
 */
static std::string*
string(pCPSParser ctx)
{   
    std::string* str = NULL;

    pANTLR3_COMMON_TOKEN    name;

    /* Initialize rule variables
     */


    name       = NULL;

    {
        // cps/CPS.g:2183:2: (name= ( SMALLID | CAPITID | CAPITNUMID ) )
        // cps/CPS.g:2183:4: name= ( SMALLID | CAPITID | CAPITNUMID )
        {
            name=(pANTLR3_COMMON_TOKEN)LT(1);
            if ( ((LA(1) >= SMALLID) && (LA(1) <= CAPITNUMID)) )
            {
                CONSUME();
                PERRORRECOVERY=ANTLR3_FALSE;FAILEDFLAG=ANTLR3_FALSE;

            }
            else 
            {
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return str;
                }
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
                EXCEPTION->expectingSet = &FOLLOW_set_in_string4662;
                RECOVERFROMMISMATCHEDSET(&FOLLOW_set_in_string4662);    goto rulestringEx;
            }

            if ( BACKTRACKING==0 ) 
            {

                	str= new std::string((char*)(((name->getText(name)))->chars));
                	
            }

        }

    }
    

    // This is where rules clean up and exit
    //
    goto rulestringEx; /* Prevent compiler warnings */
    rulestringEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }


    return str;
}
/* $ANTLR end string */

// $ANTLR start synpred1_CPS
static void synpred1_CPS_fragment(pCPSParser ctx ) 
{
    // cps/CPS.g:212:13: ( CAPITID '=' )
    // cps/CPS.g:212:14: CAPITID '='
    {
         MATCHT(CAPITID, &FOLLOW_CAPITID_in_synpred1_CPS372); 
        if  (HASEXCEPTION())
        {
            goto rulesynpred1_CPSEx;
        }
        if (HASFAILED())
        {
            return ;
        }
         MATCHT(50, &FOLLOW_50_in_synpred1_CPS373); 
        if  (HASEXCEPTION())
        {
            goto rulesynpred1_CPSEx;
        }
        if (HASFAILED())
        {
            return ;
        }

    }

// This is where rules clean up and exit
//
goto rulesynpred1_CPSEx; /* Prevent compiler warnings */
rulesynpred1_CPSEx: ;

}
// $ANTLR end synpred1_CPS

// $ANTLR start synpred2_CPS
static void synpred2_CPS_fragment(pCPSParser ctx ) 
{
    // cps/CPS.g:1591:5: ( TRUEVF )
    // cps/CPS.g:1591:6: TRUEVF
    {
         MATCHT(TRUEVF, &FOLLOW_TRUEVF_in_synpred2_CPS3314); 
        if  (HASEXCEPTION())
        {
            goto rulesynpred2_CPSEx;
        }
        if (HASFAILED())
        {
            return ;
        }

    }

// This is where rules clean up and exit
//
goto rulesynpred2_CPSEx; /* Prevent compiler warnings */
rulesynpred2_CPSEx: ;

}
// $ANTLR end synpred2_CPS

// $ANTLR start synpred3_CPS
static void synpred3_CPS_fragment(pCPSParser ctx ) 
{
    // cps/CPS.g:1595:5: ( FALSEVF )
    // cps/CPS.g:1595:6: FALSEVF
    {
         MATCHT(FALSEVF, &FOLLOW_FALSEVF_in_synpred3_CPS3333); 
        if  (HASEXCEPTION())
        {
            goto rulesynpred3_CPSEx;
        }
        if (HASFAILED())
        {
            return ;
        }

    }

// This is where rules clean up and exit
//
goto rulesynpred3_CPSEx; /* Prevent compiler warnings */
rulesynpred3_CPSEx: ;

}
// $ANTLR end synpred3_CPS

// $ANTLR start synpred7_CPS
static void synpred7_CPS_fragment(pCPSParser ctx ) 
{
    // cps/CPS.g:1986:4: ( string '(' )
    // cps/CPS.g:1986:5: string '('
    {
        FOLLOWPUSH(FOLLOW_string_in_synpred7_CPS4245);
        string(ctx);

        FOLLOWPOP();
        if  (HASEXCEPTION())
        {
            goto rulesynpred7_CPSEx;
        }
        if (HASFAILED())
        {
            return ;
        }
         MATCHT(58, &FOLLOW_58_in_synpred7_CPS4246); 
        if  (HASEXCEPTION())
        {
            goto rulesynpred7_CPSEx;
        }
        if (HASFAILED())
        {
            return ;
        }

    }

// This is where rules clean up and exit
//
goto rulesynpred7_CPSEx; /* Prevent compiler warnings */
rulesynpred7_CPSEx: ;

}
// $ANTLR end synpred7_CPS

// $ANTLR start synpred8_CPS
static void synpred8_CPS_fragment(pCPSParser ctx ) 
{
    // cps/CPS.g:2012:4: ( smallstr )
    // cps/CPS.g:2012:5: smallstr
    {
        FOLLOWPUSH(FOLLOW_smallstr_in_synpred8_CPS4283);
        smallstr(ctx);

        FOLLOWPOP();
        if  (HASEXCEPTION())
        {
            goto rulesynpred8_CPSEx;
        }
        if (HASFAILED())
        {
            return ;
        }

    }

// This is where rules clean up and exit
//
goto rulesynpred8_CPSEx; /* Prevent compiler warnings */
rulesynpred8_CPSEx: ;

}
// $ANTLR end synpred8_CPS
/* End of parsing rules
 * ==============================================
 */

/* ==============================================
 * Syntactic predicates
 */
static ANTLR3_BOOLEAN synpred1_CPS(pCPSParser ctx) 
{
    ANTLR3_MARKER   start;
    ANTLR3_BOOLEAN  success;

    BACKTRACKING++;
    start	= MARK();
    synpred1_CPS_fragment(ctx);	    // can never throw exception
    success	= !(FAILEDFLAG);
    REWIND(start);
    BACKTRACKING--;
    FAILEDFLAG	= ANTLR3_FALSE;
    return success;
}
static ANTLR3_BOOLEAN synpred3_CPS(pCPSParser ctx) 
{
    ANTLR3_MARKER   start;
    ANTLR3_BOOLEAN  success;

    BACKTRACKING++;
    start	= MARK();
    synpred3_CPS_fragment(ctx);	    // can never throw exception
    success	= !(FAILEDFLAG);
    REWIND(start);
    BACKTRACKING--;
    FAILEDFLAG	= ANTLR3_FALSE;
    return success;
}
static ANTLR3_BOOLEAN synpred2_CPS(pCPSParser ctx) 
{
    ANTLR3_MARKER   start;
    ANTLR3_BOOLEAN  success;

    BACKTRACKING++;
    start	= MARK();
    synpred2_CPS_fragment(ctx);	    // can never throw exception
    success	= !(FAILEDFLAG);
    REWIND(start);
    BACKTRACKING--;
    FAILEDFLAG	= ANTLR3_FALSE;
    return success;
}
static ANTLR3_BOOLEAN synpred7_CPS(pCPSParser ctx) 
{
    ANTLR3_MARKER   start;
    ANTLR3_BOOLEAN  success;

    BACKTRACKING++;
    start	= MARK();
    synpred7_CPS_fragment(ctx);	    // can never throw exception
    success	= !(FAILEDFLAG);
    REWIND(start);
    BACKTRACKING--;
    FAILEDFLAG	= ANTLR3_FALSE;
    return success;
}
static ANTLR3_BOOLEAN synpred8_CPS(pCPSParser ctx) 
{
    ANTLR3_MARKER   start;
    ANTLR3_BOOLEAN  success;

    BACKTRACKING++;
    start	= MARK();
    synpred8_CPS_fragment(ctx);	    // can never throw exception
    success	= !(FAILEDFLAG);
    REWIND(start);
    BACKTRACKING--;
    FAILEDFLAG	= ANTLR3_FALSE;
    return success;
}

/* End of syntactic predicates
 * ==============================================
 */

 
 



/* End of code
 * =============================================================================
 */
