global env
if {$argc < 1} {
	puts ""
	puts "File name missing."
	exit 1
}
if {$argc > 1} {
	puts ""
	puts "Too many arguments."
	exit 1
}
if {![info exists env(FDRHOME)]} {
	puts ""
	puts "Environment variable FDRHOME is not set."
	exit 1
}

set fdrhome $env(FDRHOME)
source $fdrhome/lib/fdr/fdrDirect.tcl

set instancename "_instance_"
set suffix ".csp"
set success 1
set complete 0
set sound 0
set islast 0
set finished 0
set counter 0

set filename "$argv$instancename$counter$suffix"
if {![file exists $argv.cps]} {
	puts ""
	puts "File $argv.cps does not exist."
	exit 1
} elseif {![file exists $filename]} {
	puts ""
	puts "Nothing to be checked."
	puts "Run boundsInstanceGenerator $argv.cps first."
	exit 1
} else {
	file stat $filename inststat
	file stat $argv.cps cpsstat
	if {$cpsstat(mtime) > $inststat(ctime)} {
		puts ""
		puts "File $argv.cps modified after the instances have been created."
       		puts "Rerun boundsInstanceGenerator $argv.cps ."
 		exit 1
	}
}

while {!$finished && $success} {
	set filename "$argv$instancename$counter$suffix"
	if {[file exists $filename]} {
		set fid [open $filename]
		gets $fid type
		if {$type == "-- Bounds2.2 alternating simulation check --"} {
			puts ""
			puts "The file describes an alternating simulation check."
			puts "Run boundsAlternatingSimulationChecker $argv instead."
			exit 1
		} elseif {$type == "-- Bounds2.2 compatibility check --"} {
			puts ""
			puts "The file describes a compatility check."
			puts "Run boundsCompatibilityChecker $argv instead."
			exit 1
		} elseif {$type == "-- Bounds2.2 end of trace refinement check --"} {
			set islast 1
		} elseif {$type != "-- Bounds2.2 trace refinement check --"} {
			puts ""
			puts "File $filename does not seem to describe a trace refinement check created by Bounds."
			puts "Have you run boundsInstanceGenerator $argv.cps ?"
			exit 1
		}
		gets $fid modelcomplete
		if {$modelcomplete == "-- The model is complete --"} {
			set complete 1
		} 
		gets $fid modelsound
		if {$modelsound == "-- The model is sound --"} {
			set sound 1
		}
		close $fid
		if {$islast} {
			break
		}
		puts ""		
		puts "==== Checking instance $counter of $argv ===="
		puts ""		
		set s [load "$filename"]
		set r1 [checkRefinement $s "CHAOS(alph_Spec_Proc_1)" "T" "CHAOS(alph_Sys_Proc_1)"]
		set r2 [checkRefinement $s "CHAOS(alph_Sys_Proc_1)" "T" "CHAOS(alph_Spec_Proc_1)"]
		if {($r1 != "true" && $r1 != "xtrue") || ($r2 != "true" && $r2 != "xtrue")} {
			puts "==== Alphabets of the system and the specification do not match. ===="
			set success 0
			break
		}
		set r3 [checkRefinement $s "Spec_Proc_1" "T" "Sys_Proc_1"]
		if {$r3 != "true" && $r3 != "xtrue"} {
			set success 0
			break
		}
		incr counter		
	} else {
		set finished 1
	}
}
puts ""
if {$success} {
	if {$islast} {
		if {$sound} {
			puts "==== The system is correct with respect to the specification! ===="
		} else {
			puts "==== The instances are correct with respect to the specification."
			puts "     However, there might a bug in an instance above the cut-offs. ===="
		}
	} else {
		puts "It looks like some instances are missing."
		puts "Rerun boundsInstanceGenerator $argv.cps ."
	}
} else {
	if {$complete} {
		puts "==== The system is *NOT* correct with respect to the specification. ===="
	} else {
		puts "==== The instance is not correct with respect to the specification."
		puts "     However, this may not be a real bug but a result of abstraction. ===="
	}
}
exit
