global env
if {$argc < 1} {
	puts ""
	puts "File name missing."
	exit
}
if {$argc > 1} {
	puts ""
	puts "Too many arguments."
	exit
}
if {![info exists env(FDRHOME)]} {
	puts ""
	puts "Environment variable FDRHOME is not set."
	exit
}
set fdrhome $env(FDRHOME)
source $fdrhome/lib/fdr/fdrDirect.tcl

set instancename "_instance_"
set suffix ".csp"
set success 1
set complete 0
set sound 0
set islast 0
set finished 0
set counter 0

set filename "$argv$instancename$counter$suffix"
if {![file exists $argv.cps]} {
	puts ""
	puts "File $argv.cps does not exist."
	exit 1
} elseif {![file exists $filename]} {
	puts ""
	puts "Nothing to be checked."
	puts "Run boundsInstanceGenerator $argv.cps first."
	exit 1
} else {
	file stat $filename inststat
	file stat $argv.cps cpsstat
	if {$cpsstat(mtime) > $inststat(ctime)} {
		puts ""
		puts "File $argv.cps modified after the instances have been created."
       		puts "Rerun boundsInstanceGenerator $argv.cps ."
 		exit 1
	}
}

while {!$finished && $success} {
	set filename "$argv$instancename$counter$suffix"
	if {[file exists $filename]} {
		set fid [open $filename]
		gets $fid type
		if {$type == "-- Bounds2.2 alternating simulation check --"} {
			puts ""
			puts "The file describes an alternating simulation check."
			puts "Run boundsAlternatingSimulationChecker $argv instead."
			exit 1
		} elseif {$type == "-- Bounds2.2 trace refinement check --"} {
			puts ""
			puts "The file describes a trace refinement check."
			puts "Run boundsTraceRefinementChecker $argv instead."
			exit 1
		} elseif {$type == "-- Bounds2.2 end of compatibility check --"} {
			set islast 1
		} elseif {$type != "-- Bounds2.2 compatibility check --"} {
			puts ""
			puts "File $filename does not seem to describe a compatibility check created by Bounds."
			puts "Have you run boundsInstanceGenerator $argv.cps ?"
			exit 1
		}
		gets $fid modelcomplete
		if {$modelcomplete == "-- The model is complete --"} {
			set complete 1
		}
		gets $fid modelsound
		if {$modelsound == "-- The model is sound --"} {
			set sound 1
		}
		close $fid
		if {$islast} {
			break
		}
		puts ""		
		puts "==== Checking instance $counter of $argv ===="
		puts ""		
		set s [load "$filename"]
		set r [checkRefinement $s "Comp_Spec_Proc" "T" "Comp_Sys_Proc"]
		if {$r != "true" && $r != "xtrue"} {
			set success 0
			break
		}
		incr counter		
	} else {
		set finished 1
	}
}
puts ""
if {$success} {
	if {$islast} {
		if {$sound} {
			puts "==== The system components are compatible ===="
		} else {
			puts "==== The components of the instances are compatible."
			puts "     However, the components of bigger instances may not be compatible. ===="
		}
	} else {
		puts "It looks like some instances are missing."
		puts "Rerun boundsInstanceGenerator $argv.cps ."
	}
} else {
	if {$complete} {
		puts "==== System components are *NOT* compatible ===="
	} else {
		puts "==== The components of this instance are not compatible."
		puts "     However, this may not be a real bug but a result of abstraction. ===="
	}
}
exit
