/*
 * Decompiled with CFR 0.152.
 */
package fi.aalto.bounds;

import java.io.File;
import java.util.NoSuchElementException;
import java.util.Scanner;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.operations.refinement.MioMayWeakRefinement;
import net.miowb.workbench.operations.result.RefinementResult;
import net.miowb.workbench.shell.MioCommandLine;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class MIOVerifier
implements IApplication {
    public Object start(IApplicationContext context) throws Exception {
        Display display = PlatformUI.createDisplay();
        String mioBaseFileName = "";
        try {
            String[] args = Platform.getCommandLineArgs();
            int i = 0;
            while (i < args.length) {
                if (args[i].equals("-mioBaseFileName") && i + 1 < args.length) {
                    mioBaseFileName = args[i + 1];
                    break;
                }
                ++i;
            }
            MioCommandLine mioshell = MioCommandLine.getInstance();
            try {
                Scanner scanner = new Scanner(new File(String.valueOf(mioBaseFileName) + ".miotxt"));
                scanner.useDelimiter("\n\n\n");
                try {
                    while (true) {
                        String miocmd = scanner.next();
                        mioshell.execute(miocmd);
                    }
                }
                catch (NoSuchElementException miocmd) {
                    ModalIOAutomaton specmio = mioshell.get("IFaceSpec");
                    ModalIOAutomaton sysmio = mioshell.get("IFaceImpl");
                    MioMayWeakRefinement mayweak = new MioMayWeakRefinement();
                    RefinementResult isRefined = mayweak.checkRefinement(specmio, sysmio, false, false);
                    if (isRefined.isOkay()) {
                        System.out.println("true");
                    } else {
                        System.out.println("false");
                    }
                    mioshell.resetVariables();
                }
            }
            catch (Exception e) {
                System.out.println(e);
                Integer n = IApplication.EXIT_OK;
                display.dispose();
                return n;
            }
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        finally {
            display.dispose();
        }
    }

    public void stop() {
    }
}

